/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.filechooser.model.webdav;

import com.inet.report.filechooser.i18n.Msg;
import com.inet.report.filechooser.model.IFile;
import com.inet.report.filechooser.model.IFolder;
import com.inet.report.filechooser.model.ILocation;
import com.inet.report.filechooser.model.b;
import com.inet.report.filechooser.model.webdav.WebDavFile;
import com.inet.report.filechooser.model.webdav.WebDavLocation;
import com.inet.report.filechooser.model.webdav.WebDavRootFolder;
import com.inet.report.filechooser.utils.a;
import com.inet.report.repository.davclient.DavFolder;
import com.inet.report.repository.davclient.DavResource;
import com.inet.report.repository.davclient.WebDavConnector;
import com.inet.report.repository.davclient.e;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.httpclient.HttpException;

public class WebDavFolder
implements IFolder {
    private final DavFolder bfl;
    private final IFolder bfj;
    private String path;
    private final WebDavLocation bfk;
    private final WebDavConnector bfm;
    private int state;

    public WebDavFolder(DavFolder davFolder, IFolder iFolder, WebDavConnector webDavConnector, WebDavLocation webDavLocation) {
        this.bfl = davFolder;
        this.bfj = iFolder;
        this.bfm = webDavConnector;
        this.bfk = webDavLocation;
        this.path = davFolder.getName();
        IFolder iFolder2 = this;
        while (iFolder2.getParent() != null) {
            if ((iFolder2 = iFolder2.getParent()) instanceof WebDavRootFolder) continue;
            this.path = iFolder2.getName() + "/" + this.path;
        }
        this.path = "/" + this.path;
    }

    @Override
    public ILocation getLocation() {
        return this.bfk;
    }

    @Override
    public String getDisplayName() {
        if (this.isVirtual()) {
            return Msg.getMsg("folder.virtual.displayname");
        }
        if (this.isAllUsers()) {
            return Msg.getMsg("folder.allusers.displayname");
        }
        return this.bfl.getName();
    }

    @Override
    public int getRights() {
        return this.bfl.getPermission();
    }

    @Override
    public List<IFile> getFiles() {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        List<DavResource> list = this.bfl.getResources();
        if (list != null) {
            for (DavResource davResource : list) {
                arrayList.add(new WebDavFile(davResource, this, this.bfk));
            }
        }
        return arrayList;
    }

    @Override
    public List<IFolder> getFolders() {
        ArrayList<IFolder> arrayList = new ArrayList<IFolder>();
        List<DavFolder> list = this.bfl.getFolders();
        if (list != null) {
            for (DavFolder davFolder : list) {
                arrayList.add(new WebDavFolder(davFolder, this, this.bfm, this.bfk));
            }
        }
        return arrayList;
    }

    @Override
    public Icon getIcon(boolean bl2, boolean bl3) {
        switch (this.state) {
            case 2: {
                return ICON_LOADING;
            }
        }
        Icon icon = null;
        if (this.isAllUsers()) {
            icon = a.bgG;
        } else if (this.isVirtual() && this.getParent() != null && !this.getParent().isVirtual()) {
            icon = a.bgF;
        }
        if (icon == null) {
            icon = bl2 ? a.getIcon("folder_open_16.png") : a.getIcon("folder_close_16.png");
        }
        if (this.state == 1 && icon != null) {
            icon = a.a(icon);
        }
        return icon;
    }

    @Override
    public String getName() {
        return this.bfl.getFolder().getName();
    }

    @Override
    public IFolder getParent() {
        return this.bfj;
    }

    @Override
    public String getAbsolutePath() {
        String string = this.bfl.getFolder().getHttpURL().toString();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    @Override
    public String getRelativePath() {
        return this.path;
    }

    @Override
    public synchronized void clearCache() {
        this.setState(0);
        this.bfl.clearCache();
    }

    @Override
    public boolean isInitialzed() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof WebDavFolder) {
            return this.getAbsolutePath().equals(((WebDavFolder)object).getAbsolutePath());
        }
        return super.equals(object);
    }

    @Override
    public void setState(int n2) {
        this.state = n2;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public IFolder getRoot() {
        IFolder iFolder = this;
        while (iFolder.getParent() != null) {
            iFolder = iFolder.getParent();
        }
        return iFolder;
    }

    @Override
    public IFile createFile(String string, InputStream inputStream) throws IllegalArgumentException, IOException {
        if (string == null || inputStream == null) {
            throw new IllegalArgumentException("Name or content have not to be null");
        }
        DavResource davResource = null;
        try {
            davResource = this.bfl.createResource(string, inputStream, this.bfm);
        }
        catch (HttpException httpException) {
            throw new IOException("File with name '" + string + "' could not be created");
        }
        if (davResource == null || !davResource.exists()) {
            throw new IOException("File with name '" + string + "' could not be created");
        }
        inputStream.close();
        return new WebDavFile(davResource, this, this.bfk);
    }

    @Override
    public IFolder createFolder(String string) throws IllegalArgumentException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("Name have not to be null");
        }
        DavFolder davFolder = this.bfl.getFolder(string);
        if (davFolder != null && davFolder.exists()) {
            throw new IllegalArgumentException("Folder with the name '" + string + "' already exists");
        }
        if (!this.bfl.createFolder(string)) {
            throw new IOException("Folder with name '" + string + "' could not be created");
        }
        this.bfl.clearCache();
        davFolder = this.bfl.getFolder(string);
        return new WebDavFolder(davFolder, this, this.bfm, this.bfk);
    }

    @Override
    public IFolder getFolder(String string) {
        DavFolder davFolder = this.bfl.getFolder(string);
        if (davFolder != null && davFolder.exists()) {
            return new WebDavFolder(davFolder, this, this.bfm, this.bfk);
        }
        return null;
    }

    @Override
    public IFile getFile(String string) {
        DavResource davResource = this.bfl.getResource(string);
        if (davResource != null && davResource.exists()) {
            return new WebDavFile(davResource, this, this.bfk);
        }
        return null;
    }

    @Override
    public boolean rename(String string) {
        return this.bfl.rename(string);
    }

    @Override
    public boolean delete() {
        return this.bfl.delete();
    }

    public WebDavConnector getConnector() {
        return this.bfm;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public void setFolderChangedListener(b b2) {
    }

    @Override
    public boolean exists() {
        return this.bfl.exists();
    }

    @Override
    public boolean isVirtual() {
        if (this.bfl != null && this.bfl.getFolder() instanceof e) {
            e e2 = (e)this.bfl.getFolder();
            return e2.isVirtual();
        }
        return false;
    }

    @Override
    public boolean isAllUsers() {
        if (this.bfl != null && this.bfl.getFolder() instanceof e) {
            e e2 = (e)this.bfl.getFolder();
            return e2.We();
        }
        return false;
    }
}

