/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.filechooser.model.webdav;

import com.inet.report.filechooser.model.IFile;
import com.inet.report.filechooser.model.IFolder;
import com.inet.report.filechooser.model.ILocation;
import com.inet.report.filechooser.model.b;
import com.inet.report.filechooser.model.webdav.WebDavFile;
import com.inet.report.filechooser.model.webdav.WebDavFolder;
import com.inet.report.filechooser.model.webdav.WebDavLocation;
import com.inet.report.filechooser.utils.a;
import com.inet.report.repository.davclient.DavFolder;
import com.inet.report.repository.davclient.DavResource;
import com.inet.report.repository.davclient.WebDavConnector;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.httpclient.HttpException;

public class WebDavRootFolder
implements IFolder {
    private final WebDavLocation bfk;
    private final WebDavConnector bfm;
    private int state;
    private Boolean bfo = null;
    private int lQ = -1;
    private String bfp;
    private String displayName = null;

    public WebDavRootFolder(WebDavConnector webDavConnector, WebDavLocation webDavLocation) {
        this.bfm = webDavConnector;
        this.bfk = webDavLocation;
    }

    @Override
    public ILocation getLocation() {
        return this.bfk;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        String string = this.bfm.getHost();
        int n2 = this.bfm.getPort();
        if (n2 > 0 && n2 != 80 && n2 != 443) {
            string = string + ":" + n2;
        }
        return string;
    }

    @Override
    public int getRights() {
        this.CT();
        if (this.bfo == null || !this.bfo.booleanValue()) {
            return 0;
        }
        if (this.lQ != -1) {
            return this.lQ;
        }
        DavFolder davFolder = this.bfm.getRootFolder();
        if (davFolder != null) {
            this.lQ = davFolder.getPermission();
        }
        return this.lQ;
    }

    @Override
    public List<IFile> getFiles() {
        List<DavResource> list;
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        this.CT();
        if (this.bfo == null || !this.bfo.booleanValue()) {
            return arrayList;
        }
        DavFolder davFolder = this.bfm.getRootFolder();
        if (davFolder != null && (list = davFolder.getResources()) != null) {
            for (DavResource davResource : list) {
                arrayList.add(new WebDavFile(davResource, this, this.bfk));
            }
        }
        return arrayList;
    }

    @Override
    public List<IFolder> getFolders() {
        List<DavFolder> list;
        ArrayList<IFolder> arrayList = new ArrayList<IFolder>();
        this.CT();
        if (this.bfo == null || !this.bfo.booleanValue()) {
            return arrayList;
        }
        DavFolder davFolder = this.bfm.getRootFolder();
        if (davFolder != null && (list = davFolder.getFolders()) != null) {
            for (DavFolder davFolder2 : list) {
                arrayList.add(new WebDavFolder(davFolder2, this, this.bfm, this.bfk));
            }
        }
        return arrayList;
    }

    @Override
    public Icon getIcon(boolean bl2, boolean bl3) {
        switch (this.state) {
            case 0: {
                return ICON_REPOSITORY;
            }
            case 1: 
            case 5: {
                return a.a(ICON_REPOSITORY);
            }
            case 2: {
                return ICON_LOADING;
            }
            case 3: {
                return ICON_REPOSITORY;
            }
            case 4: {
                return ICON_ERROR;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.bfm.getHost();
    }

    @Override
    public IFolder getParent() {
        return null;
    }

    @Override
    public String getAbsolutePath() {
        String string = this.bfm.getURLString();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    @Override
    public String getRelativePath() {
        return "/";
    }

    @Override
    public synchronized void clearCache() {
        this.setState(0);
        this.bfo = null;
        this.lQ = -1;
    }

    @Override
    public boolean isInitialzed() {
        if (!this.bfm.isConnected()) {
            return false;
        }
        this.CT();
        return this.bfo != null && this.bfo != false;
    }

    @Override
    public void setState(int n2) {
        this.state = n2;
        this.bfp = null;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public IFile createFile(String string, InputStream inputStream) throws IllegalArgumentException, IOException {
        if (string == null || inputStream == null) {
            throw new IllegalArgumentException("Name or content have not to be null");
        }
        DavFolder davFolder = this.bfm.getRootFolder();
        if (davFolder == null) {
            throw new IOException("Repository is not connected");
        }
        DavResource davResource = null;
        try {
            davResource = davFolder.createResource(string, inputStream, this.bfm);
        }
        catch (HttpException httpException) {
            throw new IOException("File with name '" + string + "' could not be created");
        }
        if (davResource == null || !davResource.exists()) {
            throw new IOException("File with name '" + string + "' could not be created");
        }
        inputStream.close();
        return new WebDavFile(davResource, this, this.bfk);
    }

    @Override
    public IFolder createFolder(String string) throws IllegalArgumentException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("Name have not to be null");
        }
        DavFolder davFolder = this.bfm.getRootFolder();
        if (davFolder == null) {
            throw new IOException("Repository is not connected");
        }
        DavFolder davFolder2 = davFolder.getFolder(string);
        if (davFolder2 != null && davFolder2.exists()) {
            throw new IllegalArgumentException("Folder with the name '" + string + "' already exists");
        }
        if (!davFolder.createFolder(string)) {
            throw new IOException("Folder with name '" + string + "' could not be created");
        }
        davFolder.clearCache();
        davFolder2 = davFolder.getFolder(string);
        return new WebDavFolder(davFolder2, this, this.bfm, this.bfk);
    }

    @Override
    public IFolder getRoot() {
        IFolder iFolder = this;
        while (iFolder.getParent() != null) {
            iFolder = iFolder.getParent();
        }
        return iFolder;
    }

    public WebDavConnector getConnector() {
        return this.bfm;
    }

    @Override
    public IFolder getFolder(String string) {
        this.CT();
        if (this.bfo == null || !this.bfo.booleanValue()) {
            return null;
        }
        DavFolder davFolder = this.bfm.getRootFolder();
        if (davFolder == null) {
            return null;
        }
        DavFolder davFolder2 = davFolder.getFolder(string);
        if (davFolder2 != null && davFolder2.exists()) {
            return new WebDavFolder(davFolder2, this, this.bfm, this.bfk);
        }
        return null;
    }

    @Override
    public IFile getFile(String string) {
        this.CT();
        if (this.bfo == null || !this.bfo.booleanValue()) {
            return null;
        }
        DavFolder davFolder = this.bfm.getRootFolder();
        if (davFolder == null) {
            return null;
        }
        DavResource davResource = davFolder.getResource(string);
        if (davResource != null && davResource.exists()) {
            return new WebDavFile(davResource, this, this.bfk);
        }
        return null;
    }

    @Override
    public boolean rename(String string) {
        this.CT();
        if (this.bfo == null || !this.bfo.booleanValue()) {
            return false;
        }
        DavFolder davFolder = this.bfm.getRootFolder();
        if (davFolder == null) {
            return false;
        }
        return davFolder.rename(string);
    }

    @Override
    public boolean delete() {
        return false;
    }

    public DavFolder getDavFolder() {
        this.CT();
        if (this.bfo == null || !this.bfo.booleanValue()) {
            return null;
        }
        return this.bfm.getRootFolder();
    }

    public List<String> getAvailableTags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.bfm.getAvailableTags());
        return arrayList;
    }

    private void CT() {
        if (this.bfo == null) {
            try {
                this.bfo = this.bfm.isValidMajorVersion(13);
            }
            catch (IOException iOException) {
                this.bfo = Boolean.FALSE;
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof WebDavRootFolder) {
            WebDavRootFolder webDavRootFolder = (WebDavRootFolder)object;
            return this.bfm.equals(webDavRootFolder.getConnector());
        }
        return super.equals(object);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public void setError(String string) {
        this.bfp = string;
    }

    public String getError() {
        return this.bfp;
    }

    @Override
    public void setFolderChangedListener(b b2) {
    }

    @Override
    public boolean exists() {
        return this.bfm.isConnected();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isAllUsers() {
        return false;
    }
}

