/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula;

import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.Field;
import com.inet.report.SQLField;
import com.inet.report.SummaryField;
import com.inet.report.TableSource;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FieldFilter {
    private Set<TableSource> bih;

    public FieldFilter() {
    }

    public FieldFilter(List<TableSource> list) {
        this.bih = list != null ? new HashSet<TableSource>(list) : null;
    }

    public FieldFilter(Datasource datasource) {
        if (datasource != null) {
            this.bih = new HashSet<TableSource>();
            for (int i2 = 0; i2 < datasource.getTableSourceCount(); ++i2) {
                this.bih.add(datasource.getTableSource(i2));
            }
        }
    }

    public boolean accepts(Field field) {
        if (this.bih == null || field == null) {
            return true;
        }
        if (field instanceof DatabaseField) {
            return this.bih.contains(((DatabaseField)field).getTableSource());
        }
        if (field instanceof SummaryField) {
            SummaryField summaryField = (SummaryField)field;
            return this.accepts(summaryField.getField()) && this.accepts(summaryField.getField2nd()) && this.accepts(summaryField.getChangeField()) && this.accepts(summaryField.getResetField());
        }
        if (field instanceof SQLField) {
            SQLField sQLField = (SQLField)field;
            return this.accepts(sQLField.getField());
        }
        return true;
    }
}

