/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula.parser;

import com.inet.report.ReportException;
import com.inet.report.formula.FormulaException;
import com.inet.report.formula.parser.Token;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.i18n.Msg;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FormulaParserException
extends FormulaException
implements Iterable<ReportException> {
    private Token bmm;
    private boolean bmn = false;
    private ArrayList<ReportException> bmo;

    private FormulaParserException(String string, int n2, Token token, boolean bl2) {
        super(string, n2);
        this.bmm = token;
        this.bmn = bl2;
    }

    public static FormulaParserException create(ErrorCode errorCode, boolean bl2, Token token, Object ... objectArray) {
        String string = errorCode.name();
        string = Msg.getMsg(errorCode.name(), objectArray);
        int n2 = errorCode.getErrorCodeNumber();
        if (token != null) {
            string = string + " Line:" + (token.getRow() + 1) + " Column:" + (token.Ge() + 1);
        }
        return new FormulaParserException(string, n2, token, bl2);
    }

    public static FormulaParserException create(ReportException reportException, Token token) {
        if (reportException instanceof FormulaParserException) {
            FormulaParserException formulaParserException = (FormulaParserException)reportException;
            if (formulaParserException.getToken() == null) {
                formulaParserException.msg = formulaParserException.msg + " Line:" + (token.getRow() + 1) + " Column:" + (token.Ge() + 1);
                formulaParserException.setToken(token);
            }
            return (FormulaParserException)reportException;
        }
        if (reportException.getErrorCode() == 0) {
            return FormulaParserException.create(reportException.getMessage(), false, token, 0);
        }
        return FormulaParserException.create(reportException.getMessage(), false, token, reportException.getErrorCode());
    }

    public static FormulaParserException create(String string, boolean bl2, Token token, int n2) {
        if (token != null) {
            string = string + " Token:" + token.getContent() + " Line:" + token.getRow() + " Col:" + token.Ge() + " starts at char nr.:" + token.getIndex();
        }
        return new FormulaParserException(string, n2, token, bl2);
    }

    public void appendException(ReportException reportException) {
        if (reportException != null) {
            if (this.bmo == null) {
                this.bmo = new ArrayList();
            }
            this.bmo.add(reportException);
        }
    }

    public void appendExceptionList(List<ReportException> list) {
        if (list != null && list.size() > 0) {
            if (this.bmo == null) {
                this.bmo = new ArrayList();
            }
            this.bmo.addAll(list);
        }
    }

    public int countInnerExceptions() {
        if (this.bmo != null) {
            return this.bmo.size();
        }
        return 0;
    }

    @Override
    public Iterator<ReportException> iterator() {
        if (this.bmo != null) {
            return this.bmo.iterator();
        }
        return new ArrayList().iterator();
    }

    public Token getToken() {
        return this.bmm;
    }

    public void setToken(Token token) {
        this.bmm = token;
    }

    @Override
    public int getRow() {
        if (this.bmm != null) {
            return this.bmm.Et().getLine();
        }
        return super.getRow();
    }

    @Override
    public int getColumn() {
        if (this.bmm != null) {
            return this.bmm.Et().getColumn();
        }
        return super.getColumn();
    }

    @Override
    public int getEndRow() {
        if (this.bmm != null) {
            if (this.bmn) {
                return this.bmm.getRow();
            }
            return this.bmm.Et().getEndLine();
        }
        return super.getEndRow();
    }

    @Override
    public int getEndColumn() {
        if (this.bmm != null) {
            if (this.bmn) {
                return this.bmm.Ge();
            }
            return this.bmm.Et().getEndColumn();
        }
        return super.getEndColumn();
    }

    @Override
    public int getStartIndex() {
        if (this.bmm != null) {
            return this.bmm.getIndex();
        }
        return super.getStartIndex();
    }

    @Override
    public int getLength() {
        if (this.bmm != null) {
            if (this.bmn) {
                return 0;
            }
            return this.bmm.getLength();
        }
        return super.getLength();
    }

    @Override
    protected void En() {
        this.bmm = null;
    }
}

