/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.parser;

import com.inet.lib.util.IOFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.SummaryInfo;
import com.inet.report.parser.d;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RFReader
implements d {
    private DateFormat GY = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a", Locale.US);
    private Hashtable<String, byte[]> bvL = new Hashtable();
    private URL url;

    public RFReader(URL uRL) throws IOException {
        this(uRL.openStream());
        this.url = uRL;
    }

    public RFReader(InputStream inputStream) throws IOException {
        this.d(inputStream);
    }

    public RFReader(File file) throws IOException {
        this.l(file);
    }

    public URL getURL() {
        return this.url;
    }

    public void clear() {
        this.bvL.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(InputStream inputStream) throws IOException {
        try (ZipInputStream zipInputStream = null;){
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                byte[] byArray = RFReader.a(zipInputStream, false);
                this.bvL.put(zipEntry.getName().replace('\\', "/".charAt(0)), byArray);
            }
        }
    }

    private void l(File file) throws IOException, FileNotFoundException {
        File[] fileArray = file.listFiles(bvK);
        boolean bl2 = false;
        if (fileArray != null) {
            for (File file2 : fileArray) {
                File[] fileArray2;
                Object object;
                Object object2;
                Object object3;
                String string = file2.getName();
                if (file2.isFile()) {
                    this.a(string, file2);
                    if (!"content.xml".equals(string)) continue;
                    bl2 = true;
                    continue;
                }
                if (!file2.isDirectory()) continue;
                String string2 = "Sub_";
                if ("Thumbnails".equals(string)) {
                    object3 = new File(file2, "thumbnail.png");
                    if (!((File)object3).exists()) continue;
                    this.a("Thumbnails/thumbnail.png", (File)object3);
                    continue;
                }
                if ("META-INF".equals(string)) {
                    object3 = new File(file2, "manifest.xml");
                    if (!((File)object3).exists()) continue;
                    this.a("Thumbnails/manifest.xml", (File)object3);
                    continue;
                }
                if (string.startsWith(string2)) {
                    File file3;
                    object3 = new File(file2, "content.xml");
                    if (((File)object3).exists()) {
                        this.a(string + "/" + "content.xml", (File)object3);
                    }
                    if (((File)(object2 = new File(file2, "meta.xml"))).exists()) {
                        this.a(string + "/" + "meta.xml", (File)object2);
                    }
                    if (((File)(object = new File(file2, "metaproperties.xml"))).exists()) {
                        this.a(string + "/" + "metaproperties.xml", (File)object);
                    }
                    if (!(file3 = new File(file2, "Pictures")).exists() || (fileArray2 = file3.listFiles()) == null) continue;
                    for (File file4 : fileArray2) {
                        if (!file4.isFile()) continue;
                        this.a(string + "/" + "Pictures" + "/" + file4.getName(), file4);
                    }
                    continue;
                }
                if (string.startsWith("Pictures")) {
                    object3 = file2.listFiles();
                    if (object3 == null) continue;
                    object2 = object3;
                    int n2 = ((File[])object2).length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        fileArray2 = object2[i2];
                        if (!fileArray2.isFile()) continue;
                        this.a("Pictures/" + fileArray2.getName(), (File)fileArray2);
                    }
                    continue;
                }
                if (!"Resources".equals(string)) continue;
                object3 = new File(file2, "options.xml");
                if (((File)object3).exists()) {
                    this.a("Resources/options.xml", (File)object3);
                }
                if ((object2 = file2.listFiles()) == null) continue;
                object = object2;
                int n3 = ((Object)object).length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    File[] fileArray3 = object[i3];
                    String string3 = fileArray3.getName();
                    if (!fileArray3.isFile() || !string3.startsWith("translation") || !string3.endsWith(".properties")) continue;
                    this.a("Resources/" + string3, (File)fileArray3);
                }
            }
        }
        if (!bl2) {
            if (BaseUtils.isError()) {
                BaseUtils.error("No content.xml file found in directory: " + file.getAbsolutePath());
            }
            throw new FileNotFoundException(file.getAbsolutePath() + File.separator + "content.xml");
        }
    }

    private void a(String string, File file) throws IOException {
        this.bvL.put(string.replace('\\', "/".charAt(0)), RFReader.toByteArray(new FileInputStream(file)));
    }

    private byte[] eo(String string) {
        return this.bvL.get(string);
    }

    public byte[] getManifest() {
        return this.eo("META-INF/manifest.xml");
    }

    public byte[] getThumbnail() {
        return this.eo("Thumbnails/thumbnail.png");
    }

    public byte[] getContent() {
        return this.eo("content.xml");
    }

    public byte[] getContent(int n2) {
        return this.eo("Sub_" + n2 + "/" + "content.xml");
    }

    public Hashtable<String, String> getSummaryMetaInfo() throws IOException {
        return RFReader.aN(this.eo("meta.xml"));
    }

    public Hashtable<String, String> getSummaryMetaInfo(int n2) throws IOException {
        return RFReader.aN(this.eo("Sub_" + n2 + "/" + "meta.xml"));
    }

    private static Hashtable<String, String> aN(byte[] byArray) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (byArray != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DocumentBuilder documentBuilder = BaseUtils.newDocumentBuilderFactory().newDocumentBuilder();
                Document document = documentBuilder.parse(byteArrayInputStream);
                NodeList nodeList = document.getDocumentElement().getChildNodes();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                    Node node = nodeList.item(i2);
                    if (node.getNodeType() != 1) continue;
                    String string = node.getNodeName();
                    String string2 = node.getTextContent();
                    if ("Keyword".equals(string)) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(string2);
                        continue;
                    }
                    hashtable.put(string, string2);
                }
                if (stringBuilder.length() > 0) {
                    hashtable.put("Keyword", stringBuilder.toString());
                }
                byteArrayInputStream = null;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException);
            }
        }
        return hashtable;
    }

    public void initSummaryInfo(SummaryInfo summaryInfo) throws IOException {
        this.a(this.getSummaryMetaInfo(), summaryInfo);
    }

    public void initSummaryInfo(SummaryInfo summaryInfo, int n2) throws IOException {
        this.a(this.getSummaryMetaInfo(n2), summaryInfo);
    }

    private void a(Hashtable<String, String> hashtable, SummaryInfo summaryInfo) {
        summaryInfo.setAuthor(hashtable.get("Author"));
        summaryInfo.setKeywords(hashtable.get("Keyword"));
        summaryInfo.setComments(hashtable.get("Comments"));
        summaryInfo.setReportTitle(hashtable.get("Title"));
        summaryInfo.setSubject(hashtable.get("Subject"));
        summaryInfo.setTemplate(hashtable.get("Template"));
        Date date = null;
        String string = hashtable.get("Created");
        if (string != null && string.length() > 0) {
            try {
                date = this.GY.parse(string);
            }
            catch (ParseException parseException) {
                BaseUtils.printStackTrace(parseException);
            }
            summaryInfo.setCreated(date);
        }
        date = null;
        string = hashtable.get("LastSaved");
        if (string != null && string.length() > 0) {
            try {
                date = this.GY.parse(string);
            }
            catch (ParseException parseException) {
                BaseUtils.printStackTrace(parseException);
            }
            summaryInfo.setLastSaved(date);
        }
    }

    public byte[] getImage(String string) {
        return this.eo("Pictures/" + string);
    }

    public byte[] getImage(String string, int n2) {
        return this.eo("Sub_" + n2 + "/" + "Pictures" + "/" + string);
    }

    public byte[] getTranslation(String string) {
        return this.eo("Resources/translation" + string + ".properties");
    }

    public byte[] getTranslationOptions() {
        return this.eo("Resources/options.xml");
    }

    public String getMimetype() {
        byte[] byArray = this.eo("mimetype");
        return byArray == null ? null : new String(byArray);
    }

    public Hashtable<String, byte[]> getNameToData() {
        return this.bvL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] a(InputStream inputStream, boolean bl2) throws IOException {
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] byArray = IOFunctions.readBytes(inputStream);
            return byArray;
        }
        finally {
            if (bl2) {
                inputStream.close();
            }
        }
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        return RFReader.a(inputStream, true);
    }

    public Properties readMetaProperties() throws IOException {
        byte[] byArray = this.eo("metaproperties.xml");
        Properties properties = new Properties();
        if (byArray != null) {
            properties.loadFromXML(new ByteArrayInputStream(byArray));
        }
        return properties;
    }

    public Properties readMetaProperties(int n2) throws IOException {
        byte[] byArray = this.eo("Sub_" + n2 + "/" + "metaproperties.xml");
        Properties properties = new Properties();
        if (byArray != null) {
            properties.loadFromXML(new ByteArrayInputStream(byArray));
        }
        return properties;
    }
}

