/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.permissions;

import com.inet.report.BaseUtils;
import com.inet.report.config.ConfigValue;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.permissions.PermissionUrlObject;
import com.inet.report.permissions.ReportPermissions;
import com.inet.report.permissions.WebUserInfo;
import com.inet.report.permissions.l;
import com.inet.report.permissions.o;
import com.inet.report.permissions.t;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class PermissionChecker {
    private static PermissionChecker bwq = new PermissionChecker();
    private static final ConfigValue<Boolean> bwr = new ConfigValue(ConfigKey.PERMISSION_ENABLED);
    private static final ConfigValue<PermissionUrlObject> bws = new l(ConfigKey.PERMISSION);

    private PermissionChecker() {
    }

    public static PermissionChecker getInstance() {
        return bwq;
    }

    public static void checkReportLocation(WebUserInfo webUserInfo, URL uRL) throws o {
        PermissionChecker.getInstance().checkReportLocationPermission(webUserInfo, uRL);
    }

    public void checkReportLocationPermission(WebUserInfo webUserInfo, URL uRL) throws o {
        if (webUserInfo != null && webUserInfo.isSystemAdministrator()) {
            return;
        }
        t.f(uRL);
    }

    public static void checkExecuteRight(WebUserInfo webUserInfo, URL uRL) throws o {
        PermissionChecker.getInstance().checkExecutePermission(webUserInfo, uRL);
    }

    public void checkExecutePermission(WebUserInfo webUserInfo, URL uRL) throws o {
        PermissionUrlObject permissionUrlObject;
        String string;
        if (webUserInfo != null && webUserInfo.isSystemAdministrator()) {
            return;
        }
        PermissionChecker.checkReportLocation(webUserInfo, uRL);
        if (!bwr.get().booleanValue()) {
            return;
        }
        if (webUserInfo == null) {
            return;
        }
        String string2 = "";
        boolean bl2 = uRL.getProtocol().equals("file");
        if (bl2) {
            File file = new File(uRL.getPath());
            string = file.getName();
            try {
                file = file.getCanonicalFile();
                string2 = file.toURL().toString();
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
            }
        } else {
            string2 = uRL.toString();
            int n2 = string2.lastIndexOf(47);
            string = string2.substring(n2 + 1);
        }
        if (BaseUtils.isParanoid()) {
            BaseUtils.paranoid("Checking global permissions...");
        }
        if ((permissionUrlObject = bws.get()) != null && permissionUrlObject.checkAccess(webUserInfo, string, string2, 1)) {
            if (BaseUtils.isParanoid()) {
                BaseUtils.paranoid("Global Permission: Access granted for " + webUserInfo.getWebUserName());
            }
            return;
        }
        if (BaseUtils.isParanoid()) {
            BaseUtils.paranoid("Checking folder permissions...");
        }
        PermissionUrlObject permissionUrlObject2 = null;
        try {
            permissionUrlObject2 = ReportPermissions.getPermission(uRL);
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
        }
        if (permissionUrlObject2 != null && permissionUrlObject2.checkAccess(webUserInfo, string, "", 1)) {
            if (BaseUtils.isParanoid()) {
                BaseUtils.paranoid("Folder Permission: Access granted for " + webUserInfo.getWebUserName());
            }
            return;
        }
        if (BaseUtils.isParanoid()) {
            BaseUtils.paranoid("Access denied!");
        }
        throw new o(ErrorCode.AccessDenied, uRL);
    }
}

