/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.permissions;

import com.inet.report.permissions.Permission;
import com.inet.report.permissions.PermissionGroup;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Permissions
implements Serializable {
    private HashMap<PermissionGroup, HashMap<Permission, String>> permissions = new HashMap();

    public Permissions() {
    }

    public Permissions(Permissions permissions) {
        if (permissions != null) {
            for (Map.Entry<PermissionGroup, HashMap<Permission, String>> entry : permissions.permissions.entrySet()) {
                PermissionGroup permissionGroup = entry.getKey();
                HashMap<Permission, String> hashMap = entry.getValue();
                HashMap<Permission, String> hashMap2 = new HashMap<Permission, String>();
                for (Map.Entry<Permission, String> entry2 : hashMap.entrySet()) {
                    hashMap2.put(entry2.getKey(), entry2.getValue());
                }
                this.permissions.put(permissionGroup, hashMap2);
            }
        }
    }

    public Set<PermissionGroup> getGroups() {
        return this.permissions.keySet();
    }

    public void setPermission(Permission permission, String string) {
        PermissionGroup permissionGroup = this.getPermissionGroup(permission);
        if (permissionGroup != null) {
            HashMap<Permission, String> hashMap = this.permissions.get((Object)permissionGroup);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.permissions.put(permissionGroup, hashMap);
            }
            hashMap.put(permission, string);
        }
    }

    public String getPermission(Permission permission) {
        PermissionGroup permissionGroup = this.getPermissionGroup(permission);
        if (permissionGroup == null) {
            return permission.getDefaultValue().toString();
        }
        HashMap<Permission, String> hashMap = this.permissions.get((Object)permissionGroup);
        if (hashMap == null) {
            return permission.getDefaultValue().toString();
        }
        String string = hashMap.get((Object)permission);
        if (string == null) {
            string = permission.getDefaultValue().toString();
        }
        return string;
    }

    public boolean isEmpty() {
        if (!this.permissions.isEmpty()) {
            for (PermissionGroup permissionGroup : this.permissions.keySet()) {
                HashMap<Permission, String> hashMap = this.permissions.get((Object)permissionGroup);
                for (Permission permission : hashMap.keySet()) {
                    String string = permission.getDefaultValue().toString();
                    if (string.equals(hashMap.get((Object)permission))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof Permissions) {
            Permissions permissions = (Permissions)object;
            for (PermissionGroup permissionGroup : this.permissions.keySet()) {
                if (!permissions.getGroups().contains((Object)permissionGroup)) {
                    return false;
                }
                for (Permission permission : permissionGroup.getPermissions()) {
                    String string = permissions.getPermission(permission);
                    String string2 = this.getPermission(permission);
                    if (string2.equals(string)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private PermissionGroup getPermissionGroup(Permission permission) {
        for (PermissionGroup permissionGroup : PermissionGroup.values()) {
            Permission[] permissionArray = permissionGroup.getPermissions();
            List<Permission> list = Arrays.asList(permissionArray);
            if (!list.contains((Object)permission)) continue;
            return permissionGroup;
        }
        return null;
    }
}

