/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.permissions;

import com.inet.report.permissions.Permission;
import com.inet.report.permissions.PermissionHolder;
import com.inet.report.permissions.Permissions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SystemPermissions
implements Serializable {
    private HashMap<PermissionHolder, Permissions> permissionMap = new HashMap();

    public Set<PermissionHolder> getHolder() {
        return this.permissionMap.keySet();
    }

    public Set<PermissionHolder> getHolder(PermissionHolder.TYPE tYPE) {
        Set<PermissionHolder> set = this.permissionMap.keySet();
        HashSet<PermissionHolder> hashSet = new HashSet<PermissionHolder>();
        for (PermissionHolder permissionHolder : set) {
            if (permissionHolder.getType() != tYPE) continue;
            hashSet.add(permissionHolder);
        }
        return hashSet;
    }

    public String getPermission(PermissionHolder permissionHolder, Permission permission) {
        Permissions permissions = this.permissionMap.get(permissionHolder);
        if (permissions != null) {
            return permissions.getPermission(permission);
        }
        return null;
    }

    public void setPermission(PermissionHolder permissionHolder, Permission permission, String string) {
        Permissions permissions = this.permissionMap.get(permissionHolder);
        if (permissions == null) {
            permissions = new Permissions();
        }
        permissions.setPermission(permission, string);
        this.setPermissions(permissionHolder, permissions);
    }

    public void setPermissions(PermissionHolder permissionHolder, Permissions permissions) {
        this.permissionMap.put(permissionHolder, permissions);
    }

    public Permissions getPermissions(PermissionHolder permissionHolder) {
        return this.permissionMap.get(permissionHolder);
    }

    public HashMap<PermissionHolder, Permissions> getPermissions() {
        return this.permissionMap;
    }

    public void removeHolder(PermissionHolder permissionHolder) {
        this.permissionMap.remove(permissionHolder);
    }

    public boolean containsHolder(PermissionHolder permissionHolder) {
        return this.permissionMap.containsKey(permissionHolder);
    }
}

