/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.permissions;

import com.inet.report.BaseUtils;
import com.inet.report.ah;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.permissions.LoginSettings;
import com.inet.report.permissions.RemoteWebUserInfo;
import com.inet.report.permissions.WebUserInfo;
import com.inet.report.permissions.e;
import com.inet.report.permissions.h;
import com.inet.report.permissions.k;
import com.inet.report.permissions.q;
import com.inet.report.permissions.s;
import com.inet.report.permissions.u;
import com.inet.report.permissions.v;
import com.inet.report.permissions.w;
import com.inet.report.permissions.x;
import com.inet.report.permissions.y;
import com.inet.report.permissions.z;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.HashSet;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WebUserInfoFactory {
    private static final ThreadLocal<WebUserInfo> bxb = new ThreadLocal();
    private static WebUserInfo bxc;
    public static final HashSet<String> AUTHED_USERS;
    private static boolean bxd;
    private static boolean bxe;
    private static v bxf;
    public static final WebUserInfo DUMMY_WEBUSERINFO;

    private WebUserInfoFactory() {
    }

    public static void setMasterCreator(v v2) {
        bxf = v2;
    }

    public static WebUserInfo generateWebUserInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, LoginSettings loginSettings) {
        WebUserInfo webUserInfo;
        if (loginSettings.isAuthenticationActivated()) {
            if (!WebUserInfoFactory.createWebUserInfo(httpServletRequest, httpServletResponse, loginSettings)) {
                return null;
            }
            webUserInfo = WebUserInfoFactory.getSessionWebUserInfo();
            if (webUserInfo.getWebUserName() == null && webUserInfo instanceof RemoteWebUserInfo) {
                Properties properties = new Properties();
                ((RemoteWebUserInfo)webUserInfo).requestLoginData(httpServletRequest, httpServletResponse, properties, null);
                return null;
            }
        } else {
            webUserInfo = WebUserInfoFactory.getSessionWebUserInfo();
            if (webUserInfo == null) {
                webUserInfo = DUMMY_WEBUSERINFO;
            }
        }
        return webUserInfo;
    }

    public static boolean createWebUserInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, LoginSettings loginSettings) {
        boolean bl2 = httpServletRequest.getHeader("Authorization") != null;
        WebUserInfo webUserInfo = null;
        HttpSession httpSession = httpServletRequest.getSession(true);
        Object object = httpSession.getAttribute("WebUserInfo");
        if (WebUserInfoFactory.isValidLoginConfiguration(httpServletRequest, loginSettings) || bl2 || object instanceof WebUserInfo) {
            try {
                Object object2;
                if (object instanceof WebUserInfo) {
                    if (object instanceof q) {
                        object = new q(httpServletRequest);
                    }
                    webUserInfo = (WebUserInfo)object;
                } else {
                    object2 = loginSettings.getLoginType();
                    switch (1.bxg[((Enum)object2).ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: {
                            String string = loginSettings.getLoginURL();
                            if (object2 == LoginSettings.LoginType.ldap) {
                                webUserInfo = new e(string);
                                break;
                            }
                            if (string != null && string.length() > 0) {
                                if (string.startsWith("ldap://")) {
                                    webUserInfo = new e(string);
                                    break;
                                }
                                URL uRL = WebUserInfoFactory.a(httpServletRequest, string);
                                webUserInfo = new u(uRL, loginSettings.getTrustAllHttps());
                                break;
                            }
                            if (object2 != LoginSettings.LoginType.automatic) break;
                        }
                        case 4: {
                            if (y.bxh) {
                                try {
                                    webUserInfo = new h();
                                }
                                catch (Exception exception) {
                                    BaseUtils.printStackTrace(exception);
                                }
                                break;
                            }
                            if (object2 != LoginSettings.LoginType.automatic) break;
                        }
                        case 5: {
                            if (y.bxi) {
                                try {
                                    webUserInfo = new k();
                                }
                                catch (Exception exception) {
                                    BaseUtils.printStackTrace(exception);
                                }
                                break;
                            }
                            if (object2 != LoginSettings.LoginType.automatic) break;
                        }
                        case 6: {
                            if (WebUserInfoFactory.a(httpServletRequest)) {
                                URL uRL = WebUserInfoFactory.a(httpServletRequest, "");
                                webUserInfo = new u(uRL, loginSettings.getTrustAllHttps());
                                break;
                            }
                            Principal principal = httpServletRequest.getUserPrincipal();
                            if (principal != null && principal.getName() != null) {
                                webUserInfo = new q(httpServletRequest);
                                break;
                            }
                        }
                        case 7: {
                            if (bxf == null) break;
                            webUserInfo = bxf.bi();
                        }
                    }
                }
                if (bl2 && webUserInfo instanceof RemoteWebUserInfo && (webUserInfo.getWebUserName() == null || webUserInfo instanceof h && httpServletRequest.getMethod().equals("POST") && httpServletRequest.getContentLength() == 0)) {
                    object2 = (RemoteWebUserInfo)webUserInfo;
                    object2.setLoginDelay(loginSettings.isLoginDelay());
                    if (!object2.transferClientLoginData(httpServletRequest, httpServletResponse)) {
                        httpSession.setAttribute("WebUserInfo", webUserInfo);
                        return false;
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                BaseUtils.printStackTrace(malformedURLException);
            }
        }
        if (webUserInfo == null) {
            webUserInfo = new q(httpServletRequest);
        } else {
            httpSession.setAttribute("WebUserInfo", webUserInfo);
        }
        if (webUserInfo instanceof RemoteWebUserInfo) {
            webUserInfo = new z((RemoteWebUserInfo)webUserInfo);
        }
        bxb.set(webUserInfo);
        return true;
    }

    private static URL a(HttpServletRequest httpServletRequest, String string) throws MalformedURLException, IllegalArgumentException {
        URL uRL;
        AbstractStringBuilder abstractStringBuilder;
        if (string.length() == 0) {
            abstractStringBuilder = new StringBuilder();
            ((StringBuilder)abstractStringBuilder).append(httpServletRequest.getScheme());
            ((StringBuilder)abstractStringBuilder).append("://");
            ((StringBuilder)abstractStringBuilder).append(httpServletRequest.getServerName());
            ((StringBuilder)abstractStringBuilder).append(":");
            ((StringBuilder)abstractStringBuilder).append(httpServletRequest.getServerPort());
            ((StringBuilder)abstractStringBuilder).append(httpServletRequest.getContextPath()).append("/LoginServlet");
            uRL = new URL(((StringBuilder)abstractStringBuilder).toString());
        } else {
            uRL = new URL(string);
        }
        abstractStringBuilder = httpServletRequest.getRequestURL();
        if (abstractStringBuilder != null && uRL.equals(new URL(((StringBuffer)abstractStringBuilder).toString()))) {
            throw ah.a(uRL, "LoginURL", ErrorCode.WrongLoginUrl);
        }
        return uRL;
    }

    public static boolean isValidLoginConfiguration(HttpServletRequest httpServletRequest, LoginSettings loginSettings) {
        switch (loginSettings.getLoginType()) {
            case automatic: {
                if (loginSettings.getLoginURL() != null && loginSettings.getLoginURL().length() > 0) {
                    return true;
                }
                if (y.bxh || y.bxi) {
                    return true;
                }
                if (WebUserInfoFactory.a(httpServletRequest)) {
                    return true;
                }
                return bxf != null;
            }
            case external: {
                return loginSettings.getLoginURL() != null && loginSettings.getLoginURL().length() > 0;
            }
            case ldap: {
                return true;
            }
            case windows: {
                return y.bxh;
            }
            case pam: {
                return y.bxi;
            }
            case internal: {
                return WebUserInfoFactory.a(httpServletRequest) || httpServletRequest.getUserPrincipal() != null && httpServletRequest.getUserPrincipal().getName() != null;
            }
            case master: {
                return true;
            }
        }
        return false;
    }

    private static boolean a(HttpServletRequest httpServletRequest) {
        block7: {
            if (!bxd) {
                bxd = true;
                try {
                    URL uRL = WebUserInfoFactory.a(httpServletRequest, "");
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    WebUserInfoFactory.a(httpURLConnection, true);
                    httpURLConnection.setAllowUserInteraction(false);
                    try {
                        httpURLConnection.getInputStream().close();
                        bxe = false;
                    }
                    catch (IOException iOException) {
                        if (httpURLConnection.getResponseCode() == 401 && httpURLConnection.getHeaderField("WWW-Authenticate") != null) {
                            bxe = true;
                        }
                        if (BaseUtils.isDebug()) {
                            BaseUtils.debug(iOException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    bxe = false;
                    if (!BaseUtils.isDebug()) break block7;
                    BaseUtils.debug(throwable);
                }
            }
        }
        return bxe;
    }

    static void a(HttpURLConnection httpURLConnection, boolean bl2) throws IOException {
        if (bl2 && httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            try {
                httpsURLConnection.setSSLSocketFactory(s.getSSLSocketFactory());
                httpsURLConnection.setHostnameVerifier(new x());
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                throw iOException;
            }
        }
    }

    public static String normalizeSlashes(String string) {
        if (string != null) {
            return string.replaceAll("\\\\", "/");
        }
        return string;
    }

    public static void setWebUserInfoDesigner(WebUserInfo webUserInfo) {
        bxc = webUserInfo;
    }

    public static void setWebUserInfo(WebUserInfo webUserInfo) {
        bxb.set(webUserInfo);
    }

    public static void destroyWebUserInfo() {
        bxb.set(null);
    }

    public static WebUserInfo getSessionWebUserInfo() {
        if (bxc != null) {
            return bxc;
        }
        return bxb.get();
    }

    static {
        AUTHED_USERS = new HashSet();
        DUMMY_WEBUSERINFO = new w();
    }
}

