/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.repository;

import com.inet.report.BaseUtils;
import com.inet.report.ay;
import com.inet.report.config.ConfigValue;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.repository.CCFolder;
import com.inet.report.repository.CCResource;
import com.inet.report.repository.Repository;
import com.inet.report.repository.abstracts.AbstractFolder;
import com.inet.report.repository.abstracts.AbstractRepository;
import com.inet.report.repository.db.e;
import com.inet.report.repository.hd.f;
import com.inet.report.repository.i18n.a;
import com.inet.report.repository.l;
import com.inet.report.repository.o;
import com.inet.report.repository.p;
import com.inet.report.repository.q;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class RepositoryManager {
    public static final String HD_TYPE = "file";
    public static final String DB_TYPE = "jdbc";
    public static final String REPOS_DELIMITER = "|";
    public static final String URL_ACTIVE_DELIMITER = ";";
    public static final String JDBC_INFO_DELIMITER = ";";
    private String cdY = "";
    private ArrayList<Repository> cdZ = new ArrayList();
    private Repository cea;
    private static RepositoryManager ceb = new RepositoryManager();
    private Set<l> listeners = new HashSet<l>();
    private static ConfigValue<String> cec = new o(ConfigKey.CCREPOSITORY_PATHLIST);
    private static final ConfigValue<String> ced = new p(ConfigKey.PERMISSION);
    private static final ConfigValue<String> cee = new q(ConfigKey.USERDIRECTORIES_PERMISSIONS);

    RepositoryManager() {
        BaseUtils.gn();
        if (ceb == null) {
            ceb = this;
        }
    }

    public static RepositoryManager getInstance() {
        return ceb;
    }

    public Repository copyRepository(Repository repository, URI uRI) {
        Repository repository2 = null;
        if (repository == null) {
            throw new NullPointerException(a.getMsg("error.NPE.copy.source"));
        }
        if (uRI == null) {
            throw new NullPointerException(a.getMsg("error.NPE.copy.target"));
        }
        if (repository.getLocation().toString().equals(uRI.toString())) {
            throw new IllegalArgumentException(a.getMsg("error.IAE.copy"));
        }
        repository2 = this.createRepository(uRI);
        if (repository2 == null) {
            BaseUtils.error(a.getMsg("error.cclog.copy"));
            return null;
        }
        CCFolder cCFolder = repository.getRoot();
        CCFolder cCFolder2 = repository2.getRoot();
        cCFolder.copyFolderContent(cCFolder2);
        return repository2;
    }

    public Repository createRepository(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("location of the repository is null");
        }
        String string = uRI.toString().toLowerCase();
        if (string.indexOf(REPOS_DELIMITER) != -1) {
            throw new IllegalArgumentException(a.getMsg("error.IAE.create.chraracter", REPOS_DELIMITER));
        }
        for (Repository object2 : this.cdZ) {
            String string2 = object2.getLocation().toString().toLowerCase();
            if (!string.equals(string2)) continue;
            throw new IllegalArgumentException(a.getMsg("error.IAE.create.fail", string));
        }
        String string2 = uRI.getScheme();
        if (HD_TYPE.equals(string2)) {
            for (Repository repository : this.cdZ) {
                if (repository.getLocation() == null || !HD_TYPE.equals(repository.getLocation().getScheme()) || !f.a(uRI, repository.getLocation())) continue;
                throw new IllegalArgumentException(a.getMsg("error.IAE.create.fail.parent", string));
            }
            f f2 = new f(uRI);
            this.cdZ.add(f2);
            return f2;
        }
        if (DB_TYPE.equals(string2)) {
            e e2 = new e(uRI);
            this.cdZ.add(e2);
            return e2;
        }
        throw new IllegalArgumentException(a.getMsg("error.IAE.create.invalide", string2));
    }

    public boolean deleteRepository(Repository repository, boolean bl2) {
        if (repository == null) {
            throw new IllegalStateException(a.getMsg("error.ISE.delete.null"));
        }
        if (this.cea != null && this.cea.getLocation().equals(repository.getLocation())) {
            throw new IllegalStateException(a.getMsg("error.ISE.delete.active"));
        }
        CCFolder cCFolder = repository.getRoot();
        if (cCFolder == null || !cCFolder.exists()) {
            throw new IllegalStateException(a.getMsg("error.ISE.delete.notexists"));
        }
        List<CCResource> list = null;
        if (!(cCFolder instanceof AbstractFolder)) {
            BaseUtils.error(a.getMsg("error.cclog.delete.root"));
            return false;
        }
        list = ((AbstractFolder)repository.getRoot()).getAllResources(0, true);
        if (list.size() != 0) {
            if (bl2) {
                BaseUtils.warning(a.getMsg("error.cclog.delete.empty"));
                return false;
            }
            List<CCResource> list2 = null;
            if (cCFolder instanceof AbstractFolder) {
                list2 = ((AbstractFolder)repository.getRoot()).getAllResources(2, true);
            }
            if (list2 == null || list2.size() != list.size()) {
                BaseUtils.warning(a.getMsg("error.cclog.delete.unable"));
                return false;
            }
        }
        repository.stopIndexer();
        if (cCFolder.delete(true)) {
            this.removeRepository(repository.getLocation());
            return true;
        }
        BaseUtils.error(a.getMsg("error.cclog.delete.root"));
        return false;
    }

    public boolean existsRepository(URI uRI) {
        return this.getRepository(uRI) != null;
    }

    public Repository getRepository(URI uRI) {
        if (uRI == null) {
            return null;
        }
        for (Repository repository : this.cdZ) {
            if (!uRI.equals(repository.getLocation())) continue;
            return repository;
        }
        return null;
    }

    public List<Repository> getRepositories() {
        if (this.cdZ == null) {
            this.cdZ = new ArrayList();
        }
        ArrayList arrayList = (ArrayList)this.cdZ.clone();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setActiveRepository(Repository repository) {
        Repository repository2 = this.cea;
        try {
            if (!ay.kE().isPlusVersion()) {
                BaseUtils.error(a.getMsg("error.cclog.activate.noplus"));
                repository = null;
            }
            if (ay.kE().a((short)0)) {
                BaseUtils.error(a.getMsg("error.cclog.activate.expired"));
                repository = null;
            }
            if (repository == null) {
                if (this.cea != null) {
                    this.cea.stopIndexer();
                }
                this.cea = repository;
                BaseUtils.debug(a.getMsg("error.cclog.activate.deactivate"));
                boolean bl2 = false;
                return bl2;
            }
            if (!this.existsRepository(repository.getLocation())) {
                this.cdZ.add(repository);
            }
            if (this.cea != null) {
                this.cea.stopIndexer();
            }
            this.cea = repository;
            this.cea.startIndexer(true);
            BaseUtils.info(a.getMsg("error.cclog.activate.location", this.cea.getLocation()));
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.a(repository2, this.cea);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getActiveRepository() {
        if (!ay.kE().isPlusVersion() || ay.kE().a((short)0)) {
            return null;
        }
        RepositoryManager repositoryManager = this;
        synchronized (repositoryManager) {
            String string;
            if (this.cea == null && (string = cec.get()) != null && string.length() > 0) {
                String[] stringArray = string.split(Pattern.quote(REPOS_DELIMITER));
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string2 = stringArray[i2].trim().toLowerCase();
                    if (!string2.endsWith(";true")) continue;
                    this.fw(string);
                    break;
                }
            }
        }
        if (this.cea != null) {
            this.cea.startIndexer(false);
        }
        return this.cea;
    }

    public Repository addRepository(URI uRI) {
        Object object;
        if (uRI == null) {
            BaseUtils.error(a.getMsg("error.cclog.add.null"));
            return null;
        }
        for (Repository object2 : this.cdZ) {
            if (!object2.getLocation().equals(uRI)) continue;
            return object2;
        }
        if (HD_TYPE.equals(uRI.getScheme())) {
            object = uRI.getPath();
            File file = new File((String)object);
            if (file.exists()) {
                f f2 = new f(uRI);
                if (f2.getRoot() == null) {
                    return null;
                }
                this.cdZ.add(f2);
                return f2;
            }
            BaseUtils.error(a.getMsg("error.cclog.add.notexist", uRI.toString()));
        } else if (DB_TYPE.equals(uRI.getScheme())) {
            object = new e(uRI);
            if (object.getRoot() == null) {
                return null;
            }
            this.cdZ.add((Repository)object);
            return object;
        }
        return null;
    }

    public boolean removeRepository(URI uRI) {
        if (uRI == null) {
            return false;
        }
        Repository repository = this.getRepository(uRI);
        if (repository != null) {
            if (uRI.equals(this.cea == null ? null : this.cea.getLocation())) {
                this.setActiveRepository(null);
            }
            this.cdZ.remove(repository);
            return true;
        }
        return false;
    }

    private void fw(String string) {
        String string2;
        String string3;
        Object object;
        String string4 = null;
        this.cdZ.clear();
        if (string == null || string.length() == 0) {
            if (this.getActiveRepository() != null) {
                this.setActiveRepository(null);
            }
            BaseUtils.debug(a.getMsg("error.cclog.restore.notexist"));
            return;
        }
        String[] stringArray = string.split(Pattern.quote(REPOS_DELIMITER));
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Repository repository;
            block14: {
                object = stringArray[i2].trim();
                if (((String)object).indexOf(";") == -1) continue;
                int n2 = ((String)object).lastIndexOf(";");
                string3 = ((String)object).substring(0, n2);
                string2 = ((String)object).substring(n2 + 1);
                boolean bl2 = false;
                if (string3.startsWith(DB_TYPE)) {
                    bl2 = true;
                }
                repository = null;
                try {
                    repository = this.t(string3, bl2);
                }
                catch (Throwable throwable) {
                    if (!BaseUtils.isDebug()) break block14;
                    BaseUtils.debug(throwable.getMessage());
                }
            }
            if (repository == null) continue;
            if (string2.equalsIgnoreCase("true")) {
                string4 = repository.getLocation().toString();
            }
            this.cdZ.add(repository);
        }
        if (string4 == null || string4.trim().length() == 0) {
            if (this.cea != null) {
                this.setActiveRepository(null);
            }
        } else {
            Repository repository = null;
            try {
                object = new URI(string4);
                Repository repository2 = this.getRepository((URI)object);
                if (repository2 != null) {
                    repository = repository2;
                }
                string3 = this.cea == null ? "" : this.cea.getLocation().toString();
                String string5 = string2 = repository == null ? "" : repository.getLocation().toString();
                if (string2.length() > 0 && !string3.equals(string2)) {
                    this.setActiveRepository(repository);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private Repository t(String string, boolean bl2) {
        AbstractRepository abstractRepository;
        block9: {
            abstractRepository = null;
            if (string != null) {
                string = string.trim();
                if (bl2) {
                    try {
                        URI uRI = new URI(string);
                        abstractRepository = new e(uRI);
                    }
                    catch (Throwable throwable) {
                        if (BaseUtils.gk()) {
                            BaseUtils.warning(throwable.getMessage());
                        }
                        if (BaseUtils.isParanoid()) {
                            BaseUtils.paranoid(throwable);
                        }
                        break block9;
                    }
                }
                try {
                    URI uRI = new URI(string);
                    abstractRepository = new f(uRI);
                }
                catch (Throwable throwable) {
                    if (BaseUtils.gk()) {
                        BaseUtils.warning(throwable.getMessage());
                    }
                    if (!BaseUtils.isParanoid()) break block9;
                    BaseUtils.paranoid(throwable);
                }
            }
        }
        return abstractRepository;
    }

    public void clearConfig() {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        configuration.put(ConfigKey.CCREPOSITORY_PATHLIST.getKey(), "");
        this.setActiveRepository(null);
        this.cdZ.clear();
    }

    public void addRepositoryChangeListener(l l2) {
        if (l2 != null) {
            this.listeners.add(l2);
        }
    }

    public void removeRepositoryChangeListener(l l2) {
        if (l2 != null) {
            this.listeners.remove(l2);
        }
    }

    private void a(Repository repository, Repository repository2) {
        l.a a2;
        if (repository == repository2) {
            return;
        }
        if (repository == null) {
            a2 = l.a.cdU;
        } else {
            l.a a3 = a2 = repository2 == null ? l.a.cdW : l.a.cdV;
        }
        if (this.listeners.size() > 0) {
            for (l l2 : this.listeners) {
                l2.a(a2, repository2);
            }
        }
    }

    static /* synthetic */ ConfigValue c(ConfigValue configValue) {
        cec = configValue;
        return cec;
    }

    static /* synthetic */ RepositoryManager VE() {
        return ceb;
    }

    static /* synthetic */ void a(RepositoryManager repositoryManager, String string) {
        repositoryManager.fw(string);
    }

    static /* synthetic */ Repository a(RepositoryManager repositoryManager) {
        return repositoryManager.cea;
    }
}

