/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.repository.abstracts;

import com.inet.report.permissions.PermissionUrlObject;
import com.inet.report.repository.CCElement;
import com.inet.report.repository.CCFolder;
import com.inet.report.repository.CCResource;
import com.inet.report.repository.Repository;
import com.inet.report.repository.VirtualHomeInfo;
import com.inet.report.repository.abstracts.AbstractFolder;
import com.inet.report.repository.b;
import com.inet.report.repository.d;
import com.inet.report.repository.e;
import com.inet.report.repository.i;
import com.inet.report.repository.i18n.a;
import com.inet.report.repository.permission.FolderPermissions;
import com.inet.report.repository.permission.PermissionsInfo;
import com.inet.report.repository.r;
import com.inet.report.repository.u;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class AbstractRepository
implements Repository,
e {
    public static final Pattern SEPARATOR_PATTERN = Pattern.compile("[/\\\\]");
    private final PermissionsInfo cek;
    private final i cef;
    private Thread ceu;

    public AbstractRepository(PermissionsInfo permissionsInfo) {
        this.cek = permissionsInfo;
        this.cef = new i(this);
    }

    @Override
    public boolean clear() {
        this.initialize();
        AbstractFolder abstractFolder = (AbstractFolder)this.getRoot();
        if (abstractFolder == null) {
            return true;
        }
        if (this.getPermissionsInfo().isPermissionsActivated()) {
            List<CCResource> list = abstractFolder.getAllResources(2, true);
            List<CCResource> list2 = abstractFolder.getAllResources(0, true);
            if (list.size() != list2.size()) {
                throw new com.inet.report.permissions.a(a.getMsg("error.ADE.repo.del.permission"));
            }
        }
        return abstractFolder.clear();
    }

    protected abstract void initialize();

    @Override
    public PermissionsInfo getPermissionsInfo() {
        return this.cek;
    }

    @Override
    public void stateChanged(d d2) {
        if (d2.getType() == 2) {
            this.cef.g(d2.Vx());
        } else {
            this.cef.f(d2.Vx());
        }
        this.cef.VC();
    }

    @Override
    public void stateChanged(b b2) {
        if (b2.getType() == 2) {
            this.cef.l(b2.Vw());
        } else {
            this.cef.k(b2.Vw());
        }
        this.cef.VC();
    }

    @Override
    public void startIndexer(boolean bl2) {
        boolean bl3;
        if (this.getRoot() == null) {
            return;
        }
        if (bl2) {
            this.stopIndexer();
        }
        boolean bl4 = bl3 = this.ceu == null || !this.ceu.isAlive();
        if (bl3) {
            this.ceu = new i.b(this.cef);
        }
        this.cef.init();
        this.cef.db(true);
        if (bl3) {
            this.ceu.setPriority(1);
            this.ceu.setName("Repository Indexer");
            this.ceu.start();
        }
    }

    @Override
    public void stopIndexer() {
        for (int i2 = 0; i2 < 50 && !this.cef.isFinished() && this.ceu != null && this.ceu.isAlive(); ++i2) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.cef.db(false);
        try {
            if (this.ceu != null && this.ceu.isAlive()) {
                this.ceu.join(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public i getIndexer() {
        this.initialize();
        return this.cef;
    }

    public Thread getIndexerThread() {
        this.initialize();
        return this.ceu;
    }

    @Override
    public List<CCResource> search(String string) throws Exception {
        this.initialize();
        ArrayList<CCResource> arrayList = new ArrayList<CCResource>();
        LinkedHashSet<String> linkedHashSet = new r(this.cef).fx(string);
        VirtualHomeInfo virtualHomeInfo = new VirtualHomeInfo(this.cek);
        String string2 = null;
        String string3 = null;
        if (virtualHomeInfo.isActive() && virtualHomeInfo.VH()) {
            string3 = com.inet.report.repository.abstracts.e.b(this.getRoot());
            string2 = ("/users/" + (virtualHomeInfo.VJ() != null ? virtualHomeInfo.VJ() + "/" : "") + virtualHomeInfo.getUserName() + "/").toLowerCase();
        }
        for (String string4 : linkedHashSet) {
            if (string4 == null) continue;
            try {
                CCResource cCResource;
                if (string2 != null && string3 != null && string4.toLowerCase().startsWith(string2)) {
                    string4 = string3 + "/" + string4.substring(string2.length());
                }
                if ((cCResource = this.getResource(string4)) == null) continue;
                if (this.getPermissionsInfo().isPermissionsActivated()) {
                    FolderPermissions folderPermissions = cCResource.getParent().getFolderPermissions();
                    int n2 = folderPermissions.getPermission(cCResource.getName());
                    if ((n2 & 4) != 4) continue;
                    arrayList.add(cCResource);
                    continue;
                }
                arrayList.add(cCResource);
            }
            catch (com.inet.report.permissions.a a2) {}
        }
        return arrayList;
    }

    @Override
    public CCResource getResource(String string) {
        if (string == null) {
            return null;
        }
        this.initialize();
        String[] stringArray = SEPARATOR_PATTERN.split(string);
        int n2 = stringArray.length;
        if (n2 == 0) {
            return null;
        }
        String string2 = stringArray[n2 - 1];
        CCFolder cCFolder = this.getRoot();
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            String string3 = stringArray[i2];
            if (string3.trim().length() == 0 || (cCFolder = cCFolder.getFolder(string3)) != null) continue;
            return null;
        }
        if (this.isCheckPermissionsActivated()) {
            u.a(cCFolder, string2, 4);
        }
        CCResource cCResource = cCFolder.getResource(string2);
        return cCResource;
    }

    @Override
    public CCFolder getFolder(String string) {
        if (string == null) {
            return null;
        }
        this.initialize();
        String[] stringArray = SEPARATOR_PATTERN.split(string);
        int n2 = stringArray.length;
        CCFolder cCFolder = this.getRoot();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (string2.trim().length() != 0) {
                cCFolder = cCFolder.getFolder(string2);
            }
            if (cCFolder != null) continue;
            return null;
        }
        return cCFolder;
    }

    @Override
    public boolean isCheckPermissionsActivated() {
        return this.cek != null && this.cek.isPermissionsActivated();
    }

    @Override
    public int getReportCount() {
        CCFolder cCFolder = this.getRoot();
        if (!(cCFolder instanceof AbstractFolder)) {
            return 0;
        }
        int n2 = this.getPermissionsInfo().isPermissionsActivated() ? 4 : 0;
        List<CCResource> list = ((AbstractFolder)cCFolder).getAllResources(n2, true);
        return list.size();
    }

    @Override
    public boolean isPermissionGranted(int n2, String string, CCFolder cCFolder) {
        this.initialize();
        if (!this.isCheckPermissionsActivated()) {
            return true;
        }
        FolderPermissions folderPermissions = cCFolder.getFolderPermissions();
        int n3 = folderPermissions.getPermission(string);
        return (n2 & n3) == n2;
    }

    @Override
    public List<CCResource> getAllResources() {
        return this.n(this.getRoot());
    }

    private ArrayList<CCResource> n(CCFolder cCFolder) {
        ArrayList<CCResource> arrayList = new ArrayList<CCResource>();
        if (cCFolder != null) {
            List<CCResource> list = cCFolder.getResources();
            if (list != null) {
                arrayList.addAll(list);
            }
            for (CCFolder cCFolder2 : cCFolder.getFolders()) {
                arrayList.addAll(this.n(cCFolder2));
            }
        }
        return arrayList;
    }

    @Override
    public boolean move(CCFolder cCFolder, CCFolder cCFolder2) {
        return this.a(cCFolder, cCFolder2, true);
    }

    @Override
    public boolean copy(CCFolder cCFolder, CCFolder cCFolder2) {
        return this.a(cCFolder, cCFolder2, false);
    }

    private boolean a(CCFolder cCFolder, CCFolder cCFolder2, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        List<CCResource> list;
        List<CCElement> list2;
        this.initialize();
        if (cCFolder == null || !cCFolder.exists()) {
            throw new IllegalStateException(a.getMsg("error.cclog.folder.removed"));
        }
        if (u.a(cCFolder, cCFolder2)) {
            throw new IllegalAccessError(a.getMsg("error.cclog.repo." + (bl2 ? "move" : "copy") + ".failed"));
        }
        if (cCFolder2 == null) {
            return false;
        }
        if (cCFolder.getParent() == null) {
            throw new IllegalArgumentException(a.getMsg("error.IAE.repo.move.root"));
        }
        if (cCFolder.equals(cCFolder2)) {
            throw new IllegalArgumentException(a.getMsg("error.IAE.repo.copy.self"));
        }
        if (this.getPermissionsInfo().isPermissionsActivated()) {
            list2 = ((AbstractFolder)cCFolder).getAllResources(6, true);
            list = ((AbstractFolder)cCFolder).getAllResources(0, true);
            if (list2.size() != list.size()) {
                throw new com.inet.report.permissions.a(a.getMsg("error.ADE.repo.permission"));
            }
        }
        if ((list2 = cCFolder2.getFolders()) != null) {
            list = list2.iterator();
            while (list.hasNext()) {
                object3 = (CCElement)list.next();
                if (!object3.getName().equals(cCFolder.getName())) continue;
                return false;
            }
        }
        if ((list = cCFolder2.createFolder(cCFolder.getName())) == null) {
            return false;
        }
        cCFolder.getFolderPermissions().copyTo((CCFolder)((Object)list));
        object3 = cCFolder.getResources();
        boolean bl3 = true;
        if (object3 != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (CCResource)object2.next();
                if (bl2) {
                    bl3 &= this.move((CCResource)object, (CCFolder)((Object)list));
                    continue;
                }
                bl3 &= this.copy((CCResource)object, (CCFolder)((Object)list));
            }
        }
        if ((object2 = cCFolder.getFolders()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                CCFolder cCFolder3 = (CCFolder)object.next();
                if (bl2) {
                    bl3 &= this.move(cCFolder3, (CCFolder)((Object)list));
                    continue;
                }
                bl3 &= this.copy(cCFolder3, (CCFolder)((Object)list));
            }
        }
        cCFolder2.getChangeListener().stateChanged(new b(cCFolder2, 0));
        if (bl2 && bl3) {
            return cCFolder.delete(false);
        }
        return bl3;
    }

    @Override
    public boolean copy(CCResource cCResource, CCFolder cCFolder) {
        this.initialize();
        if (cCResource == null || cCFolder == null) {
            return false;
        }
        if (this.getPermissionsInfo().isPermissionsActivated()) {
            CCFolder cCFolder2 = cCResource.getParent();
            u.a(cCFolder2, cCResource.getName(), 4);
            u.a(cCFolder, cCResource.getName(), 6);
        }
        return cCResource.copyTo(cCFolder);
    }

    @Override
    public boolean move(CCResource cCResource, CCFolder cCFolder) {
        if (this.copy(cCResource, cCFolder)) {
            return cCResource.delete();
        }
        return false;
    }

    @Override
    public void waitForIndexer(int n2) {
        for (int i2 = 0; i2 < n2 && !this.cef.isFinished() && this.ceu != null && this.ceu.isAlive(); i2 += 10) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    @Override
    public Set<String> getRegisteredTags() {
        return this.cef.VD();
    }

    @Override
    public boolean hasHomeFolder() {
        VirtualHomeInfo virtualHomeInfo = new VirtualHomeInfo(this.cek);
        if (!virtualHomeInfo.isActive() || virtualHomeInfo.VI() == null) {
            return false;
        }
        PermissionUrlObject permissionUrlObject = this.cek.getVirtualHomePermission();
        return permissionUrlObject.getAccess(this.cek.getCurrentWebUserInfo(), "*") != 0;
    }

    @Override
    public CCFolder getHomeFolder() {
        if (!this.hasHomeFolder()) {
            return null;
        }
        CCFolder cCFolder = this.getRoot();
        if (cCFolder == null) {
            return null;
        }
        String string = com.inet.report.repository.abstracts.e.b(cCFolder);
        return cCFolder.getFolder(string);
    }
}

