/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.repository.davclient;

import com.inet.report.filechooser.i18n.Msg;
import com.inet.report.repository.davclient.DavResource;
import com.inet.report.repository.davclient.WebDavConnector;
import com.inet.report.repository.davclient.WebDavUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.webdav.lib.WebdavResource;

public class DavFolder
implements Comparable<DavFolder> {
    private WebdavResource ceG;
    private final DavFolder ceH;
    private boolean initialized;
    private int kB;
    private ArrayList<DavResource> ceI;
    private ArrayList<DavFolder> ceJ;
    private final String bwW;

    public DavFolder(WebdavResource webdavResource, DavFolder davFolder, String string) {
        this.ceG = webdavResource;
        this.ceH = davFolder;
        this.bwW = string;
    }

    public String getCookie() {
        return this.bwW;
    }

    public WebdavResource getFolder() {
        return this.ceG;
    }

    public DavFolder getParent() {
        return this.ceH;
    }

    public synchronized List<DavFolder> getFolders() {
        if (this.ceJ == null) {
            this.ceJ = new ArrayList();
            List<WebdavResource> list = WebDavUtils.getFolders(this.ceG, this.bwW);
            for (WebdavResource webdavResource : list) {
                this.ceJ.add(new DavFolder(webdavResource, this, this.bwW));
            }
        }
        return this.ceJ;
    }

    public List<DavResource> getResources() {
        if (this.ceI == null) {
            ArrayList<DavResource> arrayList = new ArrayList<DavResource>();
            List<WebdavResource> list = WebDavUtils.getResources(this.ceG, this.bwW);
            for (WebdavResource webdavResource : list) {
                arrayList.add(new DavResource(webdavResource, this));
            }
            this.ceI = arrayList;
        }
        return this.ceI;
    }

    public DavResource getResource(String string) {
        List<DavResource> list = this.getResources();
        for (DavResource davResource : list) {
            if (!davResource.getName().equals(string)) continue;
            return davResource;
        }
        return null;
    }

    public DavFolder getFolder(String string) {
        List<DavFolder> list = this.getFolders();
        for (DavFolder davFolder : list) {
            if (!davFolder.getName().equals(string)) continue;
            return davFolder;
        }
        return null;
    }

    public synchronized void clearCache() {
        this.ceI = null;
        this.ceJ = null;
    }

    public boolean exists() {
        return this.ceG.exists();
    }

    public String getName() {
        return this.ceG.getName();
    }

    public String toString() {
        DavFolder davFolder = this.getRoot();
        String string = this.getFolder().getPath().replace(davFolder.getFolder().getPath(), "/" + davFolder.getName());
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DavResource createResource(String string, InputStream inputStream, WebDavConnector webDavConnector) throws HttpException, IOException {
        Object object = WebDavUtils.SYNC_OBJECT;
        synchronized (object) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byte[] byArray = new byte[4096];
                if (inputStream != null) {
                    int n2 = 0;
                    while ((n2 = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n2);
                    }
                }
                byteArrayOutputStream.close();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                outOfMemoryError.printStackTrace();
                throw new IOException(outOfMemoryError.toString());
            }
            boolean bl2 = this.ceG.putMethod(this.ceG.getPath() + "/" + string, byteArrayOutputStream.toByteArray());
            if (!bl2) {
                if (this.ceG.getStatusCode() == 401) {
                    throw new IOException(Msg.getMsg("save.error.401"));
                }
                if (this.ceG.getStatusCode() == 403) {
                    throw new IOException(Msg.getMsg("save.error.403"));
                }
                return null;
            }
            HttpURL httpURL = this.ceG.getHttpURL();
            Object object2 = null;
            int n3 = httpURL.getPort();
            if (n3 == 443 && httpURL instanceof HttpsURL) {
                n3 = -1;
            } else if (n3 == 80 && !(httpURL instanceof HttpsURL)) {
                n3 = -1;
            }
            object2 = httpURL instanceof HttpsURL ? new HttpsURL(httpURL.getHost(), n3, this.ceG.getPath() + "/" + string) : new HttpURL(httpURL.getHost(), n3, this.ceG.getPath() + "/" + string);
            if (httpURL.getUser() != null && httpURL.getUser().length() > 0) {
                object2.setUserinfo(httpURL.getUser(), httpURL.getPassword());
            }
            WebdavResource webdavResource = new WebdavResource((HttpURL)object2, 1, 0);
            if (webDavConnector.getCookie() != null) {
                webdavResource.addRequestHeader("Cookie", webDavConnector.getCookie());
            }
            try {
                webdavResource.setProperties(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new DavResource(webdavResource, this);
        }
    }

    public DavFolder getRoot() {
        DavFolder davFolder = this;
        while (davFolder.getParent() != null) {
            davFolder = davFolder.getParent();
        }
        return davFolder;
    }

    public boolean equals(DavFolder davFolder) {
        String string = this.ceG.getPath();
        String string2 = davFolder != null ? davFolder.getFolder().getPath() : null;
        return string.equals(string2);
    }

    public boolean equals(Object object) {
        if (object instanceof DavFolder) {
            return this.equals((DavFolder)object);
        }
        return super.equals(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String string) {
        DavFolder davFolder = this.getParent();
        if (davFolder != null) {
            try {
                Object object = WebDavUtils.SYNC_OBJECT;
                synchronized (object) {
                    boolean bl2 = this.ceG.moveMethod(davFolder.getFolder().getPath() + "/" + string);
                    if (bl2) {
                        this.ceG = davFolder.getFolder(string).getFolder();
                    }
                    return bl2;
                }
            }
            catch (HttpException httpException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createFolder(String string) throws IOException {
        try {
            Object object = WebDavUtils.SYNC_OBJECT;
            synchronized (object) {
                boolean bl2 = this.ceG.mkcolMethod(this.getFolder().getPath() + "/" + string);
                if (!bl2) {
                    if (this.ceG.getStatusCode() == 401) {
                        throw new IOException(Msg.getMsg("save.error.401"));
                    }
                    if (this.ceG.getStatusCode() == 403) {
                        throw new IOException(Msg.getMsg("save.error.403"));
                    }
                }
                return bl2;
            }
        }
        catch (HttpException httpException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        try {
            Object object = WebDavUtils.SYNC_OBJECT;
            synchronized (object) {
                return this.ceG.deleteMethod();
            }
        }
        catch (HttpException httpException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public int getPermission() {
        this.fZ();
        return this.kB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fZ() {
        if (!this.initialized) {
            this.initialized = true;
            this.kB = 0;
            try {
                Object object = WebDavUtils.SYNC_OBJECT;
                synchronized (object) {
                    Enumeration enumeration = this.ceG.propfindMethod("rights");
                    while (enumeration.hasMoreElements()) {
                        Object e2 = enumeration.nextElement();
                        if (e2 == null) continue;
                        String string = e2.toString();
                        try {
                            string = URLDecoder.decode(string, "UTF8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        try {
                            this.kB = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            catch (HttpException httpException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean isWritable() {
        return (this.getPermission() & 2) == 2;
    }

    @Override
    public int compareTo(DavFolder davFolder) {
        return this.toString().compareToIgnoreCase(davFolder.toString());
    }
}

