/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.repository.davclient;

import com.inet.report.repository.davclient.DavFolder;
import com.inet.report.repository.davclient.WebDavUtils;
import com.inet.report.util.Base64;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.httpclient.HttpException;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.WebdavResource;

public class DavResource
implements Comparable<DavResource> {
    private final WebdavResource ceK;
    private final DavFolder ceH;
    private long ceL;
    private Date ceM;
    private int kB;
    private String ceN;
    private boolean initialized = false;
    private boolean ceO = false;
    private List<String> ceP;
    private BufferedImage ayx;

    public DavResource(WebdavResource webdavResource, DavFolder davFolder) {
        this.ceK = webdavResource;
        this.ceH = davFolder;
    }

    public WebdavResource getResource() {
        return this.ceK;
    }

    public DavFolder getParent() {
        return this.ceH;
    }

    public String getName() {
        return this.ceK.getName();
    }

    public String toString() {
        return this.getName();
    }

    public long getLength() {
        this.fZ();
        return this.ceL;
    }

    public Date getLastModifiedDate() {
        this.fZ();
        return this.ceM;
    }

    public int getPermission() {
        this.fZ();
        return this.kB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getThumbnail() {
        if (!this.ceO) {
            try {
                Object object = WebDavUtils.SYNC_OBJECT;
                synchronized (object) {
                    Enumeration enumeration = this.ceK.propfindMethod("thumbnail");
                    while (enumeration.hasMoreElements()) {
                        Object e2 = enumeration.nextElement();
                        if (e2 == null) continue;
                        this.ayx = ImageIO.read(new ByteArrayInputStream(Base64.decode(e2.toString())));
                    }
                }
            }
            catch (HttpException httpException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ceO = true;
        }
        return this.ayx;
    }

    public boolean exists() {
        return this.ceK.exists();
    }

    public List<String> getTags() {
        this.fZ();
        return this.ceP;
    }

    public String getLocation() {
        this.fZ();
        return this.ceN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String string) {
        DavFolder davFolder = this.getParent();
        if (davFolder != null) {
            try {
                Object object = WebDavUtils.SYNC_OBJECT;
                synchronized (object) {
                    return this.ceK.moveMethod(davFolder.getFolder().getPath() + "/" + string);
                }
            }
            catch (HttpException httpException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean move(String string) {
        if (string != null) {
            try {
                Object object = WebDavUtils.SYNC_OBJECT;
                synchronized (object) {
                    return this.ceK.moveMethod(string);
                }
            }
            catch (HttpException httpException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copy(String string) {
        if (string != null) {
            try {
                Object object = WebDavUtils.SYNC_OBJECT;
                synchronized (object) {
                    return this.ceK.copyMethod(string);
                }
            }
            catch (HttpException httpException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        try {
            Object object = WebDavUtils.SYNC_OBJECT;
            synchronized (object) {
                return this.ceK.deleteMethod();
            }
        }
        catch (HttpException httpException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveTags(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String object : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            try {
                stringBuffer.append(URLEncoder.encode(object, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                stringBuffer.append(object);
            }
        }
        try {
            boolean bl2 = false;
            Object object = WebDavUtils.SYNC_OBJECT;
            synchronized (object) {
                bl2 = this.ceK.proppatchMethod(new PropertyName("CCRepository", "tags"), stringBuffer.toString(), true);
            }
            if (bl2) {
                if (this.ceP == null) {
                    this.ceP = new ArrayList<String>();
                } else {
                    this.ceP.clear();
                }
                this.ceP.addAll(list);
            }
            return bl2;
        }
        catch (HttpException httpException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fZ() {
        if (!this.initialized) {
            Object object = WebDavUtils.SYNC_OBJECT;
            synchronized (object) {
                if (this.initialized) {
                    return;
                }
                this.ceL = this.ceK.getGetContentLength();
                this.ceM = new Date(this.ceK.getGetLastModified());
                this.kB = 0;
                this.ceN = "";
                this.ceP = new ArrayList<String>();
                try {
                    Enumeration enumeration = this.ceK.propfindMethod("rightsRepolocationTags");
                    while (enumeration.hasMoreElements()) {
                        Object e2 = enumeration.nextElement();
                        if (e2 == null) continue;
                        String string = e2.toString();
                        String[] stringArray = string.split("\n");
                        if (stringArray.length >= 1 && stringArray[0] != null) {
                            try {
                                this.kB = Integer.parseInt(stringArray[0]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (stringArray.length >= 2 && stringArray[1] != null) {
                            this.ceN = stringArray[1];
                        }
                        if (stringArray.length < 3 || stringArray[2] == null) continue;
                        stringArray[2] = URLDecoder.decode(stringArray[2], "UTF-8");
                        String[] stringArray2 = stringArray[2].split(",");
                        if (stringArray2 == null) continue;
                        for (String string2 : stringArray2) {
                            string2 = string2.trim();
                            this.ceP.add(string2.trim());
                        }
                    }
                }
                catch (HttpException httpException) {
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.initialized = true;
            }
        }
    }

    @Override
    public int compareTo(DavResource davResource) {
        return davResource.getName().compareTo(this.getName());
    }

    public boolean isThumbnailCached() {
        return this.ceO;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

