/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.repository.davclient;

import com.inet.report.repository.davclient.DavResource;
import com.inet.report.repository.davclient.WebDavConnector;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.WebdavResources;

public class WebDavUtils {
    public static final Object SYNC_OBJECT = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<WebdavResource> getFolders(WebdavResource webdavResource, String string) {
        ArrayList<WebdavResource> arrayList = new ArrayList<WebdavResource>();
        if (webdavResource == null) {
            return arrayList;
        }
        try {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                Enumeration enumeration;
                WebdavResources webdavResources = webdavResource.getChildResources();
                if (webdavResources != null && (enumeration = webdavResources.getResources()) != null) {
                    while (enumeration.hasMoreElements()) {
                        WebdavResource webdavResource2;
                        Object e2 = enumeration.nextElement();
                        if (!(e2 instanceof WebdavResource) || !(webdavResource2 = (WebdavResource)e2).isCollection()) continue;
                        if (string != null) {
                            webdavResource2.addRequestHeader("Cookie", string);
                        }
                        arrayList.add(webdavResource2);
                    }
                }
            }
        }
        catch (HttpException httpException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<WebdavResource> getResources(WebdavResource webdavResource, String string) {
        ArrayList<WebdavResource> arrayList = new ArrayList<WebdavResource>();
        if (webdavResource == null) {
            return arrayList;
        }
        try {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                Enumeration enumeration;
                WebdavResources webdavResources = webdavResource.getChildResources();
                if (webdavResources != null && (enumeration = webdavResources.getResources()) != null) {
                    while (enumeration.hasMoreElements()) {
                        WebdavResource webdavResource2;
                        Object e2 = enumeration.nextElement();
                        if (!(e2 instanceof WebdavResource) || (webdavResource2 = (WebdavResource)e2).isCollection()) continue;
                        if (string != null) {
                            webdavResource2.addRequestHeader("Cookie", string);
                        }
                        arrayList.add(webdavResource2);
                    }
                }
            }
        }
        catch (HttpException httpException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebdavResource getResource(WebdavResource webdavResource, String string) throws HttpException, IOException {
        Object object = SYNC_OBJECT;
        synchronized (object) {
            return webdavResource.getChildResources().getResource(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DavResource getResource(WebDavConnector webDavConnector, String string) throws HttpException, IOException {
        Object object = SYNC_OBJECT;
        synchronized (object) {
            webDavConnector.getRootFolder();
            HttpURL httpURL = webDavConnector.getHttpUrl();
            int n2 = httpURL.getPort();
            if (n2 == 443 && httpURL instanceof HttpsURL) {
                n2 = -1;
            } else if (n2 == 80 && !(httpURL instanceof HttpsURL)) {
                n2 = -1;
            }
            Object object2 = httpURL instanceof HttpsURL ? new HttpsURL(httpURL.getHost(), n2, httpURL.getPath() + string) : new HttpURL(httpURL.getHost(), n2, httpURL.getPath() + string);
            if (httpURL.getUser() != null && httpURL.getUser().length() > 0) {
                object2.setUserinfo(httpURL.getUser(), httpURL.getPassword());
            }
            WebdavResource webdavResource = new WebdavResource((HttpURL)object2, 1, 0);
            if (webDavConnector.getCookie() != null) {
                webdavResource.addRequestHeader("Cookie", webDavConnector.getCookie());
            }
            try {
                webdavResource.setProperties(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new DavResource(webdavResource, null);
        }
    }

    public static DavResource getResource(WebDavConnector webDavConnector, URL uRL) throws HttpException, IOException {
        if (webDavConnector == null) {
            return WebDavUtils.getResource(uRL, null);
        }
        String string = webDavConnector.getURLString();
        String string2 = uRL.toString();
        if (string2.startsWith(string)) {
            return WebDavUtils.getResource(webDavConnector, string2.substring(string.length()));
        }
        return WebDavUtils.getResource(uRL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DavResource getResource(URL uRL, Map<String, String> map) throws HttpException, IOException {
        Object object = SYNC_OBJECT;
        synchronized (object) {
            String string = URLDecoder.decode(uRL.getPath(), "UTF-8");
            Object object2 = "https".equals(uRL.getProtocol()) ? new HttpsURL(uRL.getHost(), uRL.getPort(), string) : new HttpURL(uRL.getHost(), uRL.getPort(), string);
            WebdavResource webdavResource = new WebdavResource((HttpURL)object2, 1, 0);
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    webdavResource.addRequestHeader(entry.getKey(), entry.getValue());
                }
            }
            try {
                webdavResource.setProperties(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new DavResource(webdavResource, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DavResource createResource(WebDavConnector webDavConnector, String string, byte[] byArray) throws HttpException, IOException {
        DavResource davResource = WebDavUtils.getResource(webDavConnector, string);
        Object object = SYNC_OBJECT;
        synchronized (object) {
            davResource.getResource().setContentType("application/crystalclear");
            boolean bl2 = davResource.getResource().putMethod(byArray);
            if (!bl2) {
                return null;
            }
            if (davResource.getResource() != null) {
                davResource.getResource().setProperties(1);
            }
            return davResource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DavResource createResource(URL uRL, String string, byte[] byArray) throws HttpException, IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            hashMap.put("Cookie", string);
        }
        DavResource davResource = WebDavUtils.getResource(uRL, hashMap);
        Object object = SYNC_OBJECT;
        synchronized (object) {
            davResource.getResource().setContentType("application/crystalclear");
            boolean bl2 = davResource.getResource().putMethod(byArray);
            if (!bl2) {
                return null;
            }
            if (davResource.getResource() != null) {
                davResource.getResource().setProperties(1);
            }
            return davResource;
        }
    }

    public static String throwable2Message(Throwable throwable) {
        String[] stringArray;
        String string = throwable.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!string.equals("IOException") && !string.equals("IllegalStateException")) {
            for (String string2 : stringArray = string.split("(?<=[a-z])(?=[A-Z])")) {
                if (string2.equals("Exception") && stringBuilder.length() > 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string2);
            }
        }
        if ((stringArray = throwable.getLocalizedMessage()) != null && stringArray.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(": ");
            }
            stringBuilder.append((String)stringArray);
        }
        return stringBuilder.toString();
    }
}

