/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.repository;

import com.inet.report.BaseUtils;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.Section;
import com.inet.report.Subreport;
import com.inet.report.SummaryInfo;
import com.inet.report.logging.g;
import com.inet.report.permissions.PermissionUrlObject;
import com.inet.report.permissions.p;
import com.inet.report.repository.CCFolder;
import com.inet.report.repository.CCResource;
import com.inet.report.repository.Repository;
import com.inet.report.repository.db.e;
import com.inet.report.repository.hd.f;
import com.inet.report.repository.j;
import com.inet.report.repository.k;
import com.inet.report.repository.n;
import com.inet.report.repository.permission.FolderPermissions;
import com.inet.report.repository.s;
import com.inet.report.repository.virtual.VirtualFolder;
import com.inet.report.translation.Translator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.dialect.Dialect;
import org.apache.lucene.store.jdbc.dialect.DialectResolver;
import org.apache.lucene.store.jdbc.dialect.MySQLDialect;
import org.apache.lucene.store.jdbc.dialect.Oracle8Dialect;
import org.apache.lucene.store.jdbc.dialect.OracleDialect;
import org.apache.lucene.store.jdbc.dialect.PostgreSQLDialect;

public class i
implements Runnable {
    private final ArrayList<String> cdE;
    private boolean running;
    private boolean cdF;
    private Directory cdG;
    private IndexWriter indexWriter;
    private boolean cdH;
    private boolean cdI;
    private Repository cdJ;
    private PerFieldAnalyzerWrapper cdK;
    private Vector<CCResource> cdL;
    private Vector<CCResource> cdM;
    private boolean cdN;
    private static Object cdO = new Object();
    private Vector<CCResource> cdP;

    public i(Repository repository) {
        block2: {
            this.cdE = new ArrayList(7);
            this.running = true;
            this.cdF = true;
            this.indexWriter = null;
            this.cdH = true;
            this.cdI = false;
            this.cdL = new Vector();
            this.cdM = new Vector();
            this.cdN = false;
            this.cdP = new Vector();
            this.cdE.add("title");
            this.cdE.add("author");
            this.cdE.add("keywords");
            this.cdE.add("subject");
            this.cdE.add("comments");
            this.cdE.add("last saved");
            this.cdE.add("created");
            this.cdJ = repository;
            try {
                this.cdK = new PerFieldAnalyzerWrapper((Analyzer)new com.inet.report.repository.f());
                this.cdK.addAnalyzer("path", (Analyzer)new k());
                this.cdK.addAnalyzer("location", (Analyzer)new KeywordAnalyzer());
                this.cdK.addAnalyzer("name", (Analyzer)new n());
                this.cdK.addAnalyzer("lastsaved", (Analyzer)new KeywordAnalyzer());
                this.cdK.addAnalyzer("created", (Analyzer)new KeywordAnalyzer());
                this.cdK.addAnalyzer("lastmodified", (Analyzer)new KeywordAnalyzer());
                this.cdK.addAnalyzer("tags", (Analyzer)new s());
            }
            catch (Exception exception) {
                this.cdK = null;
                if (!BaseUtils.isError()) break block2;
                BaseUtils.error(com.inet.report.repository.i18n.a.getMsg("error.cclog.indexer.initial"));
                BaseUtils.error(exception);
            }
        }
    }

    public void init() {
        if (this.cdG != null) {
            return;
        }
        try {
            if (this.cdJ instanceof f) {
                this.cdG = FSDirectory.getDirectory((String)(this.cdJ.getLocation().getPath() + File.separatorChar + ".index"));
            } else if (this.cdJ instanceof e) {
                e e2 = (e)this.cdJ;
                d d2 = new d(e2);
                try {
                    DialectResolver dialectResolver = new DialectResolver();
                    dialectResolver.addLastMapper((DialectResolver.DatabaseMetaDataToDialectMapper)new a("Oracle", 9, OracleDialect.class));
                    dialectResolver.addLastMapper((DialectResolver.DatabaseMetaDataToDialectMapper)new a("Oracle", 8, Oracle8Dialect.class));
                    dialectResolver.addLastMapper((DialectResolver.DatabaseMetaDataToDialectMapper)new DialectResolver.DatabaseNameStartsWithToDialectMapper("Oracle", OracleDialect.class));
                    Object object = dialectResolver.getDialect((DataSource)d2);
                    if (object instanceof MySQLDialect) {
                        object = new c(null);
                    }
                    if (object instanceof PostgreSQLDialect) {
                        throw new IllegalArgumentException("PostgreSQL is not supported for indexing.");
                    }
                    this.cdG = new JdbcDirectory((DataSource)d2, object, "TBLINDEX");
                    ((JdbcDirectory)this.cdG).create();
                }
                catch (Throwable throwable) {
                    if (BaseUtils.isError()) {
                        BaseUtils.error("Could not create repository index in database. Using fallback to RAM");
                        BaseUtils.error(throwable);
                    }
                    this.cdG = new RAMDirectory();
                }
            } else {
                if (BaseUtils.isError()) {
                    BaseUtils.error("Repository type could not be determined. Using fallback to RAM");
                }
                this.cdG = new RAMDirectory();
            }
            this.cdG.clearLock("write.lock");
        }
        catch (Throwable throwable) {
            if (BaseUtils.isError()) {
                BaseUtils.error("Could not create repository index. Using fallback to RAM");
                BaseUtils.error(throwable);
            }
            this.cdG = new RAMDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block27: {
            g.setID("RINDEX");
            if (this.cdG == null || this.cdK == null) {
                return;
            }
            try {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug(com.inet.report.repository.i18n.a.getMsg("error.cclog.indexer.start"));
                }
                try {
                    if (!IndexReader.indexExists((Directory)this.cdG)) {
                        try {
                            this.cdN = true;
                            this.Vz();
                            this.cdN = false;
                        }
                        catch (Throwable throwable) {
                            if (BaseUtils.isError()) {
                                BaseUtils.error(throwable);
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (this.running) {
                    try {
                        if (this.cdF) {
                            this.cdN = true;
                            this.Vz();
                            this.cdF = false;
                            this.cdN = false;
                        }
                        Vector<CCResource> vector = new Vector<CCResource>();
                        vector.addAll(this.cdP);
                        if (!vector.isEmpty()) {
                            for (CCResource cCResource : vector) {
                                Date date = cCResource.getLastModifiedDate();
                                if (date == null) continue;
                                long l2 = System.currentTimeMillis() - 3600000L;
                                if (date.getTime() >= l2) continue;
                                this.e(cCResource);
                                if (cCResource.exists()) {
                                    cCResource.delete();
                                }
                                this.cdP.remove(cCResource);
                            }
                        }
                        if (this.cdH && !this.cdI) {
                            this.cdN = true;
                            try {
                                if (IndexReader.indexExists((Directory)this.cdG)) {
                                    this.optimize();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.cdN = false;
                            this.cdH = false;
                        }
                        try {
                            if (this.cdM.size() == 0 && this.cdL.size() == 0) {
                                Object object = cdO;
                                synchronized (object) {
                                    cdO.wait(10000L);
                                    continue;
                                }
                            }
                            this.cdF = true;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    catch (Throwable throwable) {
                        if (!this.running || !BaseUtils.isError()) continue;
                        BaseUtils.error(throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                if (!BaseUtils.isError()) break block27;
                BaseUtils.error(throwable);
            }
        }
    }

    private void e(CCResource cCResource) {
        String[] stringArray;
        FolderPermissions folderPermissions;
        PermissionUrlObject permissionUrlObject;
        CCFolder cCFolder = cCResource.getParent();
        if (cCFolder != null && (permissionUrlObject = (folderPermissions = cCFolder.getFolderPermissions()).getPermissionUrlObject()) != null && (stringArray = permissionUrlObject.getPatterns()) != null) {
            for (String string : stringArray) {
                String[] stringArray2;
                String string2 = cCResource.getName();
                if (!string2.equals(string) || (stringArray2 = permissionUrlObject.getUserNames(string)) == null) continue;
                for (String string3 : stringArray2) {
                    folderPermissions.removePermission(7, string2, string3, false);
                }
            }
        }
    }

    private void Vz() {
        long l2 = System.currentTimeMillis();
        ArrayList<CCResource> arrayList = null;
        try {
            if (this.cdM.size() > 0) {
                ArrayList<CCResource> arrayList2 = new ArrayList<CCResource>(this.cdM);
                this.cdM.removeAll(arrayList2);
                this.h(arrayList2);
            } else {
                arrayList = this.cdL.size() > 0 ? new ArrayList<CCResource>(this.cdL) : this.VA();
            }
            if (arrayList != null && arrayList.size() != 0) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug(com.inet.report.repository.i18n.a.getMsg("error.cclog.indexer.count", String.valueOf(arrayList.size())));
                }
                this.cdL.removeAll(arrayList);
                this.W(arrayList);
                this.cdF = false;
            }
            if (BaseUtils.isDebug() && arrayList != null && arrayList.size() > 0) {
                BaseUtils.debug(com.inet.report.repository.i18n.a.getMsg("error.cclog.indexer.time", String.valueOf(arrayList.size()), String.valueOf(System.currentTimeMillis() - l2)));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.VC();
    }

    private void h(ArrayList<CCResource> arrayList) {
        block4: {
            try {
                if (new CheckIndex((Directory)this.cdG).checkIndex().clean) {
                    this.indexWriter = new IndexWriter(this.cdG, (Analyzer)this.cdK, false, IndexWriter.MaxFieldLength.UNLIMITED);
                    for (CCResource cCResource : arrayList) {
                        String string = this.a(cCResource.getLocation());
                        this.indexWriter.deleteDocuments(new Term("location", string));
                    }
                    this.indexWriter.close(true);
                }
            }
            catch (Exception exception) {
                if (!BaseUtils.isError()) break block4;
                BaseUtils.error(exception);
            }
        }
    }

    private ArrayList<CCResource> VA() {
        ArrayList<CCResource> arrayList;
        block11: {
            arrayList = new ArrayList<CCResource>();
            try {
                QueryParser queryParser = new QueryParser("text", (Analyzer)this.cdK);
                queryParser.setDefaultOperator(QueryParser.AND_OPERATOR);
                boolean bl2 = true;
                try {
                    CheckIndex.Status status = new CheckIndex(this.cdG).checkIndex();
                    bl2 = status.clean || status.missingSegments;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl2) {
                    List<CCResource> list;
                    boolean bl3 = this.cdG.list() != null && IndexReader.indexExists((Directory)this.cdG);
                    List<CCResource> list2 = this.cdJ.getAllResources();
                    for (CCResource object32 : list2) {
                        if (!this.running) {
                            return arrayList;
                        }
                        URI uRI = object32.getLocation();
                        if (object32.getLastModifiedDate() == null) continue;
                        if (bl3) {
                            Object object = String.valueOf(object32.getLastModifiedDate().getTime());
                            String string = this.a(uRI);
                            string = URLDecoder.decode(string, "UTF-8");
                            String string2 = QueryParser.escape((String)string);
                            Query query = queryParser.parse("path:(" + string2 + ") AND lastmodified:(" + (String)object + ")");
                            int n2 = 20000;
                            IndexReader indexReader = IndexReader.open((Directory)this.cdG, (boolean)true);
                            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
                            TopDocs topDocs = indexSearcher.search(query, null, n2);
                            if (topDocs.totalHits == 0) {
                                arrayList.add(object32);
                            }
                            indexSearcher.close();
                            indexReader.close();
                            continue;
                        }
                        arrayList.add(object32);
                    }
                    CCFolder cCFolder = this.cdJ.getRoot();
                    if (cCFolder != null && (list = cCFolder.listTempResources()) != null) {
                        for (Object object : list) {
                            if (this.cdP.contains(object)) continue;
                            this.cdP.add((CCResource)object);
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!BaseUtils.isError()) break block11;
                BaseUtils.error(exception);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void W(List<CCResource> list) {
        if (list.size() == 0 || this.cdG == null) {
            return;
        }
        try {
            this.VB();
            if (!this.cdI && IndexReader.indexExists((Directory)this.cdG)) {
                this.cdG.clearLock("write.lock");
                this.indexWriter = new IndexWriter(this.cdG, (Analyzer)this.cdK, false, IndexWriter.MaxFieldLength.UNLIMITED);
            } else {
                this.indexWriter = new IndexWriter(this.cdG, (Analyzer)this.cdK, true, IndexWriter.MaxFieldLength.UNLIMITED);
                this.cdI = false;
            }
            for (CCResource cCResource : list) {
                void serializable;
                Serializable serializable2;
                if (!this.running) break;
                if (".directoryName".equals(cCResource.getName())) continue;
                try {
                    serializable2 = this.cdJ.getResource(cCResource.getLocation().toString().replace(this.cdJ.getLocation().toString(), ""));
                    if (serializable2 != null) {
                        Serializable serializable3 = serializable2;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                serializable2 = serializable.getLocation();
                String string = this.a((URI)serializable2);
                try {
                    string = URLDecoder.decode(string, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                try {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug(com.inet.report.repository.i18n.a.getMsg("error.cclog.indexer.report", string));
                    }
                    HashMap<String, String> fileNotFoundException = this.c((CCResource)serializable);
                    List<String> list2 = serializable.getTags();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (list2 != null) {
                        for (String string2 : list2) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(string2);
                        }
                    }
                    fileNotFoundException.put("tags", stringBuffer.toString().trim());
                    if (serializable.getLastModifiedDate() == null) continue;
                    this.indexWriter.deleteDocuments(new Term("location", string));
                    Document document = i.a(string, fileNotFoundException, serializable.getLastModifiedDate());
                    if (document == null) continue;
                    this.indexWriter.addDocument(document, (Analyzer)this.cdK);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.indexWriter.deleteDocuments(new Term("location", string));
                }
            }
            try {
                ((ConcurrentMergeScheduler)this.indexWriter.getMergeScheduler()).sync();
                this.indexWriter.close(true);
            }
            finally {
                if (IndexWriter.isLocked((Directory)this.cdG)) {
                    IndexWriter.unlock((Directory)this.cdG);
                }
            }
        }
        catch (Throwable throwable) {
            if (BaseUtils.isError()) {
                BaseUtils.error(throwable);
            }
        }
        finally {
            block33: {
                try {
                    if (this.indexWriter != null) {
                        this.indexWriter.close(true);
                    }
                }
                catch (Exception exception) {
                    if (!BaseUtils.isError()) break block33;
                    BaseUtils.error(exception);
                }
            }
        }
    }

    private String a(URI uRI) {
        String string = uRI.toString();
        if (this.cdJ instanceof f) {
            string = this.cdJ.getLocation().relativize(uRI).getPath();
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return string;
    }

    private void VB() {
        CheckIndex checkIndex = new CheckIndex(this.cdG);
        try {
            CheckIndex.Status status = checkIndex.checkIndex();
            if (!status.clean) {
                if (this.indexWriter != null) {
                    this.indexWriter.close();
                }
                this.init();
                this.cdI = true;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<String, String> c(CCResource cCResource) throws FileNotFoundException {
        HashMap<String, String> hashMap = new HashMap<String, String>(10);
        InputStream inputStream = null;
        try {
            inputStream = cCResource.getDataStream();
            URL uRL = null;
            try {
                uRL = cCResource.getLocation().toURL();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Engine engine = RDC.loadEngine(uRL, inputStream, null, null);
            SummaryInfo summaryInfo = engine.getSummaryInfo();
            hashMap.put("title", summaryInfo.getReportTitle());
            hashMap.put("author", summaryInfo.getAuthor());
            hashMap.put("keyword", summaryInfo.getKeywords());
            hashMap.put("keywords", summaryInfo.getKeywords());
            hashMap.put("subject", summaryInfo.getSubject());
            hashMap.put("last saved", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a").format(summaryInfo.getLastSaved()));
            hashMap.put("lastsaved", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a").format(summaryInfo.getLastSaved()));
            hashMap.put("created", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a").format(summaryInfo.getCreated()));
            hashMap.put("text", this.m(engine).toString());
            HashSet<String> hashSet = this.n(engine);
            hashMap.put("comments", summaryInfo.getComments());
            StringBuilder stringBuilder = new StringBuilder(100);
            for (String string : hashSet) {
                stringBuilder.append(string);
                stringBuilder.append(" ");
            }
            hashMap.put("elements", stringBuilder.toString().trim());
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (BaseUtils.isError()) {
                BaseUtils.error("Repository Indexer: Could not index report: " + cCResource.getName());
                BaseUtils.error(fileNotFoundException);
            }
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            if (BaseUtils.isError()) {
                BaseUtils.error("Repository Indexer: Could not index report: " + cCResource.getName());
                BaseUtils.error(exception);
            }
        }
        catch (Throwable throwable) {
            if (BaseUtils.isError()) {
                BaseUtils.error("Repository Indexer: Could not index report: " + cCResource.getName());
                BaseUtils.error(throwable);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return hashMap;
    }

    private StringBuilder m(Engine engine) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Set<String> set = new Translator(engine).listLabels(false);
            for (String string : set) {
                stringBuilder.append(string);
                stringBuilder.append(" ");
            }
        }
        catch (ReportException reportException) {
            reportException.printStackTrace();
        }
        return stringBuilder;
    }

    private HashSet<String> n(Engine engine) {
        HashSet<String> hashSet = new HashSet<String>(5);
        try {
            Vector vector = engine.getSections();
            for (Section section : vector) {
                hashSet.addAll(this.a(section));
            }
        }
        catch (ReportException reportException) {
            reportException.printStackTrace();
        }
        return hashSet;
    }

    private HashSet<String> a(Section section) throws ReportException {
        HashSet<String> hashSet = new HashSet<String>(4);
        block12: for (Element element : section.getElements()) {
            switch (element.getType()) {
                case 36: {
                    hashSet.add("Field");
                    continue block12;
                }
                case 42: {
                    hashSet.add("Diagram");
                    continue block12;
                }
                case 48: {
                    hashSet.add("BlobField");
                    continue block12;
                }
                case 46: {
                    hashSet.add("Picture");
                    continue block12;
                }
                case 68: {
                    hashSet.add("JavaBean");
                    continue block12;
                }
                case 35: {
                    hashSet.add("Text");
                    continue block12;
                }
                case 49: {
                    hashSet.add("Crosstab");
                    continue block12;
                }
                case 37: {
                    hashSet.add("Line");
                    continue block12;
                }
                case 38: {
                    hashSet.add("Box");
                    continue block12;
                }
                case 39: {
                    hashSet.add("Subreport");
                    Subreport subreport = (Subreport)element;
                    hashSet.addAll(this.n(subreport.getEngine()));
                }
            }
        }
        return hashSet;
    }

    private static Document a(String string, HashMap<String, String> hashMap, Date date) {
        Document document = new Document();
        document.add((Fieldable)new Field("location", string, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.YES));
        int n2 = string.lastIndexOf(47);
        if (n2 == -1) {
            n2 = string.lastIndexOf(92);
        }
        String string2 = "";
        String string3 = string;
        if (n2 > -1) {
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1);
        }
        document.add((Fieldable)new Field("path", string2, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES));
        document.add((Fieldable)new Field("name", string3, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES));
        String string4 = hashMap.get("title");
        if (string4 == null) {
            string4 = "";
        }
        document.add((Fieldable)new Field("title", string4, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES));
        String string5 = hashMap.get("author");
        if (string5 == null) {
            string5 = "";
        }
        document.add((Fieldable)new Field("author", string5, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES));
        String string6 = hashMap.get("keywords");
        if (string6 == null) {
            string6 = hashMap.get("keyword");
        }
        if (string6 == null) {
            string6 = "";
        }
        document.add((Fieldable)new Field("keywords", string6, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES));
        String string7 = hashMap.get("subject");
        if (string7 == null) {
            string7 = "";
        }
        document.add((Fieldable)new Field("subject", string7, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES));
        String string8 = hashMap.get("last saved");
        if (string8 == null) {
            string8 = hashMap.get("lastsaved");
        }
        string8 = string8 != null ? i.M(string8) : "";
        document.add((Fieldable)new Field("lastsaved", string8, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.YES));
        String string9 = hashMap.get("created");
        string9 = string9 == null ? String.valueOf(System.currentTimeMillis()) : i.M(string9);
        document.add((Fieldable)new Field("created", string9, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.YES));
        String string10 = hashMap.get("text");
        if (string10 == null) {
            string10 = "";
        }
        document.add((Fieldable)new Field("text", string10, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES));
        String string11 = hashMap.get("elements");
        if (string11 == null) {
            string11 = "";
        }
        document.add((Fieldable)new Field("elements", string11, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES));
        document.add((Fieldable)new Field("lastmodified", String.valueOf(date.getTime()), Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.YES));
        String string12 = hashMap.get("comments");
        if (string12 == null) {
            string12 = "";
        }
        document.add((Fieldable)new Field("comment", string12, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES));
        String string13 = hashMap.get("tags");
        if (string13 == null) {
            string13 = "";
        }
        document.add((Fieldable)new Field("tags", string13, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES));
        return document;
    }

    private static String M(String string) {
        try {
            Date date = string.indexOf(45) > -1 ? new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a").parse(string) : (string.indexOf(46) > -1 ? new SimpleDateFormat("dd.MM.yy HH:mm", Locale.ENGLISH).parse(string) : (string.indexOf(47) > -1 ? new SimpleDateFormat("MM/dd/yy hh:mm a", Locale.ENGLISH).parse(string) : new SimpleDateFormat("d MMM yyyy HH:mm:ss", Locale.ENGLISH).parse(string)));
            string = String.valueOf(date.getTime());
        }
        catch (ParseException parseException) {
            if (BaseUtils.isError()) {
                BaseUtils.error(parseException);
            }
            string = String.valueOf(System.currentTimeMillis());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void VC() {
        if (this.cdL.size() == 0 && this.cdM.size() == 0) {
            return;
        }
        this.cdF = true;
        Object object = cdO;
        synchronized (object) {
            cdO.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void db(boolean bl2) {
        this.running = bl2;
        Object object = cdO;
        synchronized (object) {
            cdO.notify();
        }
    }

    public void f(CCResource cCResource) {
        if (this.cdL.contains(cCResource = this.h(cCResource))) {
            this.cdL.remove(cCResource);
        }
        if (cCResource.getName().startsWith(".~")) {
            if (!this.cdP.contains(cCResource)) {
                this.cdP.add(cCResource);
            }
            return;
        }
        this.cdL.add(cCResource);
    }

    public void g(CCResource cCResource) {
        if ((cCResource = this.h(cCResource)).getName().startsWith(".~") && this.cdP.contains(cCResource)) {
            this.cdP.remove(cCResource);
        }
        this.cdM.add(cCResource);
    }

    public void k(CCFolder cCFolder) {
        cCFolder = this.m(cCFolder);
        for (CCFolder cCElement : cCFolder.getFolders()) {
            this.k(cCElement);
        }
        for (CCResource cCResource : cCFolder.getResources()) {
            if (this.cdL.contains(cCResource)) continue;
            if (cCResource.getName().startsWith(".~")) {
                if (this.cdP.contains(cCResource)) continue;
                this.cdP.add(cCResource);
                continue;
            }
            this.cdL.add(cCResource);
        }
    }

    public void l(CCFolder cCFolder) {
        cCFolder = this.m(cCFolder);
        for (CCFolder cCElement : cCFolder.getFolders()) {
            this.l(cCElement);
        }
        for (CCResource cCResource : cCFolder.getResources()) {
            if (cCResource.getName().startsWith(".~") && this.cdP.contains(cCResource)) {
                this.cdP.remove(cCResource);
            }
            this.cdM.add(cCResource);
        }
    }

    public Directory getDirectory() {
        return this.cdG;
    }

    protected void optimize() {
        block5: {
            try {
                if (new CheckIndex((Directory)this.cdG).checkIndex().clean) {
                    this.indexWriter = new IndexWriter(this.cdG, (Analyzer)this.cdK, false, IndexWriter.MaxFieldLength.UNLIMITED);
                    this.indexWriter.optimize(10);
                    ((ConcurrentMergeScheduler)this.indexWriter.getMergeScheduler()).sync();
                    this.indexWriter.close(true);
                }
            }
            catch (CorruptIndexException corruptIndexException) {
                if (BaseUtils.isError()) {
                    BaseUtils.error((Object)corruptIndexException);
                }
            }
            catch (IOException iOException) {
                if (!BaseUtils.isError()) break block5;
                BaseUtils.error(iOException);
            }
        }
    }

    public boolean isFinished() {
        return !this.cdN && this.cdL.size() == 0 && this.cdM.size() == 0;
    }

    public Set<String> VD() {
        TreeSet<String> treeSet;
        block7: {
            treeSet = new TreeSet<String>(new j(this));
            try {
                if (new CheckIndex((Directory)this.cdG).checkIndex().clean) {
                    IndexReader indexReader = IndexReader.open((Directory)this.cdG, (boolean)true);
                    String string = "tags";
                    TermEnum termEnum = indexReader.terms(new Term(string));
                    while (termEnum.term() != null) {
                        if (string.equals(termEnum.term().field())) {
                            treeSet.add(termEnum.term().text());
                        }
                        termEnum.next();
                    }
                }
            }
            catch (CorruptIndexException corruptIndexException) {
                if (BaseUtils.isError()) {
                    BaseUtils.error((Object)corruptIndexException);
                }
            }
            catch (IOException iOException) {
                if (!BaseUtils.isError()) break block7;
                BaseUtils.error(iOException);
            }
        }
        return treeSet;
    }

    private CCFolder m(CCFolder cCFolder) {
        if (cCFolder instanceof VirtualFolder) {
            return ((VirtualFolder)cCFolder).getWrappedFolder();
        }
        return cCFolder;
    }

    private CCResource h(CCResource cCResource) {
        if (cCResource instanceof com.inet.report.repository.virtual.a) {
            return ((com.inet.report.repository.virtual.a)cCResource).Xj();
        }
        return cCResource;
    }

    public static class b
    extends Thread
    implements p {
        public b(i i2) {
            super(i2);
            this.setDaemon(true);
        }
    }

    public static class a
    implements DialectResolver.DatabaseMetaDataToDialectMapper {
        private String cdR;
        private Class<? extends Dialect> cdS;
        private int version;

        public a(String string, int n2, Class<? extends Dialect> clazz) {
            this.cdR = string;
            this.cdS = clazz;
            this.version = n2;
        }

        public Class<? extends Dialect> getDialect(DatabaseMetaData databaseMetaData) throws SQLException {
            if (databaseMetaData.getDatabaseProductName().toLowerCase().startsWith(this.cdR.toLowerCase()) && databaseMetaData.getDatabaseMajorVersion() == this.version) {
                return this.cdS;
            }
            return null;
        }
    }

    private class c
    extends MySQLDialect {
        private c() {
        }

        public String openBlobSelectQuote() {
            return "`";
        }

        public String closeBlobSelectQuote() {
            return "`";
        }

        /* synthetic */ c(j j2) {
            this();
        }
    }

    private class d
    implements DataSource {
        private final e cdT;

        public d(e e2) {
            this.cdT = e2;
        }

        @Override
        public Connection getConnection() throws SQLException {
            Connection connection = this.cdT.Wo().Wh();
            return connection;
        }

        @Override
        public Connection getConnection(String string, String string2) throws SQLException {
            Connection connection = this.cdT.Wo().Wh();
            return connection;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 20;
        }

        @Override
        public void setLogWriter(PrintWriter printWriter) throws SQLException {
        }

        @Override
        public void setLoginTimeout(int n2) throws SQLException {
        }

        @Override
        public boolean isWrapperFor(Class<?> clazz) throws SQLException {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> clazz) throws SQLException {
            return null;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }
    }
}

