/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.repository.ssl;

import com.inet.report.repository.ssl.CertificateAcceptor;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class CertificateHostnameVerifier
implements HostnameVerifier {
    private final CertificateAcceptor ciu;

    public CertificateHostnameVerifier(CertificateAcceptor certificateAcceptor) {
        this.ciu = certificateAcceptor;
    }

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        Certificate[] certificateArray = null;
        try {
            certificateArray = sSLSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
        if (certificateArray != null) {
            for (Certificate certificate : certificateArray) {
                X509Certificate x509Certificate;
                String[] stringArray;
                if (!(certificate instanceof X509Certificate) || (stringArray = this.a(x509Certificate = (X509Certificate)certificate)) == null) continue;
                for (String string2 : stringArray) {
                    if (string.equals(string2) || this.ciu.certificatesAccepted(certificateArray, CertificateAcceptor.a.cim)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean verifyForSocket(String string, SSLSession sSLSession) throws SSLException {
        Certificate[] certificateArray;
        for (Certificate certificate : certificateArray = sSLSession.getPeerCertificates()) {
            X509Certificate x509Certificate;
            String[] stringArray;
            if (!(certificate instanceof X509Certificate) || (stringArray = this.a(x509Certificate = (X509Certificate)certificate)) == null) continue;
            for (String string2 : stringArray) {
                if (string.equals(string2) || this.ciu.certificatesAccepted(certificateArray, CertificateAcceptor.a.cim)) continue;
                throw new SSLException("wrong hostname");
            }
        }
        return true;
    }

    private String[] a(X509Certificate x509Certificate) {
        String[] stringArray;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = x509Certificate.getSubjectX500Principal().toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            int n2 = stringArray.indexOf("CN=");
            if (n2 < 0) continue;
            linkedList.add(stringArray.substring(n2 + 3));
        }
        if (!linkedList.isEmpty()) {
            stringArray = new String[linkedList.size()];
            linkedList.toArray(stringArray);
            return stringArray;
        }
        return null;
    }
}

