/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.repository.virtual;

import com.inet.report.BaseUtils;
import com.inet.report.permissions.PermissionUrlObject;
import com.inet.report.repository.CCElement;
import com.inet.report.repository.CCFolder;
import com.inet.report.repository.CCResource;
import com.inet.report.repository.abstracts.AbstractFolder;
import com.inet.report.repository.abstracts.AbstractResource;
import com.inet.report.repository.e;
import com.inet.report.repository.hd.b;
import com.inet.report.repository.permission.FolderPermissions;
import com.inet.report.repository.permission.PermissionsInfo;
import com.inet.report.repository.virtual.a;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class VirtualFolder
extends AbstractFolder {
    private URI bve;
    private String name;
    private final AbstractFolder ciz;

    public VirtualFolder(AbstractFolder abstractFolder, AbstractFolder abstractFolder2, PermissionsInfo permissionsInfo, e e2) {
        this(abstractFolder, abstractFolder2, abstractFolder2.getName(), permissionsInfo, e2);
    }

    public VirtualFolder(AbstractFolder abstractFolder, AbstractFolder abstractFolder2, String string, PermissionsInfo permissionsInfo, e e2) {
        super(abstractFolder, permissionsInfo, e2, abstractFolder2.getCCFolderImpl());
        this.ciz = abstractFolder2;
        this.name = string;
        this.Xi();
    }

    private void Xi() {
        URI uRI = this.getParent().getLocation();
        try {
            this.bve = new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath() + this.name + "/", uRI.getQuery(), uRI.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("Creating virtual folder location failed: " + uRISyntaxException.getMessage());
            }
            this.bve = uRI;
        }
    }

    @Override
    public AbstractFolder createFolder(String string) {
        if (string.startsWith(".") && !string.startsWith("._") && !string.startsWith(".~")) {
            throw new IllegalArgumentException(com.inet.report.repository.i18n.a.getMsg("error.IAE.subfolder.invalide", string));
        }
        AbstractFolder abstractFolder = super.createFolder(string);
        if (abstractFolder == null) {
            return abstractFolder;
        }
        return new VirtualFolder(this, abstractFolder, this.VL(), this.getChangeListener());
    }

    @Override
    public CCResource createResource(String string) {
        CCResource cCResource = super.createResource(string);
        if (cCResource == null) {
            return cCResource;
        }
        return new a(this.getChangeListener(), this.VL(), (AbstractResource)cCResource, this);
    }

    @Override
    public boolean delete() {
        if (!this.name.equals(super.getName())) {
            return false;
        }
        return super.delete();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CCElement)) {
            return false;
        }
        CCElement cCElement = (CCElement)object;
        URI uRI = this.getLocation();
        URI uRI2 = cCElement.getLocation();
        return uRI == null ? uRI2 == null : uRI.equals(uRI2);
    }

    @Override
    public AbstractFolder getFolder(String string) {
        AbstractFolder abstractFolder = super.getFolder(string);
        return abstractFolder != null ? new VirtualFolder(this, abstractFolder, this.VL(), this.getChangeListener()) : null;
    }

    @Override
    public List<CCFolder> getFolders() {
        List<CCFolder> list = super.getFolders();
        if (list == null) {
            return null;
        }
        ArrayList<CCFolder> arrayList = new ArrayList<CCFolder>();
        for (CCFolder cCFolder : list) {
            VirtualFolder virtualFolder = new VirtualFolder(this, (AbstractFolder)cCFolder, this.VL(), this.getChangeListener());
            if (!virtualFolder.isReadable() || !b.chX.accept(new File(cCFolder.getName()))) continue;
            arrayList.add(virtualFolder);
        }
        return arrayList;
    }

    @Override
    public URI getLocation() {
        return this.bve;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPermission(String string) {
        string = this.fA(string);
        PermissionsInfo permissionsInfo = this.VL();
        if (permissionsInfo.isPermissionsActivated()) {
            int n2 = 0;
            PermissionUrlObject[] permissionUrlObjectArray = this.VM();
            if (permissionUrlObjectArray != null) {
                for (PermissionUrlObject permissionUrlObject : permissionUrlObjectArray) {
                    if (permissionUrlObject == null) continue;
                    n2 |= permissionUrlObject.getAccess(permissionsInfo.getCurrentWebUserInfo(), string);
                }
            }
            return this.getPermissionImpl(string, n2);
        }
        return this.getPermissionImpl(string, 7);
    }

    @Override
    public CCResource getResource(String string) {
        CCResource cCResource = super.getResource(string);
        if (cCResource == null) {
            return cCResource;
        }
        return new a(this.getChangeListener(), this.VL(), (AbstractResource)cCResource, this);
    }

    @Override
    public boolean isReadable() {
        PermissionUrlObject permissionUrlObject = this.VL().getVirtualHomePermission();
        if (permissionUrlObject == null) {
            return false;
        }
        return this.getCCFolderImpl().VW() && (permissionUrlObject.getAccess(this.VL().getCurrentWebUserInfo(), "*") & 4) > 0;
    }

    @Override
    public boolean isRootOfSomeRepository() {
        return false;
    }

    @Override
    public boolean isWritable() {
        PermissionUrlObject permissionUrlObject = this.VL().getVirtualHomePermission();
        if (permissionUrlObject == null) {
            return false;
        }
        return this.getCCFolderImpl().VX() && (permissionUrlObject.getAccess(this.VL().getCurrentWebUserInfo(), "*") & 2) > 0;
    }

    @Override
    public List<CCResource> getResources() {
        return this.Y(super.getResources());
    }

    @Override
    public List<CCResource> listTempResources() {
        return this.Y(super.listTempResources());
    }

    @Override
    public boolean rename(String string) {
        if (string.startsWith(".") && !string.startsWith("._") && !string.startsWith(".~")) {
            throw new IllegalArgumentException(com.inet.report.repository.i18n.a.getMsg("error.IAE.subfolder.invalide", string));
        }
        if (!this.name.equals(super.getName())) {
            return false;
        }
        if (super.rename(string)) {
            this.name = string;
            this.Xi();
            return true;
        }
        return false;
    }

    private List<CCResource> Y(List<CCResource> list) {
        if (list == null) {
            return null;
        }
        ArrayList<CCResource> arrayList = new ArrayList<CCResource>(list.size());
        for (CCResource cCResource : list) {
            arrayList.add(new a(this.getChangeListener(), this.VL(), (AbstractResource)cCResource, this));
        }
        return arrayList;
    }

    @Override
    public List<CCResource> getAllResources(int n2, boolean bl2) {
        return this.Y(super.getAllResources(n2, bl2));
    }

    @Override
    protected PermissionUrlObject[] VM() {
        FolderPermissions folderPermissions = this.getFolderPermissions();
        return new PermissionUrlObject[]{folderPermissions.getPermissionsInfo().getVirtualHomePermission(), folderPermissions.getTemporaryPermission()};
    }

    public AbstractFolder getWrappedFolder() {
        return this.ciz;
    }
}

