/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.schedule;

import com.inet.report.Engine;
import com.inet.report.mail.MailAuthenticationMethod;
import com.inet.report.mail.MailServerProbe;
import com.inet.report.mail.MailServerProbeResult;
import com.inet.report.schedule.ExecutedInstance;
import com.inet.report.schedule.ExecutedReport;
import com.inet.report.schedule.ExecutedTask;
import com.inet.report.schedule.FileAction;
import com.inet.report.schedule.ScheduleAction;
import com.inet.report.schedule.ScheduleException;
import com.inet.report.schedule.ScheduleUtils;
import com.inet.report.schedule.Scheduler;
import com.inet.report.schedule.SchedulerValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class EmailAction
extends ScheduleAction {
    private String cjR;
    private String cjS;
    private String cjT;
    private String subject;
    private String message;
    private boolean cjU = true;
    private boolean cjV;
    private boolean cjW;
    private boolean cjX;
    private transient Date cjY;

    @Deprecated
    public boolean isAttachReport() {
        return this.cjU;
    }

    @Deprecated
    public void setAttachReport(boolean bl2) {
        this.cjU = bl2;
    }

    public String getBc() {
        return this.cjT;
    }

    public void setBc(String string) {
        this.cjT = string;
    }

    public String getCc() {
        return this.cjS;
    }

    public void setCc(String string) {
        this.cjS = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getTo() {
        return this.cjR;
    }

    public void setTo(String string) {
        this.cjR = string;
    }

    @Override
    public String[] getErrorMessages() {
        List<String> list = SchedulerValidator.validateEmailAction(this.subject, this.message, this.cjR, this.cjS, this.cjT);
        return list.toArray(new String[list.size()]);
    }

    private static String XL() {
        String string;
        try {
            string = System.getProperty("java.io.tmpdir");
        }
        catch (Throwable throwable) {
            string = "";
        }
        long l2 = System.currentTimeMillis();
        String string2 = string + "/" + Long.toHexString(l2) + Integer.toHexString(new Random().nextInt());
        return string2 + "/";
    }

    public static void sendMail(InternetAddress[] internetAddressArray, InternetAddress[] internetAddressArray2, InternetAddress[] internetAddressArray3, String string, String string2, String string3, DataSource[] dataSourceArray, Properties properties) throws Exception {
        MimeMultipart mimeMultipart;
        String string4;
        Session session;
        InternetAddress[] internetAddressArray4;
        String string5;
        String string6;
        String string7;
        String string8;
        block21: {
            Scheduler scheduler = Scheduler.getInstance();
            string8 = scheduler.getScheduleRuntimeProperty("sender");
            string7 = scheduler.getScheduleRuntimeProperty("smtphost");
            String string9 = scheduler.getScheduleRuntimeProperty("pop3host");
            string6 = scheduler.getScheduleRuntimeProperty("user");
            string5 = scheduler.getScheduleRuntimeProperty("password");
            String string10 = scheduler.getScheduleRuntimeProperty("smtpport");
            String string11 = scheduler.getScheduleRuntimeProperty("pop3port");
            if (string10 == null || string10.trim().length() == 0) {
                string10 = "25";
            }
            if (string11 == null || string11.trim().length() == 0) {
                string11 = "110";
            }
            internetAddressArray4 = SchedulerValidator.fX(string8);
            Properties properties2 = System.getProperties();
            properties2.put("mail.smtp.host", string7);
            properties2.put("mail.smtp.port", string10);
            properties2.put("mail.pop3.port", string11);
            if (Scheduler.Yh() == 1 || Scheduler.Yh() == 3) {
                if (ScheduleUtils.isDebug()) {
                    ScheduleUtils.debug(ScheduleUtils.getMsg("debug.emailaction.using_smtp_auth"));
                }
                properties2.put("mail.smtp.auth", "true");
            }
            session = Session.getInstance((Properties)properties2, null);
            if (Scheduler.Yh() == 2 || Scheduler.Yh() == 3) {
                if (ScheduleUtils.isDebug()) {
                    ScheduleUtils.debug(ScheduleUtils.getMsg("debug.emailaction.using_pop3_auth"));
                }
                try {
                    string4 = string9;
                    if (string4 != null && string4.trim().length() > 0) {
                        mimeMultipart = session.getStore("pop3");
                        mimeMultipart.connect(string4, string6, string5);
                    }
                }
                catch (Throwable throwable) {
                    if (!ScheduleUtils.isWarn()) break block21;
                    ScheduleUtils.warn("emailaction.pop3_ignore");
                    ScheduleUtils.warn(throwable);
                }
            }
        }
        string4 = new MimeMessage(session);
        if (ScheduleUtils.isParanoid()) {
            ScheduleUtils.paranoid(ScheduleUtils.getMsg("paranoid.emailaction.set_from_address", string8));
        }
        if (internetAddressArray4 != null && internetAddressArray4.length > 0) {
            string4.setFrom((Address)internetAddressArray4[0]);
        }
        string4.setSubject(string, "UTF-8");
        string4.addRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
        if (internetAddressArray2 != null) {
            string4.addRecipients(Message.RecipientType.CC, (Address[])internetAddressArray2);
        }
        if (internetAddressArray3 != null) {
            string4.addRecipients(Message.RecipientType.BCC, (Address[])internetAddressArray3);
        }
        if (properties != null) {
            mimeMultipart = properties.keySet().toArray();
            for (int i2 = 0; i2 < ((MimeMultipart)mimeMultipart).length; ++i2) {
                string4.setHeader((String)mimeMultipart[i2], properties.getProperty((String)mimeMultipart[i2]));
            }
        }
        mimeMultipart = new MimeMultipart();
        string4.setContent((Multipart)mimeMultipart);
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText(string2, "UTF-8", string3);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        string4.saveChanges();
        if (dataSourceArray != null) {
            for (int i3 = 0; i3 < dataSourceArray.length; ++i3) {
                if (ScheduleUtils.isParanoid()) {
                    ScheduleUtils.paranoid(ScheduleUtils.getMsg("paranoid.emailaction.add_file_to_attachment", dataSourceArray[i3].getName()));
                }
                MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
                mimeBodyPart2.setDataHandler(new DataHandler(dataSourceArray[i3]));
                mimeBodyPart2.setFileName(dataSourceArray[i3].getName());
                mimeBodyPart2.setDisposition("attachment");
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
            }
        }
        string4.saveChanges();
        if (ScheduleUtils.isParanoid()) {
            ScheduleUtils.paranoid(ScheduleUtils.getMsg("paranoid.emailaction.send_message"));
        }
        if (Scheduler.Yh() == 0) {
            Transport.send((Message)string4, (Address[])string4.getAllRecipients());
        } else {
            Transport transport = session.getTransport("smtp");
            transport.connect(string7, string6, string5);
            transport.sendMessage((Message)string4, string4.getAllRecipients());
            transport.close();
        }
    }

    @Override
    public void action(ExecutedTask executedTask) {
        this.cjY = new Date();
        try {
            Properties properties = new Properties();
            properties.put("X-i-net-software-product", "i-net Clear Reports");
            properties.put("X-i-net-software-product-version", Engine.getVersion());
            properties.put("X-i-net-software-sender", "i-net Clear Reports Scheduler");
            String string = EmailAction.XL();
            ArrayList<Object> arrayList = new ArrayList();
            boolean bl2 = this.cjV;
            File file = null;
            if (ScheduleUtils.isDebug()) {
                ScheduleUtils.debug(ScheduleUtils.getMsg("debug.emailaction.temp_files_for_attachment"));
            }
            if (this.cjU) {
                arrayList = ScheduleUtils.a(executedTask, string, this.XM());
            }
            if (executedTask.getTask().isValid() && executedTask.getTask().getExecutionErrors().length <= 0) {
                if (this.getMessage() == null) {
                    throw new ScheduleException(ScheduleUtils.getMsg("emailaction.err.no_message"), "");
                }
                if (this.getSubject() == null) {
                    throw new ScheduleException(ScheduleUtils.getMsg("emailaction.err.no_subject"), "");
                }
                if (EmailAction.a(executedTask)) {
                    bl2 = true;
                }
                if (bl2) {
                    if (ScheduleUtils.isDebug()) {
                        ScheduleUtils.debug(ScheduleUtils.getMsg("debug.emailaction.zip_temp_files"));
                    }
                    file = File.createTempFile("email_reports", ".zip");
                    file.deleteOnExit();
                    boolean bl3 = ScheduleUtils.b(string, file);
                    arrayList.clear();
                    if (bl3) {
                        arrayList.add(file.getAbsolutePath());
                    }
                }
                if (ScheduleUtils.isDebug()) {
                    ScheduleUtils.debug(ScheduleUtils.getMsg("debug.emailaction.create_datasources"));
                }
                DataSource[] dataSourceArray = new DataSource[arrayList.size()];
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    dataSourceArray[i2] = EmailAction.ab((String)arrayList.get(i2), bl2 ? "reports.zip" : null);
                }
                if (ScheduleUtils.isDebug()) {
                    ScheduleUtils.debug(ScheduleUtils.getMsg("debug.emailaction.call_sendmail"));
                }
                EmailAction.sendMail(SchedulerValidator.fX(this.getTo()), SchedulerValidator.fX(this.getCc()), SchedulerValidator.fX(this.getBc()), this.getSubject(), this.getMessage(), "plain", dataSourceArray, properties);
                if (this.cjU) {
                    if (ScheduleUtils.isDebug()) {
                        ScheduleUtils.debug(ScheduleUtils.getMsg("debug.emailaction.delete_temp_files"));
                    }
                    ScheduleUtils.fT(string);
                    if (bl2) {
                        if (ScheduleUtils.isDebug()) {
                            ScheduleUtils.debug(ScheduleUtils.getMsg("debug.emailaction.delete_zip_file"));
                        }
                        if (!file.delete()) {
                            if (ScheduleUtils.isWarn()) {
                                ScheduleUtils.warn(ScheduleUtils.getMsg("scheduleutils.could_not_delete_file", file.getAbsolutePath()));
                            }
                        } else if (ScheduleUtils.isParanoid()) {
                            ScheduleUtils.paranoid(ScheduleUtils.getMsg("scheduleutils.temp_file_deleted", file.getAbsolutePath()));
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            if (ScheduleUtils.isError()) {
                ScheduleUtils.error(ScheduleUtils.getMsg("emailaction.err.during_execution"));
                ScheduleUtils.error(exception);
            }
            Scheduler scheduler = Scheduler.getInstance();
            String string = scheduler.getScheduleRuntimeProperty("sender");
            String string2 = scheduler.getScheduleRuntimeProperty("smtphost");
            String string3 = scheduler.getScheduleRuntimeProperty("pop3host");
            String string4 = scheduler.getScheduleRuntimeProperty("user");
            String string5 = scheduler.getScheduleRuntimeProperty("password");
            String string6 = scheduler.getScheduleRuntimeProperty("smtpport");
            String string7 = scheduler.getScheduleRuntimeProperty("pop3port");
            MailServerProbeResult mailServerProbeResult = MailServerProbeResult.INTERNAL_FAILURE;
            try {
                new InternetAddress(string);
                mailServerProbeResult = new MailServerProbe().setSmtpHost(string2).setSmtpPort(Integer.valueOf(string6)).setAuthenticationMethod(MailAuthenticationMethod.fromID(Scheduler.Yh())).setUser(string4).setPassword(string5).setPop3Host(string3).setPop3Port(Integer.valueOf(string7)).probe();
            }
            catch (Exception exception2) {
                ScheduleUtils.error(exception);
            }
            if (mailServerProbeResult != MailServerProbeResult.OK) {
                executedTask.getTask().addExecutionError("EmailAction", ScheduleUtils.getMsg("scheduleutils.invalidEmailSettings"));
            }
            Throwable throwable = exception;
            while (throwable.getCause() != null && (!(throwable instanceof IOException) || throwable.getMessage() == null || throwable.getMessage().isEmpty())) {
                throwable = throwable.getCause();
            }
            executedTask.getTask().addExecutionError("EmailAction", throwable.getClass().getName() + ": " + throwable.getMessage());
        }
    }

    private static boolean a(ExecutedTask executedTask) {
        for (int i2 = 0; i2 < executedTask.getReportCount(); ++i2) {
            ExecutedReport executedReport = executedTask.getReport(i2);
            for (int i3 = 0; i3 < executedReport.getInstanceCount(); ++i3) {
                ExecutedInstance executedInstance = executedReport.getInstance(i3);
                String string = executedInstance.getProperties().getProperty("export_fmt");
                if (string == null || !string.startsWith("htm") && !string.startsWith("svg")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isZipAttachment() {
        return this.cjV;
    }

    public void setZipAttachment(boolean bl2) {
        this.cjV = bl2;
    }

    public boolean isAppendDate() {
        return this.cjW;
    }

    public void setAppendDate(boolean bl2) {
        this.cjW = bl2;
    }

    public boolean isAppendTime() {
        return this.cjX;
    }

    public void setAppendTime(boolean bl2) {
        this.cjX = bl2;
    }

    private String XM() {
        String string = this.cjW ? (this.cjX ? FileAction.cks.format(this.cjY) : FileAction.ckq.format(this.cjY)) : (this.cjX ? FileAction.ckr.format(this.cjY) : null);
        if (string != null) {
            string = string.replace('*', '_');
            string = string.replace('?', '_');
            string = string.replace(':', '_');
            string = string.replace('*', '_');
            string = string.replace('<', '_');
            string = string.replace('>', '_');
        }
        return string;
    }

    private static DataSource ab(String string, String string2) throws Exception {
        File file = new File(string);
        String string3 = string2 == null ? file.getName() : string2;
        file = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource((InputStream)fileInputStream, "application/x-unknown");
        byteArrayDataSource.setName(string3);
        fileInputStream.close();
        return byteArrayDataSource;
    }

    @Override
    public String toString() {
        boolean bl2 = super.toString().length() > 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EmailAction] ");
        stringBuffer.append("to=");
        stringBuffer.append(this.cjR);
        stringBuffer.append(", bcc=");
        stringBuffer.append(this.cjT);
        stringBuffer.append(", cc=");
        stringBuffer.append(this.cjS);
        stringBuffer.append(", subject=");
        stringBuffer.append(this.subject);
        stringBuffer.append(", attachreport(s)=");
        stringBuffer.append(this.cjU);
        stringBuffer.append(", zipattachment=");
        stringBuffer.append(this.cjV);
        stringBuffer.append(", message=");
        stringBuffer.append(this.message);
        stringBuffer.append(bl2 ? "\n" + super.toString() : "");
        return stringBuffer.toString();
    }
}

