/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.schedule;

import com.inet.report.schedule.ScheduleException;
import com.inet.report.schedule.ScheduleExecution;
import com.inet.report.schedule.ScheduleUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MonthlyExecution
extends ScheduleExecution {
    private ScheduleExecution.WeekIndex ckw;
    private ScheduleExecution.WeekDay ckx;
    private int y = 0;
    private int cky = 0;
    private int ckz = 0;

    MonthlyExecution() {
        super(new Date(), 0, 0);
        try {
            this.setYearStepSize(1);
        }
        catch (ScheduleException scheduleException) {
            // empty catch block
        }
        this.ckJ = 3;
    }

    protected MonthlyExecution(Date date, int n2, int n3) {
        super(date, n2, n3);
        try {
            this.setYearStepSize(1);
        }
        catch (ScheduleException scheduleException) {
            // empty catch block
        }
        this.ckJ = 3;
    }

    MonthlyExecution(Date date, int[] nArray, int n2, int n3, int n4, ScheduleExecution.WeekIndex weekIndex, ScheduleExecution.WeekDay weekDay) throws ScheduleException {
        super(date, n2, n3);
        this.ckw = weekIndex;
        this.ckx = weekDay;
        this.setMonthStepSize(n4);
        this.setYearStepSize(1);
        if (weekIndex == null && weekDay == null) {
            this.setSpecificDays(nArray);
        }
        this.ckJ = 3;
    }

    @Deprecated
    MonthlyExecution(Date date, int[] nArray, int[] nArray2, int n2, int n3) throws ScheduleException {
        super(date, n2, n3);
        this.setSpecificMonths(nArray);
        this.setSpecificDays(nArray2);
        this.ckJ = 3;
    }

    @Deprecated
    MonthlyExecution(Date date, int[] nArray, int[] nArray2, int n2, int n3, int n4, int n5) throws ScheduleException {
        super(date, n2, n3, n4, n5);
        this.setSpecificMonths(nArray);
        this.setSpecificDays(nArray2);
        this.ckJ = 3;
    }

    public void setMonthStepSize(int n2) throws ScheduleException {
        String[] stringArray;
        if (n2 < 1) {
            this.ckG[4] = ScheduleUtils.getMsg("Range_Error_Month_Stepping_Low", new Integer(1));
        }
        if (n2 >= 12) {
            this.ckG[4] = ScheduleUtils.getMsg("Range_Error_Month_Stepping_High", new Integer(11));
        }
        if ((stringArray = this.getErrorMessages()).length > 0) {
            throw new ScheduleException(stringArray, "SE1059");
        }
        this.bv(4, n2);
    }

    public void setWeekDay(ScheduleExecution.WeekIndex weekIndex, ScheduleExecution.WeekDay weekDay) {
        this.ckw = weekIndex;
        this.ckx = weekDay;
    }

    public void setYearStepSize(int n2) throws ScheduleException {
        String[] stringArray;
        if (n2 < 1) {
            this.ckG[5] = ScheduleUtils.getMsg("Range_Error_Year_Stepping_Low", new Integer(1));
        }
        if ((stringArray = this.getErrorMessages()).length > 0) {
            throw new ScheduleException(stringArray, "SE2059");
        }
        this.bv(5, n2);
    }

    public int getYearStepSize() {
        return this.jm(5);
    }

    public int getMonthStepSize() {
        return this.jm(4);
    }

    public void setSpecificMonths(int[] nArray) throws ScheduleException {
        if (nArray == null || nArray.length == 0) {
            this.ckH[4] = ScheduleUtils.getMsg("ERR_Task_monthList");
        } else {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] > 12) {
                    this.ckH[4] = ScheduleUtils.getMsg("Range_Error_Month_Value_High");
                }
                if (nArray[i2] >= 1) continue;
                this.ckH[4] = ScheduleUtils.getMsg("Range_Error_Month_Value_Low");
            }
        }
        String[] stringArray = this.getErrorMessages();
        if (stringArray.length > 0) {
            throw new ScheduleException(stringArray, "SE0053");
        }
        this.e(4, nArray);
    }

    public int[] getSpecificMonths() {
        return this.jn(4);
    }

    public void setSpecificDays(int[] nArray) throws ScheduleException {
        if (nArray == null || nArray.length == 0) {
            this.ckH[2] = ScheduleUtils.getMsg("ERR_Task_day");
        } else {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] > 31) {
                    this.ckH[2] = ScheduleUtils.getMsg("Range_Error_Day_Value_High");
                }
                if (nArray[i2] >= 1) continue;
                this.ckH[2] = ScheduleUtils.getMsg("Range_Error_Day_Value_Low");
            }
        }
        String[] stringArray = this.getErrorMessages();
        if (stringArray.length > 0) {
            throw new ScheduleException(stringArray, "SE0052");
        }
        this.e(2, nArray);
    }

    public int[] getSpecificDays() {
        return this.jn(2);
    }

    @Override
    int XK() {
        return 1838;
    }

    private int bu(int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(true);
        calendar.set(5, 1);
        calendar.set(1, n3);
        calendar.set(2, n2);
        switch (this.ckw) {
            case LAST: {
                if (ScheduleExecution.WeekDay.DAY.equals((Object)this.ckx)) {
                    return calendar.getActualMaximum(5);
                }
                for (int i2 = calendar.getActualMaximum(5); i2 >= 1; --i2) {
                    calendar.set(5, i2);
                    if (this.ckx.ordinal() + 1 != calendar.get(7)) continue;
                    return i2;
                }
                break;
            }
            default: {
                if (ScheduleExecution.WeekDay.DAY.equals((Object)this.ckx)) {
                    return this.ckw.ordinal() + 1;
                }
                int n4 = 0;
                for (int i3 = 1; i3 <= calendar.getActualMaximum(5); ++i3) {
                    calendar.set(5, i3);
                    if (this.ckx.ordinal() + 1 != calendar.get(7)) continue;
                    if (n4 == this.ckw.ordinal()) {
                        return i3;
                    }
                    ++n4;
                }
            }
        }
        throw new IllegalStateException();
    }

    public ScheduleExecution.WeekDay getWeekDay() {
        return this.ckx;
    }

    public ScheduleExecution.WeekIndex getWeekIndex() {
        return this.ckw;
    }

    @Override
    Date getNextExecutionTime(Calendar calendar) {
        int n2;
        int n3;
        long l2;
        this.XT();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setLenient(false);
        Calendar calendar3 = (Calendar)calendar.clone();
        if (this.getEndDate() != null && (l2 = this.getEndDate().getTime()) < calendar3.getTime().getTime()) {
            return null;
        }
        int[] nArray = this.getHourRange();
        if (nArray == null || nArray[0] == 0) {
            nArray = null;
        }
        Date date = this.getStartDate();
        calendar3.setTime(date);
        int n4 = -1;
        int n5 = 1;
        int n6 = calendar3.get(11);
        if (nArray != null) {
            n5 = nArray[0];
            n6 = nArray[1];
        } else {
            n6 = this.jn(1)[0];
        }
        calendar3.set(11, n6);
        n4 = n6;
        calendar3.set(12, this.jn(0)[0]);
        calendar3.set(13, 0);
        calendar3.set(14, 0);
        boolean bl2 = calendar3.getTime().after(calendar.getTime());
        int n7 = -1;
        int[] nArray2 = this.jn(2);
        int[] nArray3 = this.jn(4);
        int n8 = calendar3.get(2);
        int n9 = -1;
        int n10 = this.jm(5);
        if (nArray3 == null) {
            n9 = this.jm(4);
            nArray3 = new int[]{};
        }
        int n11 = calendar3.get(5);
        int n12 = -1;
        for (n3 = 0; n3 < nArray3.length; ++n3) {
            if (nArray3[n3] - 1 != n8) continue;
            n12 = n3;
            break;
        }
        n3 = n11;
        if (nArray2 != null) {
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                if (nArray2[n2] != n11) continue;
                n7 = n2;
                break;
            }
            if (n7 == -1) {
                n3 = nArray2[0];
            }
        }
        if (this.ckw != null && this.ckx != null) {
            n3 = this.bu(n8, calendar3.get(1));
        }
        calendar3.set(5, n3);
        n2 = calendar3.get(5);
        bl2 &= !(n2 != n3 || n7 < 0 && n11 > n3 || n12 < 0 && n9 < 0);
        while (!bl2) {
            int n13;
            int n14 = 0;
            n11 = calendar3.get(5);
            int n15 = n8 = calendar3.get(2);
            int n16 = (calendar3.get(11) + n5) % 24;
            boolean bl3 = nArray != null && n16 != n4 && (nArray[1] <= n16 && n16 <= nArray[2] || n16 <= nArray[2] && nArray[2] <= nArray[1] || nArray[2] <= nArray[1] && nArray[1] <= n16);
            n7 = -1;
            if (nArray2 != null) {
                for (n13 = 0; n13 < nArray2.length; ++n13) {
                    if (nArray2[n13] != n11) continue;
                    n7 = n13;
                    break;
                }
            }
            if (bl3 && n7 >= 0 && (n12 >= 0 || n9 >= 0)) {
                calendar3.add(11, n5);
            } else {
                n13 = 0;
                while (n13 == 0) {
                    int n17;
                    block44: {
                        int n18;
                        int n19;
                        n17 = 1;
                        if (nArray2 == null) {
                            // empty if block
                        }
                        if (n12 < 0 && n9 < 0) {
                            if (nArray2 != null) {
                                n7 = nArray2.length - 1;
                            }
                            for (n19 = 0; n19 < nArray3.length; ++n19) {
                                if (nArray3[n19] - 1 <= n8) continue;
                                n12 = n19;
                                break;
                            }
                            if (n12 < 0) {
                                n12 = 0;
                                n14 = n10;
                            }
                        } else if (n7 < 0) {
                            if (nArray2 != null) {
                                for (n19 = 0; n19 < nArray2.length; ++n19) {
                                    if (nArray2[n19] <= n11) continue;
                                    n7 = n19 - 1;
                                    if (n7 >= 0) break;
                                    n7 += nArray2.length;
                                    break;
                                }
                            }
                            if (n7 == -1) {
                                if (n9 == -1) {
                                    if ((n12 = (n12 + 1) % nArray3.length) == 0) {
                                        n14 = n10;
                                    }
                                    if (nArray2 != null) {
                                        n7 = nArray2.length - 1;
                                    }
                                } else {
                                    n15 = (n8 + n9) % 12;
                                    if (n8 + n9 >= 12) {
                                        n14 = n10;
                                    }
                                    n8 = n15;
                                }
                            }
                        } else if (n7 == nArray2.length - 1 || nArray2[(n7 + 1) % nArray2.length] > calendar3.getActualMaximum(5)) {
                            if (n9 == -1) {
                                if ((n12 = (n12 + 1) % nArray3.length) == 0) {
                                    n14 = n10 != -1 ? n10 : 1;
                                }
                            } else {
                                n15 = (n8 + n9) % 12;
                                if (n8 + n9 >= 12) {
                                    n14 = n10;
                                }
                                n8 = n15;
                                n7 = -1;
                            }
                        }
                        if (nArray2 != null) {
                            n17 = n19 = nArray2[(n7 + 1) % nArray2.length];
                        }
                        n19 = calendar3.get(1) + (n14 > 0 ? n14 : 0);
                        int n20 = n18 = n9 == -1 ? nArray3[n12] - 1 : n15;
                        if (this.ckw != null && this.ckx != null) {
                            n17 = this.bu(n18, n19);
                        }
                        n13 = 1;
                        try {
                            this.A(n19, n18, n17);
                            calendar2.set(n19, n18, n17);
                            calendar2.get(5);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            n13 = 0;
                            if (!"YEAR".equals(illegalArgumentException.getMessage())) break block44;
                            return null;
                        }
                    }
                    if (n13 == 0) continue;
                    if (n14 > 0) {
                        calendar3.add(1, n14);
                    }
                    if (n9 == -1) {
                        calendar3.set(2, nArray3[n12] - 1);
                    } else {
                        calendar3.set(2, n15);
                    }
                    calendar3.set(5, n17);
                    calendar3.set(11, n6);
                }
            }
            bl2 = calendar3.getTime().after(calendar.getTime());
            if (this.ckL == null || !calendar3.getTime().after(this.ckL)) continue;
            return null;
        }
        return calendar3.getTime();
    }

    private void XT() {
        this.y = 0;
        this.cky = 0;
        this.ckz = 0;
    }

    private void A(int n2, int n3, int n4) {
        if (this.y == n2 && this.cky == n3 && this.ckz == n4) {
            int[] nArray;
            int[] nArray2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The i-net Clear Reports Scheduler could not calculate the next execution time. The configuration complexity is to high. Please send an email with your scheduler.xml and/or server log files to clearreports@inetsoftware.de");
            stringBuilder.append(" Type: " + this.ckJ);
            if (this.ckK != null) {
                stringBuilder.append(" Startdate: " + new SimpleDateFormat("dd. MMM yyyy").format(this.ckK));
            }
            if ((nArray2 = this.getSpecificMonths()) != null) {
                stringBuilder.append(" specific Months: ");
                for (int i2 = 0; i2 < nArray2.length; ++i2) {
                    stringBuilder.append(nArray2[i2]);
                    if (i2 == nArray2.length - 1) continue;
                    stringBuilder.append(", ");
                }
            }
            if ((nArray = this.getSpecificDays()) != null) {
                stringBuilder.append(" specific Days: ");
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    stringBuilder.append(nArray[i3]);
                    if (i3 == nArray.length - 1) continue;
                    stringBuilder.append(", ");
                }
            }
            stringBuilder.append(" MonthSteps: " + this.getMonthStepSize());
            stringBuilder.append(" YearSteps: " + this.getYearStepSize());
            if (this.ckw != null) {
                stringBuilder.append(" weekIndex: " + (Object)((Object)this.ckw));
            }
            if (this.ckx != null) {
                stringBuilder.append(" weekDay: " + (Object)((Object)this.ckx));
            }
            this.ckG[4] = stringBuilder.toString();
            throw new IllegalStateException(stringBuilder.toString());
        }
        this.y = n2;
        this.cky = n3;
        this.ckz = n4;
    }
}

