/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.schedule;

import com.inet.report.ReportException;
import com.inet.report.cache.Cache;
import com.inet.report.cache.PageOutOfRangeException;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.schedule.ExecutedInstance;
import com.inet.report.schedule.ExecutedReport;
import com.inet.report.schedule.ExecutedTask;
import com.inet.report.schedule.ScheduleAction;
import com.inet.report.schedule.ScheduleException;
import com.inet.report.schedule.ScheduleTask;
import com.inet.report.schedule.ScheduleUtils;
import com.inet.viewer.PrinterJobProgress;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;

public class PrintAction
extends ScheduleAction {
    private int ckB = 1;
    private String ckC = null;
    private boolean avg = true;
    private int orientation = 0;
    private int aYX = 0;
    public static final int ORIENTATION_USE_DEFAULT = 0;
    public static final int ORIENTATION_PORTRAIT = 1;
    public static final int ORIENTATION_LANDSCAPE = 2;
    public static final int QUALITY_NORMAL = 0;
    public static final int QUALITY_DRAFT = 1;
    public static final int QUALITY_HIGH = 2;

    @Override
    public String[] getErrorMessages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (this.getQuality()) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                arrayList.add(ScheduleUtils.getMsg("printaction.err.invalid_quality", new Integer(this.getQuality())));
            }
        }
        switch (this.getOrientation()) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                arrayList.add(ScheduleUtils.getMsg("printaction.err.invalid_orientation", new Integer(this.getOrientation())));
            }
        }
        if (this.ckB <= 0) {
            arrayList.add(ScheduleUtils.getMsg("printaction.err.invalid_copies", new Integer(this.getCopies())));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public void action(ExecutedTask executedTask) {
        if (ScheduleUtils.isDebug()) {
            ScheduleUtils.debug(ScheduleUtils.getMsg("debug.printaction.render_patch_non_java"));
        }
        block5: for (int i2 = 0; i2 < executedTask.getReportCount(); ++i2) {
            ExecutedReport executedReport = executedTask.getReport(i2);
            for (int i3 = 0; i3 < executedReport.getInstanceCount(); ++i3) {
                ExecutedInstance executedInstance = executedReport.getInstance(i3);
                String string = ScheduleUtils.b(executedInstance);
                try {
                    ScheduleUtils.a(executedInstance, 3, "");
                }
                catch (ReportException reportException) {
                    if (reportException.getErrorCode() == ErrorCode.ExportFormatDisabled.getErrorCodeNumber()) {
                        executedTask.getTask().addExecutionError("PrintAction", ScheduleUtils.getMsg("printaction.err.javaFormatDiabled", executedReport.getReport().getScheduleName()));
                        continue block5;
                    }
                    ScheduleUtils.a(executedTask, executedInstance, string, reportException);
                }
                if (executedInstance.fP(string)) continue;
                List<ScheduleTask.LastGeneratedReportInstance> list = executedTask.getTask().getLastReportInstances().get(executedReport.getReport().getScheduleName());
                if (list != null) {
                    list.clear();
                }
                try {
                    this.a(executedInstance);
                    continue;
                }
                catch (ScheduleException scheduleException) {
                    if (ScheduleUtils.isError()) {
                        ScheduleUtils.error(ScheduleUtils.getMsg("printaction.err.print_instance"));
                        ScheduleUtils.error(scheduleException.getMessage());
                    }
                    executedTask.getTask().addExecutionError("PrintAction", scheduleException.getClass().getName() + ": " + scheduleException.getMessage());
                    continue;
                }
                catch (Exception exception) {
                    if (ScheduleUtils.isError()) {
                        ScheduleUtils.error(ScheduleUtils.getMsg("printaction.err.print_instance"));
                        ScheduleUtils.error(exception);
                    }
                    Throwable throwable = exception;
                    while (throwable.getCause() != null) {
                        throwable = throwable.getCause();
                    }
                    executedTask.getTask().addExecutionError("PrintAction", throwable.getClass().getName() + ": " + throwable.getMessage());
                }
            }
        }
    }

    private void a(ExecutedInstance executedInstance) throws Exception {
        if (this.ckC != null) {
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
            for (int i2 = 0; i2 < printServiceArray.length; ++i2) {
                if (!printServiceArray[i2].getName().equals(this.ckC)) continue;
                this.a(executedInstance, printServiceArray[i2]);
            }
        } else {
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            if (printService != null) {
                this.a(executedInstance, printService);
            } else {
                throw new ScheduleException(ScheduleUtils.getMsg("printaction.no_print_service_found"), "SE0060");
            }
        }
    }

    private void a(ExecutedInstance executedInstance, PrintService printService) throws Exception {
        if (ScheduleUtils.isDebug()) {
            ScheduleUtils.debug(ScheduleUtils.getMsg("printaction.using_print_service", printService.getName()));
        }
        a a2 = new a(executedInstance);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(printService);
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (ScheduleUtils.isDebug()) {
            ScheduleUtils.debug(ScheduleUtils.getMsg("debug.printaction.start_print_copy"));
        }
        hashPrintRequestAttributeSet.add(new Copies(this.ckB));
        switch (this.getOrientation()) {
            case 2: {
                hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
                break;
            }
            case 1: {
                hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
                break;
            }
        }
        if (this.isUseColor()) {
            hashPrintRequestAttributeSet.add(Chromaticity.COLOR);
        } else {
            hashPrintRequestAttributeSet.add(Chromaticity.MONOCHROME);
        }
        switch (this.getQuality()) {
            case 1: {
                hashPrintRequestAttributeSet.add(PrintQuality.DRAFT);
                break;
            }
            case 2: {
                hashPrintRequestAttributeSet.add(PrintQuality.HIGH);
                break;
            }
            case 0: {
                hashPrintRequestAttributeSet.add(PrintQuality.NORMAL);
            }
        }
        PrinterJobProgress printerJobProgress = new PrinterJobProgress(null, printerJob, hashPrintRequestAttributeSet, a2);
        printerJobProgress.startProgress();
        while (!printerJobProgress.isFinished()) {
            try {
                Thread.sleep(1000L);
                if (!ScheduleUtils.isParanoid()) continue;
                ScheduleUtils.paranoid(ScheduleUtils.getMsg("paranoid.printaction_wait_busy"));
            }
            catch (InterruptedException interruptedException) {
                if (ScheduleUtils.isDebug()) {
                    ScheduleUtils.debug(ScheduleUtils.getMsg("debug.printaction.cancel_print"));
                }
                return;
            }
        }
        if (printerJobProgress.getErrorMessage() != null && printerJobProgress.getErrorMessage().toLowerCase().contains("exception")) {
            throw new RuntimeException(printerJobProgress.getErrorMessage());
        }
        if (ScheduleUtils.isDebug()) {
            ScheduleUtils.debug(ScheduleUtils.getMsg("debug.printaction.finished_print_copy"));
        }
    }

    public int getCopies() {
        return this.ckB;
    }

    public void setCopies(int n2) {
        this.ckB = n2;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n2) {
        this.orientation = n2;
    }

    public String getPrinterName() {
        return this.ckC;
    }

    public void setPrinterName(String string) {
        this.ckC = string != null && string.equals(ScheduleUtils.getMsg("printactionbeaninfo.printername.default_printer")) ? null : string;
    }

    public int getQuality() {
        return this.aYX;
    }

    public void setQuality(int n2) {
        this.aYX = n2;
    }

    public boolean isUseColor() {
        return this.avg;
    }

    public void setUseColor(boolean bl2) {
        this.avg = bl2;
    }

    @Override
    public String toString() {
        boolean bl2 = super.toString().length() > 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[PrintAction ");
        stringBuffer.append("printerName=");
        stringBuffer.append(this.ckC);
        stringBuffer.append(", copies=");
        stringBuffer.append(this.ckB);
        stringBuffer.append(", orientation=");
        stringBuffer.append(this.orientation);
        stringBuffer.append(", quality=");
        stringBuffer.append(this.aYX);
        stringBuffer.append(", useColor=");
        stringBuffer.append(this.avg);
        stringBuffer.append(bl2 ? "\n" + super.toString() : "");
        return stringBuffer.toString();
    }

    private static class a
    implements RenderData {
        private ExecutedInstance ckD;

        a(ExecutedInstance executedInstance) {
            this.ckD = executedInstance;
        }

        @Override
        public byte[] getPageData(int n2) throws ViewerException {
            try {
                return Cache.getCache().getPageAndWait(this.ckD.XN(), n2, 600000);
            }
            catch (Exception exception) {
                throw new ViewerException("getPageData", exception);
            }
        }

        @Override
        public int getPageCount() throws ViewerException {
            try {
                return Cache.getCache().getPageCountAndWait(this.ckD.XN(), 600000);
            }
            catch (Exception exception) {
                throw new ViewerException("getPageCount", exception);
            }
        }

        @Override
        public boolean isPageLimitExceeded() throws ViewerException {
            try {
                return Cache.getCache().isPageLimitExceeded(this.ckD.XN());
            }
            catch (Exception exception) {
                throw new ViewerException("isPageLimitExceeded", exception);
            }
        }

        @Override
        public void setReportTitle(String string) {
        }

        @Override
        public String getReportTitle() {
            return null;
        }

        @Override
        public String getReportLocation() {
            return null;
        }

        @Override
        public byte[] getNextExportChunk() throws ViewerException {
            return null;
        }

        @Override
        public int getExportChunkCount(Properties properties) throws ViewerException {
            return 0;
        }

        @Override
        public byte[] getGroupTree() throws ViewerException {
            return null;
        }

        @Override
        public byte[] refreshPageData(int n2) throws ViewerException {
            return null;
        }

        @Override
        public void setReportProperty(String string, String string2) {
        }

        @Override
        public String getReportProperty(String string) {
            return null;
        }

        @Override
        public void setPromptOnRefresh(boolean bl2) {
        }

        @Override
        public RenderData getCopy() {
            return null;
        }

        @Override
        public void setReportLocation(String string) {
        }

        @Override
        public Properties getProperties() {
            return null;
        }

        @Override
        public boolean isPromptOnRefresh() {
            return false;
        }

        @Override
        public void stop() {
        }

        @Override
        public byte[] search(String string, int n2, int n3) {
            return null;
        }

        @Override
        public byte[] getFontData(int n2) {
            try {
                return Cache.getCache().getPageAndWait(this.ckD.XN(), -n2, 600000);
            }
            catch (PageOutOfRangeException pageOutOfRangeException) {
                return null;
            }
            catch (Exception exception) {
                throw new ViewerException("getFontData", exception);
            }
        }

        @Override
        public void resetServerCacheTimeout() {
            throw new ViewerException("resetting is unsupported for PrintReportData. You should not see this error.");
        }
    }
}

