/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.schedule;

import com.inet.report.schedule.ExecutionTimeProvider;
import com.inet.report.schedule.ScheduleException;
import com.inet.report.schedule.ScheduleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public abstract class ScheduleExecution
implements ExecutionTimeProvider {
    String[] ckG = new String[6];
    String[] ckH = new String[6];
    String ckI;
    public static final int TYPE_MINUTE = 0;
    public static final int TYPE_HOUR = 1;
    public static final int TYPE_DAY = 2;
    public static final int TYPE_WEEK = 3;
    public static final int TYPE_MONTH = 4;
    public static final int TYPE_YEAR = 5;
    public static final int ILLEGAL_STEPSIZE = -1;
    public static final int DAILY_INTERVAL = 1;
    public static final int WEEKLY_INTERVAL = 2;
    public static final int MONTHLY_INTERVAL = 3;
    public static final int ONLY_ONCE = 4;
    public static final int YEARLY_INTERVAL = 5;
    int ckJ;
    private int loopCount = -1;
    protected Date ckK = new Date();
    protected Date ckL;
    protected int[] ckM = new int[]{-1, -1, -1, -1, -1, -1};
    protected int[][] ckN = new int[6][];

    ScheduleExecution(Date date, int n2, int n3) {
        if (date == null) {
            this.ckI = ScheduleUtils.getMsg("scheduletask.err.no_start_date_set");
        } else {
            this.ckK = date;
        }
        if (n2 < 0) {
            this.ckH[1] = ScheduleUtils.getMsg("Range_Error_Hour_Value_Low");
        } else if (n2 > 23) {
            this.ckH[1] = ScheduleUtils.getMsg("Range_Error_Hour_Value_High");
        }
        if (n3 < 0) {
            this.ckH[0] = ScheduleUtils.getMsg("Range_Error_Minute_Value_Low");
        } else if (n3 > 59) {
            this.ckH[0] = ScheduleUtils.getMsg("Range_Error_Minute_Value_High");
        }
        int[] nArray = new int[]{n2};
        int[] nArray2 = new int[]{n3};
        this.ckN[0] = nArray2;
        this.ckN[1] = nArray;
    }

    ScheduleExecution(Date date, int n2, int n3, int n4, int n5) throws ScheduleException {
        if (date == null) {
            this.ckI = ScheduleUtils.getMsg("scheduletask.err.no_start_date_set");
        } else {
            this.ckK = date;
        }
        this.setHourRange(n4, n2, n3, n5);
        int[] nArray = new int[]{n5};
        int n6 = n4;
        this.ckN[0] = nArray;
        this.ckM[1] = n6;
    }

    abstract int XK();

    abstract Date getNextExecutionTime(Calendar var1);

    public int getIntervalType() {
        return this.ckJ;
    }

    private Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(System.currentTimeMillis()));
        return calendar;
    }

    @Override
    public Date getNextExecutionTime() {
        if (this.loopCount != 0) {
            return this.getNextExecutionTime(this.getCalendar());
        }
        return null;
    }

    int jm(int n2) {
        if (this.jo(n2)) {
            return this.ckM[n2];
        }
        return -1;
    }

    int[] jn(int n2) {
        if (this.jp(n2)) {
            return this.ckN[n2];
        }
        return null;
    }

    void bv(int n2, int n3) {
        if (this.jo(n2)) {
            this.ckM[n2] = n3;
        }
    }

    void e(int n2, int[] nArray) {
        if (this.jp(n2)) {
            nArray = this.x(nArray);
            this.ckN[n2] = nArray;
        }
    }

    private int[] x(int[] nArray) {
        Arrays.sort(nArray);
        int n2 = -1;
        int[] nArray2 = new int[]{};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] == n2) {
                nArray2 = new int[nArray.length - 1];
                System.arraycopy(nArray, 0, nArray2, 0, i2);
                System.arraycopy(nArray, i2 + 1, nArray2, i2, nArray2.length - i2);
                nArray = nArray2;
                --i2;
            }
            n2 = nArray[i2];
        }
        return nArray;
    }

    boolean jo(int n2) {
        int n3 = n2 * 2;
        int n4 = this.XK();
        return (1 << n3 & n4) != 0;
    }

    boolean jp(int n2) {
        int n3 = n2 * 2 + 1;
        int n4 = this.XK();
        return (1 << n3 & n4) != 0;
    }

    String[] getErrorMessages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < 6; ++i2) {
            if (this.ckH[i2] != null) {
                arrayList.add(this.ckH[i2]);
            }
            if (this.ckG[i2] == null) continue;
            arrayList.add(this.ckG[i2]);
        }
        if (this.ckI != null) {
            arrayList.add(this.ckI);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setHourRange(int n2, int n3, int n4) throws ScheduleException {
        this.setHourRange(n2, n3, n4, 0);
    }

    public void setHourRange(int n2, int n3, int n4, int n5) throws ScheduleException {
        if (n5 < 0) {
            this.ckH[0] = ScheduleUtils.getMsg("Range_Error_Minute_Value_Low");
        }
        if (n5 >= 60) {
            this.ckH[0] = ScheduleUtils.getMsg("Range_Error_Minute_Value_High");
        }
        if (n2 <= 0) {
            this.ckG[1] = ScheduleUtils.getMsg("Range_Error_Hour_Stepping_Low");
        }
        if (n4 < n3) {
            this.ckH[1] = ScheduleUtils.getMsg("Range_Error_End_Before_Start");
        }
        if (n4 < 0) {
            this.ckH[1] = ScheduleUtils.getMsg("Range_Error_Hour_Value_Low");
        } else if (n4 > 23) {
            this.ckH[1] = ScheduleUtils.getMsg("Range_Error_Hour_Value_High");
        }
        if (n3 < 0) {
            this.ckH[1] = ScheduleUtils.getMsg("Range_Error_Hour_Value_Low");
        } else if (n3 > 23) {
            this.ckH[1] = ScheduleUtils.getMsg("Range_Error_Hour_Value_High");
        }
        String[] stringArray = this.getErrorMessages();
        if (stringArray.length > 0) {
            throw new ScheduleException(stringArray, "SE0045");
        }
        int n6 = (n4 - n3) / n2 + 1;
        int[] nArray = new int[n6];
        int n7 = 0;
        for (int i2 = n3; i2 <= n4; i2 += n2) {
            nArray[n7++] = i2 % 24;
        }
        this.e(1, nArray);
        this.e(0, new int[]{n5});
    }

    @Override
    public Date getStartDate() {
        return this.ckK;
    }

    @Override
    public void setStartDate(Date date) throws ScheduleException {
        if (date == null) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduletask.err.no_start_date_set"), "SE0044");
        }
        this.ckK = date;
    }

    @Override
    public final Date getEndDate() {
        return this.ckL;
    }

    @Override
    public final void setEndDate(Date date) {
        this.ckL = date;
    }

    public void setStartTime(int n2, int n3) throws ScheduleException {
        String[] stringArray;
        if (n2 < 0) {
            this.ckH[1] = ScheduleUtils.getMsg("Range_Error_Hour_Value_Low");
        }
        if (n2 > 23) {
            this.ckH[1] = ScheduleUtils.getMsg("Range_Error_Hour_Value_High");
        }
        if (n3 < 0) {
            this.ckH[0] = ScheduleUtils.getMsg("Range_Error_Minute_Value_Low");
        }
        if (n3 > 59) {
            this.ckH[0] = ScheduleUtils.getMsg("Range_Error_Minute_Value_High");
        }
        if ((stringArray = this.getErrorMessages()).length > 0) {
            throw new ScheduleException(stringArray, "SE0046");
        }
        this.ckN[1] = new int[]{n2};
        this.ckN[0] = new int[]{n3};
    }

    public int getHour() {
        int[] nArray = this.jn(1);
        if (nArray.length == 0) {
            return 0;
        }
        return nArray[0];
    }

    public int getMinute() {
        int[] nArray = this.jn(0);
        if (nArray.length == 0) {
            return 0;
        }
        return nArray[0];
    }

    public int[] getHourRange() {
        return ScheduleExecution.y(this.jn(1));
    }

    private static int[] y(int[] nArray) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (nArray == null) {
            return null;
        }
        int n5 = nArray.length;
        if (n5 < 2) {
            return null;
        }
        if (n5 == 2) {
            n3 = nArray[0];
            n4 = nArray[1];
            n2 = n4 - n3;
        } else {
            int n6;
            int[] nArray2 = new int[n5];
            for (n6 = 0; n6 < n5; ++n6) {
                nArray2[n6] = (nArray[(n6 + 1) % n5] - nArray[n6] + 24) % 24;
            }
            n6 = -1;
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                int n7 = (i2 - 1 + n5) % n5;
                int n8 = (i2 + 1) % n5;
                if (nArray2[i2] == nArray2[n7] || nArray2[i2] == nArray2[n8]) continue;
                if (n6 == -1) {
                    n6 = i2;
                    n2 = nArray2[n8];
                    continue;
                }
                return null;
            }
            if (n6 == -1) {
                n6 = n5 - 1;
                n2 = nArray2[0];
            }
            n3 = nArray[(n6 + 1) % n5];
            n4 = nArray[n6];
        }
        return new int[]{n2, n3, n4};
    }

    @Override
    public void setLoopCount(int n2) {
        this.loopCount = n2;
    }

    @Override
    public int getLoopCount() {
        return this.loopCount;
    }

    public static enum WeekDay {
        SUNDAY,
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY,
        DAY;

    }

    public static enum WeekIndex {
        FIRST,
        SECOND,
        THIRD,
        FOURTH,
        LAST;

    }
}

