/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.schedule;

import com.inet.report.schedule.DailyExecution;
import com.inet.report.schedule.MonthlyExecution;
import com.inet.report.schedule.OneDayExecution;
import com.inet.report.schedule.ScheduleException;
import com.inet.report.schedule.ScheduleExecution;
import com.inet.report.schedule.WeeklyExecution;
import com.inet.report.schedule.YearlyExecution;
import java.util.Date;

public final class ScheduleExecutionFactory {
    private ScheduleExecutionFactory() {
    }

    public static ScheduleExecution createScheduleExecution(int n2) {
        ScheduleExecution scheduleExecution = null;
        switch (n2) {
            case 1: {
                scheduleExecution = new DailyExecution();
                break;
            }
            case 2: {
                scheduleExecution = new WeeklyExecution();
                break;
            }
            case 3: {
                scheduleExecution = new MonthlyExecution();
                break;
            }
            case 4: {
                scheduleExecution = new OneDayExecution();
            }
        }
        return scheduleExecution;
    }

    public static OneDayExecution createOneDayExecution(Date date, int n2, int n3) throws ScheduleException {
        return new OneDayExecution(date, n2, n3);
    }

    public static OneDayExecution createOneDayExecution(Date date, int n2, int n3, int n4, int n5) throws ScheduleException {
        return new OneDayExecution(date, n2, n3, n4, n5);
    }

    public static DailyExecution createDailyExecution(Date date, int n2, int n3, int n4) throws ScheduleException {
        return new DailyExecution(date, n2, n3, n4);
    }

    public static DailyExecution createDailyExecution(Date date, int n2, int n3, int n4, int n5, int n6) throws ScheduleException {
        return new DailyExecution(date, n2, n3, n4, n5, n6);
    }

    public static WeeklyExecution createWeeklyExecution(Date date, int n2, int[] nArray, int n3, int n4) throws ScheduleException {
        return new WeeklyExecution(date, n2, nArray, n3, n4);
    }

    public static WeeklyExecution createWeeklyExecution(Date date, int n2, int[] nArray, int n3, int n4, int n5, int n6) throws ScheduleException {
        return new WeeklyExecution(date, n2, nArray, n3, n4, n5, n6);
    }

    @Deprecated
    public static MonthlyExecution createMonthlyExecution(Date date, int[] nArray, int[] nArray2, int n2, int n3) throws ScheduleException {
        return new MonthlyExecution(date, nArray, nArray2, n2, n3);
    }

    public static MonthlyExecution createMonthlyExecution(Date date, int[] nArray, int n2, int n3, int n4, ScheduleExecution.WeekIndex weekIndex, ScheduleExecution.WeekDay weekDay) throws ScheduleException {
        return new MonthlyExecution(date, nArray, n2, n3, n4, weekIndex, weekDay);
    }

    public static YearlyExecution createYearlyExecution(Date date, int[] nArray, int n2, int n3, int n4, ScheduleExecution.WeekIndex weekIndex, ScheduleExecution.WeekDay weekDay) throws ScheduleException {
        return new YearlyExecution(date, nArray, n2, n3, weekIndex, weekDay, n4);
    }

    @Deprecated
    public static MonthlyExecution createMonthlyExecution(Date date, int[] nArray, int[] nArray2, int n2, int n3, int n4, int n5) throws ScheduleException {
        return new MonthlyExecution(date, nArray, nArray2, n2, n3, n4, n5);
    }
}

