/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.schedule;

import com.inet.report.BaseUtils;
import com.inet.report.schedule.DynamicProperties;
import com.inet.report.schedule.ScheduleException;
import com.inet.report.schedule.ScheduleTask;
import com.inet.report.schedule.ScheduleUtils;
import com.inet.report.schedule.SchedulerValidator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class ScheduleReport {
    private Properties Iq = new Properties();
    private String clm;
    private List<Object> bCy = new ArrayList<Object>();
    private String cln;
    private ScheduleTask clo;
    private HashMap<String, Integer> clp = new HashMap();

    ScheduleReport(String string, Properties properties, ScheduleTask scheduleTask) {
        this.clo = scheduleTask;
        this.cln = string;
        this.addAllProperties(properties);
    }

    public void addProperty(String string, String string2) throws ScheduleException {
        if (string == null || string.trim().length() == 0) {
            throw new ScheduleException(ScheduleUtils.getMsg("schedulereport.err.report_property_null_or_empty"), "SE0032");
        }
        String string3 = string.toLowerCase();
        if ("export_fmt".equals(string3) && (string2 == null || string2.trim().length() == 0)) {
            string2 = "java";
        }
        this.Iq.setProperty(string3, string2);
    }

    public String getPropertyValue(String string) {
        return this.Iq.getProperty(string.toLowerCase());
    }

    public String getDynamicPropertiesClass() {
        return this.clm;
    }

    public void setDynamicPropertiesClass(String string) {
        this.bCy.clear();
        if (string == null || string.trim().length() == 0) {
            this.clm = null;
        } else {
            int n2 = string.lastIndexOf("|(");
            int n3 = string.lastIndexOf(")|");
            if (n2 >= 0 && n3 > n2) {
                this.bCy = BaseUtils.getParams(string.substring(n2 + 2, n3), ",|;");
            }
            this.clm = string;
        }
    }

    public boolean isDynamic() {
        return this.clm != null && this.clm.trim().length() != 0;
    }

    public DynamicProperties getDynamicPropertiesClassInstance() {
        try {
            return this.XY();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private DynamicProperties XY() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object object;
        int n2 = this.clm.indexOf("|(");
        String string = "";
        string = n2 > 0 ? this.clm.substring(0, n2) : this.clm;
        Class clazz = BaseUtils.classForName(string);
        Class[] classArray = new Class[this.bCy.size()];
        int n3 = this.clm.indexOf(")|");
        if (n3 > 0 && n3 > n2) {
            object = BaseUtils.getParams(this.clm.substring(n2 + 2, n3), ",|;");
            classArray = new Class[object.size()];
            for (int i2 = 0; i2 < object.size(); ++i2) {
                Class<?> clazz2;
                String string2 = object.get(i2).toString();
                Object object2 = this.bCy.get(i2);
                if (string2.toLowerCase().contains("double")) {
                    classArray[i2] = Double.TYPE;
                    if (object2 != null && !object2.toString().isEmpty()) continue;
                    this.bCy.set(i2, 0.0);
                    continue;
                }
                if (string2.toLowerCase().contains("int")) {
                    classArray[i2] = Integer.TYPE;
                    if (object2 != null && !object2.toString().isEmpty()) continue;
                    this.bCy.set(i2, 0);
                    continue;
                }
                if (string2.toLowerCase().contains("boolean")) {
                    classArray[i2] = Boolean.TYPE;
                    if (object2 != null && !object2.toString().isEmpty()) continue;
                    this.bCy.set(i2, Boolean.FALSE);
                    continue;
                }
                classArray[i2] = clazz2 = Class.forName(string2);
                Object object3 = object2;
                if (object3 == null || object3.getClass().isAssignableFrom(classArray[i2])) continue;
                this.bCy.set(i2, null);
            }
        }
        object = clazz.getConstructor(classArray);
        DynamicProperties dynamicProperties = (DynamicProperties)((Constructor)object).newInstance(this.bCy.toArray());
        return dynamicProperties;
    }

    public String getScheduleName() {
        return this.cln;
    }

    public void addAllProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        String[] stringArray = properties.keySet().toArray(new String[properties.size()]);
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.addProperty(stringArray[i2].toLowerCase(), properties.getProperty(stringArray[i2]));
            }
        }
        catch (ScheduleException scheduleException) {
            // empty catch block
        }
    }

    public Properties getProperties() {
        Properties properties = (Properties)this.Iq.clone();
        String string = properties.getProperty("report");
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL == null) {
            try {
                uRL = new File(string).toURI().toURL();
                InputStream inputStream = uRL.openStream();
                inputStream.close();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                uRL = null;
            }
        }
        if (uRL != null) {
            properties.setProperty("report", uRL.toString());
        }
        return properties;
    }

    public void removeProperty(String string) {
        this.Iq.remove(string);
    }

    public boolean isValid() {
        return this.getErrorMessages().length == 0;
    }

    public String[] getErrorMessages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ScheduleReport scheduleReport = this.clo.getReport(this.cln);
        if (scheduleReport == null) {
            arrayList.add(ScheduleUtils.getMsg("schedulereport.err.report_not_found_in_task"));
        } else if (!this.equals(scheduleReport)) {
            arrayList.add(ScheduleUtils.getMsg("schedulereport.err.report_of_task_is_not_this"));
        }
        arrayList.addAll(SchedulerValidator.validateScheduleReportLocation(this.Iq.getProperty("report"), this.Iq.getProperty("export_fmt", "java")));
        if (this.clm != null) {
            try {
                Class<?> clazz = this.XY().getClass();
                if ((clazz.getModifiers() & 0x400) != 0) {
                    arrayList.add(ScheduleUtils.getMsg("schedulereport.err.dynamic_properties_abstract", this.clm));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                arrayList.add(ScheduleUtils.getMsg("schedulereport.err.dynamic_properties_not_found", this.clm));
            }
            catch (SecurityException securityException) {
                arrayList.add(ScheduleUtils.getMsg("schedulereport.err.dynamic_properties_security", this.clm));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                arrayList.add(ScheduleUtils.getMsg("schedulereport.err.dynamic_properties_no_method", this.clm));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                arrayList.add(ScheduleUtils.getMsg("schedulereport.err.dynamic_properties_argument", this.clm));
            }
            catch (InstantiationException instantiationException) {
                arrayList.add(ScheduleUtils.getMsg("schedulereport.err.dynamic_properties_abstract", this.clm));
            }
            catch (IllegalAccessException illegalAccessException) {
                arrayList.add(ScheduleUtils.getMsg("schedulereport.err.dynamic_properties_access", this.clm));
            }
            catch (InvocationTargetException invocationTargetException) {
                arrayList.add(ScheduleUtils.getMsg("schedulereport.err.dynamic_properties_invocation", this.clm));
            }
            catch (ClassCastException classCastException) {
                arrayList.add(ScheduleUtils.getMsg("schedulereport.err.dynamic_properties_not_implementing", this.clm));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ScheduleReport] ");
        stringBuffer.append("scheduleName=");
        stringBuffer.append(this.getScheduleName());
        return stringBuffer.toString();
    }

    public void setPropertyType(String string, int n2) throws ScheduleException {
        if (this.getPropertyValue(string) == null) {
            throw new ScheduleException(ScheduleUtils.getMsg("schedulereport.set_property_type_not_defined", string), "SE0033");
        }
        this.clp.put(string.toLowerCase(), new Integer(n2));
    }

    public int getPropertyType(String string) {
        Integer n2 = this.clp.get(string.toLowerCase());
        if (n2 != null) {
            return n2;
        }
        return -1;
    }
}

