/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.schedule;

import com.inet.report.BaseUtils;
import com.inet.report.schedule.ErrorAction;
import com.inet.report.schedule.ExecutionTimeProvider;
import com.inet.report.schedule.ScheduleAction;
import com.inet.report.schedule.ScheduleException;
import com.inet.report.schedule.ScheduleExecution;
import com.inet.report.schedule.ScheduleExecutionFactory;
import com.inet.report.schedule.ScheduleReport;
import com.inet.report.schedule.ScheduleUtils;
import com.inet.report.schedule.Scheduler;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ScheduleTask {
    private boolean enabled = true;
    private String name = null;
    private final Integer clq;
    private String description = null;
    private Date clr = null;
    private ArrayList<ScheduleReport> ckn = new ArrayList();
    private ArrayList<ScheduleAction> cls = new ArrayList();
    private boolean clt = false;
    public static final int STATUS_EXECUTING = 1;
    public static final int STATUS_WAITING_FOR_EXECUTION = 2;
    public static final int STATUS_SCHEDULED = 3;
    public static final int STATUS_UNSCHEDULED = 4;
    private int status = 4;
    private ExecutionTimeProvider clu;
    private static AtomicInteger clv = new AtomicInteger(0);
    private Map<String, List<LastGeneratedReportInstance>> clw = new ConcurrentHashMap<String, List<LastGeneratedReportInstance>>(16, 0.75f, 1);
    private ArrayList<String> Rw = new ArrayList();
    private boolean clx;

    ScheduleTask() {
        this.clq = clv.getAndAdd(1);
        this.clu = ScheduleExecutionFactory.createScheduleExecution(4);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getName() {
        return this.name;
    }

    public Integer getId() {
        return this.clq;
    }

    public String[] getErrorMessage() {
        String[] stringArray = new String[]{};
        if (this.clu == null) {
            return new String[]{ScheduleUtils.getMsg("scheduletask.err.no_execution_time_set")};
        }
        if (this.clu instanceof ScheduleExecution) {
            ScheduleExecution scheduleExecution = (ScheduleExecution)this.clu;
            if (scheduleExecution.getStartDate() == null) {
                return new String[]{ScheduleUtils.getMsg("scheduletask.err.no_start_date_set")};
            }
            if (scheduleExecution.getEndDate() != null && scheduleExecution.getEndDate().before(scheduleExecution.getStartDate())) {
                return new String[]{ScheduleUtils.getMsg("scheduletask.err.start_after_end")};
            }
        }
        return stringArray;
    }

    public boolean isValid() {
        if (this.clu == null) {
            return false;
        }
        if (this.clu instanceof ScheduleExecution) {
            ScheduleExecution scheduleExecution = (ScheduleExecution)this.clu;
            if (scheduleExecution.getStartDate() == null) {
                return false;
            }
            if (scheduleExecution.getEndDate() != null && scheduleExecution.getEndDate().before(scheduleExecution.getStartDate())) {
                return false;
            }
        }
        return true;
    }

    public void setLastRun(Date date) {
        this.clr = date;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    public int getReportCount() {
        return this.ckn.size();
    }

    public ScheduleReport getReport(int n2) {
        ScheduleReport scheduleReport;
        try {
            scheduleReport = this.ckn.get(n2);
        }
        catch (Exception exception) {
            scheduleReport = null;
        }
        return scheduleReport;
    }

    public ScheduleReport getReport(String string) {
        for (int i2 = 0; i2 < this.getReportCount(); ++i2) {
            ScheduleReport scheduleReport = this.getReport(i2);
            if (!scheduleReport.getScheduleName().equalsIgnoreCase(string)) continue;
            return scheduleReport;
        }
        return null;
    }

    public boolean containsReport(String string) {
        return this.getReport(string) != null;
    }

    public ScheduleReport addReport(String string, Properties properties) throws ScheduleException {
        if (string == null || string.trim().length() == 0) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduletask.add_report_no_schedule_name"), "SE0027");
        }
        if (this.containsReport(string)) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduletask.add_report.report_exists", string), "SE0028");
        }
        if (properties == null) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduletask.add_report.no_properties"), "SE0029");
        }
        if (!properties.containsKey("report")) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduletask.add_report.no_report_property"), "SE0030");
        }
        if (properties.getProperty("report").trim().length() == 0) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduletask.add_report.empty_report_property"), "SE0031");
        }
        ScheduleReport scheduleReport = new ScheduleReport(string, properties, this);
        this.ckn.add(scheduleReport);
        return scheduleReport;
    }

    public void removeReport(String string) {
        for (int i2 = 0; i2 < this.getReportCount(); ++i2) {
            if (!this.getReport(i2).getScheduleName().equalsIgnoreCase(string)) continue;
            this.ckn.remove(i2);
            return;
        }
    }

    public ScheduleAction removeAction(int n2) {
        return this.cls.remove(n2);
    }

    public void addAction(ScheduleAction scheduleAction) throws ScheduleException {
        if (scheduleAction == null) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduletask.add_action_null"), "SE0024");
        }
        for (ScheduleAction scheduleAction2 : this.cls) {
            ScheduleAction scheduleAction3 = scheduleAction2;
            if (scheduleAction3.getClass() != scheduleAction.getClass() || scheduleAction.getClass() == new ErrorAction(null).getClass()) continue;
            throw new ScheduleException(ScheduleUtils.getMsg("scheduletask.add_action_twice", ScheduleUtils.getActionClassName(scheduleAction)), "SE0026");
        }
        this.cls.add(scheduleAction);
    }

    public int getActionCount() {
        return this.cls.size();
    }

    public ScheduleAction getAction(int n2) {
        return this.cls.get(n2);
    }

    private int fR(String string) {
        for (int i2 = 0; i2 < this.cls.size(); ++i2) {
            if (!this.cls.get(i2).getClass().getName().equals(string)) continue;
            return i2;
        }
        return -1;
    }

    public ScheduleAction getAction(String string) {
        int n2 = this.fR(string);
        if (n2 == -1) {
            return null;
        }
        return this.getAction(n2);
    }

    public ScheduleAction removeAction(ScheduleAction scheduleAction) {
        int n2 = this.fR(scheduleAction.getClass().getName());
        if (n2 != -1) {
            return this.removeAction(n2);
        }
        return null;
    }

    public Date getNextStart() {
        if (this.clu == null) {
            return null;
        }
        try {
            Date date = this.clu.getNextExecutionTime();
            return date;
        }
        catch (IllegalStateException illegalStateException) {
            if (BaseUtils.isError()) {
                BaseUtils.error(illegalStateException);
            }
            return null;
        }
    }

    public ExecutionTimeProvider getExecutionTime() {
        return this.clu;
    }

    public final void setExecutionTime(ExecutionTimeProvider executionTimeProvider) {
        this.clu = executionTimeProvider;
    }

    public int getStatus() {
        return this.status;
    }

    void setStatus(int n2) {
        switch (n2) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.clx = false;
            }
        }
        this.status = n2;
    }

    public void setName(String string) throws ScheduleException {
        ScheduleTask scheduleTask = Scheduler.getInstance().getTask(string);
        if (scheduleTask != null && scheduleTask != this) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduler.add_task_already_exists", string), "SE0002");
        }
        this.name = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ScheduleTask] ");
        stringBuffer.append("name=");
        stringBuffer.append(this.getName());
        stringBuffer.append("description=");
        stringBuffer.append(this.getDescription());
        return stringBuffer.toString();
    }

    public boolean isDeleteIfExpired() {
        return this.clt;
    }

    public void setDeleteIfExpired(boolean bl2) {
        this.clt = bl2;
    }

    public void addExecutionError(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            this.Rw.add("execution: " + string2);
        } else {
            this.Rw.add(string + ": " + string2);
        }
    }

    void p(Date date) {
        this.clr = date;
        this.Rw.add(0, DateFormat.getDateTimeInstance(2, 2, Locale.getDefault()).format(date));
    }

    public Date getLastRun() {
        return this.clr;
    }

    void XZ() {
        this.Rw.clear();
    }

    public String[] getExecutionErrors() {
        return this.Rw.toArray(new String[this.Rw.size()]);
    }

    public void setExecutionErrors(String[] stringArray) {
        this.Rw = new ArrayList(stringArray.length);
        for (String string : stringArray) {
            this.Rw.add(string);
        }
    }

    public void markForExecution() {
        if (this.status == 2 || this.status == 1) {
            return;
        }
        if (this.status == 3) {
            Scheduler.getInstance().c(this);
        }
        this.setStatus(2);
        this.clx = true;
    }

    public Map<String, List<LastGeneratedReportInstance>> getLastReportInstances() {
        return this.clw;
    }

    public boolean isManualExecution() {
        return this.clx;
    }

    public static class LastGeneratedReportInstance {
        private ArrayList<String> files = new ArrayList();
        private String nameSuffix;

        public ArrayList<String> getFiles() {
            return this.files;
        }

        public void setFiles(ArrayList<String> arrayList) {
            this.files = arrayList;
        }

        public void setNameSuffix(String string) {
            this.nameSuffix = string;
        }

        public String getNameSuffix() {
            return this.nameSuffix;
        }
    }
}

