/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.schedule;

import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.PromptRequestWarning;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ay;
import com.inet.report.cache.Cache;
import com.inet.report.cache.KeyNotFoundException;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.config.structure.model.DefaulMessageProvider;
import com.inet.report.dw;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.logging.StaticStreamLogger;
import com.inet.report.permissions.Permission;
import com.inet.report.permissions.PermissionGroup;
import com.inet.report.permissions.PermissionHolder;
import com.inet.report.permissions.Permissions;
import com.inet.report.permissions.SystemPermissions;
import com.inet.report.schedule.ExecutedInstance;
import com.inet.report.schedule.ExecutedReport;
import com.inet.report.schedule.ExecutedTask;
import com.inet.report.schedule.ScheduleAction;
import com.inet.report.schedule.ScheduleException;
import com.inet.report.schedule.ScheduleExecution;
import com.inet.report.schedule.ScheduleReport;
import com.inet.report.schedule.ScheduleTask;
import com.inet.report.schedule.Scheduler;
import com.inet.report.schedule.a;
import com.inet.report.schedule.b;
import com.inet.report.schedule.c;
import com.inet.report.schedule.d;
import com.inet.report.schedule.zip.f;
import com.inet.report.svg.SVGUtils;
import com.inet.report.util.UpdateableClassLoader;
import com.inet.report.util.o;
import com.inet.report.util.v;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public final class ScheduleUtils {
    public static final String SCHEDULE_IN_PROCESS = "getscheduleinprocessreport";
    public static final int PATCH_NOTHING = 0;
    public static final int PATCH_EMAIL_FILE = 1;
    public static final int PATCH_PRINT = 3;
    public static ArrayList<String> formate = new b();
    private static final o cly = new o("com.inet.report.schedule.server.LanguageResources");
    private static final DefaulMessageProvider clz = new DefaulMessageProvider("com.inet.report.schedule.server.LanguageResources");
    private static StaticStreamLogger IX = null;
    static boolean clA = false;

    public static o getLanguageBundle() {
        return cly;
    }

    public static String getMsg(String string) {
        return cly.getMsg(string);
    }

    public static String getMsg(String string, Locale locale) {
        String string2 = clz.getMessage(string, locale, new Object[0]);
        if (string2 == null) {
            return "$" + string + "$";
        }
        return string2;
    }

    public static String getMsg(String string, Locale locale, Object ... objectArray) {
        String string2 = ScheduleUtils.getMsg(string, locale);
        try {
            string2 = MessageFormat.format(string2, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String getMsg(String string, Object ... objectArray) {
        String string2 = ScheduleUtils.getMsg(string);
        try {
            string2 = MessageFormat.format(string2, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static void addClassPathEntry(String string) throws ScheduleException, MalformedURLException {
        URL uRL = null;
        MalformedURLException malformedURLException = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException2) {
            malformedURLException = malformedURLException2;
        }
        if (uRL == null) {
            try {
                uRL = new File(string).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException3) {
                malformedURLException = malformedURLException3;
            }
        }
        if (uRL == null && malformedURLException != null) {
            throw malformedURLException;
        }
        if (!(BaseUtils.getUpdateableClassLoader() instanceof UpdateableClassLoader)) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduleutils.no_updateableClassLoader", string), "SE0060");
        }
        ((UpdateableClassLoader)((Object)BaseUtils.getUpdateableClassLoader())).addUrl(uRL);
    }

    public static String getActionName(ScheduleAction scheduleAction) {
        return ScheduleUtils.getActionName(scheduleAction.getClass().getName());
    }

    public static String getActionName(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("com.inet.report.schedule.EmailAction") || string.equals("com.inet.report.schedule.FileAction") || string.equals("com.inet.report.schedule.PrintAction") || string.equals("com.inet.report.schedule.ErrorAction") || string.equals("com.inet.report.schedule.FtpAction")) {
            return ScheduleUtils.getActionDisplayName(string);
        }
        String string2 = ScheduleUtils.getActionDisplayName(string);
        if (string2 != null && !string2.trim().equals("")) {
            return string2;
        }
        Scheduler scheduler = Scheduler.getInstance();
        for (int i2 = 0; i2 < scheduler.getCustomActionCount(); ++i2) {
            Scheduler.CustomActionDefinition customActionDefinition = scheduler.getCustomAction(i2);
            if (!customActionDefinition.getClassName().equals(string)) continue;
            return customActionDefinition.getName();
        }
        return null;
    }

    public static String getActionClassName(ScheduleAction scheduleAction) {
        return scheduleAction.getClass().getName();
    }

    static String fS(String string) {
        String string2 = string;
        string2 = string2.replace('\\', '_');
        string2 = string2.replace('/', '_');
        string2 = string2.replace(':', '_');
        string2 = string2.replace('*', '_');
        string2 = string2.replace('?', '_');
        string2 = string2.replace('\"', '_');
        string2 = string2.replace('<', '_');
        string2 = string2.replace('>', '_');
        string2 = string2.replace('|', '_');
        return string2;
    }

    static String a(String string, ExecutedInstance executedInstance, String string2) throws Exception {
        Cache cache = Cache.getCache();
        ReportCacheKey reportCacheKey = executedInstance.XN();
        String string3 = string + ScheduleUtils.a(executedInstance, true, string2);
        new File(string3).getParentFile().mkdirs();
        if (ScheduleUtils.isParanoid()) {
            ScheduleUtils.paranoid(ScheduleUtils.getMsg("paranoid.scheduleutils.start_file", string3));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string3);
        for (int i2 = 1; i2 <= cache.getPageCountAndWait(reportCacheKey); ++i2) {
            fileOutputStream.write(cache.getPageAndWait(reportCacheKey, i2));
        }
        fileOutputStream.close();
        fileOutputStream = null;
        if (ScheduleUtils.isParanoid()) {
            ScheduleUtils.paranoid(ScheduleUtils.getMsg("paranoid.scheduleutils.finished_file", string3));
        }
        return string3;
    }

    static ArrayList<String> b(String string, ExecutedInstance executedInstance, String string2) throws Exception {
        Cache cache = Cache.getCache();
        ReportCacheKey reportCacheKey = executedInstance.XN();
        String string3 = string + ScheduleUtils.a(executedInstance, true, string2);
        new File(string3).getParentFile().mkdirs();
        if (ScheduleUtils.isParanoid()) {
            ScheduleUtils.paranoid(ScheduleUtils.getMsg("paranoid.scheduleutils.start_file", string3));
        }
        if (string2 == null) {
            string2 = "";
        }
        int n2 = cache.getPageCountAndWait(reportCacheKey);
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 1; i2 <= n2; ++i2) {
            string3 = string + ScheduleUtils.a(executedInstance, true, string2 + (i2 == 1 ? "" : (string2.isEmpty() ? "" + i2 : "_" + i2)));
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            fileOutputStream.write(cache.getPageAndWait(reportCacheKey, i2));
            fileOutputStream.close();
            arrayList.add(string3);
        }
        if (ScheduleUtils.isParanoid()) {
            ScheduleUtils.paranoid(ScheduleUtils.getMsg("paranoid.scheduleutils.finished_file", string3));
        }
        return arrayList;
    }

    private static ArrayList<String> c(String string, ExecutedInstance executedInstance, String string2) throws Exception {
        Cache cache = Cache.getCache();
        ReportCacheKey reportCacheKey = executedInstance.XN();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = executedInstance.XP().getReport().getScheduleName();
        if (string2 != null) {
            string3 = string3 + "_" + ScheduleUtils.fS(string2);
        }
        String string4 = string + (string.endsWith("/") ? "" : "/") + string3 + ".svg";
        new File(string4).getParentFile().mkdirs();
        if (ScheduleUtils.isParanoid()) {
            ScheduleUtils.paranoid(ScheduleUtils.getMsg("paranoid.scheduleutils.start_file", string4));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string4);
        fileOutputStream.write(SVGUtils.getSvgViewer());
        fileOutputStream.close();
        if (ScheduleUtils.isParanoid()) {
            ScheduleUtils.paranoid(ScheduleUtils.getMsg("paranoid.scheduleutils.finished_file", string4));
        }
        fileOutputStream = null;
        arrayList.add(string4);
        for (int i2 = 1; i2 <= cache.getPageCountAndWait(reportCacheKey); ++i2) {
            String string5 = string + (string.endsWith("/") ? "" : "/") + string3 + "/" + i2 + ".svg";
            new File(string5).getParentFile().mkdirs();
            if (ScheduleUtils.isParanoid()) {
                ScheduleUtils.paranoid(ScheduleUtils.getMsg("paranoid.scheduleutils.start_file", string5));
            }
            fileOutputStream = new FileOutputStream(string5);
            fileOutputStream.write(cache.getPageAndWait(reportCacheKey, i2));
            fileOutputStream.close();
            if (ScheduleUtils.isParanoid()) {
                ScheduleUtils.paranoid(ScheduleUtils.getMsg("paranoid.scheduleutils.finished_file", string5));
            }
            fileOutputStream = null;
            arrayList.add(string5);
        }
        return arrayList;
    }

    static ArrayList<String> d(String string, ExecutedInstance executedInstance, String string2) throws Exception {
        String string3 = ScheduleUtils.a(executedInstance, false, string2);
        Properties properties = new Properties();
        properties.put("export_fmt", "htm");
        properties.put("file", new File(string, string3 + ".html").getPath());
        c c2 = new c(properties, null, null, executedInstance);
        Throwable[] throwableArray = new Throwable[1];
        d d2 = new d(null, c2, properties, throwableArray);
        d2.run();
        if (throwableArray[0] != null) {
            if (throwableArray[0] instanceof Exception) {
                throw (Exception)throwableArray[0];
            }
            if (throwableArray[0] instanceof Error) {
                throw (Error)throwableArray[0];
            }
        }
        return d2.getFileNames();
    }

    static void fT(String string) {
        ScheduleUtils.deleteDirectory(new File(string));
    }

    private static void deleteDirectory(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                fileArray[i2].deleteOnExit();
                if (fileArray[i2].isDirectory()) {
                    ScheduleUtils.deleteDirectory(fileArray[i2]);
                    continue;
                }
                try {
                    if (!fileArray[i2].delete()) {
                        if (!ScheduleUtils.isDebug()) continue;
                        ScheduleUtils.debug(ScheduleUtils.getMsg("scheduleutils.could_not_delete_file", fileArray[i2].getAbsolutePath()));
                        continue;
                    }
                    if (!ScheduleUtils.isParanoid()) continue;
                    ScheduleUtils.paranoid(ScheduleUtils.getMsg("scheduleutils.temp_file_deleted", fileArray[i2].getAbsolutePath()));
                    continue;
                }
                catch (SecurityException securityException) {
                    if (!ScheduleUtils.isDebug()) continue;
                    ScheduleUtils.debug(securityException + " while deleting files");
                }
            }
        }
        if (!file.delete() && ScheduleUtils.isDebug()) {
            ScheduleUtils.debug(ScheduleUtils.getMsg("scheduleutils.could_not_delete_file", file.getAbsolutePath()));
        }
    }

    static boolean b(String string, File file) throws Exception {
        f f2 = new f(new FileOutputStream(file));
        boolean bl2 = ScheduleUtils.a(new File(string), f2, "");
        f2.close();
        f2 = null;
        return bl2;
    }

    private static boolean a(File file, f f2, String string) throws Exception {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            if (ScheduleUtils.isDebug()) {
                ScheduleUtils.debug(ScheduleUtils.getMsg("scheduleutils.no_files_in_directory_for_zip", file.getAbsolutePath()));
            }
            return false;
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileArray[i2].isDirectory()) {
                if (ScheduleUtils.a(fileArray[i2], f2, string + fileArray[i2].getName() + "/")) {
                    bl2 = true;
                }
            } else {
                FileInputStream fileInputStream = new FileInputStream(fileArray[i2]);
                com.inet.report.schedule.zip.c c2 = new com.inet.report.schedule.zip.c(string + fileArray[i2].getName());
                f2.a(c2);
                int n2 = 0;
                byte[] byArray = new byte[16384];
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    f2.write(byArray, 0, n2);
                }
                f2.closeEntry();
                fileInputStream.close();
                bl2 = true;
            }
            fileArray[i2] = null;
        }
        return bl2;
    }

    public static Properties getAllProperties(ScheduleAction scheduleAction) throws ScheduleException {
        try {
            Properties properties = new Properties();
            if (scheduleAction != null) {
                BeanInfo beanInfo = Introspector.getBeanInfo(scheduleAction.getClass());
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
                    String string = propertyDescriptorArray[i2].getName();
                    Method method = propertyDescriptorArray[i2].getReadMethod();
                    Method method2 = propertyDescriptorArray[i2].getWriteMethod();
                    if (method == null || method2 == null) continue;
                    Object object = method.invoke((Object)scheduleAction, (Object[])null);
                    if (object != null) {
                        String string2 = object.toString();
                        properties.setProperty(string.toLowerCase(), string2);
                        continue;
                    }
                    properties.setProperty(string.toLowerCase(), new String());
                }
            }
            return properties;
        }
        catch (Exception exception) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduleutils.bean.could_not_read_properties", scheduleAction.getClass().getName()), exception, "SE0039");
        }
    }

    public static Class getType(ScheduleAction scheduleAction, String string) throws ScheduleException {
        PropertyDescriptor propertyDescriptor = ScheduleUtils.a(scheduleAction, string);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getPropertyType();
        }
        return null;
    }

    public static Properties getProperties(ScheduleAction scheduleAction) throws ScheduleException {
        try {
            Properties properties = new Properties();
            if (scheduleAction != null) {
                BeanInfo beanInfo = Introspector.getBeanInfo(scheduleAction.getClass());
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
                    Object object;
                    String string = propertyDescriptorArray[i2].getName();
                    Method method = propertyDescriptorArray[i2].getReadMethod();
                    Method method2 = propertyDescriptorArray[i2].getWriteMethod();
                    if (method == null || method2 == null || (object = method.invoke((Object)scheduleAction, (Object[])null)) == null) continue;
                    String string2 = object.toString();
                    if (string == null || string2.length() <= 0 || string.length() <= 0) continue;
                    properties.setProperty(string.toLowerCase(), string2);
                }
            }
            return properties;
        }
        catch (Exception exception) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduleutils.bean.could_not_read_properties", scheduleAction.getClass().getName()), exception, "SE0040");
        }
    }

    public static Object getActionProperty(ScheduleAction scheduleAction, String string) throws ScheduleException {
        try {
            PropertyDescriptor propertyDescriptor = ScheduleUtils.a(scheduleAction, string);
            if (propertyDescriptor != null) {
                Method method = propertyDescriptor.getReadMethod();
                if (method != null) {
                    return method.invoke((Object)scheduleAction, (Object[])null);
                }
                return null;
            }
            return null;
        }
        catch (Exception exception) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduleutils.bean.could_not_read_property", string, scheduleAction.getClass().getName()), exception, "SE0037");
        }
    }

    public static String getActionPropertyValueDescription(String string, String string2, String string3) throws ScheduleException {
        PropertyDescriptor propertyDescriptor = ScheduleUtils.getActionPropertyDescriptor(string, string2);
        if (propertyDescriptor != null) {
            return (String)propertyDescriptor.getValue(string3);
        }
        return null;
    }

    public static void setActionProperties(ScheduleAction scheduleAction, Properties properties) throws ScheduleException {
        try {
            if (scheduleAction != null && properties != null) {
                BeanInfo beanInfo = Introspector.getBeanInfo(scheduleAction.getClass());
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                Enumeration<Object> enumeration = properties.keys();
                block2: while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
                        Object object;
                        if (!string.equalsIgnoreCase(propertyDescriptorArray[i2].getName())) continue;
                        Method method = propertyDescriptorArray[i2].getWriteMethod();
                        if (method == null || (object = a.ac(propertyDescriptorArray[i2].getPropertyType().getName(), properties.getProperty(string))) == null) continue block2;
                        method.invoke((Object)scheduleAction, object);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduleutils.bean.could_not_write_properties", scheduleAction.getClass().getName()), exception, "SE0041");
        }
    }

    public static void setActionProperty(ScheduleAction scheduleAction, String string, String string2) throws ScheduleException {
        if (scheduleAction != null) {
            try {
                Object object = a.ac(ScheduleUtils.getType(scheduleAction, string).getName(), string2);
                ScheduleUtils.a(scheduleAction, string, object);
            }
            catch (Exception exception) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduleutils.bean.could_not_write_property", string, scheduleAction.getClass().getName()), exception, "SE0043");
            }
        }
    }

    private static void a(ScheduleAction scheduleAction, String string, Object object) throws ScheduleException {
        Method method;
        PropertyDescriptor propertyDescriptor;
        if (object != null && (propertyDescriptor = ScheduleUtils.a(scheduleAction, string)) != null && (method = propertyDescriptor.getWriteMethod()) != null) {
            try {
                method.invoke((Object)scheduleAction, object);
            }
            catch (Exception exception) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduleutils.bean.could_not_write_property", string, scheduleAction.getClass().getName()), exception, "SE0042");
            }
        }
    }

    public static String getActionPropertyDisplayName(ScheduleAction scheduleAction, String string) throws ScheduleException {
        PropertyDescriptor propertyDescriptor = ScheduleUtils.a(scheduleAction, string);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getDisplayName();
        }
        return null;
    }

    public static String getActionPropertyShortDescription(ScheduleAction scheduleAction, String string) throws ScheduleException {
        PropertyDescriptor propertyDescriptor = ScheduleUtils.a(scheduleAction, string);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getShortDescription();
        }
        return null;
    }

    private static PropertyDescriptor a(ScheduleAction scheduleAction, String string) throws ScheduleException {
        return ScheduleUtils.b(scheduleAction.getClass(), string);
    }

    public static PropertyDescriptor getActionPropertyDescriptor(String string, String string2) throws ScheduleException {
        return ScheduleUtils.a(ScheduleUtils.classForName(string), string2);
    }

    private static PropertyDescriptor b(Class clazz, String string) throws ScheduleException {
        try {
            if (clazz != null) {
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
                    if (!string.equalsIgnoreCase(propertyDescriptorArray[i2].getName())) continue;
                    return propertyDescriptorArray[i2];
                }
            }
            return null;
        }
        catch (IntrospectionException introspectionException) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduleutils.bean.could_not_read_property", string, clazz.getName()), introspectionException, "SE0038");
        }
    }

    public static ScheduleAction classForName(String string) throws ScheduleException {
        Throwable throwable = null;
        try {
            return (ScheduleAction)BaseUtils.classForName(string).newInstance();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            if (string.equalsIgnoreCase("com.inet.report.schedule.EmailAction")) {
                throw new ScheduleException(ScheduleUtils.getMsg("ERR_Action_Email_Jar_Missing"), throwable, "SE0034");
            }
            if (string.equalsIgnoreCase("com.inet.report.schedule.PrintAction")) {
                throw new ScheduleException(ScheduleUtils.getMsg("ERR_Action_Viewer_Missing"), throwable, "SE0035");
            }
            throw new ScheduleException(ScheduleUtils.getMsg("scheduleutils.could_not_get_action_instance", string), throwable, "SE0036");
        }
    }

    private static String a(ExecutedInstance executedInstance, boolean bl2, String string) {
        ScheduleReport scheduleReport = executedInstance.XP().getReport();
        String string2 = scheduleReport.getScheduleName();
        Properties properties = executedInstance.getDynamicProperties();
        String string3 = ScheduleUtils.b(executedInstance);
        if (string3 == null || string3.trim().length() == 0 || string3.equals("java")) {
            string3 = "pdf";
        }
        if (properties != null) {
            Object[] objectArray = properties.values().toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (i2 != objectArray.length - 1) {
                    string2 = string2 + "_";
                }
                string2 = string2 + objectArray[i2];
            }
        }
        if (string != null && !string.isEmpty()) {
            string2 = string2 + "_" + string;
        }
        if (bl2) {
            return ScheduleUtils.fS(string2 + "." + ScheduleUtils.getExtensionByFormat(string3));
        }
        return string2;
    }

    public static String getExtensionByFormat(String string) {
        string.toLowerCase();
        if (string.equalsIgnoreCase("ps") || string.equalsIgnoreCase("ps2") || string.equalsIgnoreCase("ps3")) {
            return "ps";
        }
        if (string.equalsIgnoreCase("data")) {
            return "csv";
        }
        return string;
    }

    static String b(ExecutedInstance executedInstance) {
        ScheduleReport scheduleReport = executedInstance.XP().getReport();
        String string = scheduleReport.getProperties().getProperty("export_fmt", "");
        Properties properties = executedInstance.getProperties();
        if (properties != null && properties.containsKey("export_fmt")) {
            string = properties.getProperty("export_fmt");
        }
        return string.toLowerCase();
    }

    public static final Date parseDate(String string) {
        try {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
            try {
                return dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                dateFormat = DateFormat.getDateInstance(2);
                try {
                    return dateFormat.parse(string);
                }
                catch (ParseException parseException2) {
                    String[] stringArray = new String[]{"yyyy-MM-dd HH:mm:ss z", "M/d/yy h:mm a", "d. MMMM yyyy HH:mm:ss z", "dd.MM.yyyy", "MMM dd, yy h:mm a", "MMM dd, yy", "MMM. dd, yy h:mm a", "MMM. dd, yy h:mma", "MMM. dd, yy", "MMMM dd, yy", "dd-MMM-yyyy HH:mm:ss", "dd MMM yyyy HH:mm", "dd-MMM-yyyy HH:mm", "dd-MM-yyyy HH:mm", "dd-MM-yyyy", "dd-MMM-yyyy", "MM-dd-yyyy hh:mm:ss a", "MM-dd-yyyy HH:mm", "MM-dd-yyyy", "yyyy-MM-dd", "yyyy/M/dd HH:mm:ss", "MM/dd/yy HH:mm:ss", "MM/dd/yy HH:mm:ss", "MM/dd/yy HH:mm", "MM/dd/yy hh:mm a", "MM/dd/yy", "MM-yy", "HH:mm:ss", "HH:mm", "h:mm:ss a", "h:mm a", "hh:mm a", "E,MMM dd, yyyy", "d. MMMM yyyy", "yyyy.MM.dd", "yyyy/MM/dd", "yyyy/M/d", "dd MMM yy"};
                    ParsePosition parsePosition = new ParsePosition(0);
                    Date date = null;
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[i2]);
                        simpleDateFormat.setLenient(false);
                        date = simpleDateFormat.parse(string.trim(), parsePosition);
                        if (date != null) break;
                    }
                    if (date == null) {
                        throw new ArithmeticException(ScheduleUtils.getMsg("ERR_Task_date", string));
                    }
                    return date;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static Scheduler createNewScheduler() {
        return Scheduler.createNewScheduler();
    }

    static void Ya() {
        IX = StaticStreamLogger.getInstance("SCHEDULER");
        IX.setLogLevel(0);
        try {
            boolean bl2;
            boolean bl3 = bl2 = Scheduler.isLogEnabled() && ay.kE().isPlusVersion();
            if (bl2) {
                IX = BaseUtils.gj();
                if (IX != null) {
                    return;
                }
                IX.setLogLevel(Scheduler.getLogLevel());
                String string = Scheduler.getLogFile();
                if (string == null || string.length() == 0) {
                    IX.setLogStream(Engine.getLogStream());
                } else {
                    File file = new File(string);
                    file.getParentFile().mkdirs();
                    PrintStream printStream = new PrintStream(new FileOutputStream(file.getAbsolutePath(), clA));
                    IX.setLogStream(printStream);
                }
                IX.error("Was unable to get a logger object from Baseutils, now using Scheduler's own old logger.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getLogContent() {
        String string = null;
        String string2 = Scheduler.getLogFile();
        String string3 = dw.azD.get(ConfigKey.LOG_FILE.getKey());
        if (IX == null) {
            ScheduleUtils.Ya();
        }
        string = string2 == null || string2.trim().length() == 0 ? (string3 == null || string3.trim().length() == 0 ? "no scheduler or engine log file specified" : ScheduleUtils.getFileContent(string3)) : ScheduleUtils.getFileContent(string2);
        clA = true;
        ScheduleUtils.Ya();
        clA = false;
        return string;
    }

    private static final String getFileContent(String string) {
        StringBuffer stringBuffer;
        block3: {
            stringBuffer = new StringBuffer();
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append("<br>");
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                if (!ScheduleUtils.isDebug()) break block3;
                ScheduleUtils.debug(exception);
            }
        }
        return stringBuffer.toString();
    }

    public static void info(Object object) {
        if (IX != null) {
            IX.info(object);
        }
    }

    public static void error(Object object) {
        if (IX != null) {
            IX.error(object);
        }
    }

    public static void debug(Object object) {
        if (IX != null) {
            IX.debug(object);
        }
    }

    public static void warn(Object object) {
        if (IX != null) {
            IX.warn(object);
        }
    }

    public static void paranoid(Object object) {
        ScheduleUtils.debug(object);
    }

    public static boolean isDebug() {
        if (IX != null) {
            return IX.getLogLevel() >= 4;
        }
        return false;
    }

    public static boolean isWarn() {
        if (IX != null) {
            return IX.getLogLevel() >= 2;
        }
        return false;
    }

    public static boolean isError() {
        if (IX != null) {
            return IX.getLogLevel() >= 1;
        }
        return false;
    }

    public static boolean isInfo() {
        if (IX != null) {
            return IX.getLogLevel() >= 3;
        }
        return false;
    }

    public static boolean isParanoid() {
        if (IX != null) {
            return IX.getLogLevel() >= 4;
        }
        return false;
    }

    public static String encodeHTML(String string) {
        return v.encodeHTML(string);
    }

    public static String decodeHTML(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            char c2;
            int n4;
            char c3;
            if ((c3 = string.charAt(n3++)) == '&' && (n4 = n3) < n2 && (c2 = string.charAt(n4++)) == '#' && n4 < n2) {
                int n5;
                String string2;
                if ((c2 = string.charAt(n4++)) == 'x' || c2 == 'X') {
                    if (n4 < n2 && ScheduleUtils.O(c2 = string.charAt(n4++))) {
                        while (n4 < n2) {
                            if (ScheduleUtils.O(c2 = string.charAt(n4++))) continue;
                            if (c2 != ';') break;
                            string2 = string.substring(n3 + 2, n4 - 1);
                            try {
                                n5 = Integer.parseInt(string2, 16);
                                if (n5 >= 0 && n5 < 65536) {
                                    c3 = (char)n5;
                                    n3 = n4;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                    }
                } else if (ScheduleUtils.isDigit(c2)) {
                    while (n4 < n2) {
                        if (ScheduleUtils.isDigit(c2 = string.charAt(n4++))) continue;
                        if (c2 != ';') break;
                        string2 = string.substring(n3 + 1, n4 - 1);
                        try {
                            n5 = Integer.parseInt(string2);
                            if (n5 < 0 || n5 >= 65536) break;
                            c3 = (char)n5;
                            n3 = n4;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    private static boolean O(char c2) {
        return ScheduleUtils.P(c2) || ScheduleUtils.isDigit(c2);
    }

    private static boolean P(char c2) {
        return c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F';
    }

    private static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    public static boolean validatePassword(String string) {
        String string2 = Scheduler.getInstance().getPassword();
        if (string == null && string2 == null) {
            return true;
        }
        if (string != null) {
            return string.equals(BaseUtils.decrypt(string2));
        }
        return BaseUtils.decrypt(string2).equals(string);
    }

    public static boolean isFirstCall() {
        Scheduler.getInstance();
        return Scheduler.isFirstCall();
    }

    static void b(ExecutedTask executedTask) {
        Cache cache = Cache.getCache();
        for (int i2 = 0; i2 < executedTask.getReportCount(); ++i2) {
            ExecutedReport executedReport = executedTask.getReport(i2);
            for (int i3 = 0; i3 < executedReport.getInstanceCount(); ++i3) {
                Properties properties = executedReport.getInstance(i3).getProperties();
                try {
                    ReportCacheKey reportCacheKey = cache.createKey(properties);
                    if (!cache.exists(reportCacheKey)) continue;
                    if (cache.getType() == 1 || cache.getType() == 2) {
                        cache.setSchedule(reportCacheKey, false);
                        continue;
                    }
                    if (!ScheduleUtils.isWarn()) continue;
                    ScheduleUtils.warn(ScheduleUtils.getMsg("scheduleutils.cache.can_not_handle_schedule_flag", com.inet.report.cache.f.dj(cache.getType())));
                    continue;
                }
                catch (ReportException reportException) {
                    if (!ScheduleUtils.isWarn()) continue;
                    ScheduleUtils.warn(ScheduleUtils.getMsg("scheduleutils.cache.could_not_clear") + properties);
                    ScheduleUtils.warn(reportException);
                }
            }
        }
    }

    public static boolean patchProperties(Properties properties, int n2, String string, String string2) {
        switch (n2) {
            case 1: {
                if (!properties.containsKey("export_fmt") || properties.getProperty("export_fmt") == null || properties.getProperty("export_fmt").equals("") || properties.getProperty("export_fmt").equals("java")) {
                    properties.put("export_fmt", "pdf");
                    return true;
                }
                if (properties.getProperty("export_fmt").toLowerCase().equalsIgnoreCase("htm")) {
                    if (string2 == null) {
                        properties.put("export_fmt", "htm" + string);
                    } else {
                        properties.put("export_fmt", "htm" + string + "_" + string2);
                    }
                    return true;
                }
                if (properties.getProperty("export_fmt").toLowerCase().equalsIgnoreCase("html")) {
                    if (string2 == null) {
                        properties.put("export_fmt", "html" + string);
                    } else {
                        properties.put("export_fmt", "html" + string + "_" + string2);
                    }
                    return true;
                }
                return false;
            }
            case 3: {
                if (properties.containsKey("export_fmt") && !properties.get("export_fmt").equals("")) {
                    properties.put("export_fmt", "java");
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private static void a(ExecutedTask executedTask, Properties properties) {
        block4: {
            if (executedTask.o(properties)) {
                properties.remove(SCHEDULE_IN_PROCESS);
                Cache cache = Cache.getCache();
                try {
                    ReportCacheKey reportCacheKey = cache.createKey(properties);
                    if (!cache.exists(reportCacheKey)) {
                        properties.put(SCHEDULE_IN_PROCESS, "true");
                    }
                }
                catch (ReportException reportException) {
                    if (!ScheduleUtils.isDebug()) break block4;
                    ScheduleUtils.debug(reportException);
                }
            }
        }
    }

    static ReportCacheKey a(Properties properties, boolean bl2, ExecutedInstance executedInstance) throws ReportException {
        Object[] objectArray;
        Object object;
        Cache cache = Cache.getCache();
        dw.j(properties);
        String string = properties.getProperty("report");
        if (string.startsWith("file:")) {
            try {
                string = new File(string.substring(5)).toURI().toURL().toString();
                properties.put("report", string);
            }
            catch (MalformedURLException malformedURLException) {
                BaseUtils.error(malformedURLException);
            }
        }
        if (ScheduleUtils.isParanoid()) {
            ScheduleUtils.paranoid(ScheduleUtils.getMsg("scheduleutils.render_report"));
            object = (Properties)properties.clone();
            ScheduleUtils.paranoid("report:\t\t" + ((Properties)object).getProperty("report"));
            ((Properties)object).remove("report");
            objectArray = ((Properties)object).keySet().toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ScheduleUtils.paranoid((String)objectArray[i2] + ":\t\t" + ((Properties)object).get(objectArray[i2]));
            }
        }
        if (!bl2) {
            properties.put(SCHEDULE_IN_PROCESS, "true");
        }
        object = cache.getKey(properties, Scheduler.getInstance().getPropertiesChecker(), null);
        while (cache.exists((ReportCacheKey)object)) {
            block19: {
                try {
                    if (cache.isFinishWrittenToStore((ReportCacheKey)object)) {
                    }
                    break block19;
                }
                catch (KeyNotFoundException keyNotFoundException) {
                    ReportCacheKey reportCacheKey = ((ReportCacheKey)object).create(false);
                    if (!cache.isFinishWrittenToStore(reportCacheKey)) break block19;
                }
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                if (ScheduleUtils.isDebug()) {
                    ScheduleUtils.debug(ScheduleUtils.getMsg("scheduleutils.cancel_render"));
                }
                return null;
            }
        }
        try {
            objectArray = cache.getFailureCause((ReportCacheKey)object);
        }
        catch (ReportException reportException) {
            object = ((ReportCacheKey)object).create(false);
            objectArray = cache.getFailureCause((ReportCacheKey)object);
        }
        if (objectArray != null) {
            ReportException reportException = ReportExceptionFactory.createReportException(ErrorCode.failedReport, new Object[0]);
            reportException.initCause((Throwable)objectArray);
            throw reportException;
        }
        ScheduleTask.LastGeneratedReportInstance lastGeneratedReportInstance = new ScheduleTask.LastGeneratedReportInstance();
        List<ScheduleTask.LastGeneratedReportInstance> list = executedInstance.XP().XR().getTask().getLastReportInstances().get(executedInstance.XP().getReport().getScheduleName());
        if (list == null) {
            list = new CopyOnWriteArrayList<ScheduleTask.LastGeneratedReportInstance>();
            executedInstance.XP().XR().getTask().getLastReportInstances().put(executedInstance.XP().getReport().getScheduleName(), list);
        }
        list.add(lastGeneratedReportInstance);
        Properties properties2 = executedInstance.getDynamicProperties();
        if (properties2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            Object[] objectArray2 = properties2.values().toArray();
            for (int i3 = 0; i3 < objectArray2.length; ++i3) {
                stringBuilder.append(objectArray2[i3]);
                if (i3 >= objectArray2.length - 1) continue;
                stringBuilder.append("_");
            }
            lastGeneratedReportInstance.setNameSuffix(stringBuilder.toString());
        }
        return object;
    }

    static void a(ExecutedInstance executedInstance, int n2, String string) throws ReportException {
        Properties properties = executedInstance.getProperties();
        ScheduleUtils.patchProperties(properties, n2, executedInstance.XP().getReport().getScheduleName(), string);
        ScheduleUtils.a(executedInstance.XP().XR(), properties);
        executedInstance.x(ScheduleUtils.a(properties, true, executedInstance));
    }

    public static String getActionDisplayName(String string) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(BaseUtils.classForName(string));
            return beanInfo.getBeanDescriptor().getDisplayName();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (string.equals("com.inet.report.schedule.EmailAction")) {
                return ScheduleUtils.getMsg("emailactionbeaninfo.displayname");
            }
            if (string.equals("com.inet.report.schedule.PrintAction")) {
                return ScheduleUtils.getMsg("printactionbeaninfo.displayname");
            }
            if (string.equals("com.inet.report.schedule.FileAction")) {
                return ScheduleUtils.getMsg("fileactionbeaninfo.displayname");
            }
            if (string.equals("com.inet.report.schedule.ErrorAction")) {
                return ScheduleUtils.getMsg("erroractionbeaninfo.displayname");
            }
            if (string.equals("com.inet.report.schedule.FtpAction")) {
                return ScheduleUtils.getMsg("ftpactionbeaninfo.displayname");
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getActionShortDescription(ScheduleAction scheduleAction) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(scheduleAction.getClass());
            return beanInfo.getBeanDescriptor().getShortDescription();
        }
        catch (IntrospectionException introspectionException) {
            return "";
        }
    }

    public static boolean isSAXAvailable() {
        try {
            BaseUtils.classForName("org.xml.sax.SAXException");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static void removeCustomActionIgnoreCase(String string) throws ScheduleException {
        Scheduler.getInstance().removeCustomActionIgnoreCase(string);
    }

    public static void resetLastExecution(ScheduleTask scheduleTask) {
        scheduleTask.setLastRun(null);
    }

    public static int[] getSpecificValues(ScheduleExecution scheduleExecution, int n2) {
        return scheduleExecution.jn(n2);
    }

    public static int getStepSize(ScheduleExecution scheduleExecution, int n2) {
        return scheduleExecution.jm(n2);
    }

    public static String[] getAvailableActionClassNames(Scheduler scheduler) {
        return scheduler.Yf();
    }

    public static boolean containsDisabledAction(ScheduleTask scheduleTask) {
        Scheduler scheduler = Scheduler.getInstance();
        for (int i2 = 0; i2 < scheduleTask.getActionCount(); ++i2) {
            ScheduleAction scheduleAction = scheduleTask.getAction(i2);
            String string = scheduleAction.getClass().getName();
            if (scheduler.isActionEnabled(string)) continue;
            return true;
        }
        return false;
    }

    static ArrayList<String> a(ExecutedTask executedTask, String string, String string2) throws Exception {
        return ScheduleUtils.a(executedTask, string, string2, false);
    }

    static ArrayList<String> a(ExecutedTask executedTask, String string, String string2, boolean bl2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < executedTask.getReportCount(); ++i2) {
            ExecutedReport executedReport = executedTask.getReport(i2);
            String string3 = "";
            if (executedTask.getReportCount() > 1) {
                string3 = executedReport.getReport().getScheduleName() + "/";
            }
            for (int i3 = 0; i3 < executedReport.getInstanceCount(); ++i3) {
                ExecutedInstance executedInstance = executedReport.getInstance(i3);
                String string4 = ScheduleUtils.b(executedInstance);
                try {
                    ScheduleUtils.a(executedInstance, 1, string2);
                }
                catch (ReportException reportException) {
                    ScheduleUtils.a(executedTask, executedInstance, string4, reportException);
                }
                if (executedInstance.fP(string4)) continue;
                ArrayList<String> arrayList2 = null;
                if (string4.startsWith("htm")) {
                    arrayList2 = ScheduleUtils.d(string + string3, executedInstance, string2);
                } else if (string4.startsWith("svg")) {
                    arrayList2 = ScheduleUtils.c(string + string3, executedInstance, string2);
                } else if (string4.equals("bmp") || string4.equals("gif") || string4.equals("jpeg") || string4.equals("jpg") || string4.equals("png") || string4.equals("ps") || string4.equals("ps2") || string4.equals("ps3")) {
                    arrayList2 = ScheduleUtils.b(string + string3, executedInstance, string2);
                } else {
                    arrayList2 = new ArrayList();
                    arrayList2.add(ScheduleUtils.a(string, executedInstance, string2));
                }
                arrayList.addAll(arrayList2);
                if (!bl2) continue;
                List<ScheduleTask.LastGeneratedReportInstance> list = executedTask.getTask().getLastReportInstances().get(executedReport.getReport().getScheduleName());
                ScheduleTask.LastGeneratedReportInstance lastGeneratedReportInstance = null;
                for (ScheduleTask.LastGeneratedReportInstance lastGeneratedReportInstance2 : list) {
                    if (!lastGeneratedReportInstance2.getFiles().isEmpty()) continue;
                    lastGeneratedReportInstance = lastGeneratedReportInstance2;
                    break;
                }
                if (lastGeneratedReportInstance == null) continue;
                lastGeneratedReportInstance.setFiles(arrayList2);
            }
        }
        return arrayList;
    }

    static void a(ExecutedTask executedTask, ExecutedInstance executedInstance, String string, ReportException reportException) {
        executedInstance.fQ(string);
        if (ScheduleUtils.isWarn()) {
            ScheduleUtils.warn(ScheduleUtils.getMsg("scheduleutils.could_not_render_report") + executedInstance.getProperties());
            ScheduleUtils.warn(reportException);
        }
        String string2 = reportException.getMessage();
        if (reportException instanceof PromptRequestWarning) {
            string2 = string2 + ": " + ((PromptRequestWarning)reportException).getMissingPrompts();
        }
        executedTask.getTask().addExecutionError(null, string2);
    }

    static File getConfigFile(String string) {
        File file = null;
        try {
            file = new File(ClassLoader.getSystemResource(string).getFile());
            if (file.exists()) {
                return file;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            file = new File(BaseUtils.IZ.getResource(string).getFile());
            if (file.exists()) {
                return file;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            URL uRL = ClassLoader.getSystemResource("com/inet/report/Engine.class");
            if (uRL != null) {
                file = new File(new URL(uRL, string).getFile());
            }
            if (file.exists()) {
                return file;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            file = new File(new URL("file:" + System.getProperty("user.home") + "/" + string).getFile());
            if (file.exists()) {
                return file;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            file = new File(new URL("file://" + System.getProperty("user.home") + "/" + string).getFile());
            if (file.exists()) {
                return file;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            file = new File(new URL("file:" + System.getProperty("user.dir") + "/" + string).getFile());
            if (file.exists()) {
                return file;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            file = new File(new URL("file://" + System.getProperty("user.dir") + "/" + string).getFile());
            if (file.exists()) {
                return file;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Date[] getNextExecutions(ScheduleExecution scheduleExecution, int n2) {
        Date date;
        int n3 = scheduleExecution.getLoopCount();
        if (n3 >= 0) {
            n2 = Math.min(n3, n2);
        }
        ArrayList<Date> arrayList = new ArrayList<Date>(n2);
        Calendar calendar = Calendar.getInstance();
        for (int i2 = 0; i2 < n2 && (date = scheduleExecution.getNextExecutionTime(calendar)) != null; ++i2) {
            arrayList.add(date);
            calendar.setTime(date);
        }
        return arrayList.toArray(new Date[arrayList.size()]);
    }

    public static void patchSchedulerRightToSystemPermissions(SystemPermissions systemPermissions) {
        if (systemPermissions != null) {
            Set<PermissionHolder> set = systemPermissions.getHolder();
            block0: for (PermissionHolder permissionHolder : set) {
                Permission[] permissionArray;
                Permissions permissions = systemPermissions.getPermissions(permissionHolder);
                if (permissions == null) continue;
                int n2 = 0;
                for (Permission permission : permissionArray = PermissionGroup.REMOTE_MODULES.getPermissions()) {
                    String string = permissions.getPermission(permission);
                    if (!Boolean.valueOf(string).booleanValue()) continue;
                    ++n2;
                    if (permission == Permission.MODULE_SCHEDULER) continue block0;
                }
                if (n2 != permissionArray.length - 1) continue;
                permissions.setPermission(Permission.MODULE_SCHEDULER, Boolean.TRUE.toString());
            }
        }
    }
}

