/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.schedule;

import com.inet.lib.list.StringList;
import com.inet.report.BaseUtils;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ay;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationChangeEvent;
import com.inet.report.config.ConfigurationChangeListener;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.dw;
import com.inet.report.logging.g;
import com.inet.report.permissions.SystemPermissions;
import com.inet.report.permissions.p;
import com.inet.report.permissions.r;
import com.inet.report.schedule.DynamicProperties;
import com.inet.report.schedule.ExecutedInstance;
import com.inet.report.schedule.ExecutedReport;
import com.inet.report.schedule.ExecutedTask;
import com.inet.report.schedule.OneDayExecution;
import com.inet.report.schedule.ScheduleAction;
import com.inet.report.schedule.ScheduleException;
import com.inet.report.schedule.ScheduleReport;
import com.inet.report.schedule.ScheduleTask;
import com.inet.report.schedule.ScheduleUtils;
import com.inet.report.schedule.SchedulerPreferences;
import com.inet.report.schedule.e;
import com.inet.report.schedule.f;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.BackingStoreException;

public class Scheduler
implements ConfigurationChangeListener {
    private String password = "001AD4839EDC51F71F3166B9F40133003A13DDF08ED75CF60E286FAEE8A5D3F3C1";
    private static String clD = "001AD4839EDC51F71F3166B9F40133003A13DDF08ED75CF60E286FAEE8A5D3F3C1";
    private Timer timer = new Timer(true);
    private static Scheduler clE = null;
    private List<String> clF = new ArrayList<String>();
    private b clG = null;
    private Thread clH = null;
    private static int clI;
    public static final String PROPERTY_MAX_WORKER = "maxworker";
    public static final String PROPERTY_SMTP_PORT = "smtpport";
    public static final String PROPERTY_POP3_PORT = "pop3port";
    private ArrayList<ScheduleTask> clJ = new ArrayList();
    private ArrayList<DynamicPropertiesDefinition> clK = new ArrayList();
    private Hashtable<String, CustomActionDefinition> clL = new Hashtable();
    private Map<Integer, ScheduleTask> clM = new LinkedHashMap<Integer, ScheduleTask>();
    private File clN = null;
    private File clO = null;
    private String clP = "scheduler.xml";
    private String clQ = "scheduler.backup.xml";
    private String clR = "scheduler.xml.damaged";
    private String clS = "scheduler.backup.xml.damaged";
    private int clT;
    private String clU;
    private ThreadGroup clV = new ThreadGroup("i-net scheduler");
    private HashMap<ScheduleTask, TimerTask> clW = new HashMap();
    private List<c> clX = Collections.synchronizedList(new ArrayList());
    private Properties aEn = new Properties();
    @Deprecated
    private static int clY;
    @Deprecated
    private static String clZ;
    private static boolean cma;
    public static final int LOG_LEVEL_FATAL = 0;
    public static final int LOG_LEVEL_ERROR = 1;
    public static final int LOG_LEVEL_WARN = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_DEBUG = 4;
    public static final int LOG_LEVEL_PARANOID = 5;
    public static final String PROPERTY_SMTP_HOST = "smtphost";
    public static final String PROPERTY_POP3_HOST = "pop3host";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_SENDER = "sender";
    public static final String PROPERTY_PROPERTIES_CHECKER = "propertieschecker";
    private PropertiesChecker cmb = null;
    private boolean cmc;
    public static final String PROPERTY_EMAIL_AUTHENTICATION = "emailauth";
    public static final int AUTHENTICATION_NONE = 0;
    public static final int AUTHENTICATION_SMTP = 1;
    public static final int AUTHENTICATION_POP3 = 2;
    public static final int AUTHENTICATION_POP3_AND_SMTP = 3;

    private Scheduler() {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        configurationManager.addConfigurationChangeListener(this);
        Configuration configuration = configurationManager.getCurrent();
        this.clU = configuration.getName();
        this.clT = configuration.getScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ScheduleTask scheduleTask) {
        Map<Integer, ScheduleTask> map = this.clM;
        synchronized (map) {
            this.clM.put(scheduleTask.getId(), scheduleTask);
        }
    }

    public ScheduleTask addTask(String string) throws ScheduleException {
        if (string == null || string.trim().length() == 0) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduler.no_task_name"), "SE0001");
        }
        ScheduleTask scheduleTask = new ScheduleTask();
        scheduleTask.setName(string);
        this.a(scheduleTask);
        if (ScheduleUtils.isDebug()) {
            ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.add_task", string));
        }
        return scheduleTask;
    }

    private Integer fU(String string) {
        for (ScheduleTask scheduleTask : this.clM.values()) {
            if (!scheduleTask.getName().equals(string)) continue;
            return scheduleTask.getId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Integer n2) throws ScheduleException {
        if (n2 == null || n2 < 0) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduler.no_task_name"), "SE0003");
        }
        Map<Integer, ScheduleTask> map = this.clM;
        synchronized (map) {
            ScheduleTask scheduleTask = this.clM.remove(n2);
            if (scheduleTask == null) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.remove_non_existing_task", n2), "SE0004");
            }
            if (ScheduleUtils.isDebug()) {
                ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.remove_task", n2.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeTask(String string) throws ScheduleException {
        if (string == null || string.trim().length() == 0) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduler.no_task_name"), "SE0003");
        }
        Map<Integer, ScheduleTask> map = this.clM;
        synchronized (map) {
            ScheduleTask scheduleTask = this.clM.remove(this.fU(string));
            if (scheduleTask == null) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.remove_non_existing_task", string), "SE0004");
            }
            if (ScheduleUtils.isDebug()) {
                ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.remove_task", string));
            }
        }
    }

    public ScheduleTask[] list() {
        ScheduleTask[] scheduleTaskArray = new ScheduleTask[this.clM.size()];
        scheduleTaskArray = this.clM.values().toArray(scheduleTaskArray);
        return scheduleTaskArray;
    }

    public Collection<ScheduleTask> getTasks() {
        return new ArrayList<ScheduleTask>(this.clM.values());
    }

    public ScheduleTask getTask(String string) {
        if (string == null) {
            return null;
        }
        return this.clM.get(this.fU(string));
    }

    public ScheduleTask getTask(Integer n2) {
        if (n2 == null) {
            return null;
        }
        return this.clM.get(n2);
    }

    public void loadXML() {
        this.de(true);
    }

    private void de(boolean bl2) {
        File file;
        block39: {
            ScheduleUtils.Ya();
            this.clN = ScheduleUtils.getConfigFile(this.clP);
            this.Yb();
            SchedulerPreferences.loadTasks(this);
            file = this.clN;
            if (this.clN == null) {
                this.clO = ScheduleUtils.getConfigFile(this.clQ);
                if (this.clO == null) {
                    if (!bl2) {
                        return;
                    }
                    this.saveXML();
                    if (ScheduleUtils.isWarn()) {
                        ScheduleUtils.warn(ScheduleUtils.getMsg("scheduler.xml.config_created_new"));
                    }
                    try {
                        com.inet.report.schedule.a.a(this, this.clN);
                        file = this.clN;
                    }
                    catch (Throwable throwable) {
                        if (ScheduleUtils.isError()) {
                            ScheduleUtils.error(throwable);
                        }
                        break block39;
                    }
                }
                if (ScheduleUtils.isWarn()) {
                    ScheduleUtils.warn(ScheduleUtils.getMsg("scheduler.xml.use_backup", this.clP, this.clQ));
                }
                try {
                    com.inet.report.schedule.a.a(this, this.clO);
                    file = this.clO;
                    this.saveXML();
                }
                catch (Throwable throwable) {
                    if (ScheduleUtils.isError()) {
                        ScheduleUtils.error(throwable);
                    }
                    if (ScheduleUtils.isWarn()) {
                        ScheduleUtils.warn(ScheduleUtils.getMsg("scheduler.xml.bad_backup", this.clO.toString()));
                    }
                    this.b(this.clO, this.clS);
                    this.saveXML();
                    try {
                        com.inet.report.schedule.a.a(this, this.clN);
                        file = this.clN;
                        break block39;
                    }
                    catch (Throwable throwable2) {
                        if (ScheduleUtils.isError()) {
                            ScheduleUtils.error(throwable2);
                        }
                        break block39;
                    }
                }
            }
            try {
                com.inet.report.schedule.a.a(this, this.clN);
            }
            catch (Throwable throwable) {
                if (ScheduleUtils.isError()) {
                    ScheduleUtils.error(throwable);
                }
                if (ScheduleUtils.isWarn()) {
                    ScheduleUtils.warn(ScheduleUtils.getMsg("scheduler.xml.bad_config", this.clN.toString()));
                }
                this.b(this.clN, this.clR);
                this.clO = ScheduleUtils.getConfigFile(this.clQ);
                if (this.clO == null) {
                    this.saveXML();
                    if (ScheduleUtils.isWarn()) {
                        ScheduleUtils.warn(ScheduleUtils.getMsg("scheduler.xml.backup_created_new"));
                    }
                    try {
                        com.inet.report.schedule.a.a(this, this.clN);
                    }
                    catch (Throwable throwable3) {
                        if (ScheduleUtils.isError()) {
                            ScheduleUtils.error(throwable3);
                        }
                        break block39;
                    }
                }
                try {
                    com.inet.report.schedule.a.a(this, this.clO);
                    file = this.clO;
                    this.saveXML();
                }
                catch (Throwable throwable4) {
                    if (ScheduleUtils.isError()) {
                        ScheduleUtils.error(throwable4);
                    }
                    this.b(this.clO, this.clS);
                    this.saveXML();
                    if (ScheduleUtils.isWarn()) {
                        ScheduleUtils.warn(ScheduleUtils.getMsg("scheduler.xml.bad_backup", this.clO.toString()));
                    }
                    try {
                        com.inet.report.schedule.a.a(this, this.clN);
                    }
                    catch (Throwable throwable5) {
                        if (!ScheduleUtils.isError()) break block39;
                        ScheduleUtils.error(throwable5);
                    }
                }
            }
        }
        if (ScheduleUtils.isInfo()) {
            ScheduleUtils.info(ScheduleUtils.getMsg("scheduler.xml.current_config", file.toString()));
        }
        if (this.clN != null && this.clN.exists() || this.clO != null && this.clO.exists()) {
            if (SchedulerPreferences.isConfigAccessable()) {
                String[] stringArray;
                Object object;
                Object object2;
                SchedulerPreferences.saveTasks(this.clM.values());
                if (SchedulerPreferences.isConfigEmpty()) {
                    object2 = new ArrayList();
                    for (int i2 = 0; i2 < this.getCustomActionCount(); ++i2) {
                        object = this.getCustomAction(i2);
                        stringArray = new String[]{((CustomActionDefinition)object).getName(), ((CustomActionDefinition)object).getClassName(), ((CustomActionDefinition)object).getPath()};
                        ((ArrayList)object2).add(stringArray);
                    }
                    SchedulerPreferences.setEnabledActions(Arrays.asList(this.Yf()));
                    SchedulerPreferences.setRuntimeProperties(this.getScheduleRuntimeProperties());
                    SchedulerPreferences.setActivated(this.isStarted());
                    SchedulerPreferences.setCustomActionDefinitions((ArrayList<String[]>)object2);
                    SchedulerPreferences.flushPreferences();
                }
                this.r(this.clN);
                this.r(ScheduleUtils.getConfigFile(this.clQ));
                object2 = ConfigurationManager.getInstance();
                Configuration configuration = ((ConfigurationManager)object2).getCurrent();
                object = configuration.get(ConfigKey.SYSTEMPERMISSIONS.getKey(), ConfigKey.SYSTEMPERMISSIONS.getDefault());
                stringArray = r.ey((String)object);
                ScheduleUtils.patchSchedulerRightToSystemPermissions((SystemPermissions)stringArray);
                object = r.a((SystemPermissions)stringArray);
                configuration.put(ConfigKey.SYSTEMPERMISSIONS.getKey(), (String)object);
                try {
                    configuration.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    if (BaseUtils.gk()) {
                        BaseUtils.warning(backingStoreException);
                    }
                }
            } else {
                BaseUtils.error("Scheduler cannot write to System-Preferences and will not work properly now. Make sure Clear Reports can write the used configuration!");
            }
        }
    }

    private void Yb() {
        this.clF = SchedulerPreferences.getEnabledActions();
        this.setScheduleRuntimeProperties(SchedulerPreferences.getRuntimeProperties());
        if (!ay.kE().isPlusVersion() && this.isStarted() || !SchedulerPreferences.isActivated()) {
            this.stop();
        }
        if (ay.kE().isPlusVersion() && !this.isStarted() && SchedulerPreferences.isActivated()) {
            try {
                this.start();
            }
            catch (ScheduleException scheduleException) {
                ScheduleUtils.error(scheduleException);
            }
        }
        this.clL.clear();
        List<String[]> list = SchedulerPreferences.getCustomActionDefinitions();
        for (String[] stringArray : list) {
            if (stringArray.length <= 1) continue;
            this.ad(stringArray[0], stringArray[1]);
        }
    }

    private void b(File file, String string) {
        File file2 = new File(string);
        if (file2.exists()) {
            file2.delete();
        }
        if (file.renameTo(file2) && ScheduleUtils.isWarn()) {
            ScheduleUtils.warn(ScheduleUtils.getMsg("scheduler.xml.save_damaged", file.getName(), file2.getName()));
        }
    }

    private boolean r(File file) {
        if (file == null) {
            return true;
        }
        File file2 = new File(file.getAbsolutePath() + ".migrated");
        if (file2.exists()) {
            file2.delete();
        }
        if (!file.renameTo(file2)) {
            if (ScheduleUtils.isWarn()) {
                ScheduleUtils.warn(ScheduleUtils.getMsg("scheduler.xml.unable_to_rename_backup_failed", this.clN.getName()));
            }
            return false;
        }
        return true;
    }

    public boolean isActionEnabled(String string) {
        return this.clF.contains(string);
    }

    public boolean saveXML() {
        if (!SchedulerPreferences.isConfigAccessable()) {
            return false;
        }
        try {
            SchedulerPreferences.saveTasks(this.clM.values());
        }
        catch (Throwable throwable) {
            if (BaseUtils.isInfo()) {
                BaseUtils.info(throwable);
            }
            return false;
        }
        if (this.isStarted()) {
            this.clG.refresh();
        }
        SchedulerPreferences.flushPreferences();
        return true;
    }

    static boolean isFirstCall() {
        return ScheduleUtils.validatePassword(BaseUtils.decrypt(clD));
    }

    @Deprecated
    public void setPassword(String string) {
        this.password = BaseUtils.encrypt(string);
    }

    @Deprecated
    void fV(String string) {
        this.password = string;
    }

    int Yc() {
        String string = this.getScheduleRuntimeProperty(PROPERTY_MAX_WORKER);
        if (string == null) {
            return 5;
        }
        return new Integer(string);
    }

    @Deprecated
    public void addDynamicPropertiesClass(String string, String string2) throws ScheduleException {
        this.clK.add(new DynamicPropertiesDefinition(string, string2));
    }

    @Deprecated
    public void addDynamicPropertiesClass(String string) throws ScheduleException {
        this.clK.add(new DynamicPropertiesDefinition(string));
    }

    @Deprecated
    public int getDynamicPropertiesClassCount() {
        return this.clK.size();
    }

    @Deprecated
    public DynamicPropertiesDefinition getDynamicPropertiesClass(int n2) {
        return this.clK.get(n2);
    }

    @Deprecated
    public DynamicPropertiesDefinition getDynamicPropertiesClass(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        for (int i2 = 0; i2 < this.getDynamicPropertiesClassCount(); ++i2) {
            DynamicPropertiesDefinition dynamicPropertiesDefinition = this.getDynamicPropertiesClass(i2);
            if (!dynamicPropertiesDefinition.getClassName().equals(string)) continue;
            return dynamicPropertiesDefinition;
        }
        return null;
    }

    @Deprecated
    public void removeDynamicPropertiesClass(String string) throws ScheduleException {
        ScheduleTask[] scheduleTaskArray;
        DynamicPropertiesDefinition dynamicPropertiesDefinition = this.getDynamicPropertiesClass(string);
        if (dynamicPropertiesDefinition == null) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduler.dynamic_properties_not_found", string), "SE0005");
        }
        for (ScheduleTask scheduleTask : scheduleTaskArray = this.list()) {
            for (int i2 = 0; i2 < scheduleTask.getReportCount(); ++i2) {
                String string2 = scheduleTask.getReport(i2).getDynamicPropertiesClass();
                if (string2 == null || !dynamicPropertiesDefinition.getClassName().equals(string2)) continue;
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.dynamic_properties_remove_used", string), "SE0006");
            }
        }
        for (int i3 = 0; i3 < this.getDynamicPropertiesClassCount(); ++i3) {
            if (this.getDynamicPropertiesClass(i3) != dynamicPropertiesDefinition) continue;
            this.clK.remove(i3);
            return;
        }
    }

    public void addCustomAction(String string, String string2, String string3) throws ScheduleException {
        if (string == null || string.trim().length() == 0) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduler.no_custom_action_name"), "SE0008");
        }
        CustomActionDefinition customActionDefinition = this.clL.get(string);
        if (customActionDefinition != null) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduler.add_custom_action_exists", customActionDefinition.name, customActionDefinition.className, customActionDefinition.path), "SE0009");
        }
        customActionDefinition = new CustomActionDefinition(string2, string, string3);
        this.clL.put(string, customActionDefinition);
        if (ScheduleUtils.isDebug()) {
            ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.add_custom_action", string, string2, string3));
        }
    }

    CustomActionDefinition ad(String string, String string2) {
        CustomActionDefinition customActionDefinition = new CustomActionDefinition();
        customActionDefinition.name = string;
        customActionDefinition.className = string2;
        this.clL.put(string, customActionDefinition);
        if (ScheduleUtils.isDebug()) {
            ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.add_custom_action", string, string2, "classpath"));
        }
        return customActionDefinition;
    }

    public int getCustomActionCount() {
        return this.clL.size();
    }

    public CustomActionDefinition getCustomAction(int n2) {
        if (!this.clL.isEmpty()) {
            String string = (String)this.clL.keySet().toArray()[n2];
            return this.clL.get(string);
        }
        return null;
    }

    public void start() throws ScheduleException {
        if (this.isStarted()) {
            return;
        }
        this.cmc = true;
        dw.sw();
        if (!ay.kE().isPlusVersion()) {
            throw new ScheduleException(ScheduleUtils.getMsg("plusLicenseRequired"), "SE0013");
        }
        ScheduleUtils.Ya();
        if (ScheduleUtils.isInfo()) {
            ScheduleUtils.info(ScheduleUtils.getMsg("scheduler.starting"));
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        Thread thread = new Thread((Runnable)new e(this), "i-net scheduler (check started)");
        thread.setDaemon(true);
        thread.setPriority(5);
        thread.start();
        this.Yd();
        this.Ye();
        this.cmc = false;
    }

    public boolean isStarted() {
        if (this.cmc) {
            return true;
        }
        return this.clG != null && this.clG.isAlive() && this.clH != null && this.clH.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        c c2;
        if (!this.isStarted()) {
            return;
        }
        if (ScheduleUtils.isInfo()) {
            ScheduleUtils.info(ScheduleUtils.getMsg("scheduler.stopping"));
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        BaseUtils.a(this.clG);
        BaseUtils.a(this.clH);
        do {
            List<c> list = this.clX;
            synchronized (list) {
                c2 = this.clX.size() > 0 ? this.clX.remove(0) : null;
                BaseUtils.a(c2);
            }
        } while (c2 != null);
        this.clJ.clear();
        if (ScheduleUtils.isInfo()) {
            ScheduleUtils.info(ScheduleUtils.getMsg("scheduler.stopped"));
        }
    }

    private void Yd() {
        this.clG = new b();
        this.clG.setDaemon(true);
        this.clG.setPriority(5);
        this.clG.start();
    }

    private void Ye() {
        this.clH = new Thread(this.clV, new f(this), "i-net scheduler (update execute)");
        this.clH.setDaemon(true);
        this.clH.setPriority(5);
        this.clH.start();
    }

    void b(ScheduleTask scheduleTask) {
        scheduleTask.XZ();
        scheduleTask.getLastReportInstances().clear();
        ExecutedTask executedTask = new ExecutedTask(scheduleTask);
        for (int i2 = 0; i2 < scheduleTask.getReportCount(); ++i2) {
            Object object;
            String string;
            ScheduleReport scheduleReport = scheduleTask.getReport(i2);
            String string2 = scheduleReport.getScheduleName();
            if (ScheduleUtils.isDebug()) {
                ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.start_check_if_report_valid", string2));
            }
            boolean bl2 = scheduleReport.isValid();
            if (ScheduleUtils.isDebug()) {
                ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.finished_check_if_report_valid", string2, Boolean.toString(bl2)));
            }
            if (!bl2) {
                string = scheduleReport.getErrorMessages();
                object = new StringBuffer();
                for (Object object2 : string) {
                    ((StringBuffer)object).append((String)object2);
                }
                String string3 = ((StringBuffer)object).toString();
                scheduleTask.addExecutionError(null, string3);
                ScheduleUtils.warn(ScheduleUtils.getMsg("scheduler.dont_execute_invalid_report", string2, scheduleTask.getName(), string3));
                continue;
            }
            string = executedTask.a(scheduleReport);
            if (scheduleReport.isDynamic()) {
                object = scheduleReport.getDynamicPropertiesClassInstance();
                if (object == null) {
                    ScheduleException scheduleException = new ScheduleException(ScheduleUtils.getMsg("scheduler.dynamic_class_not_found", scheduleReport.getDynamicPropertiesClass(), scheduleTask.getName()), "SE0007");
                    ((ExecutedReport)((Object)string)).setException(scheduleException);
                    if (ScheduleUtils.isWarn()) {
                        ScheduleUtils.warn(scheduleException.getMessage());
                    }
                    scheduleTask.addExecutionError(null, scheduleException.getMessage());
                    continue;
                }
                object.start();
                boolean bl3 = false;
                while (object.next()) {
                    bl3 = true;
                    Properties properties = scheduleReport.getProperties();
                    Properties properties2 = object.getProperties();
                    if (properties2 != null) {
                        properties.putAll((Map<?, ?>)properties2);
                    }
                    ((ExecutedReport)((Object)string)).n(properties2);
                }
                if (!bl3 && BaseUtils.gk()) {
                    BaseUtils.warning(ScheduleUtils.getMsg("scheduler.dynamic.zeroProperties", object.getClass().getName()));
                }
                object.finish();
                continue;
            }
            ((ExecutedReport)((Object)string)).XQ();
        }
        this.a(scheduleTask, executedTask);
        ScheduleUtils.b(executedTask);
    }

    private void a(ScheduleTask scheduleTask, ExecutedTask executedTask) {
        for (int i2 = 0; i2 < scheduleTask.getActionCount(); ++i2) {
            ScheduleAction scheduleAction = scheduleTask.getAction(i2);
            if (ScheduleUtils.isInfo()) {
                ScheduleUtils.info(ScheduleUtils.getMsg("scheduler.start_action", ScheduleUtils.getActionName(scheduleAction), scheduleTask.getName()));
            }
            scheduleAction.action(executedTask);
            if (!ScheduleUtils.isInfo()) continue;
            ScheduleUtils.info(ScheduleUtils.getMsg("scheduler.finished_action", ScheduleUtils.getActionName(scheduleAction), scheduleTask.getName()));
        }
        Scheduler.b(executedTask);
    }

    private static void b(ExecutedTask executedTask) {
        Cache cache = Cache.getCache();
        if (cache.getType() == 1 || cache.getType() == 2) {
            for (int i2 = 0; i2 < executedTask.getReportCount(); ++i2) {
                ExecutedReport executedReport = executedTask.getReport(i2);
                for (int i3 = 0; i3 < executedReport.getInstanceCount(); ++i3) {
                    ExecutedInstance executedInstance = executedReport.getInstance(i3);
                    ReportCacheKey reportCacheKey = executedInstance.XN();
                    try {
                        cache.setSchedule(reportCacheKey, false);
                        continue;
                    }
                    catch (ReportException reportException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Deprecated
    String getPassword() {
        return this.password;
    }

    public static synchronized Scheduler getInstance() {
        if (clE == null) {
            clE = new Scheduler();
            clE.de(false);
        }
        return clE;
    }

    void a(ScheduleTask scheduleTask, TimerTask timerTask) {
        this.clW.put(scheduleTask, timerTask);
    }

    void c(ScheduleTask scheduleTask) {
        TimerTask timerTask = this.clW.remove(scheduleTask);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    String[] Yf() {
        String[] stringArray = new String[4 + this.getCustomActionCount()];
        stringArray[0] = "com.inet.report.schedule.FileAction";
        stringArray[1] = "com.inet.report.schedule.EmailAction";
        stringArray[2] = "com.inet.report.schedule.PrintAction";
        stringArray[3] = "com.inet.report.schedule.FtpAction";
        for (int i2 = 0; i2 < this.getCustomActionCount(); ++i2) {
            stringArray[4 + i2] = this.getCustomAction(i2).getClassName();
        }
        return stringArray;
    }

    public void resetPassword() {
        this.password = clD;
    }

    static Scheduler createNewScheduler() {
        if (clE != null) {
            ConfigurationManager.getInstance().removeConfigurationChangeListener(clE);
            clE.stop();
        }
        clE = null;
        return Scheduler.getInstance();
    }

    public void setScheduleRuntimeProperty(String string, String string2) {
        this.aEn.put(string, string2);
    }

    public void setScheduleRuntimeProperties(Properties properties) {
        this.aEn.putAll((Map<?, ?>)properties);
    }

    public String getScheduleRuntimeProperty(String string) {
        return this.aEn.getProperty(string);
    }

    public Properties getScheduleRuntimeProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.aEn);
        return properties;
    }

    public static boolean isLogEnabled() {
        return cma;
    }

    @Deprecated
    public static String getLogFile() {
        return clZ;
    }

    @Deprecated
    public static void setLogFile(String string) {
        clZ = string;
    }

    @Deprecated
    public static int getLogLevel() {
        return clY;
    }

    @Deprecated
    public static void setLogLevel(int n2) {
        if (n2 < 0 || n2 > 5) {
            return;
        }
        clY = n2;
    }

    public static void setLogEnabled(boolean bl2) {
        cma = bl2;
    }

    public void resetScheduler() {
        if (this.isStarted()) {
            this.stop();
        }
        boolean bl2 = true;
        this.clN = ScheduleUtils.getConfigFile(this.clP);
        this.clO = ScheduleUtils.getConfigFile(this.clQ);
        while (bl2 && this.clN != null) {
            bl2 = this.clN.delete();
            this.clN = ScheduleUtils.getConfigFile(this.clP);
        }
        while (bl2 && this.clO != null) {
            bl2 = this.clO.delete();
            this.clO = ScheduleUtils.getConfigFile(this.clQ);
        }
        this.aEn = com.inet.report.schedule.a.XV();
        cma = true;
        clZ = "";
        clY = 3;
        SchedulerPreferences.reset();
        if (bl2) {
            clE = Scheduler.createNewScheduler();
        } else {
            this.clK.clear();
            this.clL.clear();
            this.clM.clear();
            this.clJ.clear();
            this.aEn = com.inet.report.schedule.a.XV();
            cma = true;
            clZ = "";
            clY = 3;
            this.password = "001AD4839EDC51F71F3166B9F40133003A13DDF08ED75CF60E286FAEE8A5D3F3C1";
            clD = "001AD4839EDC51F71F3166B9F40133003A13DDF08ED75CF60E286FAEE8A5D3F3C1";
            this.saveXML();
        }
    }

    public CustomActionDefinition getCustomAction(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        for (int i2 = 0; i2 < this.getCustomActionCount(); ++i2) {
            CustomActionDefinition customActionDefinition = this.getCustomAction(i2);
            if (!customActionDefinition.getName().equalsIgnoreCase(string)) continue;
            return customActionDefinition;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomAction(String string) throws ScheduleException {
        if (string == null || string.trim().length() == 0) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduler.no_custom_action_name"), "SE0010");
        }
        CustomActionDefinition customActionDefinition = this.getCustomAction(string);
        if (customActionDefinition == null) {
            throw new ScheduleException(ScheduleUtils.getMsg("scheduler.remove_custom_action_non_existing", string), "SE0011");
        }
        Map<Integer, ScheduleTask> map = this.clM;
        synchronized (map) {
            Iterator<ScheduleTask> iterator = this.clM.values().iterator();
            StringList stringList = new StringList();
            block3: while (iterator.hasNext()) {
                ScheduleTask scheduleTask = iterator.next();
                for (int i2 = 0; i2 < scheduleTask.getActionCount(); ++i2) {
                    if (!scheduleTask.getAction(i2).getClass().getName().equals(customActionDefinition.getClassName())) continue;
                    stringList.addElement(scheduleTask.getName());
                    continue block3;
                }
            }
            if (stringList.size() > 0) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.remove_custom_action_in_use", string, stringList.toString()), "SE0012");
            }
        }
        this.clL.remove(string);
        if (ScheduleUtils.isDebug()) {
            ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.remove_custom_action", customActionDefinition.getName(), customActionDefinition.getClassName(), customActionDefinition.getPath()));
        }
    }

    void removeCustomActionIgnoreCase(String string) throws ScheduleException {
        for (int i2 = 0; i2 < this.getCustomActionCount(); ++i2) {
            CustomActionDefinition customActionDefinition = this.getCustomAction(i2);
            if (!string.equalsIgnoreCase(customActionDefinition.getClassName())) continue;
            this.removeCustomAction(customActionDefinition.getName());
            return;
        }
    }

    static String Yg() {
        return Scheduler.getInstance().getScheduleRuntimeProperty(PROPERTY_PROPERTIES_CHECKER);
    }

    public void setPropertiesChecker(PropertiesChecker propertiesChecker) {
        this.cmb = propertiesChecker;
        if (propertiesChecker == null) {
            if (ScheduleUtils.isDebug()) {
                ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.propertieschecker.set_class", "null"));
            }
        } else if (ScheduleUtils.isDebug()) {
            ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.propertieschecker.set_class", propertiesChecker.getClass().getName()));
        }
    }

    public PropertiesChecker getPropertiesChecker() {
        if (this.cmb != null) {
            if (ScheduleUtils.isDebug()) {
                ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.propertieschecker.use_class", this.cmb.getClass().getName()));
            }
            return this.cmb;
        }
        String string = Scheduler.Yg();
        if (string == null || string.trim().length() == 0) {
            if (ScheduleUtils.isDebug()) {
                ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.propertieschecker.use_class", "null"));
            }
            return null;
        }
        try {
            Class clazz = BaseUtils.classForName(string);
            if (!PropertiesChecker.class.isAssignableFrom(clazz)) {
                if (ScheduleUtils.isError()) {
                    ScheduleUtils.error(ScheduleUtils.getMsg("scheduler.propertieschecker.no_propertieschecker"));
                }
                if (ScheduleUtils.isDebug()) {
                    ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.propertieschecker.use_class", "null"));
                }
                return null;
            }
            if ((clazz.getModifiers() & 0x400) == 1024) {
                if (ScheduleUtils.isError()) {
                    ScheduleUtils.error(ScheduleUtils.getMsg("scheduler.propertieschecker.abstract", string));
                }
                if (ScheduleUtils.isDebug()) {
                    ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.propertieschecker.use_class", "null"));
                }
                return null;
            }
            this.cmb = (PropertiesChecker)clazz.newInstance();
            if (ScheduleUtils.isDebug()) {
                ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.propertieschecker.use_class", this.cmb.getClass().getName()));
            }
            return this.cmb;
        }
        catch (Exception exception) {
            if (ScheduleUtils.isError()) {
                ScheduleUtils.error(ScheduleUtils.getMsg("scheduler.propertieschecker.could_not_create_instance", string));
            }
            if (ScheduleUtils.isError()) {
                ScheduleUtils.error(exception);
            }
            if (ScheduleUtils.isDebug()) {
                ScheduleUtils.debug(ScheduleUtils.getMsg("scheduler.propertieschecker.use_class", "null"));
            }
            return null;
        }
    }

    static int Yh() {
        String string = Scheduler.getInstance().getScheduleRuntimeProperty(PROPERTY_EMAIL_AUTHENTICATION);
        if (string == null || string.trim().length() == 0) {
            if (ScheduleUtils.isWarn()) {
                ScheduleUtils.warn(ScheduleUtils.getMsg("scheduler.get_invalid_auth_mode", "null or empty"));
            }
            return 1;
        }
        try {
            int n2 = Integer.valueOf(string);
            switch (n2) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return n2;
                }
            }
            if (ScheduleUtils.isWarn()) {
                ScheduleUtils.warn(ScheduleUtils.getMsg("scheduler.get_invalid_auth_mode", string));
            }
            return 1;
        }
        catch (NumberFormatException numberFormatException) {
            if (ScheduleUtils.isWarn()) {
                ScheduleUtils.warn(ScheduleUtils.getMsg("scheduler.get_invalid_auth_mode", string));
            }
            return 1;
        }
    }

    public List<String> getEnabledActionClassNames() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(6);
        for (String string : stringArray = this.Yf()) {
            if (!this.isActionEnabled(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public CustomActionDefinition getCustomActionByClassName(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        for (int i2 = 0; i2 < this.getCustomActionCount(); ++i2) {
            CustomActionDefinition customActionDefinition = this.getCustomAction(i2);
            if (!customActionDefinition.getClassName().equalsIgnoreCase(string)) continue;
            return customActionDefinition;
        }
        return null;
    }

    public void setEnabledActions(List<String> list) {
        this.clF = list;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent configurationChangeEvent) {
        if (!(configurationChangeEvent.getType() != 0 || configurationChangeEvent.getChangedConfigurationName().equals(this.clU) && configurationChangeEvent.getChangedConfigurationScope() == this.clT || this.clU == null)) {
            this.clU = configurationChangeEvent.getChangedConfigurationName();
            this.clT = configurationChangeEvent.getChangedConfigurationScope();
            Scheduler.createNewScheduler();
            return;
        }
        if (!configurationChangeEvent.isCurrentConfiguration()) {
            return;
        }
        this.Yb();
    }

    static {
        clY = 3;
        clZ = "";
        cma = true;
    }

    class c
    extends Thread
    implements p {
        private ScheduleTask ckc;

        public c(ScheduleTask scheduleTask) {
            super(Scheduler.this.clV, "i-net scheduler task(\"" + scheduleTask.getName() + "\")");
            this.ckc = scheduleTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            g.D("Sh", clI++);
            if (ScheduleUtils.containsDisabledAction(this.ckc)) {
                this.ckc.XZ();
                this.ckc.addExecutionError(null, ScheduleUtils.getMsg("scheduler.task_contains_disabled"));
                this.ckc.setStatus(4);
                return;
            }
            try {
                Scheduler.this.clX.add(this);
                Date date = new Date();
                int n2 = this.ckc.getExecutionTime().getLoopCount();
                if (n2 > 0 && !this.ckc.isManualExecution()) {
                    this.ckc.getExecutionTime().setLoopCount(n2 - 1);
                }
                Scheduler.this.b(this.ckc);
                this.ckc.setLastRun(date);
                this.ckc.p(date);
            }
            catch (Throwable throwable) {
                if (ScheduleUtils.isError()) {
                    ScheduleUtils.error("Error during execution of task");
                    ScheduleUtils.error(throwable);
                }
            }
            finally {
                block16: {
                    Scheduler.this.clX.remove(this);
                    Scheduler.this.clJ.remove(this.ckc);
                    if (this.ckc.isDeleteIfExpired() && !this.ckc.isManualExecution() && this.ckc.getExecutionErrors().length < 2 && (this.ckc.getExecutionTime() instanceof OneDayExecution || this.ckc.getNextStart() == null)) {
                        try {
                            Scheduler.this.removeTask(this.ckc.getName());
                        }
                        catch (ScheduleException scheduleException) {
                            if (!ScheduleUtils.isWarn()) break block16;
                            ScheduleUtils.warn(scheduleException.getMessage());
                        }
                    }
                }
                SchedulerPreferences.saveTaskAfterExecution(this.ckc);
                this.ckc.setStatus(4);
            }
        }
    }

    class a
    extends TimerTask {
        private ScheduleTask ckc;

        a(ScheduleTask scheduleTask) {
            this.ckc = scheduleTask;
            Scheduler.this.a(scheduleTask, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Scheduler.this.c(this.ckc);
            ArrayList arrayList = Scheduler.this.clJ;
            synchronized (arrayList) {
                if (Scheduler.this.clJ.size() >= Scheduler.this.Yc()) {
                    if (ScheduleUtils.isInfo()) {
                        ScheduleUtils.info(ScheduleUtils.getMsg("scheduler.task_queued", this.ckc.getName()));
                    }
                    this.ckc.setStatus(2);
                } else {
                    this.ckc.setStatus(1);
                    Scheduler.this.clJ.add(this.ckc);
                    c c2 = new c(this.ckc);
                    c2.setPriority(5);
                    c2.start();
                }
            }
        }
    }

    class b
    extends Thread {
        private boolean isRefresh;

        b() {
            super(Scheduler.this.clV, "i-net scheduler (update tasks)");
            this.isRefresh = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            g.setID("ShUpdt");
            if (ScheduleUtils.isInfo()) {
                ScheduleUtils.info(ScheduleUtils.getMsg("scheduler.start_update_scheduled"));
            }
            while (true) {
                Map map = Scheduler.this.clM;
                synchronized (map) {
                    for (Object object : Scheduler.this.clM.values()) {
                        if (!((ScheduleTask)object).isEnabled()) continue;
                        switch (((ScheduleTask)object).getStatus()) {
                            case 2: {
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 3: {
                                break;
                            }
                            case 4: {
                                Date date = ((ScheduleTask)object).getNextStart();
                                if (date == null) break;
                                if (ScheduleUtils.isInfo()) {
                                    ScheduleUtils.info(ScheduleUtils.getMsg("scheduler.scheduled_task", ((ScheduleTask)object).getName(), DateFormat.getDateTimeInstance().format(date)));
                                }
                                Scheduler.this.timer.schedule((TimerTask)new a((ScheduleTask)object), date);
                                ((ScheduleTask)object).setStatus(3);
                            }
                        }
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    if (this.isRefresh) {
                        if (ScheduleUtils.isInfo()) {
                            ScheduleUtils.info(ScheduleUtils.getMsg("scheduler.refresh_tasks"));
                        }
                        ScheduleTask[] scheduleTaskArray = Scheduler.this.list();
                        for (ScheduleTask scheduleTask : scheduleTaskArray) {
                            Scheduler.this.c(scheduleTask);
                        }
                        Scheduler.this.timer.cancel();
                        Scheduler.this.clW.clear();
                        Scheduler.this.timer = new Timer(true);
                        this.isRefresh = false;
                        for (ScheduleTask scheduleTask : Scheduler.this.clM.values()) {
                            if (scheduleTask.getStatus() == 1) continue;
                            scheduleTask.setStatus(4);
                        }
                    } else if (ScheduleUtils.isInfo()) {
                        ScheduleUtils.info(ScheduleUtils.getMsg("scheduler.stop_update_scheduled"));
                    }
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() {
            this.isRefresh = true;
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                if (ScheduleUtils.isError()) {
                    ScheduleUtils.error(ScheduleUtils.getMsg("scheduler.refresh_tasks_error"));
                }
            }
            finally {
                Scheduler.this.Yd();
            }
        }
    }

    @Deprecated
    public class DynamicPropertiesDefinition {
        private String className;
        private String path;

        DynamicPropertiesDefinition(String string) throws ScheduleException {
            this.initClass(string);
        }

        DynamicPropertiesDefinition(String string, String string2) throws ScheduleException {
            this.setClassAndPath(string, string2);
        }

        public String getPath() {
            return this.path;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassAndPath(String string, String string2) throws ScheduleException {
            for (int i2 = 0; i2 < Scheduler.this.getDynamicPropertiesClassCount(); ++i2) {
                DynamicPropertiesDefinition dynamicPropertiesDefinition = Scheduler.this.getDynamicPropertiesClass(i2);
                if (dynamicPropertiesDefinition == this || !dynamicPropertiesDefinition.getClassName().equals(string)) continue;
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.dynamic_properties_class_already_registred"), "SE0020");
            }
            Class clazz = null;
            try {
                ScheduleUtils.addClassPathEntry(string2);
                clazz = BaseUtils.classForName(string);
            }
            catch (Exception exception) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.dynamic_properties_class_not_found"), "SE0021");
            }
            if (!DynamicProperties.class.isAssignableFrom(clazz)) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.dynamic_properties_class_not_implements", string), "SE0022");
            }
            if ((clazz.getModifiers() & 0x400) != 0) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.dynamic_properties_class_abstract", string), "SE0023");
            }
            this.className = string;
            this.path = string2;
        }

        public void initClass(String string) throws ScheduleException {
            for (int i2 = 0; i2 < Scheduler.this.getDynamicPropertiesClassCount(); ++i2) {
                DynamicPropertiesDefinition dynamicPropertiesDefinition = Scheduler.this.getDynamicPropertiesClass(i2);
                if (dynamicPropertiesDefinition == this || !dynamicPropertiesDefinition.getClassName().equals(string)) continue;
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.dynamic_properties_class_already_registred"), "SE0020");
            }
            Class clazz = null;
            try {
                clazz = BaseUtils.classForName(string);
            }
            catch (Exception exception) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.dynamic_properties_class_not_found"), "SE0021");
            }
            if (!DynamicProperties.class.isAssignableFrom(clazz)) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.dynamic_properties_class_not_implements", string), "SE0022");
            }
            if ((clazz.getModifiers() & 0x400) != 0) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.dynamic_properties_class_abstract", string), "SE0023");
            }
            this.className = string;
        }
    }

    public static class CustomActionDefinition {
        private String name;
        private String path;
        private String className;

        CustomActionDefinition(String string, String string2, String string3) throws ScheduleException {
            this.setName(string2);
            this.setClassAndPath(string, string3);
        }

        CustomActionDefinition() {
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassAndPath(String string, String string2) throws ScheduleException {
            Class clazz;
            if (string == null || string.trim().length() == 0) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.set_custom_action_classname_invalid"), "SE0014");
            }
            try {
                ScheduleUtils.addClassPathEntry(string2);
                clazz = BaseUtils.classForName(string);
            }
            catch (Exception exception) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.custom_action_not_found", string), exception, "SE0015");
            }
            if (!ScheduleAction.class.isAssignableFrom(clazz)) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.custom_action_no_schedule_action", string), "SE0016");
            }
            if ((clazz.getModifiers() & 0x400) != 0) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.custom_action_abstract", string), "SE0017");
            }
            this.className = string;
            this.path = string2;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) throws ScheduleException {
            if (string == null || string.trim().length() == 0) {
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.no_custom_action_name"), "SE0018");
            }
            for (int i2 = 0; i2 < Scheduler.getInstance().getCustomActionCount(); ++i2) {
                CustomActionDefinition customActionDefinition = Scheduler.getInstance().getCustomAction(i2);
                if (!string.equals(customActionDefinition.getName()) || customActionDefinition == this) continue;
                throw new ScheduleException(ScheduleUtils.getMsg("scheduler.add_custom_action_exists", customActionDefinition.name, customActionDefinition.className, customActionDefinition.path), "SE0019");
            }
            this.name = string;
        }

        public String getPath() {
            return this.path;
        }
    }
}

