/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.schedule;

import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.PreferencesUtils;
import com.inet.report.BaseUtils;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.schedule.DailyExecution;
import com.inet.report.schedule.EmailAction;
import com.inet.report.schedule.ErrorAction;
import com.inet.report.schedule.FileAction;
import com.inet.report.schedule.FtpAction;
import com.inet.report.schedule.MonthlyExecution;
import com.inet.report.schedule.OneDayExecution;
import com.inet.report.schedule.PrintAction;
import com.inet.report.schedule.ScheduleAction;
import com.inet.report.schedule.ScheduleException;
import com.inet.report.schedule.ScheduleExecution;
import com.inet.report.schedule.ScheduleReport;
import com.inet.report.schedule.ScheduleTask;
import com.inet.report.schedule.ScheduleUtils;
import com.inet.report.schedule.Scheduler;
import com.inet.report.schedule.WeeklyExecution;
import com.inet.report.schedule.YearlyExecution;
import java.io.Reader;
import java.io.StringReader;
import java.security.AccessControlException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;

public class SchedulerPreferences {
    private static final String aKB;
    private static final List<String> cme;
    private static final List<String[]> cmf;
    private static final Properties cmg;

    private static Preferences Yj() {
        return SchedulerPreferences.fW("schedule");
    }

    private static Preferences fW(String string) {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        Configuration configuration = configurationManager.getCurrent();
        String string2 = aKB + "/" + configuration.getName() + "/" + string;
        Preferences preferences = null;
        int n2 = configuration.getScope();
        if (n2 == 1) {
            if (PreferencesUtils.isSystemReadable(string2)) {
                try {
                    Preferences preferences2 = PreferencesUtils.systemRoot();
                    if (preferences2.nodeExists(string2)) {
                        return preferences2.node(string2);
                    }
                    if (PreferencesUtils.isSystemWriteable(string2)) {
                        return preferences2.node(string2);
                    }
                }
                catch (BackingStoreException backingStoreException) {
                    BaseUtils.printStackTrace(backingStoreException);
                }
            }
        } else if (n2 == 2 && PreferencesUtils.isUserReadable(string2)) {
            return PreferencesUtils.userRoot().node(string2);
        }
        return preferences;
    }

    private static void a(Preferences preferences, String string, String string2) {
        block6: {
            try {
                if (preferences != null) {
                    if (string2 == null) {
                        if (preferences.get(string, null) != null) {
                            preferences.remove(string);
                        }
                    } else {
                        preferences.put(string, string2);
                    }
                }
            }
            catch (AccessControlException accessControlException) {
                if (!BaseUtils.isDebug()) break block6;
                BaseUtils.debug("cannot access preferences");
            }
        }
    }

    private static void a(Preferences preferences, String string, Date date) {
        block6: {
            try {
                if (preferences != null) {
                    if (date != null) {
                        String string2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
                        preferences.put(string, string2);
                    } else if (preferences.get(string, null) != null) {
                        preferences.remove(string);
                    }
                }
            }
            catch (AccessControlException accessControlException) {
                if (!BaseUtils.isDebug()) break block6;
                BaseUtils.debug("cannot access preferences");
            }
        }
    }

    private static Date b(Preferences preferences, String string, Date date) {
        block5: {
            try {
                String string2;
                if (preferences != null && (string2 = preferences.get(string, "")) != null && !string2.isEmpty()) {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(string2);
                }
            }
            catch (AccessControlException accessControlException) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("cannot access preferences");
                }
            }
            catch (ParseException parseException) {
                if (!BaseUtils.isError()) break block5;
                BaseUtils.error(parseException);
            }
        }
        return date;
    }

    private static void a(Preferences preferences, String string, boolean bl2) {
        block3: {
            try {
                if (preferences != null) {
                    preferences.putBoolean(string, bl2);
                }
            }
            catch (AccessControlException accessControlException) {
                if (!BaseUtils.isDebug()) break block3;
                BaseUtils.debug("cannot access preferences");
            }
        }
    }

    private static void a(Preferences preferences, String string, int n2) {
        block3: {
            try {
                if (preferences != null) {
                    preferences.putInt(string, n2);
                }
            }
            catch (AccessControlException accessControlException) {
                if (!BaseUtils.isDebug()) break block3;
                BaseUtils.debug("cannot access preferences");
            }
        }
    }

    private static void a(Preferences preferences, String string, String[] stringArray) {
        block6: {
            try {
                if (preferences != null && stringArray != null) {
                    Preferences preferences2 = preferences.node(string);
                    preferences2.clear();
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        if (stringArray[i2] == null) continue;
                        preferences2.put(String.valueOf(i2), stringArray[i2]);
                    }
                }
            }
            catch (AccessControlException accessControlException) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("cannot access preferences");
                }
            }
            catch (BackingStoreException backingStoreException) {
                if (!BaseUtils.isDebug()) break block6;
                BaseUtils.debug("cannot access preferences");
            }
        }
    }

    private static String[] b(Preferences preferences, String string, String[] stringArray) {
        block6: {
            try {
                if (preferences != null && string != null && preferences.nodeExists(string)) {
                    Preferences preferences2 = preferences.node(string);
                    String[] stringArray2 = preferences2.keys();
                    String[] stringArray3 = new String[stringArray2.length];
                    for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                        stringArray3[i2] = preferences2.get(stringArray2[i2], null);
                    }
                    return stringArray3;
                }
                return stringArray;
            }
            catch (AccessControlException accessControlException) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("cannot access preferences");
                }
            }
            catch (BackingStoreException backingStoreException) {
                if (!BaseUtils.isDebug()) break block6;
                BaseUtils.debug("cannot access preferences");
            }
        }
        return stringArray;
    }

    private static void a(Preferences preferences, String string, int[] nArray) {
        block4: {
            try {
                if (preferences != null && nArray != null) {
                    Preferences preferences2 = preferences;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int n2 : nArray) {
                        stringBuilder.append(n2).append(",");
                    }
                    preferences2.put(string, stringBuilder.toString());
                }
            }
            catch (AccessControlException accessControlException) {
                if (!BaseUtils.isDebug()) break block4;
                BaseUtils.debug("cannot access preferences");
            }
        }
    }

    private static int[] b(Preferences preferences, String string, int[] nArray) {
        block5: {
            try {
                if (preferences != null) {
                    String string2 = preferences.get(string, null);
                    if (string2 == null) {
                        return nArray;
                    }
                    String[] stringArray = string2.split(",");
                    int[] nArray2 = new int[stringArray.length];
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        if (stringArray[i2].length() <= 0) continue;
                        nArray2[i2] = Integer.valueOf(stringArray[i2]);
                    }
                    return nArray2;
                }
            }
            catch (AccessControlException accessControlException) {
                if (!BaseUtils.isDebug()) break block5;
                BaseUtils.debug("cannot access preferences");
            }
        }
        return nArray;
    }

    private static void a(Preferences preferences, String string, Properties properties) {
        block6: {
            try {
                if (preferences != null) {
                    Preferences preferences2 = preferences.node(string);
                    preferences2.clear();
                    for (String string2 : properties.stringPropertyNames()) {
                        preferences2.put(string2, properties.getProperty(string2));
                    }
                }
            }
            catch (AccessControlException accessControlException) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("cannot access preferences");
                }
            }
            catch (BackingStoreException backingStoreException) {
                if (!BaseUtils.isDebug()) break block6;
                BaseUtils.debug("cannot access preferences");
            }
        }
    }

    private static Properties b(Preferences preferences, String string, Properties properties) {
        block6: {
            try {
                if (preferences != null) {
                    Preferences preferences2 = preferences.node(string);
                    Properties properties2 = new Properties();
                    for (String string2 : preferences2.keys()) {
                        String string3 = preferences2.get(string2, "");
                        properties2.put(string2, string3);
                    }
                    return properties2;
                }
            }
            catch (AccessControlException accessControlException) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("cannot access preferences");
                }
            }
            catch (BackingStoreException backingStoreException) {
                if (!BaseUtils.isError()) break block6;
                BaseUtils.error(backingStoreException);
            }
        }
        return properties;
    }

    private static void b(Preferences preferences) {
        block3: {
            if (preferences != null) {
                try {
                    preferences.removeNode();
                }
                catch (BackingStoreException backingStoreException) {
                    if (!BaseUtils.isDebug()) break block3;
                    BaseUtils.debug("cannot access preferences");
                }
            }
        }
    }

    public static List<String> getEnabledActions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.SCHEDULER_ENABLED_ACTIONS.getKey());
        if (string == null) {
            return cme;
        }
        for (String string2 : string.split(",")) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static void setEnabledActions(List<String> list) {
        if (SchedulerPreferences.isConfigEmpty() && list.size() == cme.size() && list.containsAll(cme)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string).append(",");
        }
        ConfigurationManager.getInstance().getCurrent().put(ConfigKey.SCHEDULER_ENABLED_ACTIONS.getKey(), stringBuilder.toString());
    }

    public static void setActivated(boolean bl2) {
        if (SchedulerPreferences.isConfigEmpty() && !bl2) {
            return;
        }
        ConfigurationManager.getInstance().getCurrent().put(ConfigKey.SCHEDULER_ACTIVATED.getKey(), Boolean.valueOf(bl2).toString());
    }

    public static boolean isReadOnly() {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        Configuration configuration = configurationManager.getCurrent();
        return !ConfigurationManager.isReadable(configuration.getScope()) || !ConfigurationManager.isWriteable(configuration.getScope());
    }

    public static boolean isActivated() {
        return Boolean.valueOf(ConfigurationManager.getInstance().getCurrent().get(ConfigKey.SCHEDULER_ACTIVATED.getKey(), Boolean.valueOf(false).toString()));
    }

    public static void setCustomActionDefinitions(ArrayList<String[]> arrayList) {
        if (SchedulerPreferences.isConfigEmpty() && arrayList.equals(cmf)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        CustomActionDefStorage customActionDefStorage = new CustomActionDefStorage();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String[] stringArray : arrayList) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder2.append(string).append("SWE--OO980PLKKKNBN");
            }
            arrayList2.add(stringBuilder2.toString());
        }
        customActionDefStorage.setDefs(arrayList2);
        new Json().toJson(customActionDefStorage, stringBuilder);
        ConfigurationManager.getInstance().getCurrent().put(ConfigKey.SCHEDULER_CUSTOM_ACTION_DEFINITIONS.getKey(), stringBuilder.toString());
    }

    public static List<String[]> getCustomActionDefinitions() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.SCHEDULER_CUSTOM_ACTION_DEFINITIONS.getKey());
        if (string == null) {
            return cmf;
        }
        StringReader stringReader = new StringReader(string);
        try {
            CustomActionDefStorage customActionDefStorage = new Json().fromJson((Reader)stringReader, CustomActionDefStorage.class);
            ArrayList<String> arrayList = customActionDefStorage.getDefs();
            ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
            for (String string2 : arrayList) {
                String[] stringArray = string2.split(Pattern.quote("SWE--OO980PLKKKNBN"), -1);
                arrayList2.add(stringArray);
            }
            return arrayList2;
        }
        catch (JsonException jsonException) {
            if (BaseUtils.isError()) {
                BaseUtils.error("Unable to read the CustomActionDefinition-Setting.");
                BaseUtils.error(jsonException);
            }
            return cmf;
        }
    }

    public static boolean isConfigEmpty() {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        if (configuration.get(ConfigKey.SCHEDULER_ENABLED_ACTIONS.getKey()) != null) {
            return false;
        }
        if (configuration.get(ConfigKey.SCHEDULER_RUNTIME_OPTIONS.getKey()) != null) {
            return false;
        }
        if (configuration.get(ConfigKey.SCHEDULER_ACTIVATED.getKey()) != null) {
            return false;
        }
        return configuration.get(ConfigKey.SCHEDULER_CUSTOM_ACTION_DEFINITIONS.getKey()) == null;
    }

    public static boolean isConfigAccessable() {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        return ConfigurationManager.isWriteable(configuration.getScope());
    }

    public static void saveTasks(Collection<ScheduleTask> collection) {
        Preferences preferences = SchedulerPreferences.Yj();
        if (preferences != null) {
            SchedulerPreferences.a(collection, preferences);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void a(Collection<ScheduleTask> collection, Preferences preferences) {
        if (preferences == null || !SchedulerPreferences.isConfigAccessable()) {
            return;
        }
        Preferences preferences2 = preferences.node("tasks");
        SchedulerPreferences.b(preferences2);
        preferences2 = preferences.node("tasks");
        for (ScheduleTask scheduleTask : collection) {
            void n2;
            Object object;
            void var8_15;
            Object object2;
            Preferences preferences3 = preferences2.node(scheduleTask.getName());
            SchedulerPreferences.a(preferences3, "description", scheduleTask.getDescription());
            SchedulerPreferences.a(preferences3, "enabled", scheduleTask.isEnabled());
            SchedulerPreferences.a(preferences3, "deleteIfExpired", scheduleTask.isDeleteIfExpired());
            SchedulerPreferences.a(preferences3, "executionErrors", scheduleTask.getExecutionErrors());
            SchedulerPreferences.a(preferences3, "lastExecutionDate", scheduleTask.getLastRun());
            try {
                preferences3.node("lastRenderedFiles").removeNode();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            Preferences preferences4 = preferences3.node("lastRenderedFiles");
            for (Map.Entry<String, List<ScheduleTask.LastGeneratedReportInstance>> object32 : scheduleTask.getLastReportInstances().entrySet()) {
                object2 = preferences4.node(object32.getKey());
                for (ScheduleTask.LastGeneratedReportInstance lastGeneratedReportInstance : object32.getValue()) {
                    Preferences preferences5 = ((Preferences)object2).node(Integer.toHexString(lastGeneratedReportInstance.hashCode()));
                    for (String string : lastGeneratedReportInstance.getFiles()) {
                        preferences5.put(Integer.toHexString(string.hashCode()), string);
                    }
                }
            }
            ScheduleExecution scheduleExecution = (ScheduleExecution)scheduleTask.getExecutionTime();
            if (scheduleExecution.getIntervalType() == 1) {
                SchedulerPreferences.a(preferences3, "stepsize", ((DailyExecution)scheduleExecution).getDayStepSize());
            } else if (scheduleExecution.getIntervalType() == 3) {
                SchedulerPreferences.a(preferences3, "specificDays", ((MonthlyExecution)scheduleExecution).getSpecificDays());
                SchedulerPreferences.a(preferences3, "specificMonths", ((MonthlyExecution)scheduleExecution).getSpecificMonths());
                SchedulerPreferences.a(preferences3, "stepsize", ((MonthlyExecution)scheduleExecution).getMonthStepSize());
                ScheduleExecution.WeekIndex weekIndex = ((MonthlyExecution)scheduleExecution).getWeekIndex();
                SchedulerPreferences.a(preferences3, "weekIndex", weekIndex != null ? weekIndex.ordinal() : -1);
                object2 = ((MonthlyExecution)scheduleExecution).getWeekDay();
                SchedulerPreferences.a(preferences3, "weekDay", object2 != null ? ((Enum)object2).ordinal() : -1);
            } else if (scheduleExecution.getIntervalType() == 2) {
                SchedulerPreferences.a(preferences3, "stepsize", ((WeeklyExecution)scheduleExecution).getWeekStepSize());
                SchedulerPreferences.a(preferences3, "specificDays", ((WeeklyExecution)scheduleExecution).getSpecificDays());
            } else if (scheduleExecution.getIntervalType() == 5) {
                SchedulerPreferences.a(preferences3, "stepsize", ((YearlyExecution)scheduleExecution).getYearStepSize());
                SchedulerPreferences.a(preferences3, "specificMonths", ((YearlyExecution)scheduleExecution).getSpecificMonths());
                ScheduleExecution.WeekIndex weekIndex = ((YearlyExecution)scheduleExecution).getWeekIndex();
                SchedulerPreferences.a(preferences3, "weekIndex", weekIndex != null ? weekIndex.ordinal() : -1);
                object2 = ((YearlyExecution)scheduleExecution).getWeekDay();
                SchedulerPreferences.a(preferences3, "weekDay", object2 != null ? ((Enum)object2).ordinal() : -1);
            }
            SchedulerPreferences.a(preferences3, "startdate", scheduleExecution.getStartDate());
            SchedulerPreferences.a(preferences3, "enddate", scheduleExecution.getEndDate());
            SchedulerPreferences.a(preferences3, "intervaltype", scheduleExecution.getIntervalType());
            SchedulerPreferences.a(preferences3, "minute", scheduleExecution.getMinute());
            SchedulerPreferences.a(preferences3, "hour", scheduleExecution.getHour());
            SchedulerPreferences.a(preferences3, "hourRange", scheduleExecution.getHourRange());
            SchedulerPreferences.a(preferences3, "loopCount", scheduleExecution.getLoopCount());
            boolean bl2 = false;
            while (var8_15 < scheduleTask.getReportCount()) {
                object2 = scheduleTask.getReport((int)var8_15);
                object = preferences3.node("reports").node(((ScheduleReport)object2).getScheduleName());
                SchedulerPreferences.a((Preferences)object, "exportFormat", ((ScheduleReport)object2).getDynamicPropertiesClass());
                SchedulerPreferences.a((Preferences)object, "properties", ((ScheduleReport)object2).getProperties());
                ++var8_15;
            }
            boolean bl3 = false;
            while (n2 < scheduleTask.getActionCount()) {
                block20: {
                    object2 = scheduleTask.getAction((int)n2);
                    if (object2 instanceof ErrorAction) {
                        object = preferences3.node("actions").node(((ErrorAction)object2).getOriginalActionClassName());
                        SchedulerPreferences.a((Preferences)object, "className", ((ErrorAction)object2).getOriginalActionClassName());
                        SchedulerPreferences.a((Preferences)object, "properties", ((ErrorAction)object2).getActionProperties());
                    } else {
                        object = preferences3.node("actions").node(object2.getClass().getName());
                        SchedulerPreferences.a((Preferences)object, "className", object2.getClass().getName());
                        try {
                            SchedulerPreferences.a((Preferences)object, "properties", ScheduleUtils.getProperties((ScheduleAction)object2));
                        }
                        catch (ScheduleException scheduleException) {
                            if (!BaseUtils.isError()) break block20;
                            BaseUtils.error(scheduleException);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public static void saveTaskAfterExecution(ScheduleTask scheduleTask) {
        Preferences preferences = SchedulerPreferences.Yj();
        if (preferences == null) {
            return;
        }
        Preferences preferences2 = preferences.node("tasks");
        if (Scheduler.getInstance().getTask(scheduleTask.getId()) == null) {
            try {
                preferences2.removeNode();
            }
            catch (BackingStoreException backingStoreException) {}
        } else {
            Preferences preferences3 = preferences2.node(scheduleTask.getName());
            SchedulerPreferences.a(preferences3, "executionErrors", scheduleTask.getExecutionErrors());
            try {
                preferences3.node("lastRenderedFiles").removeNode();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            Preferences preferences4 = preferences3.node("lastRenderedFiles");
            for (Map.Entry<String, List<ScheduleTask.LastGeneratedReportInstance>> entry : scheduleTask.getLastReportInstances().entrySet()) {
                Preferences preferences5 = preferences4.node(entry.getKey());
                for (ScheduleTask.LastGeneratedReportInstance lastGeneratedReportInstance : entry.getValue()) {
                    Preferences preferences6 = preferences5.node(Integer.toHexString(lastGeneratedReportInstance.hashCode()));
                    for (String string : lastGeneratedReportInstance.getFiles()) {
                        preferences6.put("file" + Integer.toHexString(string.hashCode()), string);
                    }
                    if (lastGeneratedReportInstance.getNameSuffix() == null) continue;
                    preferences6.put("reportSuffix", lastGeneratedReportInstance.getNameSuffix());
                }
            }
            SchedulerPreferences.a(preferences3, "lastExecutionDate", scheduleTask.getLastRun());
            SchedulerPreferences.a(preferences3, "loopCount", scheduleTask.getExecutionTime().getLoopCount());
        }
        SchedulerPreferences.flushPreferences();
    }

    public static void loadTasks(Scheduler scheduler) {
        block7: {
            try {
                Preferences preferences = SchedulerPreferences.Yj();
                if (preferences == null) {
                    return;
                }
                Preferences preferences2 = preferences.node("tasks");
                SchedulerPreferences.a(preferences2, scheduler);
            }
            catch (BackingStoreException backingStoreException) {
                if (BaseUtils.isError()) {
                    BaseUtils.error(backingStoreException);
                }
            }
            catch (SecurityException securityException) {
                if (BaseUtils.isError()) {
                    BaseUtils.error(securityException);
                }
            }
            catch (ScheduleException scheduleException) {
                if (!BaseUtils.isError()) break block7;
                BaseUtils.error(scheduleException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void a(Preferences preferences, Scheduler scheduler) throws ScheduleException, BackingStoreException {
        for (String string : preferences.childrenNames()) {
            void var15_19;
            Object object;
            Object object2;
            Object object4;
            Preferences preferences2 = preferences.node(string);
            ScheduleTask scheduleTask = null;
            int n2 = 1;
            try {
                object4 = string;
                while (scheduler.getTask((String)object4) != null) {
                    object4 = string + " (import " + n2++ + ")";
                }
                scheduleTask = scheduler.addTask((String)object4);
            }
            catch (ScheduleException scheduleException) {
                throw new IllegalStateException(scheduleException);
            }
            scheduleTask.setDescription(preferences2.get("description", null));
            scheduleTask.setEnabled(preferences2.getBoolean("enabled", false));
            scheduleTask.setDeleteIfExpired(preferences2.getBoolean("deleteIfExpired", false));
            scheduleTask.setExecutionErrors(SchedulerPreferences.b(preferences2, "executionErrors", new String[0]));
            object4 = preferences2.node("lastRenderedFiles");
            Map<String, List<ScheduleTask.LastGeneratedReportInstance>> map = scheduleTask.getLastReportInstances();
            for (String string2 : ((Preferences)object4).childrenNames()) {
                Preferences object5 = ((Preferences)object4).node(string2);
                CopyOnWriteArrayList<Object> copyOnWriteArrayList = new CopyOnWriteArrayList<Object>();
                for (String string3 : object5.childrenNames()) {
                    object2 = object5.node(string3);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String string4 : ((Preferences)object2).keys()) {
                        String string5;
                        if (!string4.startsWith("file") || (string5 = ((Preferences)object2).get(string4, null)) == null) continue;
                        arrayList.add(string5);
                    }
                    ScheduleTask.LastGeneratedReportInstance lastGeneratedReportInstance = new ScheduleTask.LastGeneratedReportInstance();
                    lastGeneratedReportInstance.setFiles(arrayList);
                    lastGeneratedReportInstance.setNameSuffix(((Preferences)object2).get("reportSuffix", null));
                    copyOnWriteArrayList.add(lastGeneratedReportInstance);
                }
                map.put(string2, copyOnWriteArrayList);
            }
            scheduleTask.setLastRun(SchedulerPreferences.b(preferences2, "lastExecutionDate", null));
            scheduleTask.setExecutionTime(SchedulerPreferences.c(preferences2));
            Preferences preferences3 = preferences2.node("reports");
            for (String string6 : preferences3.childrenNames()) {
                Preferences preferences4 = preferences3.node(string6);
                object = SchedulerPreferences.b(preferences4, "properties", new Properties());
                ScheduleReport scheduleReport = scheduleTask.addReport(string6, (Properties)object);
                scheduleReport.setDynamicPropertiesClass(preferences4.get("exportFormat", null));
            }
            Preferences preferences4 = preferences2.node("actions");
            String[] stringArray = preferences4.childrenNames();
            int n3 = stringArray.length;
            boolean bl2 = false;
            while (var15_19 < n3) {
                block16: {
                    String string7 = stringArray[var15_19];
                    object = preferences4.node(string7);
                    String string8 = ((Preferences)object).get("className", "");
                    Properties properties = SchedulerPreferences.b((Preferences)object, "properties", new Properties());
                    try {
                        ScheduleAction scheduleAction = ScheduleUtils.classForName(string8);
                        try {
                            ScheduleUtils.setActionProperties(scheduleAction, properties);
                            scheduleTask.addAction(scheduleAction);
                        }
                        catch (ScheduleException scheduleException) {
                            if (BaseUtils.gk()) {
                                BaseUtils.warning(scheduleException);
                            }
                        }
                    }
                    catch (Exception exception) {
                        object2 = new ErrorAction(scheduleTask);
                        ((ErrorAction)object2).setActionProperties(properties);
                        ((ErrorAction)object2).setOriginalActionClassName(string8);
                        try {
                            scheduleTask.addAction((ScheduleAction)object2);
                        }
                        catch (ScheduleException scheduleException) {
                            if (!BaseUtils.isError()) break block16;
                            BaseUtils.error(scheduleException);
                        }
                    }
                }
                ++var15_19;
            }
        }
    }

    private static ScheduleExecution c(Preferences preferences) throws ScheduleException {
        Object object;
        ScheduleExecution scheduleExecution = null;
        int n2 = preferences.getInt("intervaltype", -1);
        switch (n2) {
            case 1: {
                object = new DailyExecution();
                ((DailyExecution)object).setDayStepSize(preferences.getInt("stepsize", -1));
                scheduleExecution = object;
                break;
            }
            case 2: {
                WeeklyExecution weeklyExecution = new WeeklyExecution();
                weeklyExecution.setSpecificDays(SchedulerPreferences.b(preferences, "specificDays", new int[0]));
                weeklyExecution.setWeekStepSize(preferences.getInt("stepsize", -1));
                scheduleExecution = weeklyExecution;
                break;
            }
            case 3: {
                int n3;
                MonthlyExecution monthlyExecution = new MonthlyExecution();
                int[] nArray = SchedulerPreferences.b(preferences, "specificDays", new int[0]);
                if (nArray != null && nArray.length > 0 && nArray[0] != 0) {
                    monthlyExecution.setSpecificDays(nArray);
                }
                if ((n3 = preferences.getInt("stepsize", 1)) >= 1 && n3 < 12) {
                    monthlyExecution.setMonthStepSize(n3);
                }
                int n4 = preferences.getInt("weekIndex", -1);
                int n5 = preferences.getInt("weekDay", -1);
                monthlyExecution.setWeekDay(n4 != -1 ? ScheduleExecution.WeekIndex.values()[n4] : null, n5 != -1 ? ScheduleExecution.WeekDay.values()[n5] : null);
                int[] nArray2 = SchedulerPreferences.b(preferences, "specificMonths", new int[0]);
                if (nArray2 != null && nArray2.length > 0 && nArray2[0] != 0) {
                    monthlyExecution.setSpecificMonths(nArray2);
                }
                scheduleExecution = monthlyExecution;
                break;
            }
            case 5: {
                YearlyExecution yearlyExecution = new YearlyExecution();
                int[] nArray = SchedulerPreferences.b(preferences, "specificMonths", new int[0]);
                if (nArray != null && nArray.length > 0 && nArray[0] != 0) {
                    yearlyExecution.setSpecificMonths(nArray);
                }
                yearlyExecution.setYearStepSize(preferences.getInt("stepsize", 1));
                int n6 = preferences.getInt("weekIndex", -1);
                int n7 = preferences.getInt("weekDay", -1);
                yearlyExecution.setWeekDay(n6 != -1 ? ScheduleExecution.WeekIndex.values()[n6] : null, n7 != -1 ? ScheduleExecution.WeekDay.values()[n7] : null);
                scheduleExecution = yearlyExecution;
                break;
            }
            default: {
                scheduleExecution = new OneDayExecution();
            }
        }
        scheduleExecution.setStartDate(SchedulerPreferences.b(preferences, "startdate", null));
        scheduleExecution.setEndDate(SchedulerPreferences.b(preferences, "enddate", null));
        scheduleExecution.setLoopCount(preferences.getInt("loopCount", -1));
        object = SchedulerPreferences.b(preferences, "hourRange", null);
        if (object != null) {
            scheduleExecution.setHourRange((int)object[0], (int)object[1], (int)object[2], preferences.getInt("minute", 0));
        } else {
            scheduleExecution.setStartTime(preferences.getInt("hour", 0), preferences.getInt("minute", 0));
        }
        return scheduleExecution;
    }

    public static void setRuntimeProperties(Properties properties) {
        CharSequence charSequence;
        if (SchedulerPreferences.isConfigEmpty() && properties.equals(cmg)) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            charSequence = (String)enumeration.nextElement();
            if (!((String)charSequence).toLowerCase().contains("password")) continue;
            properties.setProperty((String)charSequence, BaseUtils.encrypt(properties.getProperty((String)charSequence)));
        }
        charSequence = new StringBuilder();
        new Json().toJson(properties, (Appendable)((Object)charSequence));
        ConfigurationManager.getInstance().getCurrent().put(ConfigKey.SCHEDULER_RUNTIME_OPTIONS.getKey(), ((StringBuilder)charSequence).toString());
    }

    public static Properties getRuntimeProperties() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.SCHEDULER_RUNTIME_OPTIONS.getKey(), null);
        if (string == null) {
            return cmg;
        }
        StringReader stringReader = new StringReader(string);
        Properties properties = new Json().fromJson((Reader)stringReader, Properties.class);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.toLowerCase().contains("password")) continue;
            properties.setProperty(string2, BaseUtils.decrypt(properties.getProperty(string2)));
        }
        return properties;
    }

    public static void reset() {
        if (!SchedulerPreferences.isConfigAccessable()) {
            return;
        }
        Preferences preferences = SchedulerPreferences.Yj();
        if (preferences == null) {
            return;
        }
        Preferences preferences2 = preferences.node("tasks");
        SchedulerPreferences.b(preferences2);
        ConfigurationManager.getInstance().getCurrent().put(ConfigKey.SCHEDULER_ENABLED_ACTIONS.getKey(), null);
        ConfigurationManager.getInstance().getCurrent().put(ConfigKey.SCHEDULER_ACTIVATED.getKey(), null);
        ConfigurationManager.getInstance().getCurrent().put("scheduler_password", null);
        ConfigurationManager.getInstance().getCurrent().put(ConfigKey.SCHEDULER_CUSTOM_ACTION_DEFINITIONS.getKey(), null);
        ConfigurationManager.getInstance().getCurrent().put(ConfigKey.SCHEDULER_RUNTIME_OPTIONS.getKey(), null);
        SchedulerPreferences.flushPreferences();
    }

    public static void flushPreferences() {
        try {
            Preferences preferences = SchedulerPreferences.Yj();
            if (preferences != null) {
                preferences.node("tasks").flush();
            }
        }
        catch (BackingStoreException backingStoreException) {
            BaseUtils.printStackTrace(backingStoreException);
        }
    }

    static {
        String string = PreferencesUtils.getRelativePrefPath(ConfigurationManager.class);
        aKB = string.equals("/") ? "/com/inet/report/config/cc" : string + "/cc";
        cme = new ArrayList<String>(5);
        cme.add(EmailAction.class.getName());
        cme.add(FtpAction.class.getName());
        cme.add(FileAction.class.getName());
        cme.add(PrintAction.class.getName());
        cmf = new ArrayList<String[]>();
        cmg = new Properties();
        cmg.setProperty("maxworker", String.valueOf(5));
        cmg.setProperty("password", "");
        cmg.setProperty("pop3host", "");
        cmg.setProperty("pop3port", "110");
        cmg.setProperty("sender", "");
        cmg.setProperty("smtphost", "");
        cmg.setProperty("smtpport", "25");
        cmg.setProperty("user", "");
        cmg.setProperty("propertieschecker", "");
        cmg.setProperty("emailauth", String.valueOf(0));
    }

    public static class CustomActionDefStorage {
        private ArrayList<String> defs;

        private CustomActionDefStorage() {
        }

        public void setDefs(ArrayList<String> arrayList) {
            this.defs = arrayList;
        }

        public ArrayList<String> getDefs() {
            return this.defs;
        }
    }
}

