/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.schedule;

import com.inet.lib.list.StringList;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.i18n.Msg;
import com.inet.report.permissions.a;
import com.inet.report.schedule.ScheduleUtils;
import com.inet.report.util.q;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class SchedulerValidator {
    public static List<String> validateScheduleReportLocation(String string, String string2) {
        return SchedulerValidator.validateScheduleReportLocation(string, string2, Msg.getThreadLocale());
    }

    public static List<String> validateScheduleReportLocation(String string, String string2, Locale locale) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            arrayList.add(ScheduleUtils.getMsg("schedulereport.err.report_property_not_set", locale));
        } else {
            if (string.startsWith("file:")) {
                try {
                    string = new File(string.substring(5)).toURI().toURL().toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            try {
                int n2 = SchedulerValidator.a(string, string2, arrayList, locale);
                if (n2 == 0) {
                    n2 = SchedulerValidator.a("file:" + string, string2, arrayList, locale);
                }
                if (n2 == 0) {
                    arrayList.add(ScheduleUtils.getMsg("schedulereport.err.file_not_a_report", locale));
                }
            }
            catch (a a2) {
                arrayList.add(ScheduleUtils.getMsg("schedulereport.err.fileNotExecutable", locale));
            }
        }
        return arrayList;
    }

    private static int a(String string, String string2, ArrayList<String> arrayList, Locale locale) {
        int n2 = 0;
        try {
            n2 = q.i(new URL(string));
            if (!SchedulerValidator.isValidFormat(string, string2)) {
                arrayList.add(ScheduleUtils.getMsg("schedulereport.err.not_enabled_export_format", locale, string2));
            }
        }
        catch (ReportException reportException) {
            if (reportException.getErrorCode() == ErrorCode.IllegalPath.getErrorCodeNumber()) {
                n2 = 2;
                arrayList.add("[Code" + reportException.getErrorCode() + "] " + reportException.getMessage());
            } else {
                n2 = 0;
            }
        }
        catch (MalformedURLException malformedURLException) {
            n2 = 0;
        }
        catch (a a2) {
            throw a2;
        }
        catch (Exception exception) {
            n2 = 0;
        }
        return n2;
    }

    public static boolean isValidFormat(String string, String string2) throws ReportException {
        Engine engine = new Engine();
        engine.setReportFile(string);
        String[] stringArray = engine.getReportProperties().getEnabledFormats();
        if (stringArray != null) {
            StringList stringList = new StringList(stringArray);
            return stringList.contains(string2);
        }
        return true;
    }

    public static List<String> validateFileActionLocation(String string) {
        return SchedulerValidator.validateFileActionLocation(string, Msg.getThreadLocale());
    }

    public static List<String> validateFileActionLocation(String string, Locale locale) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.trim().length() == 0) {
            arrayList.add(ScheduleUtils.getMsg("fileaction.err.no_path", locale));
        } else {
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL == null) {
                try {
                    File file = new File(string);
                    uRL = file.toURI().toURL();
                    if (!file.exists() || uRL == null) {
                        arrayList.add(ScheduleUtils.getMsg("fileaction_err.path_not_found", locale, string));
                    } else if (file.isFile()) {
                        arrayList.add(ScheduleUtils.getMsg("fileaction_err.path_not_dir", locale, string));
                    } else if (!file.canRead()) {
                        arrayList.add(ScheduleUtils.getMsg("fileaction_err.path_not_readable", locale, string));
                    } else if (!file.canWrite()) {
                        arrayList.add(ScheduleUtils.getMsg("fileaction_err.path_not_writeable", locale, string));
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    public static List<String> validateFtpAction(String string, int n2, String string2) {
        return SchedulerValidator.validateFtpAction(string, n2, string2, Msg.getThreadLocale());
    }

    public static List<String> validateFtpAction(String string, int n2, String string2, Locale locale) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.trim().length() == 0) {
            arrayList.add(ScheduleUtils.getMsg("ftpaction.err.no_server", locale));
        }
        if (n2 < 1) {
            arrayList.add(ScheduleUtils.getMsg("ftpaction.err.invalid_port", locale, String.valueOf(n2)));
        }
        return arrayList;
    }

    public static List<String> validateEmailAction(String string, String string2, String string3, String string4, String string5) {
        return SchedulerValidator.validateEmailAction(string, string2, string3, string4, string5, Msg.getThreadLocale());
    }

    public static List<String> validateEmailAction(String string, String string2, String string3, String string4, String string5, Locale locale) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string3 == null || string3.trim().isEmpty()) {
            arrayList.add(ScheduleUtils.getMsg("emailaction.err.no_to", locale));
        }
        if (string2 == null) {
            arrayList.add(ScheduleUtils.getMsg("emailaction.err.no_message", locale));
        }
        if (string == null) {
            arrayList.add(ScheduleUtils.getMsg("emailaction.err.no_subject", locale));
        }
        try {
            SchedulerValidator.fX(string3);
        }
        catch (AddressException addressException) {
            arrayList.add(ScheduleUtils.getMsg("emailaction.err.bad_to", locale, string3) + addressException.getMessage());
        }
        try {
            SchedulerValidator.fX(string4);
        }
        catch (AddressException addressException) {
            arrayList.add(ScheduleUtils.getMsg("emailaction.err.bad_cc", locale, string4) + addressException.getMessage());
        }
        try {
            SchedulerValidator.fX(string5);
        }
        catch (AddressException addressException) {
            arrayList.add(ScheduleUtils.getMsg("emailaction.err.bad_bc", locale, string5) + addressException.getMessage());
        }
        return arrayList;
    }

    static InternetAddress[] fX(String string) throws AddressException {
        if (string == null || string.trim().length() == 0) {
            return new InternetAddress[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        int n2 = arrayList.size();
        if (n2 == 0) {
            return null;
        }
        InternetAddress[] internetAddressArray = new InternetAddress[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            internetAddressArray[i2] = new InternetAddress((String)arrayList.get(i2), true);
        }
        return internetAddressArray;
    }
}

