/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.svg;

import com.inet.lib.util.ColorUtils;
import com.inet.lib.util.IOFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.BorderProperties;
import com.inet.report.config.font.y;
import com.inet.report.layout.w;
import com.inet.report.renderer.a;
import com.inet.report.util.Base64;
import com.inet.report.util.MemoryStream;
import com.inet.report.util.ad;
import com.inet.report.util.u;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class SVGUtils {
    private static final byte[] art = BaseUtils.getBytes("bold");
    private static final byte[] arm = BaseUtils.getBytes(" stroke");
    private static final byte[] cok = BaseUtils.getBytes(" clip-path=");
    private static final byte[] com = BaseUtils.getBytes("\n</clipPath>");
    private static final byte[] con = BaseUtils.getBytes("\n<clipPath  clip-rule=\"evenodd\"");
    private static final byte[] coo = BaseUtils.getBytes("/>");
    private static final byte[] aro = BaseUtils.getBytes(">");
    private static final byte[] cop = BaseUtils.getBytes(")");
    private static final byte[] coq = BaseUtils.getBytes("cm\"");
    private static final byte[] cor = BaseUtils.getBytes(",");
    private static final byte[] cos = BaseUtils.getBytes(" C");
    private static final byte[] cot = BaseUtils.getBytes(" cx=\"");
    private static final byte[] cou = BaseUtils.getBytes(" cy=\"");
    private static final int[] cov = new int[]{160, 80};
    private static final int[] cow = new int[]{40, 40};
    private static final byte[] cox = BaseUtils.getBytes(" text-decoration=\"");
    private static final byte[] coy = BaseUtils.getBytes("\n</defs>");
    private static final byte[] coz = BaseUtils.getBytes("\n<defs>");
    private static final byte[] coA = BaseUtils.getBytes("\n<filter id=\"dropShadow\">\n<feGaussianBlur in=\"SourceGraphic\" stdDeviation=\"15\" result=\"shadow\" />\n</filter>");
    private static final byte[] coB = BaseUtils.getBytes(" filter=\"url(#dropShadow)\" ");
    private static final byte[] coC = BaseUtils.getBytes("\n<ellipse");
    private static final byte[] coD = BaseUtils.getBytes("=");
    private static final byte[] coE = BaseUtils.getBytes(" fill");
    private static final byte[] coF = BaseUtils.getBytes(" font-family=\"");
    private static final byte[] coG = BaseUtils.getBytes(" font-size=\"");
    private static final byte[] coH = BaseUtils.getBytes(" font-style=\"");
    private static final byte[] coI = BaseUtils.getBytes(" font-weight=\"");
    private static final byte[] coJ = BaseUtils.getBytes("\n</g>");
    private static final byte[] coK = BaseUtils.getBytes("\n<g");
    private static final byte[] coL = BaseUtils.getBytes("#");
    private static final byte[] coM = BaseUtils.getBytes(" height=\"");
    private static final byte[] coN = BaseUtils.getBytes(" id=\"");
    private static final byte[] coO = BaseUtils.getBytes(" xlink:href=\"data:image/png;base64,");
    private static final byte[] coP = BaseUtils.getBytes("\n<image");
    private static final byte[] ars = BaseUtils.getBytes("italic");
    private static final byte[] coQ = BaseUtils.getBytes("\n<line");
    private static final byte[] coR = BaseUtils.getBytes("line-through");
    private static final byte[] coS = BaseUtils.getBytes(" L");
    private static final byte[] coT = BaseUtils.getBytes(" l");
    private static final byte[] coU = BaseUtils.getBytes(" stroke-width=\"");
    private static final byte[] coV = BaseUtils.getBytes("\"url(#");
    private static final byte[] coW = BaseUtils.getBytes(" M");
    private static final byte[] coX = BaseUtils.getBytes("none");
    private static final byte[] coY = BaseUtils.getBytes(" opacity");
    private static final byte[] coZ = BaseUtils.getBytes("\n</svg>\n");
    private static final byte[] cpa = BaseUtils.getBytes("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" version=\"1.1\"");
    private static final byte[] cpb = BaseUtils.getBytes("z");
    private static final byte[] cpc = BaseUtils.getBytes("\n<path d=\"");
    private static final byte[] cpd = BaseUtils.getBytes(" preserveAspectRatio=\"");
    private static final byte[] cpe = BaseUtils.getBytes(" Q");
    private static final byte[] cpf = BaseUtils.getBytes("\"");
    private static final byte[] cpg = BaseUtils.getBytes("\n<rect");
    private static final byte[] cph = BaseUtils.getBytes(" rotate(");
    private static final byte[] cpi = BaseUtils.getBytes(" rx=\"");
    private static final byte[] cpj = BaseUtils.getBytes(" ry=\"");
    private static final byte[] cpk = BaseUtils.getBytes(" ");
    private static final byte[] cpl = BaseUtils.getBytes(" stroke-dasharray:");
    private static final byte[] cpm = BaseUtils.getBytes(" style=\"");
    private static final byte[] are = BaseUtils.getBytes("</text>");
    private static final byte[] cpn = BaseUtils.getBytes("\n<text xml:space=\"preserve\"");
    private static final byte[] cpo = BaseUtils.getBytes(" transform=\"");
    private static final byte[] cpp = BaseUtils.getBytes(" translate(");
    private static final byte[] cpq = BaseUtils.getBytes("-transparency");
    private static final byte[] cpr = BaseUtils.getBytes("</tspan>");
    private static final byte[] cps = BaseUtils.getBytes("<tspan");
    private static final byte[] aru = BaseUtils.getBytes("underline");
    private static final byte[] arE = BaseUtils.getBytes(" width=\"");
    private static final byte[] cpt = BaseUtils.getBytes(" x=\"");
    private static final byte[] arw = BaseUtils.getBytes(" x1=\"");
    private static final byte[] arx = BaseUtils.getBytes(" x2=\"");
    private static final byte[] cpu = BaseUtils.getBytes("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\" \"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\">\n");
    private static final byte[] cpv = BaseUtils.getBytes(" y=\"");
    private static final byte[] ary = BaseUtils.getBytes(" y1=\"");
    private static final byte[] arz = BaseUtils.getBytes(" y2=\"");
    private static final byte[] cpw = BaseUtils.getBytes("<a xlink:href=\"");
    private static final byte[] cpx = BaseUtils.getBytes("</a>");
    private static final byte[] cpy = BaseUtils.getBytes("square");
    private static final Class cpz = new SVGUtils().getClass();
    private static final String[] cpA = new String[]{"back.gif", "back_disabled.gif", "doublecontinous.gif", "doublecontinous_disabled.gif", "doublepage.gif", "doublepage_disabled.gif", "dropdown.png", "end.gif", "end_disabled.gif", "lock.gif", "next.gif", "next_disabled.gif", "print.gif", "singlepage.gif", "start.gif", "start_disabled.gif", "unlock.gif", "zoomin.gif", "zoomout.gif"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSvgViewer() throws IOException {
        InputStream inputStream = cpz.getResourceAsStream("SVGViewer.htm");
        if (inputStream == null) {
            throw new RuntimeException("Resource SVGViewer.htm not found.");
        }
        try {
            byte[] byArray = IOFunctions.readBytes(inputStream);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSvgIcons(String string) throws IOException {
        InputStream inputStream = cpz.getResourceAsStream(string);
        if (inputStream == null) {
            throw new RuntimeException("Resource " + string + " not found.");
        }
        try {
            byte[] byArray = IOFunctions.readBytes(inputStream);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    public static byte[] getSvgViewerPackage(int n2, boolean bl2, String string, int n3) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = "-1;//##LP##".getBytes();
        byte[] byArray2 = "false;//##LH##".getBytes();
        byte[] byArray3 = "\"client/svgviewer\";//##IP##".getBytes();
        byte[] byArray4 = "<meta http-equiv=\"refresh\" content=\"60\">".getBytes();
        byte[] byArray5 = SVGUtils.getSvgViewer();
        int n4 = SVGUtils.a(byArray5, 0, byArray5.length, byArray);
        byArray5 = SVGUtils.a(byArray5, n4, byArray, String.valueOf(n2).getBytes());
        int n5 = SVGUtils.a(byArray5, 0, byArray5.length, byArray2);
        byArray5 = SVGUtils.a(byArray5, n5, byArray2, String.valueOf(bl2).getBytes());
        int n6 = SVGUtils.a(byArray5, 0, byArray5.length, byArray3);
        byArray5 = SVGUtils.a(byArray5, n6, byArray3, ("\"" + string + "\"").getBytes());
        int n7 = SVGUtils.a(byArray5, 0, byArray5.length, byArray4);
        String string2 = n3 > 0 ? "<meta http-equiv=\"refresh\" content=\"60\">".replaceFirst("60", String.valueOf(n3)) : (n3 == 0 ? "<meta http-equiv=\"refresh\" content=\"60\">" : "");
        byArray5 = SVGUtils.a(byArray5, n7, byArray4, string2.getBytes());
        u.a(byteArrayOutputStream, string + ".htm", byArray5);
        for (int i2 = 0; i2 < cpA.length; ++i2) {
            u.a(byteArrayOutputStream, cpA[i2], SVGUtils.getSvgIcons(cpA[i2]));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] getSvgViewer(String string, String string2, int n2) throws IOException {
        byte[] byArray = "\"\";//##PR##".getBytes();
        byte[] byArray2 = "\"client/svgviewer\";//##IP##".getBytes();
        byte[] byArray3 = "<meta http-equiv=\"refresh\" content=\"60\">".getBytes();
        byte[] byArray4 = SVGUtils.getSvgViewer();
        string = string.replaceAll("#", "%23");
        int n3 = SVGUtils.a(byArray4, 0, byArray4.length, byArray2);
        byArray4 = SVGUtils.a(byArray4, n3, byArray2, ("\"" + string2 + "/" + "client" + "/svgviewer" + "\"").getBytes());
        int n4 = SVGUtils.a(byArray4, 0, byArray4.length, byArray);
        byArray4 = SVGUtils.a(byArray4, n4, byArray, string.getBytes());
        int n5 = SVGUtils.a(byArray4, 0, byArray4.length, byArray3);
        String string3 = n2 > 0 ? "<meta http-equiv=\"refresh\" content=\"60\">".replaceFirst("60", String.valueOf(n2)) : (n2 == 0 ? "<meta http-equiv=\"refresh\" content=\"60\">" : "");
        byArray4 = SVGUtils.a(byArray4, n5, byArray3, string3.getBytes());
        return byArray4;
    }

    private static int a(byte[] byArray, int n2, int n3, byte[] byArray2) {
        n3 -= byArray2.length;
        block0: for (int i2 = n2; i2 < n3; ++i2) {
            if (byArray[i2] != byArray2[0]) continue;
            for (int i3 = 1; i3 < byArray2.length; ++i3) {
                if (byArray[i2 + i3] != byArray2[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    private static byte[] a(byte[] byArray, int n2, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray.length - byArray2.length + byArray3.length];
        int n3 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (i2 < n2) {
                byArray4[n3] = byArray[i2];
                ++n3;
            }
            if (i2 == n2) {
                for (int i3 = 0; i3 < byArray3.length; ++i3) {
                    byArray4[n3] = byArray3[i3];
                    ++n3;
                }
            }
            if (i2 <= n2 + byArray2.length) continue;
            byArray4[n3] = byArray[i2];
            ++n3;
        }
        return byArray4;
    }

    public static byte[] beginGrouping(MemoryStream memoryStream, int n2, int n3) {
        memoryStream.write(coK);
        if (n2 != 0 || n3 != 0) {
            SVGUtils.b(memoryStream, n2, n3, 0);
        }
        memoryStream.write(aro);
        return coJ;
    }

    private static byte[] gc(String string) throws UnsupportedEncodingException {
        return ad.ew(string).getBytes("UTF8");
    }

    private static String gd(String string) {
        String string2 = "serif";
        String string3 = y.cv(string);
        if (string3.equals("MONOSPACED")) {
            string2 = "monospace";
        } else if (string3.equals("SANSSERIF")) {
            string2 = "sans-serif";
        } else if (string3.equals("SERIF")) {
            string2 = "serif";
        }
        return string2;
    }

    private static void a(MemoryStream memoryStream, byte[] byArray, byte[] byArray2) {
        memoryStream.write(byArray);
        memoryStream.write(byArray2);
        memoryStream.write(cpf);
    }

    public static void writeBytes(MemoryStream memoryStream, byte[][] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte[] byArray2 = byArray[i2];
            memoryStream.write(byArray2);
        }
    }

    public static byte[][] writeClip(MemoryStream memoryStream, String string, String string2, int n2, int n3, int n4, int n5) {
        byte[][] byArrayArray;
        byte[][] byArray = SVGUtils.a(memoryStream, string, string2);
        memoryStream.write(cpg);
        SVGUtils.i(memoryStream, n2, n3, n4, n5);
        memoryStream.write(coo);
        SVGUtils.writeBytes(memoryStream, byArray);
        if (string2 != null && string2.length() > 0) {
            byArrayArray = new byte[2][];
            byArrayArray[1] = cpx;
        } else {
            byArrayArray = new byte[][]{coJ};
        }
        return byArrayArray;
    }

    private static byte[][] g(MemoryStream memoryStream, String string) {
        return SVGUtils.a(memoryStream, string, null);
    }

    private static byte[][] a(MemoryStream memoryStream, String string, String string2) {
        byte[] byArray = BaseUtils.getBytes(string);
        memoryStream.write(coz);
        memoryStream.write(con);
        SVGUtils.a(memoryStream, coN, byArray);
        memoryStream.write(aro);
        boolean bl2 = string2 != null && string2.length() > 0;
        int n2 = 9;
        byte[] byArray2 = null;
        if (bl2) {
            try {
                byArray2 = SVGUtils.gc(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                BaseUtils.error(unsupportedEncodingException);
            }
            n2 = 13;
        }
        byte[][] byArrayArray = new byte[n2][];
        int n3 = 0;
        byArrayArray[n3++] = com;
        byArrayArray[n3++] = coy;
        if (bl2) {
            byArrayArray[n3++] = cpw;
            byArrayArray[n3++] = byArray2;
            byArrayArray[n3++] = cpf;
            byArrayArray[n3++] = aro;
        }
        byArrayArray[n3++] = coK;
        byArrayArray[n3++] = cok;
        byArrayArray[n3++] = coV;
        byArrayArray[n3++] = byArray;
        byArrayArray[n3++] = cop;
        byArrayArray[n3++] = cpf;
        byArrayArray[n3++] = aro;
        return byArrayArray;
    }

    private static void a(MemoryStream memoryStream, byte[] byArray, int n2) {
        memoryStream.write(byArray);
        memoryStream.write(coD);
        memoryStream.write(cpf);
        if (ColorUtils.getAlpha(n2) == 0) {
            memoryStream.write(coX);
        } else {
            memoryStream.write(coL);
            memoryStream.writeByteAsHexString(n2 & 0xFF);
            memoryStream.writeByteAsHexString(n2 >> 8 & 0xFF);
            memoryStream.writeByteAsHexString(n2 >> 16 & 0xFF);
            int n3 = ColorUtils.getAlpha(n2);
            if (n3 < 255) {
                memoryStream.write(cpf);
                memoryStream.write(coY);
                memoryStream.write(coD);
                memoryStream.write(cpf);
                memoryStream.writeFloatAsString((float)n3 / 255.0f);
            }
        }
        memoryStream.write(cpf);
    }

    private static void a(MemoryStream memoryStream, byte[] byArray, Color color) {
        SVGUtils.a(memoryStream, byArray, ColorUtils.toCcColor(color));
    }

    private static void a(MemoryStream memoryStream, float f2, float f3) {
        memoryStream.writeFloatAsString(f2);
        memoryStream.write(cor);
        memoryStream.writeFloatAsString(f3);
    }

    private static void f(MemoryStream memoryStream, int n2, int n3) {
        memoryStream.writeIntAsString(n2);
        memoryStream.write(cor);
        memoryStream.writeIntAsString(n3);
    }

    public static void writeCompositeRect(MemoryStream memoryStream, int n2, int n3, int n4, int n5, BorderProperties borderProperties, boolean bl2) {
        int n6 = borderProperties.getForeColor();
        int n7 = borderProperties.getBottomLineStyle();
        int n8 = borderProperties.getTopLineStyle();
        int n9 = borderProperties.getRightLineStyle();
        int n10 = borderProperties.getLeftLineStyle();
        int n11 = borderProperties.getBackColor();
        SVGUtils.a(memoryStream, n2, n3, n4, n5, n10, n9, n8, n7, n6, n11, bl2);
    }

    static void a(MemoryStream memoryStream, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, boolean bl2) {
        int n12 = 20;
        SVGUtils.writeRect(memoryStream, n2, n3, n4, n5, -1, n11);
        SVGUtils.writeLine(memoryStream, n2, n3, n2 + n4, n3, n8, n12, n10);
        SVGUtils.writeLine(memoryStream, n2, n3 + n5, n2 + n4, n3 + n5, n9, n12, n10);
        SVGUtils.writeLine(memoryStream, n2, n3, n2, n3 + n5, n6, n12, n10);
        SVGUtils.writeLine(memoryStream, n2 + n4, n3, n2 + n4, n3 + n5, n7, n12, n10);
    }

    private static void a(MemoryStream memoryStream, float[] fArray) {
        memoryStream.write(cos);
        SVGUtils.a(memoryStream, fArray[0], fArray[1]);
        memoryStream.write(cpk);
        SVGUtils.a(memoryStream, fArray[2], fArray[3]);
        memoryStream.write(cpk);
        SVGUtils.a(memoryStream, fArray[4], fArray[5]);
    }

    public static void writeDropShadow(MemoryStream memoryStream, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        memoryStream.write(coK);
        memoryStream.write(coB);
        memoryStream.write(aro);
        int n9 = -1;
        int n10 = 20;
        int n11 = 1;
        SVGUtils.writeRect(memoryStream, n2 += 75, n3 += 75, n4, n5, n10, n11, n9, n6, n7, n8);
        memoryStream.write(coJ);
    }

    private static void g(MemoryStream memoryStream, int n2, int n3, int n4, int n5) {
        int n6 = n4 / 2;
        int n7 = n2 + n6;
        int n8 = n5 / 2;
        int n9 = n3 + n8;
        SVGUtils.b(memoryStream, cot, n7);
        SVGUtils.b(memoryStream, cou, n9);
        SVGUtils.b(memoryStream, cpi, n6);
        SVGUtils.b(memoryStream, cpj, n8);
        SVGUtils.b(memoryStream, coU, 10);
    }

    private static void g(MemoryStream memoryStream, int n2, int n3) {
        SVGUtils.a(memoryStream, coE, n2);
        SVGUtils.a(memoryStream, arm, n3);
    }

    private static void a(MemoryStream memoryStream, Paint paint, Paint paint2) {
        SVGUtils.a(memoryStream, coE, paint);
        SVGUtils.a(memoryStream, arm, paint2);
    }

    public static void writeImage(MemoryStream memoryStream, byte[] byArray, String string, Rectangle2D rectangle2D) {
        int n2 = (int)rectangle2D.getX();
        int n3 = (int)rectangle2D.getY();
        int n4 = (int)rectangle2D.getWidth();
        int n5 = (int)rectangle2D.getHeight();
        SVGUtils.writeImage(memoryStream, byArray, string, n2, n3, n4, n5);
    }

    public static void writeImage(MemoryStream memoryStream, byte[] byArray, String string, int n2, int n3, int n4, int n5) {
        String string2 = "image" + n2 + "," + n3 + "," + n4 + "x" + n5;
        byte[][] byArray2 = SVGUtils.writeClip(memoryStream, string2, string, n2, n3, n4, n5);
        if (byArray != null && byArray.length > 0) {
            memoryStream.write(coP);
            SVGUtils.a(memoryStream, cpd, coX);
            SVGUtils.b(memoryStream, cpt, n2);
            SVGUtils.b(memoryStream, cpv, n3);
            SVGUtils.b(memoryStream, arE, n4);
            SVGUtils.b(memoryStream, coM, n5);
            byte[] byArray3 = Base64.encodeBytesToBytes(byArray);
            SVGUtils.a(memoryStream, coO, byArray3);
            memoryStream.write(coo);
        } else {
            SVGUtils.writeRect(memoryStream, n2, n3, n4, n5, 255, -1);
            SVGUtils.writeLine(memoryStream, n2, n3, n2 + n4, n3 + n5, 255);
            SVGUtils.writeLine(memoryStream, n2, n3 + n5, n2 + n4, n3, 255);
        }
        SVGUtils.writeBytes(memoryStream, byArray2);
    }

    private static void b(MemoryStream memoryStream, byte[] byArray, int n2) {
        memoryStream.write(byArray);
        memoryStream.writeIntAsString(n2);
        memoryStream.write(cpf);
    }

    public static void writeLine(MemoryStream memoryStream, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 20;
        int n8 = 1;
        SVGUtils.writeLine(memoryStream, n2, n3, n4, n5, n8, n7, n6);
    }

    public static void writeLine(MemoryStream memoryStream, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        SVGUtils.a(memoryStream, n2, n3, n4, n5, n6, n7, n8, true);
    }

    static void a(MemoryStream memoryStream, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        if (n7 < 1) {
            n7 = 1;
        }
        if (n6 == 0) {
            return;
        }
        if (n6 == 2) {
            if (n2 == n4) {
                SVGUtils.writeLine(memoryStream, n2 - n7, n3, n4 - n7, n5, 1, n7, n8);
                SVGUtils.writeLine(memoryStream, n2 + n7, n3, n4 + n7, n5, 1, n7, n8);
            } else {
                SVGUtils.writeLine(memoryStream, n2, n3 - n7, n4, n5 - n7, 1, n7, n8);
                SVGUtils.writeLine(memoryStream, n2, n3 + n7, n4, n5 + n7, 1, n7, n8);
            }
        } else {
            memoryStream.write(coQ);
            SVGUtils.a(memoryStream, arm, n8);
            SVGUtils.h(memoryStream, n2, n3, n4, n5);
            SVGUtils.b(memoryStream, coU, n7);
            SVGUtils.t(memoryStream, n6);
            SVGUtils.a(memoryStream, coE, -1);
            SVGUtils.a(memoryStream, BaseUtils.getBytes(" stroke-linecap=\""), cpy);
            memoryStream.write(coo);
        }
    }

    private static void h(MemoryStream memoryStream, int n2, int n3, int n4, int n5) {
        SVGUtils.b(memoryStream, arw, n2);
        SVGUtils.b(memoryStream, ary, n3);
        SVGUtils.b(memoryStream, arx, n4);
        SVGUtils.b(memoryStream, arz, n5);
    }

    private static void t(MemoryStream memoryStream, int n2) {
        if (n2 == 3) {
            SVGUtils.h(memoryStream, cov[0], cov[1]);
        } else if (n2 == 4) {
            SVGUtils.h(memoryStream, cow[0], cow[1]);
        }
    }

    private static void h(MemoryStream memoryStream, int n2, int n3) {
        memoryStream.write(cpm);
        memoryStream.write(cpl);
        SVGUtils.f(memoryStream, n2, n3);
        memoryStream.write(cpf);
    }

    private static void b(MemoryStream memoryStream, float f2, float f3) {
        memoryStream.write(coS);
        SVGUtils.a(memoryStream, f2, f3);
    }

    private static void c(MemoryStream memoryStream, float f2, float f3) {
        memoryStream.write(coW);
        SVGUtils.a(memoryStream, f2, f3);
    }

    private static byte[][] a(MemoryStream memoryStream, int n2, int n3, int n4, String string, int n5, int n6, int n7) {
        boolean bl2;
        Object object = null;
        memoryStream.write(coK);
        SVGUtils.b(memoryStream, n2, n3, n4);
        memoryStream.write(aro);
        memoryStream.write(cpn);
        if (string != null) {
            memoryStream.write(coF);
            if (!string.equals("SansSerif")) {
                SVGUtils.h(memoryStream, string);
                memoryStream.write(cor);
            }
            String string2 = SVGUtils.gd(string);
            SVGUtils.h(memoryStream, string2);
            memoryStream.write(cpf);
        }
        if (n6 >= 0) {
            SVGUtils.b(memoryStream, coG, n6);
        }
        SVGUtils.a(memoryStream, coE, n7);
        boolean bl3 = (n5 & 1) > 0;
        boolean bl4 = (n5 & 2) > 0;
        boolean bl5 = (n5 & 4) > 0;
        boolean bl6 = bl2 = (n5 & 8) > 0;
        if (bl5) {
            SVGUtils.a(memoryStream, cox, aru);
        } else if (bl2) {
            SVGUtils.a(memoryStream, cox, coR);
        }
        if (bl3) {
            SVGUtils.a(memoryStream, coI, art);
        }
        if (bl4) {
            SVGUtils.a(memoryStream, coH, ars);
        }
        memoryStream.write(aro);
        if (bl2 && bl5) {
            memoryStream.write(cps);
            SVGUtils.a(memoryStream, cox, coR);
            memoryStream.write(aro);
            object = new byte[3][];
            object[0] = cpr;
            object[1] = are;
            object[2] = coJ;
        } else {
            object = new byte[2][];
            object[0] = are;
            object[1] = coJ;
        }
        return object;
    }

    public static void writeOval(MemoryStream memoryStream, int n2, int n3, int n4, int n5, int n6, int n7) {
        memoryStream.write(coC);
        SVGUtils.g(memoryStream, n7, n6);
        SVGUtils.g(memoryStream, n2, n3, n4, n5);
        memoryStream.write(coo);
    }

    public static void writePage(MemoryStream memoryStream, MemoryStream memoryStream2, boolean bl2, int n2, int n3, int n4) {
        if (bl2) {
            memoryStream.reset();
            memoryStream2.write(cpu);
            memoryStream.write(cpa);
            memoryStream.write(arE);
            memoryStream.writeFloatAsString((float)n2 / 567.0f);
            memoryStream.write(coq);
            memoryStream.write(coM);
            memoryStream.writeFloatAsString((float)n3 / 567.0f);
            memoryStream.write(coq);
            memoryStream.writeString(" viewBox=\"0 0 " + n2 + " " + n3 + "\"");
            memoryStream.write(aro);
            memoryStream.write(coz);
            memoryStream.write(coA);
            memoryStream.write(coy);
        } else {
            memoryStream2.write(coK);
            memoryStream2.write(aro);
            memoryStream2.write(coJ);
        }
    }

    public static void writePageFooter(MemoryStream memoryStream) {
        memoryStream.write(coZ);
    }

    private static void a(MemoryStream memoryStream, byte[] byArray, Paint paint) {
        if (paint == null || paint instanceof Color) {
            Color color = (Color)paint;
            SVGUtils.a(memoryStream, byArray, color);
        } else if (paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            SVGUtils.a(memoryStream, byArray, gradientPaint.getColor1());
        } else {
            if (paint instanceof TexturePaint) {
                throw new IllegalArgumentException("paint:" + paint.getClass().getName());
            }
            throw new IllegalArgumentException("paint:" + paint.getClass().getName());
        }
    }

    public static void writePath(MemoryStream memoryStream, PathIterator pathIterator, Paint paint, Paint paint2) {
        memoryStream.write(cpc);
        SVGUtils.a(memoryStream, pathIterator);
        memoryStream.write(cpf);
        SVGUtils.a(memoryStream, paint, paint2);
        memoryStream.write(coo);
    }

    private static void a(MemoryStream memoryStream, PathIterator pathIterator) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            pathIterator.next();
            switch (n2) {
                case 0: {
                    SVGUtils.c(memoryStream, fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    SVGUtils.b(memoryStream, fArray[0], fArray[1]);
                    break;
                }
                case 3: {
                    SVGUtils.a(memoryStream, fArray);
                    break;
                }
                case 2: {
                    SVGUtils.b(memoryStream, fArray);
                    break;
                }
                case 4: {
                    memoryStream.write(cpb);
                }
            }
        }
    }

    private static void b(MemoryStream memoryStream, float[] fArray) {
        memoryStream.write(cpe);
        SVGUtils.a(memoryStream, fArray[0], fArray[1]);
        memoryStream.write(cpk);
        SVGUtils.a(memoryStream, fArray[2], fArray[3]);
    }

    public static void writeRect(MemoryStream memoryStream, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 20;
        int n9 = 1;
        SVGUtils.writeRect(memoryStream, n2, n3, n4, n5, n8, n9, n6, n7, 0, 0);
    }

    public static void writeRect(MemoryStream memoryStream, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        if (ColorUtils.getAlpha(n8) != 0 || ColorUtils.getAlpha(n9) != 0) {
            if (n6 < 1) {
                n6 = 1;
            }
            memoryStream.write(cpg);
            SVGUtils.b(memoryStream, cpt, n2);
            SVGUtils.b(memoryStream, cpv, n3);
            SVGUtils.b(memoryStream, arE, n4);
            SVGUtils.b(memoryStream, coM, n5);
            SVGUtils.b(memoryStream, coU, n6);
            SVGUtils.t(memoryStream, n7);
            SVGUtils.g(memoryStream, n9, n8);
            if (n10 > 0) {
                SVGUtils.b(memoryStream, cpi, n10);
            }
            if (n11 > 0) {
                SVGUtils.b(memoryStream, cpj, n11);
            }
            memoryStream.write(coo);
        }
    }

    private static void i(MemoryStream memoryStream, int n2, int n3, int n4, int n5) {
        SVGUtils.b(memoryStream, cpt, n2);
        SVGUtils.b(memoryStream, cpv, n3);
        SVGUtils.b(memoryStream, arE, n4);
        SVGUtils.b(memoryStream, coM, n5);
    }

    public static void writeRotateString(MemoryStream memoryStream, String string, int n2, int n3, int n4, Font font, int n5) {
        String string2 = font.getName();
        int n6 = font.getStyle();
        int n7 = font.getSize();
        SVGUtils.writeRotateString(memoryStream, string, n2, n3, n4, string2, n6, n7, n5);
    }

    public static void writeRotateString(MemoryStream memoryStream, String string, int n2, int n3, int n4, w w2) {
        int n5 = w2.getColor();
        com.inet.report.layout.y y2 = w2.GI();
        int n6 = y2.GP();
        String string2 = y2.getName();
        int n7 = w2.GJ();
        SVGUtils.writeRotateString(memoryStream, string, n2, n3, n4, string2, n7, n6, n5);
    }

    public static void writeRotateString(MemoryStream memoryStream, String string, int n2, int n3, int n4, String string2, int n5, int n6, int n7) {
        byte[][] byArray = SVGUtils.a(memoryStream, n2, n3, n4, string2, n5, n6, n7);
        SVGUtils.h(memoryStream, string);
        SVGUtils.writeBytes(memoryStream, byArray);
    }

    public static byte[] writeShadowClip(MemoryStream memoryStream, String string, int n2, int n3, int n4, int n5, int n6, int n7) {
        RectangularShape rectangularShape;
        RectangularShape rectangularShape2;
        byte[][] byArray = SVGUtils.g(memoryStream, string);
        memoryStream.write(cpc);
        int n8 = 15;
        int n9 = 75;
        if (n6 > 0 || n7 > 0) {
            rectangularShape2 = new RoundRectangle2D.Float(n2 - n8, n3 - n8, n4, n5, n6, n7);
            rectangularShape = new RoundRectangle2D.Float(n2 + n9, n3 + n9, n4, n5, n6, n7);
        } else {
            rectangularShape2 = new Rectangle2D.Float(n2 - n8, n3 - n8, n4, n5);
            rectangularShape = new Rectangle2D.Float(n2 + n9, n3 + n9, n4, n5);
        }
        Area area = new Area(rectangularShape);
        area.subtract(new Area(rectangularShape2));
        SVGUtils.a(memoryStream, area.getPathIterator(null));
        memoryStream.write(cpf);
        memoryStream.write(coo);
        SVGUtils.writeBytes(memoryStream, byArray);
        return coJ;
    }

    private static void h(MemoryStream memoryStream, String string) {
        try {
            memoryStream.write(SVGUtils.gc(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private static void b(MemoryStream memoryStream, int n2, int n3, int n4) {
        if (n2 != 0 || n3 != 0 || n4 != 0) {
            memoryStream.write(cpo);
            memoryStream.write(cpp);
            SVGUtils.f(memoryStream, n2, n3);
            memoryStream.write(cop);
            if (n4 != 0) {
                memoryStream.write(cph);
                memoryStream.writeIntAsString(360 - n4);
                memoryStream.write(cop);
            }
            memoryStream.write(cpf);
        }
    }

    private static void a(MemoryStream memoryStream, AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            memoryStream.write(cpo);
            memoryStream.write("matrix(".getBytes());
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            memoryStream.writeDoubleAsString(dArray[0], 6);
            for (int i2 = 1; i2 < dArray.length; ++i2) {
                double d2 = dArray[i2];
                memoryStream.write(cor);
                memoryStream.writeDoubleAsString(d2, 6);
            }
            memoryStream.write(cop);
            memoryStream.write(cpf);
        }
    }

    public static void writeBorderAndShadow(MemoryStream memoryStream, BorderProperties borderProperties, int n2, int n3, int n4, int n5, int n6, String string) {
        int n7;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        int n8 = a.g(borderProperties);
        int n9 = borderProperties.getBottomLineStyle();
        int n10 = borderProperties.getTopLineStyle();
        int n11 = borderProperties.getRightLineStyle();
        int n12 = borderProperties.getLeftLineStyle();
        int n13 = n6 / 2;
        int n14 = n6 * 2;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        if (n11 != 0) {
            n15 = n13;
        }
        if (n10 != 0) {
            n16 = n13;
        }
        if (n12 != 0) {
            n17 = n13;
        }
        if (n9 != 0) {
            n18 = n13;
        }
        boolean bl6 = bl5 = n10 == 2;
        if (bl5) {
            n16 += n14;
        }
        boolean bl7 = bl4 = n11 == 2;
        if (bl4) {
            n15 += n14;
        }
        boolean bl8 = bl3 = n12 == 2;
        if (bl3) {
            n17 += n14;
        }
        boolean bl9 = bl2 = n9 == 2;
        if (bl2) {
            n18 += n14;
        }
        int n19 = n4 + n17 + n15;
        int n20 = n5 + n16 + n18;
        int n21 = n2 - n17;
        int n22 = n21 + n17;
        int n23 = n3 - n16;
        int n24 = n23 + n16;
        int n25 = n21 + n19;
        int n26 = n25 - n15;
        int n27 = n23 + n20;
        int n28 = n27 - n18;
        SVGUtils.writeRect(memoryStream, n22, n24, n4 + n13, n5 + n13, -1, n8);
        int n29 = n7 = borderProperties.getForeColor();
        if (n7 != -1) {
            Color color = ColorUtils.toJavaColor(n7);
            n29 = ColorUtils.toCcColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 128));
        }
        if (bl5) {
            SVGUtils.writeLine(memoryStream, n21, n23, n25, n23, 1, n6, n7);
            SVGUtils.writeLine(memoryStream, n22, n24, n26, n24, 1, n6, n7);
        } else {
            SVGUtils.writeLine(memoryStream, n21, n23, n25, n23, n10, n6, n7);
        }
        if (bl3) {
            SVGUtils.writeLine(memoryStream, n21, n23, n21, n27, 1, n6, n7);
            SVGUtils.writeLine(memoryStream, n22, n24, n22, n28, 1, n6, n7);
        } else {
            SVGUtils.writeLine(memoryStream, n21, n23, n21, n27, n12, n6, n7);
        }
        if (bl2) {
            SVGUtils.writeLine(memoryStream, n21, n27, n25, n27, 1, n6, n7);
            SVGUtils.writeLine(memoryStream, n22, n28, n26, n28, 1, n6, n7);
        } else {
            SVGUtils.writeLine(memoryStream, n21, n27, n25, n27, n9, n6, n7);
        }
        if (bl4) {
            SVGUtils.writeLine(memoryStream, n25, n23, n25, n27, 1, n6, n7);
            SVGUtils.writeLine(memoryStream, n26, n24, n26, n28, 1, n6, n7);
        } else {
            SVGUtils.writeLine(memoryStream, n25, n23, n25, n27, n11, n6, n7);
        }
        if (borderProperties.isDropShadow()) {
            int n30 = n19 + n13;
            int n31 = n20 + n13;
            byte[] byArray = SVGUtils.writeShadowClip(memoryStream, string, n21, n23, n30, n31, 0, 0);
            SVGUtils.writeDropShadow(memoryStream, n21, n23, n19, n20, n29, 0, 0);
            memoryStream.write(byArray);
        }
    }

    public static void writeStartTransform(MemoryStream memoryStream, AffineTransform affineTransform) {
        memoryStream.write(coK);
        SVGUtils.a(memoryStream, affineTransform);
        memoryStream.write(aro);
    }

    public static void writeEndTransform(MemoryStream memoryStream) {
        memoryStream.write(coJ);
    }

    public static int getAutoRefresh(Properties properties) {
        int n2 = -1;
        String string = properties.getProperty("autorefresh");
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
                n2 /= 1000;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }
}

