/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.util;

import com.inet.report.BaseUtils;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public final class MemoryStream
extends OutputStream
implements DataOutput,
Serializable {
    private static final byte[] cqP = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] cqQ = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final char[] cqR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private byte[] buf;
    private int count;

    public MemoryStream() {
        this(512);
    }

    public MemoryStream(int n2) {
        this.buf = new byte[n2];
    }

    @Override
    public void writeBoolean(boolean bl2) {
        this.write(bl2 ? 1 : 0);
    }

    public void writeUTF8Boolean(boolean bl2) {
        this.writeUTF8Int(bl2 ? 1 : 0);
    }

    @Override
    public void writeByte(int n2) {
        this.write(n2);
    }

    @Override
    public void writeFloat(float f2) {
        this.writeInt(Float.floatToIntBits(f2));
    }

    @Override
    public void write(int n2) {
        if (this.count >= this.buf.length) {
            this.jz(this.count + 1);
        }
        this.buf[this.count++] = (byte)n2;
    }

    @Override
    public void writeUTF(String string) {
        int n2;
        int n3 = string.length();
        int n4 = this.count;
        this.jz(this.count + 2);
        this.count += 2;
        for (n2 = 0; n2 < n3; ++n2) {
            this.writeCharUtf8(string.charAt(n2));
        }
        n2 = this.count - n4 - 2;
        if (n2 > 65535) {
            this.count = n4;
            throw new IllegalStateException("Max UFT Length reached");
        }
        this.patchShort(n4, n2);
    }

    public void writeUTF8(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeCharUtf8(string.charAt(i2));
        }
    }

    public void writeASCII(String string) {
        int n2 = string.length();
        this.jz(this.count + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buf[this.count++] = (byte)string.charAt(i2);
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        int n4 = this.count + n3;
        this.jz(n4);
        System.arraycopy(byArray, n2, this.buf, this.count, n3);
        this.count = n4;
    }

    private void jz(int n2) {
        if (n2 > this.buf.length) {
            this.jA(n2);
        }
    }

    private void jA(int n2) {
        byte[] byArray;
        int n3 = this.count > 1000000 ? n2 + 1000000 : (this.buf.length << 1 > n2 ? this.buf.length << 1 : n2);
        try {
            byArray = new byte[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            try {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("OutOfMemoryError in MemoryStream:" + n3);
                }
                Thread.yield();
                byArray = new byte[n2];
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                throw new OutOfMemoryError("OutOfMemoryError in MemoryStream:" + n3);
            }
        }
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        this.buf = byArray;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public void writeTo(MemoryStream memoryStream) {
        memoryStream.write(this.buf, 0, this.count);
    }

    public void writeTo(MemoryStream memoryStream, int n2, int n3) {
        if (n2 + n3 > this.count) {
            throw new ArrayIndexOutOfBoundsException("index=" + (n2 + n3) + " size=" + this.count);
        }
        memoryStream.write(this.buf, n2, n3);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        int n2 = this.count;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, 0, byArray, 0, n2);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void writeShort(int n2) {
        this.jz(this.count + 2);
        this.buf[this.count++] = (byte)(n2 >> 8);
        this.buf[this.count++] = (byte)n2;
    }

    @Override
    public void writeInt(int n2) {
        this.jz(this.count + 4);
        this.buf[this.count++] = (byte)(n2 >> 24);
        this.buf[this.count++] = (byte)(n2 >> 16);
        this.buf[this.count++] = (byte)(n2 >> 8);
        this.buf[this.count++] = (byte)n2;
    }

    @Override
    public void writeLong(long l2) {
        this.writeInt((int)(l2 >> 32));
        this.writeInt((int)l2);
    }

    public void writeInversShort(int n2) {
        this.jz(this.count + 2);
        this.buf[this.count++] = (byte)n2;
        this.buf[this.count++] = (byte)(n2 >> 8);
    }

    public void writeInverseInt(int n2) {
        this.jz(this.count + 4);
        this.buf[this.count++] = (byte)n2;
        this.buf[this.count++] = (byte)(n2 >> 8);
        this.buf[this.count++] = (byte)(n2 >> 16);
        this.buf[this.count++] = (byte)(n2 >> 24);
    }

    public void writeInverseLong(long l2) {
        this.writeInverseInt((int)l2);
        this.writeInverseInt((int)(l2 >> 32));
    }

    public void writeInverseDouble(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        this.writeInverseLong(l2);
    }

    @Override
    public void writeDouble(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        this.writeLong(l2);
    }

    public void replaceDWord(int n2, int n3) {
        this.buf[n3++] = (byte)(n2 & 0xFF);
        this.buf[n3++] = (byte)(n2 >> 8 & 0xFF);
        this.buf[n3++] = (byte)(n2 >> 16 & 0xFF);
        this.buf[n3] = (byte)(n2 >> 24 & 0xFF);
    }

    public void replaceInt(int n2, int n3) {
        this.buf[n3++] = (byte)(n2 >> 24);
        this.buf[n3++] = (byte)(n2 >> 16);
        this.buf[n3++] = (byte)(n2 >> 8);
        this.buf[n3] = (byte)n2;
    }

    public void replaceWord(int n2, int n3) {
        this.buf[n3++] = (byte)(n2 & 0xFF);
        this.buf[n3] = (byte)(n2 >> 8 & 0xFF);
    }

    public void replaceByte(int n2, int n3) {
        if (n3 < 0 || n3 > this.count) {
            return;
        }
        this.buf[n3] = (byte)(n2 & 0xFF);
    }

    public void replaceBytes(byte[] byArray, int n2, int n3, int n4) {
        if (n2 + n4 > byArray.length) {
            n4 = byArray.length - n2;
        }
        if (n4 <= 0) {
            return;
        }
        int n5 = n3 + n4;
        if (n5 > this.count) {
            if (n5 > this.buf.length) {
                byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n5)];
                System.arraycopy(this.buf, 0, byArray2, 0, this.count);
                this.buf = byArray2;
            }
            this.count = n5;
        }
        System.arraycopy(byArray, n2, this.buf, n3, n4);
    }

    public void writeString(String string) {
        int n2 = string.length();
        if (this.count + n2 > this.buf.length) {
            this.jA(this.count + n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buf[this.count++] = (byte)string.charAt(i2);
        }
    }

    public void writeStringJava2(CharSequence charSequence) {
        if (charSequence == null) {
            this.writeUTF8Int(-1);
            return;
        }
        int n2 = charSequence.length();
        this.writeUTF8Int(n2);
        int n3 = this.count + n2 * 2;
        this.jz(n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            this.buf[this.count++] = (byte)(c2 >> 8);
            this.buf[this.count++] = (byte)c2;
        }
    }

    public void setLength(int n2) {
        if (n2 < 0) {
            return;
        }
        if (n2 > this.count) {
            if (n2 > this.buf.length) {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buf, 0, byArray, 0, this.count);
                this.buf = byArray;
            }
            for (int i2 = this.count; i2 < n2; ++i2) {
                this.buf[i2] = 0;
            }
        }
        this.count = n2;
    }

    public int getLength() {
        return this.count;
    }

    public void writeIntAsString(int n2) {
        if (n2 == 0) {
            this.write(48);
            return;
        }
        if (n2 < 0) {
            this.write(45);
            n2 = -n2;
        }
        int n3 = 0;
        int n4 = n2;
        while (n4 > 99) {
            n4 /= 100;
            n3 += 2;
        }
        if (n4 > 0) {
            ++n3;
        }
        if (n4 > 9) {
            ++n3;
        }
        if ((n3 += this.count) > this.buf.length) {
            this.jz(n3);
        }
        this.count = n3;
        while (n2 > 99) {
            int n5 = n2 - (n2 /= 100) * 100;
            this.buf[--n3] = cqP[n5];
            this.buf[--n3] = cqQ[n5];
        }
        if (n2 > 0) {
            this.buf[--n3] = cqP[n2];
        }
        if (n2 > 9) {
            this.buf[--n3] = cqQ[n2];
        }
    }

    public void writeTwipsAsPoints(int n2) {
        if (n2 < 0) {
            n2 = -n2;
            this.write(45);
        }
        this.writeIntAsString(n2 / 20);
        int n3 = n2 % 20;
        if (n3 != 0) {
            this.write(46);
            this.write(cqP[n3 >> 1]);
            if ((n3 & 1) != 0) {
                this.write(cqP[5]);
            }
        }
    }

    public void writeFloatAsString(float f2) {
        if (f2 < 0.0f) {
            f2 = -f2;
            this.write(45);
        }
        int n2 = (int)f2;
        int n3 = -1 * this.count;
        this.writeIntAsString(n2);
        if ((f2 -= (float)n2) == 0.0f || (n3 += this.count) == 8) {
            return;
        }
        this.write(46);
        while (n3 < 8) {
            if (f2 == 0.0f) {
                return;
            }
            n2 = (int)(f2 *= 10.0f);
            f2 -= (float)n2;
            this.write(cqP[n2]);
            ++n3;
        }
    }

    public void writeDoubleAsString(double d2, int n2) {
        this.writeDoubleAsString(d2, n2, false);
    }

    public void writeDoubleAsString(double d2, int n2, boolean bl2) {
        if (d2 < 0.0) {
            d2 = -1.0 * d2;
            this.write(45);
        }
        int n3 = (int)d2;
        d2 -= (double)n3;
        int n4 = -this.count;
        this.writeIntAsString(n3);
        if (bl2) {
            n4 = 0;
            if (d2 == 0.0) {
                return;
            }
        } else {
            n4 += this.count;
        }
        this.write(46);
        while (n4 < n2) {
            if (d2 == 0.0) {
                return;
            }
            n3 = (int)(d2 *= 10.0);
            d2 -= (double)n3;
            this.write(cqP[n3]);
            ++n4;
        }
    }

    public void writeByteAsHexString(int n2) {
        this.write(cqR[n2 >> 4 & 0xF]);
        this.write(cqR[n2 & 0xF]);
    }

    public void writeShortAsHex(int n2) {
        this.writeByteAsHexString(n2 >> 8);
        this.writeByteAsHexString(n2);
    }

    public void writeBytesAsHexString(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.writeByteAsHexString(byArray[i2]);
        }
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public void insertBytes(int n2, MemoryStream memoryStream) {
        this.b(n2, memoryStream.buf, 0, memoryStream.count);
    }

    void b(int n2, byte[] byArray, int n3, int n4) {
        if (n2 > this.count) {
            throw new RuntimeException("Insert(" + n2 + ") after end(" + this.count + ") of stream.");
        }
        if (n4 == 0) {
            return;
        }
        int n5 = this.count + n4;
        this.jz(n5);
        System.arraycopy(this.buf, n2, this.buf, n2 + n4, this.count - n2);
        System.arraycopy(byArray, n3, this.buf, n2, n4);
        this.count = n5;
    }

    public void moveBytes(int n2, int n3) {
        this.C(n2, this.count - n2, n3);
    }

    void C(int n2, int n3, int n4) {
        this.jz(this.count + n3);
        System.arraycopy(this.buf, n2, this.buf, this.count, n3);
        System.arraycopy(this.buf, n4, this.buf, n4 + n3, this.count - n4 - n3);
        System.arraycopy(this.buf, this.count, this.buf, n4, n3);
    }

    public void patchInt(int n2, int n3) {
        this.buf[n2++] = (byte)(n3 >> 24);
        this.buf[n2++] = (byte)(n3 >> 16);
        this.buf[n2++] = (byte)(n3 >> 8);
        this.buf[n2++] = (byte)n3;
    }

    public void patchShort(int n2, int n3) {
        this.buf[n2++] = (byte)(n3 >> 8);
        this.buf[n2++] = (byte)n3;
    }

    public String toHexDump() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.count; ++i2) {
            stringBuffer.append(Integer.toString(this.buf[i2] & 0xFF)).append(" ");
        }
        return stringBuffer.toString();
    }

    public int skipInt() {
        int n2 = this.count;
        int n3 = n2 + 4;
        this.jz(n3);
        this.count = n3;
        return n2;
    }

    public void writeCharUtf8(char c2) throws InternalError {
        if (c2 < '\u0080') {
            this.write(c2);
        } else if (c2 < '\u0800') {
            this.write(0xC0 | c2 >> 6 & 0x1F);
            this.write(0x80 | c2 >> 0 & 0x3F);
        } else if (c2 < '\u10000') {
            this.write(0xE0 | c2 >> 12 & 0x1F);
            this.write(0x80 | c2 >> 6 & 0x3F);
            this.write(0x80 | c2 >> 0 & 0x3F);
        } else {
            throw new IllegalStateException("32 bit unicode char detected");
        }
    }

    public void writeUTF8Int(int n2) {
        if (this.count + 5 > this.buf.length) {
            this.jA(this.count + 5);
        }
        if (n2 < 0) {
            if (n2 >= -8) {
                this.buf[this.count++] = (byte)(n2 & 0xF);
                return;
            }
            if (n2 >= -1024) {
                this.buf[this.count++] = (byte)(n2 >> 8 & 7);
                this.buf[this.count++] = (byte)n2;
                return;
            }
            if (n2 >= -131072) {
                this.buf[this.count++] = (byte)(n2 >> 16 & 3);
                this.buf[this.count++] = (byte)(n2 >> 8);
                this.buf[this.count++] = (byte)n2;
                return;
            }
            if (n2 >= -16777216) {
                this.buf[this.count++] = 1;
                this.buf[this.count++] = (byte)(n2 >> 16);
                this.buf[this.count++] = (byte)(n2 >> 8);
                this.buf[this.count++] = (byte)n2;
                return;
            }
            this.buf[this.count++] = 1;
            this.buf[this.count++] = 0;
            this.buf[this.count++] = 0;
            this.buf[this.count++] = 0;
            return;
        }
        if (n2 <= 127) {
            this.buf[this.count++] = (byte)(0x80 | n2);
            return;
        }
        if (n2 <= 16383) {
            this.buf[this.count++] = (byte)(0x40 | n2 >> 8);
            this.buf[this.count++] = (byte)n2;
            return;
        }
        if (n2 <= 0x1FFFFF) {
            this.buf[this.count++] = (byte)(0x20 | n2 >> 16);
            this.buf[this.count++] = (byte)(n2 >> 8);
            this.buf[this.count++] = (byte)n2;
            return;
        }
        if (n2 <= 0xFFFFFFF) {
            this.buf[this.count++] = (byte)(0x10 | n2 >> 24);
            this.buf[this.count++] = (byte)(n2 >> 16);
            this.buf[this.count++] = (byte)(n2 >> 8);
            this.buf[this.count++] = (byte)n2;
            return;
        }
        this.buf[this.count++] = 31;
        this.buf[this.count++] = -1;
        this.buf[this.count++] = -1;
        this.buf[this.count++] = -1;
    }

    public void insertUTF8Int(int n2, int n3) {
        int n4 = this.count;
        this.writeUTF8Int(n3);
        this.moveBytes(n4, n2);
    }

    public boolean equalsBytes(byte[] byArray) {
        if (byArray.length != this.count) {
            return false;
        }
        int n2 = byArray.length;
        while (n2-- != 0) {
            if (byArray[n2] == this.buf[n2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeBytes(String string) throws IOException {
        this.writeASCII(string);
    }

    @Override
    public void writeChar(int n2) throws IOException {
        this.writeShort(n2);
    }

    @Override
    public void writeChars(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeChar(string.charAt(i2));
        }
    }
}

