/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.UIManager;

public class GUIUtils {
    public static final int TOP = 0;
    public static final int LEFT = 1;
    public static final int BOTTOM = 2;
    public static final int RIGHT = 3;
    public static final int SIDE_GAP = 30;
    public static final int TITLED_SIDE_GAP = 28;
    public static final int TOP_GAP = 20;
    public static final int BUTTOM_GAP = 10;
    public static final int GAP_LINE = 20;
    public static final int GAP = 10;
    public static final int GAP_HALF = 5;
    public static final Insets INSETS_TOP = new Insets(20, 30, 10, 30);
    public static final Insets INSETS_TOP_HALF = new Insets(20, 30, 5, 30);
    public static final Insets INSETS_TOP_ZERO = new Insets(20, 30, 0, 30);
    public static final Insets INSETS_MIDDLE = new Insets(0, 30, 10, 30);
    public static final Insets INSETS_MIDDLE_HALF = new Insets(0, 30, 5, 30);
    public static final Insets INSETS_MIDDLE_ZERO = new Insets(0, 30, 0, 30);
    public static final Insets INSETS_BOTTOM = new Insets(0, 30, 10, 30);
    public static final Insets INSETS_NULL = new Insets(0, 0, 0, 0);
    public static final Insets TITLED_INSETS_TOP = new Insets(20, 28, 10, 28);
    public static final Insets TITLED_INSETS_MIDDLE = new Insets(0, 28, 10, 28);
    public static final Insets TITLED_INSETS_MIDDLE_HALF = new Insets(0, 28, 5, 28);
    public static final Insets TITLED_INSETS_MIDDLE_ZERO = new Insets(0, 28, 0, 28);
    public static final Insets TITLED_INSETS_BOTTOM = new Insets(0, 28, 10, 28);
    public static final Insets COMPONENT_INSETS_TOP = new Insets(20, 10, 10, 10);
    public static final Insets COMPONENT_INSETS_TOP_HALF = new Insets(20, 10, 5, 10);
    public static final Insets COMPONENT_INSETS_MIDDLE = new Insets(0, 10, 10, 10);
    public static final Insets COMPONENT_INSETS_MIDDLE_HALF = new Insets(0, 10, 5, 10);
    public static final Insets COMPONENT_INSETS_MIDDLE_ZERO = new Insets(0, 10, 0, 10);
    public static final Insets COMPONENT_INSETS_BOTTOM = new Insets(0, 10, 10, 10);
    public static final int SCROLLBAR_INCREMENT = 10;
    public static final Color DARKER = new Color(205, 210, 214);
    public static final Color BRIGTHER = new Color(230, 235, 240);
    public static final Color ENABLED_COLOR = UIManager.getColor("TitledBorder.titleColor");
    public static final Color DISABLED_COLOR = UIManager.getColor("Label.disabledForeground");
    public static final Color LINK_ACTIVE_COLOR = Color.BLUE;
    public static final Color LINK_DEFAULT_COLOR = Color.DARK_GRAY;
    public static final int HELP_BUTTON_SIZE = 24;
    public static final Color CHANGED_COLOR = new Color(200, 0, 0);
    public static final Color ANNOTATION_COLOR = new Color(0, 0, 120);

    public static Insets addGap(Insets insets, int direction, int value) {
        switch (direction) {
            case 0: {
                insets = new Insets(insets.top + value, insets.left, insets.bottom, insets.right);
                break;
            }
            case 1: {
                insets = new Insets(insets.top, insets.left + value, insets.bottom, insets.right);
                break;
            }
            case 2: {
                insets = new Insets(insets.top, insets.left, insets.bottom + value, insets.right);
                break;
            }
            case 3: {
                insets = new Insets(insets.top, insets.left, insets.bottom, insets.right + value);
                break;
            }
        }
        return insets;
    }

    public static Insets removeGap(Insets insets, int direction, int value) {
        switch (direction) {
            case 0: {
                insets = new Insets(insets.top - value, insets.left, insets.bottom, insets.right);
                break;
            }
            case 1: {
                insets = new Insets(insets.top, insets.left - value, insets.bottom, insets.right);
                break;
            }
            case 2: {
                insets = new Insets(insets.top, insets.left, insets.bottom - value, insets.right);
                break;
            }
            case 3: {
                insets = new Insets(insets.top, insets.left, insets.bottom, insets.right - value);
                break;
            }
        }
        return insets;
    }

    public static String clipString(String s2, int maxWidth, FontMetrics fm2, boolean appendPoints) {
        int sw = fm2.stringWidth(s2);
        if (sw <= maxWidth) {
            return s2;
        }
        String sPoints = "...";
        int delta = appendPoints ? fm2.stringWidth(sPoints) : 0;
        maxWidth -= delta;
        while (sw > maxWidth && s2.length() > 0) {
            s2 = s2.substring(0, s2.length() - 1);
            sw = fm2.stringWidth(s2);
        }
        return appendPoints ? s2 + sPoints : s2;
    }

    public static void centerOnFrame(Window parent, Window me) {
        int parentWidth = 0;
        int parentHeight = 0;
        int locx = 0;
        int locy = 0;
        if (parent == null || !parent.isShowing()) {
            GraphicsEnvironment localGraphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Point centerPoint = localGraphicsEnvironment.getCenterPoint();
            locx = centerPoint.x - me.getWidth() / 2;
            locy = centerPoint.y - me.getHeight() / 2;
        } else {
            Point parentLocation = parent.getLocation();
            parentWidth = parent.getWidth();
            parentHeight = parent.getHeight();
            locx = parentLocation.x + parentWidth / 2 - me.getWidth() / 2;
            locy = parentLocation.y + parentHeight / 2 - me.getHeight() / 2;
        }
        if (parent != null && parent.isShowing()) {
            Rectangle bounds = parent.getGraphicsConfiguration().getBounds();
            if (locx + me.getWidth() > bounds.width + bounds.x) {
                locx = bounds.width + bounds.x - me.getWidth();
            }
            if (locy + me.getHeight() > bounds.height + bounds.y) {
                locy = bounds.height + bounds.y - me.getHeight();
            }
            if (locx < bounds.x) {
                locx = bounds.x;
            }
            if (locy < bounds.y) {
                locy = bounds.y;
            }
        } else {
            if (locx < 0) {
                locx = 0;
            }
            if (locy < 0) {
                locy = 0;
            }
        }
        me.setLocation(locx, locy);
    }
}

