/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup;

import com.inet.lib.swing.LaF;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TitlePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel lblTitle = new JLabel();
    private JLabel subTitle = new JLabel();
    private JLabel txtDescription = new JLabel();
    private ImageIcon background;
    private ImageIcon panelIcon;

    public TitlePanel(String panelIconName) {
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(1));
        this.lblTitle.setOpaque(false);
        this.txtDescription.setVerticalAlignment(1);
        try {
            this.background = ResourceManager.getInstance() != null ? ResourceManager.getInstance().getImageIconResource("com/inet/setup/images/topimage.png") : new ImageIcon(ClassLoader.getSystemResource("img/topimage.png"));
        }
        catch (ResourceNotFoundException e2) {
            this.background = new ImageIcon(ClassLoader.getSystemResource("img/topimage.png"));
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        if (panelIconName != null) {
            try {
                this.panelIcon = ResourceManager.getInstance() != null ? ResourceManager.getInstance().getImageIconResource(panelIconName) : new ImageIcon(ClassLoader.getSystemResource("img/" + panelIconName));
            }
            catch (ResourceNotFoundException e4) {
                e4.printStackTrace();
            }
            catch (IOException e5) {
                e5.printStackTrace();
            }
        }
        this.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 80, 5, 2), 0, 0));
        this.add((Component)this.subTitle, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(15, 80, 5, 2), 0, 0));
        this.setBorder(LaF.getBorder(2));
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.background != null) {
            return new Dimension(this.background.getIconWidth(), this.background.getIconHeight());
        }
        return new Dimension(591, 64);
    }

    @Override
    public Dimension preferredSize() {
        if (this.background != null) {
            return new Dimension(this.background.getIconWidth(), this.background.getIconHeight());
        }
        return new Dimension(591, 64);
    }

    public void setHeading(String title) {
        this.lblTitle.setText(title);
    }

    public void setSubtitle(String subtitle) {
        this.subTitle.setText(subtitle);
    }

    public void setDescription(String description) {
        this.txtDescription.setText("<html><div style='width=400' width='400'>" + description + "</div></html>");
        Dimension dim = this.txtDescription.getUI().getPreferredSize(this.txtDescription);
        this.txtDescription.setPreferredSize(dim);
        this.txtDescription.setText("<html>" + description + "</html>");
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.background != null) {
            g2.drawImage(this.background.getImage(), Math.max(this.getWidth() - this.background.getIconWidth(), 0), 0, null);
        }
        if (this.panelIcon != null) {
            g2.drawImage(this.panelIcon.getImage(), 10, 10, null);
        }
    }

    public void setPanelIcon(ImageIcon panelIcon) {
        this.panelIcon = panelIcon;
        this.repaint();
    }

    public void setPanelIcon(String panelIconName) {
        try {
            this.panelIcon = ResourceManager.getInstance() != null ? ResourceManager.getInstance().getImageIconResource(panelIconName) : new ImageIcon(ClassLoader.getSystemResource("img/" + panelIconName));
        }
        catch (ResourceNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        this.repaint();
    }
}

