/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.setup.TitlePanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.textui.Group;
import com.inet.textui.InetIzPanel;
import com.inet.textui.PanelGroup;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackHandler;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public abstract class AbstractPanel
extends IzPanel
implements InetIzPanel {
    private static final long serialVersionUID = -4785735742469730210L;
    private boolean first = true;
    private JPanel localPanel = null;
    private String heading = null;
    private String subtitle = null;
    private String description = null;
    private String panelIconName = null;
    private AbstractUIHandler handler;
    private SummaryMap summaryGetter = new SummaryMap();
    private TitlePanel pnlTitle;
    private FilteredVariables filteredVariables;
    private boolean showTitleBar = true;
    private int panelID = -1;

    public AbstractPanel(InstallerFrame parent, InstallData idata, String heading, String subtitle, String description, String panelIconName) {
        super(parent, idata);
        this.heading = heading;
        this.subtitle = subtitle;
        this.description = description;
        this.panelIconName = panelIconName;
        this.setName(this.myClassname);
    }

    @Override
    public InstallerFrame getInstallerFrame() {
        return this.parent;
    }

    @Override
    public void panelActivate() {
        Debug.log((Object)"panelActivate()", this.getClass());
        this.summaryGetter.clear();
        super.panelActivate();
        this.initGUI();
        if (this.parent.isHelpVisible()) {
            this.parent.showHelp();
        }
    }

    @Override
    public void panelDeactivate() {
        super.panelDeactivate();
        Debug.log((Object)"panelDeactivate()", this.getClass());
    }

    @Override
    public boolean isValidated() {
        if (this.filteredVariables != null) {
            Set<String> keySet = this.filteredVariables.keySet();
            for (String key : keySet) {
                String variable = this.filteredVariables.getVariable(key);
                if (variable == null) continue;
                this.idata.setVariable(key, variable);
            }
        }
        return super.isValidated();
    }

    private void initGUI() {
        if (this.first) {
            this.first = false;
            this.setLayout(new BorderLayout(0, 0));
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.setBackground(Color.black);
            this.pnlTitle = new TitlePanel(this.panelIconName);
            if (this.heading != null && this.heading.length() > 0) {
                this.pnlTitle.setHeading(this.heading);
            }
            if (this.subtitle != null && this.subtitle.length() > 0) {
                this.pnlTitle.setSubtitle(this.subtitle);
            }
            if (this.description != null && this.description.length() > 0) {
                this.pnlTitle.setDescription(this.description);
            }
            this.localPanel = this.initPanelGUI();
            if (this.showTitleBar) {
                this.add((Component)this.pnlTitle, "North");
            }
            this.add((Component)this.localPanel, "Center");
        }
    }

    public JPanel initPanelGUI() {
        return new JPanel();
    }

    public FilteredVariables readFilteredVariables(Map<String, String> filter) {
        this.filteredVariables = new FilteredVariables(this.idata.getVariables(), filter);
        return this.filteredVariables;
    }

    public Map<String, String> getRequiredVariables() {
        HashMap<String, String> requiredVariables = new HashMap<String, String>();
        return requiredVariables;
    }

    @Override
    public Group getTextUiGroup() {
        if (this.localPanel == null) {
            throw new IllegalStateException("encountered fatal problem with panel '" + this.heading + "'");
        }
        PanelGroup panelGroup = new PanelGroup(this.localPanel);
        return panelGroup;
    }

    public File getDirectoryFileFromChooser(File defaultPath, String chooserHeading) {
        JFileChooser chooser;
        if (defaultPath != null && defaultPath.length() > 0L) {
            chooser = new JFileChooser(defaultPath);
            chooser.setLocale(Locale.getDefault());
            chooser.updateUI();
        } else {
            chooser = new JFileChooser();
            chooser.setLocale(Locale.getDefault());
            chooser.updateUI();
        }
        chooser.setFileSelectionMode(1);
        if (chooserHeading != null && chooserHeading.length() > 0) {
            chooser.setDialogTitle(chooserHeading);
        } else {
            chooser.setDialogTitle(this.parent.langpack.getString("ServletPanel.installPath"));
        }
        chooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return ((AbstractPanel)AbstractPanel.this).parent.langpack.getString("ServletPanel.directorys_only");
            }

            @Override
            public boolean accept(File f2) {
                return f2.isDirectory();
            }
        });
        int returnVal = chooser.showOpenDialog(this.parent);
        if (returnVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    protected void recalcWidthForComponent(List<JComponent> ... listComp) {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        for (List<JComponent> listc : listComp) {
            list.addAll(listc);
        }
        this.recalcWidthForComponentList(list);
    }

    protected void recalcWidthForComponent(JComponent ... list) {
        this.recalcWidthForComponentList(Arrays.asList(list));
    }

    private void recalcWidthForComponentList(List<JComponent> list) {
        int width = 0;
        int height = 0;
        for (JComponent jComponent : list) {
            if (jComponent == null) continue;
            width = (int)(jComponent.getPreferredSize().getWidth() > (double)width ? jComponent.getPreferredSize().getWidth() : (double)width);
            height = (int)(jComponent.getPreferredSize().getHeight() > (double)height ? jComponent.getPreferredSize().getHeight() : (double)height);
        }
        Dimension dim = new Dimension(width, height);
        for (JComponent jComponent : list) {
            if (jComponent == null) continue;
            jComponent.setPreferredSize(dim);
        }
    }

    @Override
    public void setUIHandler(AbstractUIHandler handler) {
        this.handler = handler;
    }

    @Override
    public void emitError(String title, String message) {
        if (this.handler == null) {
            super.emitError(title, message);
        } else {
            this.handler.emitError(title, message);
        }
    }

    @Override
    public void emitErrorAndBlockNext(String title, String message) {
        if (this.handler == null) {
            super.emitErrorAndBlockNext(title, message);
        } else {
            this.handler.emitErrorAndBlockNext(title, message);
        }
    }

    @Override
    public void emitNotification(String title, String message) {
        if (this.handler == null) {
            super.emitNotification(title, message);
        } else {
            this.handler.emitNotification(title, message);
        }
    }

    @Override
    public void emitWarning(String title, String message) {
        if (this.handler == null) {
            super.emitWarning(title, message);
        } else {
            this.handler.emitWarning(title, message);
        }
    }

    @Override
    public int askQuestion(String title, String question, int choices) {
        if (this.handler == null) {
            return super.askQuestion(title, question, choices);
        }
        return this.handler.askQuestion(title, question, choices);
    }

    @Override
    public int askQuestion(String title, String question, int choices, int defaultChoice) {
        if (this.handler == null) {
            return super.askQuestion(title, question, choices, defaultChoice);
        }
        return this.handler.askQuestion(title, question, choices, defaultChoice);
    }

    @Override
    public String getSummaryBody() {
        if (this.summaryGetter == null || this.summaryGetter.size() == 0) {
            return null;
        }
        String start = "<table><tr>";
        String end = "</tr></table>";
        String tdstart = "<td>";
        String tdend = "</td>";
        String tdmiddle = "</td><td width=\"30\" align=\"center\">-</td><td>";
        String trmiddle = "</tr><tr>";
        StringBuilder summary = new StringBuilder();
        summary.append(start);
        boolean firstrun = true;
        for (SummaryEntry entry : this.summaryGetter) {
            if (!firstrun) {
                summary.append(trmiddle);
            }
            summary.append(tdstart);
            summary.append(AbstractPanel.encodeHTML(this.parent.langpack.getString(entry.getKey())));
            summary.append(tdmiddle);
            summary.append(AbstractPanel.encodeHTML(this.cutTextLines(entry.getValue(), ",", " ", ";")));
            summary.append(tdend);
            firstrun = false;
        }
        summary.append(end);
        return summary.toString();
    }

    private String cutTextLines(String plainText, String ... seperators) {
        StringBuilder result = new StringBuilder();
        int maxLength = 80;
        int startIndex = 0;
        int cutIndex = startIndex + maxLength;
        if (plainText.length() < maxLength) {
            return plainText;
        }
        while (true) {
            if (cutIndex > plainText.length()) break;
            if (plainText.indexOf(10, startIndex) != -1 && plainText.indexOf(10, startIndex) < cutIndex) {
                String substring = plainText.substring(startIndex, plainText.indexOf(10, startIndex)).trim();
                if (substring.length() > 0) {
                    result.append(substring);
                    result.append("\n");
                }
                startIndex = plainText.indexOf(10, startIndex) + "\n".length();
                cutIndex = startIndex + maxLength;
                continue;
            }
            int index = -1;
            int sepLen = 0;
            String testString = plainText.substring(startIndex, cutIndex);
            for (String seperator : seperators) {
                int lastIndexOf = testString.lastIndexOf(seperator);
                if (index >= lastIndexOf) continue;
                index = lastIndexOf;
                sepLen = seperator.trim().length();
            }
            if (index > 0) {
                cutIndex = startIndex + index;
            } else {
                sepLen = 1;
            }
            result.append(plainText.substring(startIndex, cutIndex + sepLen).trim());
            result.append("\n");
            startIndex = cutIndex + 1;
            cutIndex = startIndex + maxLength;
        }
        result.append(plainText.substring(startIndex).trim());
        return result.toString();
    }

    @Override
    public String getSummaryCaption() {
        return AbstractPanel.encodeHTML(super.getSummaryCaption());
    }

    public void putToSummary(String key, String value, int position) {
        this.summaryGetter.add(key, value, position);
    }

    public static String encodeHTML(String s2) {
        if (s2 == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 > '\u007f' || c2 == '\"' || c2 == '<' || c2 == '>') {
                out.append("&#" + c2 + ";");
                continue;
            }
            out.append(c2);
        }
        String string = out.toString();
        string = string.replace("\n", "<br>");
        return string;
    }

    public static String encodeXML(String token) {
        if (token == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(token.length());
        block7: for (int i2 = 0; i2 < token.length(); ++i2) {
            switch (token.charAt(i2)) {
                case '<': {
                    result.append("&#60;");
                    continue block7;
                }
                case '>': {
                    result.append("&#62;");
                    continue block7;
                }
                case '&': {
                    result.append("&#38;");
                    continue block7;
                }
                case '\'': {
                    result.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    result.append("&#34;");
                    continue block7;
                }
                default: {
                    result.append(token.charAt(i2));
                }
            }
        }
        return result.toString();
    }

    public void setPanelIcon(String panelIcon) {
        if (this.pnlTitle != null) {
            this.pnlTitle.setPanelIcon(panelIcon);
        }
    }

    @Override
    public String getHeading() {
        return this.heading;
    }

    protected void createReverseMapping() {
        List<Pack> list = PackHandler.getAllPacks();
        for (Pack pack : list) {
            Pack parentPack;
            String parent = pack.parent;
            if (parent == null || "".equalsIgnoreCase(parent) || (parentPack = PackHandler.getPack(parent)) == null) continue;
            parentPack.addRevMapping(pack.id);
        }
    }

    protected void createReverseDependencies() {
        for (Pack p2 : PackHandler.getAvailablePacks()) {
            this.reverseDepsForPack(p2);
        }
    }

    protected void reverseDepsForPack(Pack pack) {
        for (Pack p2 : PackHandler.getAvailablePacks()) {
            List<String> dependencies;
            RulesEngine rules = this.parent.getRules();
            boolean canInstallPack = rules.canInstallPack(p2.id, this.idata.getVariables());
            if (!canInstallPack || (dependencies = p2.getDependencies()) == null || !dependencies.contains(pack.name)) continue;
            pack.addReverseDependency(p2.name);
        }
    }

    public static String getMultilineLabel(String message) {
        String tmp = "";
        int start = 0;
        int index = message.indexOf("\n");
        while (index != -1) {
            tmp = tmp + message.substring(start, index) + "<br>";
            start = index += 2;
            index = message.indexOf("\n", index);
        }
        message = tmp + message.substring(start);
        return "<html><body>" + message + "</body></html>";
    }

    public void setShowTitleBar(boolean showTitleBar) {
        this.showTitleBar = showTitleBar;
    }

    public int getPanelID() {
        return this.panelID;
    }

    public void setPanelID(int panelID) {
        this.panelID = panelID;
    }

    private class SummaryEntry
    implements Comparable<SummaryEntry> {
        private final String key;
        private final String value;
        private final int position;

        public SummaryEntry(String key, String value, int position) {
            this.key = key;
            this.value = value;
            this.position = position;
        }

        @Override
        public int compareTo(SummaryEntry o2) {
            return Integer.valueOf(this.position).compareTo(o2.position);
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    private class SummaryMap
    extends TreeSet<SummaryEntry> {
        private static final long serialVersionUID = 3327115328389920725L;

        private SummaryMap() {
        }

        public void add(String key, String value, int position) {
            this.add(new SummaryEntry(key, value, position));
        }
    }
}

