/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.widget.ContextPanel;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class ApachePanel
extends AbstractPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JList listTable;
    private JButton btnSearch;
    private JTextField txtSelectedHttpd;
    private JButton btnBrowse;
    private JPanel pnlSelectHTTPD;
    private FilteredVariables filteredVariables;
    private JButton btnBrowseLinux;
    private String[] possiblePaths = new String[]{"/etc/httpd.conf", "/etc/apache2/httpd.conf", "/opt/lampp/etc/httpd.conf"};
    private String selectedConf = "";
    private ContextPanel pnlVirtualDir;
    private static final int ALIAS_OK = -1;
    private static final int CONTAINS_CC = 1;
    private static final int WARN_CC = 2;
    private static final int CONTAINS_ALIAS = 3;
    private static final int WARN_ALIAS = 4;

    public ApachePanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("ApachePanel.heading"), null, null, "com/inet/setup/images/Database48.png");
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("APACHEPHP_CONF_PATH", null);
        requiredVariables.put("APACHEPHP_SERVLET_VERSION", null);
        requiredVariables.put("SERVLET_REMOTE_INSTALL", null);
        requiredVariables.put("APACHEPHP_VIRTUAL_DIRECTORY", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
    }

    public void panelFinish() {
        if (!"true".equalsIgnoreCase(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"))) {
            this.filteredVariables.setVariable("APACHEPHP_CONF_PATH", this.selectedConf);
        }
        this.putToSummary(this.parent.langpack.getString("ApachePanel.file_open_title"), this.filteredVariables.getVariable("APACHEPHP_CONF_PATH"), 1);
        if (this.pnlVirtualDir != null) {
            this.filteredVariables.setVariable("APACHEPHP_VIRTUAL_DIRECTORY", this.pnlVirtualDir.getContext());
            this.putToSummary(this.parent.langpack.getString("WindowsServicePanel.VirtualDir"), this.pnlVirtualDir.getContext(), 2);
        }
    }

    @Override
    public boolean isValidated() {
        if (GraphicsEnvironment.isHeadless()) {
            this.selectedConf = this.txtSelectedHttpd.getText();
        } else if (this.txtSelectedHttpd != null && (this.selectedConf.length() == 0 && this.txtSelectedHttpd.getText().length() > 0 || !this.selectedConf.equalsIgnoreCase(this.txtSelectedHttpd.getText()))) {
            this.selectedConf = this.txtSelectedHttpd.getText();
        }
        if (!"true".equalsIgnoreCase(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"))) {
            if (this.selectedConf.length() == 0) {
                this.emitError(this.parent.langpack.getString("ApachePanel.emptyFieldsTitle"), this.parent.langpack.getString("ApachePanel.emptyFields"));
                this.txtSelectedHttpd.requestFocus();
                return false;
            }
            if (!new File(this.selectedConf).exists()) {
                this.emitError(this.parent.langpack.getString("ApachePanel.file_open_title"), this.parent.langpack.getString("ApachePanel.notExistFields"));
                this.txtSelectedHttpd.requestFocus();
                return false;
            }
            if (!new File(this.selectedConf).canWrite()) {
                this.emitError(this.parent.langpack.getString("ApachePanel.file_open_title"), this.parent.langpack.getString("ApachePanel.cantWriteFields"));
                this.txtSelectedHttpd.requestFocus();
                return false;
            }
            JComponent reselecet = null;
            reselecet = this.pnlVirtualDir.isValidated();
            if (this.pnlVirtualDir != null && reselecet != null) {
                reselecet.requestFocus();
                return false;
            }
            String virtualDir = this.pnlVirtualDir.getContext();
            int check = this.checkApache(this.selectedConf, virtualDir);
            if (check != -1) {
                int askQuestion = 47;
                switch (check) {
                    case 1: {
                        askQuestion = this.askQuestion(this.parent.langpack.getString("ApachePanel.containsCC.title"), this.parent.langpack.getString("ApachePanel.containsCC.msg", new String[]{this.selectedConf, virtualDir}), 37, 49);
                        break;
                    }
                    case 3: {
                        askQuestion = this.askQuestion(this.parent.langpack.getString("ApachePanel.containsAlias.title"), this.parent.langpack.getString("ApachePanel.containsAlias.msg", new String[]{this.selectedConf, virtualDir}), 37, 49);
                        break;
                    }
                    case 2: {
                        this.emitNotification(this.parent.langpack.getString("ApachePanel.warnCC.title"), this.parent.langpack.getString("ApachePanel.warnCC.msg", new String[]{this.selectedConf, virtualDir}));
                        break;
                    }
                    case 4: {
                        this.emitNotification(this.parent.langpack.getString("ApachePanel.warnAlias.title"), this.parent.langpack.getString("ApachePanel.warnAlias.msg", new String[]{this.selectedConf, virtualDir}));
                    }
                }
                if (askQuestion != 47) {
                    this.pnlVirtualDir.getContextBox().requestFocus();
                    return false;
                }
            }
        }
        this.panelFinish();
        return super.isValidated();
    }

    private int checkApache(String fileName, String virtualDirectory) {
        try {
            FileReader reader = new FileReader(fileName);
            BufferedReader r2 = new BufferedReader(reader);
            String line = r2.readLine();
            int i2 = 1;
            while (line != null) {
                int rtValue = this.lineChecker(line, i2, virtualDirectory);
                if (rtValue > 0) {
                    return rtValue;
                }
                line = r2.readLine();
                ++i2;
            }
        }
        catch (Exception e2) {
            Debug.error(e2, this.getClass());
        }
        return -1;
    }

    protected int lineChecker(String line, int i2, String virtualDirectory) {
        String commentRex = "### *i-net *Clear Reports *\\Q" + virtualDirectory + "\\E *START";
        String commentRexLC = "### *i-net *" + "Clear Reports".toLowerCase() + " *\\Q" + virtualDirectory.toLowerCase() + "\\E *start";
        String aliasRex = "Alias */\\Q" + virtualDirectory + "\\E/.*";
        String aliasRexLC = "alias */\\Q" + virtualDirectory.toLowerCase() + "\\E/.*";
        if (line.matches(commentRex)) {
            Debug.log((Object)("CC " + i2 + " " + line), this.getClass());
            return 1;
        }
        if (line.matches(aliasRex)) {
            Debug.log((Object)("Alias " + i2 + " " + line), this.getClass());
            return 3;
        }
        if (line.toLowerCase().matches(commentRexLC)) {
            Debug.log((Object)("cc " + i2 + " " + line), this.getClass());
            return 2;
        }
        if (line.toLowerCase().matches(aliasRexLC)) {
            Debug.log((Object)("alias " + i2 + " " + line), this.getClass());
            return 4;
        }
        return 0;
    }

    @Override
    public JPanel initPanelGUI() {
        JPanel localPanel = new JPanel();
        localPanel.setLayout(new GridBagLayout());
        if ("true".equalsIgnoreCase(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"))) {
            String introText = this.parent.langpack.getString("ApachePanel.infoRemote");
            localPanel.add((Component)new JLabel(ApachePanel.getMultilineLabel(introText)), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, GUIUtils.INSETS_TOP, 0, 0));
            localPanel.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, GUIUtils.INSETS_NULL, 0, 0));
            return localPanel;
        }
        this.pnlSelectHTTPD = !OsVersion.IS_WINDOWS ? this.createHTTPDUnix(this.parent.langpack.getString("ApachePanel.intro"), this.parent.langpack.getString("ApachePanel.info")) : this.createHTTPDWindows(this.parent.langpack.getString("ApachePanel.introWindows"), this.parent.langpack.getString("ApachePanel.infoWindows"));
        this.pnlVirtualDir = new ContextPanel(this.parent, this.filteredVariables.getVariable("APACHEPHP_VIRTUAL_DIRECTORY"), this.parent.langpack.getString("ApachePanel.virtualDir"), this, this.parent.langpack.getString("ApachePanel.noVirtualDir.msg"));
        localPanel.add((Component)this.pnlSelectHTTPD, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, GUIUtils.TITLED_INSETS_TOP, 0, 0));
        localPanel.add((Component)this.pnlVirtualDir, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        localPanel.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, GUIUtils.INSETS_NULL, 0, 0));
        if (this.btnBrowse != null && this.btnSearch != null) {
            this.recalcWidthForComponent(this.btnBrowse, this.btnSearch);
        }
        return localPanel;
    }

    private JPanel createHTTPDHeadless() {
        JPanel pnl = new JPanel();
        this.txtSelectedHttpd = new JTextField(this.filteredVariables.getVariable("APACHEPHP_CONF_PATH"));
        JLabel lblhttpd = new JLabel(this.parent.langpack.getString("ApachePanel.httpdSelectionText"));
        lblhttpd.setLabelFor(this.txtSelectedHttpd);
        pnl.add(lblhttpd);
        pnl.add(this.txtSelectedHttpd);
        return pnl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JPanel createHTTPDUnix(String introText, String infoText) {
        if (GraphicsEnvironment.isHeadless()) {
            return this.createHTTPDHeadless();
        }
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString("ApachePanel.httpdSearch")));
        this.listTable = new JList(new DefaultListModel());
        this.listTable.setName("ApachePanel_listTable");
        this.listTable.setSelectionMode(0);
        this.listTable.addListSelectionListener(this);
        this.listTable.setMinimumSize(new Dimension(100, 100));
        JScrollPane scrollPane = new JScrollPane(this.listTable);
        scrollPane.setMinimumSize(new Dimension(100, 100));
        for (int i2 = 0; i2 < this.possiblePaths.length; ++i2) {
            try {
                if (!new File(this.possiblePaths[i2]).exists()) continue;
                ((DefaultListModel)this.listTable.getModel()).addElement(this.possiblePaths[i2]);
                continue;
            }
            catch (Throwable thr) {
                thr.printStackTrace();
                continue;
            }
            finally {
                if (this.listTable.getModel().getSize() > 0) {
                    this.listTable.setSelectedIndex(0);
                }
            }
        }
        this.btnSearch = new JButton(this.parent.langpack.getString("ApachePanel.automatic_search_button"));
        this.btnSearch.setName("ApachePanel_btnSearch");
        this.btnSearch.addActionListener(this);
        this.btnBrowseLinux = ButtonFactory.createButton(this.parent.langpack.getString("ApachePanel.browse"), this.parent.icons.getImageIcon("open"), this.idata.buttonsHColor);
        this.btnBrowseLinux.setName("ApachePanel_btnBrowseLinux");
        this.btnBrowseLinux.addActionListener(this);
        pnl.add((Component)new JLabel(ApachePanel.getMultilineLabel(introText)), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 11, 2, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        pnl.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 12, 1, GUIUtils.removeGap(GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 3, 10), 0, 0));
        pnl.add((Component)this.btnBrowseLinux, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        pnl.add((Component)this.btnSearch, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 12, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        pnl.add((Component)new JLabel(ApachePanel.getMultilineLabel(infoText)), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 11, 2, GUIUtils.COMPONENT_INSETS_BOTTOM, 0, 0));
        return pnl;
    }

    private JPanel createHTTPDWindows(String introText, String infoText) {
        if (GraphicsEnvironment.isHeadless()) {
            return this.createHTTPDHeadless();
        }
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString("ApachePanel.httpdSelection")));
        this.txtSelectedHttpd = new JTextField(this.filteredVariables.getVariable("APACHEPHP_CONF_PATH"));
        this.txtSelectedHttpd.setName("ApachePanel_txtSelectedHttpd");
        this.btnBrowse = ButtonFactory.createButton(this.parent.langpack.getString("ApachePanel.browse"), this.parent.icons.getImageIcon("open"), this.idata.buttonsHColor);
        this.btnBrowse.setName("ApachePanel_btnBrowse");
        this.btnBrowse.addActionListener(this);
        pnl.add((Component)new JLabel(ApachePanel.getMultilineLabel(introText)), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 11, 2, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        pnl.add((Component)this.txtSelectedHttpd, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, GUIUtils.removeGap(GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 3, 10), 0, 0));
        pnl.add((Component)this.btnBrowse, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 18, 2, GUIUtils.removeGap(GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 1, 10), 0, 0));
        pnl.add((Component)new JLabel(ApachePanel.getMultilineLabel(infoText)), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 11, 2, GUIUtils.COMPONENT_INSETS_BOTTOM, 0, 0));
        return pnl;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.btnSearch) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                Process p2 = Runtime.getRuntime().exec("locate -q -r httpd.conf$");
                BufferedInputStream input = new BufferedInputStream(p2.getInputStream());
                byte[] in = new byte[1];
                String read = "";
                while (input.read(in) > -1) {
                    read = read + new String(in);
                }
                StringTokenizer token = new StringTokenizer(read, "\n");
                while (token.hasMoreTokens()) {
                    DefaultListModel defaultListModel;
                    String file = token.nextToken();
                    if (!file.endsWith("httpd.conf") || this.listTable == null || (defaultListModel = (DefaultListModel)this.listTable.getModel()).contains(file)) continue;
                    defaultListModel.addElement(file);
                }
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                this.setCursor(Cursor.getDefaultCursor());
                this.emitError(this.parent.langpack.getString("installer.error"), ex2.getMessage());
            }
            this.setCursor(Cursor.getDefaultCursor());
        } else if (e2.getSource() == this.btnBrowse) {
            File f2;
            JFileChooser fc2 = new JFileChooser();
            fc2.setLocale(Locale.getDefault());
            fc2.updateUI();
            fc2.setMultiSelectionEnabled(false);
            fc2.setFileSelectionMode(0);
            fc2.addChoosableFileFilter(new HttpdFilter());
            File selected = new File(this.txtSelectedHttpd.getText());
            if (selected.getParent() != null) {
                fc2.setCurrentDirectory(selected.getParentFile());
                fc2.setSelectedFile(selected);
            }
            fc2.setVisible(true);
            if (fc2.showOpenDialog(this) == 0 && (f2 = fc2.getSelectedFile()) != null) {
                this.txtSelectedHttpd.setText(f2.getAbsolutePath());
                this.selectedConf = f2.getAbsolutePath();
            }
        } else if (e2.getSource() == this.btnBrowseLinux && this.listTable != null) {
            File f3;
            JFileChooser fc3 = new JFileChooser();
            fc3.setLocale(Locale.getDefault());
            fc3.updateUI();
            fc3.setMultiSelectionEnabled(false);
            fc3.setFileSelectionMode(0);
            fc3.addChoosableFileFilter(new HttpdFilter());
            File selected = new File(this.listTable.getSelectedIndex() == -1 ? "" : (String)this.listTable.getSelectedValue());
            if (selected.getParent() != null) {
                fc3.setCurrentDirectory(selected.getParentFile());
                fc3.setSelectedFile(selected);
            }
            fc3.setVisible(true);
            if (fc3.showOpenDialog(this) == 0 && (f3 = fc3.getSelectedFile()) != null && this.listTable != null) {
                DefaultListModel defaultListModel = (DefaultListModel)this.listTable.getModel();
                if (!defaultListModel.contains(f3.getAbsolutePath())) {
                    defaultListModel.addElement(f3.getAbsolutePath());
                }
                this.selectedConf = f3.getAbsolutePath();
                this.listTable.setSelectedIndex(this.listTable.getLastVisibleIndex());
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e2) {
        if (this.listTable.getSelectedValue() != null) {
            this.selectedConf = this.listTable.getSelectedValue().toString().trim();
        }
    }

    private class HttpdFilter
    extends FileFilter {
        private HttpdFilter() {
        }

        @Override
        public boolean accept(File f2) {
            return f2.isDirectory() || f2.getName().equalsIgnoreCase("httpd.conf");
        }

        @Override
        public String getDescription() {
            return "httpd.conf";
        }
    }
}

