/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.setup.Constants;
import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.util.JsonCreator;
import com.inet.setup.panels.widget.GeneralConfigPanel;
import com.inet.setup.panels.widget.LoginConfigPanel;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.Debug;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CCConfigPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private JPanel localPanel;
    private GeneralConfigPanel pnlGeneralConfig;
    private LoginConfigPanel pnlRemoteInterface;
    private JLabel lblEditConfig;
    private FilteredVariables filteredVariables;
    private Configuration config;
    private String chosenConfigId;
    private String masterPassword = "";
    private boolean oldPasswordExists;
    private LocalBehavior localBehavior = new LocalBehavior();

    public CCConfigPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("CCConfigPanel.heading"), null, null, "com/inet/setup/images/Database48.png");
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("SERVICE_INSTALL_PORT", null);
        requiredVariables.put("APACHEPHP_INSTALL_PORT", null);
        requiredVariables.put("ADD_TO_CONFIG", null);
        requiredVariables.put("SELECTED", null);
        requiredVariables.put("SELECTED_PROPERTY", null);
        requiredVariables.put("SCOPE_NAME", null);
        requiredVariables.put("CONFIG_NAME", null);
        requiredVariables.put("INSTALL_PATH", null);
        requiredVariables.put("REMOTE_ADMIN_PASSWORD", null);
        requiredVariables.put("SCOPE_CONFIG", null);
        requiredVariables.put("CONFIG_NAME_XML", null);
        requiredVariables.put("SERVLET_REMOTE_INSTALL", null);
        return requiredVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void panelActivate() {
        boolean configIsNewOrChanged;
        block32: {
            this.idata.getStatHandler().notifyPanelActivation(this);
            this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
            String variable = this.filteredVariables.getVariable("INSTALL_PATH");
            if (variable != null) {
                this.oldPasswordExists = new File(variable, "remotelogin.xml").exists();
            }
            super.panelActivate();
            boolean isServer = this.idata.getRules().isConditionTrue("izpack.selected.CCRunTime") || this.idata.getRules().isConditionTrue("izpack.selected.CCService") || this.idata.getRules().isConditionTrue("izpack.selected.CCDeamon") || this.idata.getRules().isConditionTrue("izpack.selected.CCIIS") || this.idata.getRules().isConditionTrue("izpack.selected.CCApache");
            this.pnlGeneralConfig.setServerInstallation(isServer);
            configIsNewOrChanged = true;
            this.pnlRemoteInterface.updateCmbboxPermissionLogin(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"), this.idata.getRules().isConditionTrue("installservlet"));
            try {
                ConfigurationManager configManager = ConfigurationManager.getInstance();
                String scopeName = this.filteredVariables.getVariable("SCOPE_NAME");
                int scope = Constants.getScopeValue(scopeName);
                String selectedConfigImport = this.filteredVariables.getVariable("SELECTED");
                this.pnlRemoteInterface.setSelectedConfigAction(selectedConfigImport);
                this.pnlRemoteInterface.setServletInstallationFlag(this.idata.getRules().isConditionTrue("installservlet"));
                if (selectedConfigImport.equalsIgnoreCase("CREATE_FROM_LOCAL")) {
                    String selectedProperty = this.filteredVariables.getVariable("SELECTED_PROPERTY");
                    String[] split = selectedProperty.split("::");
                    configIsNewOrChanged = !split[1].equals(this.chosenConfigId);
                    this.chosenConfigId = split[1];
                    this.config = configManager.get(Constants.getScopeValue(split[0]), split[1]);
                    break block32;
                }
                if (selectedConfigImport.equalsIgnoreCase("CREATE_FROM_PROPS")) {
                    this.config = null;
                    String selectedProperty = this.filteredVariables.getVariable("SELECTED_PROPERTY");
                    configIsNewOrChanged = !selectedProperty.equals(this.chosenConfigId);
                    this.chosenConfigId = selectedProperty;
                    Properties properties = new Properties();
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(selectedProperty);
                        properties.load(fis);
                        if (!properties.isEmpty() && configIsNewOrChanged) {
                            this.pnlGeneralConfig.setActivateRemote(String.valueOf(Boolean.TRUE).equalsIgnoreCase(properties.getProperty("remoteInterface.enabled")));
                            if (properties.getProperty("permission.loginurl").length() > 0) {
                                this.pnlRemoteInterface.setLoginURL(properties.getProperty("permission.loginurl"));
                            }
                            if (properties.getProperty("listener.port").length() > 0) {
                                this.pnlGeneralConfig.setPort(properties.getProperty("listener.port"));
                            }
                        }
                        break block32;
                    }
                    catch (Throwable e2) {
                        break block32;
                    }
                    finally {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (IOException e3) {
                            Debug.error(e3, this.getClass());
                        }
                    }
                }
                if (selectedConfigImport.equalsIgnoreCase("CREATE_NEW")) {
                    configIsNewOrChanged = !"CreateNew".equals(this.chosenConfigId);
                    this.chosenConfigId = "CreateNew";
                    if (configIsNewOrChanged) {
                        this.pnlGeneralConfig.setActivateRemote(Boolean.TRUE);
                        this.pnlRemoteInterface.setLoginURL(null);
                        this.pnlGeneralConfig.setPort("9000");
                    }
                } else {
                    String name = this.filteredVariables.getVariable("CONFIG_NAME");
                    configIsNewOrChanged = !name.equals(this.chosenConfigId);
                    this.chosenConfigId = name;
                    this.config = configManager.get(scope, this.chosenConfigId);
                }
            }
            catch (Exception e4) {
                // empty catch block
            }
        }
        if (this.config != null && configIsNewOrChanged) {
            if (this.config.get("listener.port") != null && this.config.get("listener.port").length() > 0) {
                this.pnlGeneralConfig.setPort(this.config.get("listener.port"));
            }
            if (this.config.get("remoteInterface.enabled") != null) {
                this.pnlGeneralConfig.setActivateRemote(String.valueOf(Boolean.TRUE).equalsIgnoreCase(this.config.get("remoteInterface.enabled")));
            } else {
                this.pnlGeneralConfig.setActivateRemote(Boolean.TRUE);
            }
            if (this.config.get("permission.loginurl") != null && this.config.get("permission.loginurl").length() > 0) {
                this.pnlRemoteInterface.setLoginURL(this.config.get("permission.loginurl"));
            }
            if (this.config.get("adhoc.enabled") != null && this.config.get("adhoc.enabled").length() > 0 && !GraphicsEnvironment.isHeadless()) {
                this.pnlGeneralConfig.setAdhocSelected(String.valueOf(Boolean.TRUE).equalsIgnoreCase(this.config.get("adhoc.enabled")));
            } else {
                this.pnlGeneralConfig.setAdhocSelected(Boolean.TRUE);
            }
            if (this.config.get("permission.logintype") != null && this.config.get("permission.logintype").length() > 0) {
                this.pnlRemoteInterface.setPermissionType(this.config.get("permission.logintype"));
            } else {
                this.pnlRemoteInterface.setPermissionType("automatic");
            }
        }
    }

    public void panelFinish() {
        String variable = this.filteredVariables.getVariable("ADD_TO_CONFIG");
        HashMap<Object, Object> map = null;
        if (variable != null && variable.trim().length() > 0) {
            try {
                map = JsonCreator.createMapFromJson(variable);
            }
            catch (IllegalArgumentException iae) {
                map = new HashMap();
            }
            catch (NullPointerException npe) {
                map = new HashMap();
            }
        } else {
            map = new HashMap<String, String>();
        }
        map.put("remoteInterface.enabled", this.pnlGeneralConfig.isActivateRemote() ? "true" : "false");
        if (GraphicsEnvironment.isHeadless()) {
            map.put("remoteInterface.ipfilter", this.pnlRemoteInterface.getIPFilter());
        }
        map.put("adhoc.enabled", this.pnlGeneralConfig.isAdhocSelected() ? "true" : "false");
        map.put("permission.logintype", this.pnlRemoteInterface.getPermissionType());
        String loginURL = this.pnlRemoteInterface.getLoginURL();
        if (loginURL != null && this.pnlRemoteInterface.isLoginURLEnabled()) {
            map.put("permission.loginurl", loginURL);
        }
        if (this.pnlGeneralConfig.isServerInstallation()) {
            this.filteredVariables.setVariable("SERVICE_INSTALL_PORT", this.pnlGeneralConfig.getPort());
            this.filteredVariables.setVariable("APACHEPHP_INSTALL_PORT", this.pnlGeneralConfig.getPort());
            this.putToSummary(this.parent.langpack.getString("CCConfigPanel.port"), this.filteredVariables.getVariable("SERVICE_INSTALL_PORT"), 0);
            map.put("listener.port", this.pnlGeneralConfig.isEnabled() ? this.pnlGeneralConfig.getPort() : "9000");
        }
        this.filteredVariables.setVariable("ADD_TO_CONFIG", JsonCreator.createJsonFromMap(map));
        this.filteredVariables.setVariable("REMOTE_ADMIN_PASSWORD", this.masterPassword);
        this.filteredVariables.setVariable("SCOPE_CONFIG", this.filteredVariables.getVariable("SCOPE_NAME") + "/" + this.filteredVariables.getVariable("CONFIG_NAME_XML"));
        if (GraphicsEnvironment.isHeadless()) {
            this.putToSummary(this.parent.langpack.getString("IPFilterPanel.remoteIPFilter"), this.pnlRemoteInterface.getIPFilter(), 2);
        }
        this.putToSummary(this.parent.langpack.getString("CCConfigPanel.permission.login"), this.pnlRemoteInterface.getPermissionTypeI18N(), 3);
        this.putToSummary(this.parent.langpack.getString("CCConfigPanel.remoteServletUrl"), loginURL, 4);
        this.putToSummary(this.parent.langpack.getString("CCConfigPanel.remote.activate.long"), this.pnlGeneralConfig.isActivateRemote() ? this.parent.langpack.getString("installer.yes") : this.parent.langpack.getString("installer.no"), 1);
        this.putToSummary(this.parent.langpack.getString("AdhocActivationPanel.activateAdhoc"), this.pnlGeneralConfig.isAdhocSelected() ? this.parent.langpack.getString("installer.yes") : this.parent.langpack.getString("installer.no"), 6);
    }

    @Override
    public boolean isValidated() {
        JComponent reselecet = null;
        reselecet = this.pnlGeneralConfig.isValidated();
        if (this.pnlGeneralConfig != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        reselecet = this.pnlRemoteInterface.isValidated();
        if (this.pnlRemoteInterface != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        this.masterPassword = this.pnlRemoteInterface.getMasterPassword();
        this.panelFinish();
        return super.isValidated();
    }

    @Override
    public JPanel initPanelGUI() {
        this.localPanel = new JPanel();
        this.localPanel.setBorder(BorderFactory.createEmptyBorder());
        this.localPanel.setLayout(new GridBagLayout());
        this.lblEditConfig = new JLabel(this.parent.langpack.getString("CCConfigPanel.additional.config"));
        this.pnlGeneralConfig = new GeneralConfigPanel(this.parent, "9000", this);
        this.pnlGeneralConfig.setName("pnlGeneralConfig");
        this.pnlGeneralConfig.addActionListener(this.localBehavior);
        this.pnlRemoteInterface = new LoginConfigPanel(this.parent, this, this.oldPasswordExists, this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"), this.filteredVariables.getVariable("INSTALL_PATH"), this.filteredVariables.getVariable("SELECTED"), this.idata.getRules().isConditionTrue("installservlet"));
        this.pnlRemoteInterface.setName("pnlRemoteInterface");
        this.localPanel.add((Component)this.lblEditConfig, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.INSETS_TOP_HALF, 0, 0));
        this.localPanel.add((Component)this.pnlGeneralConfig, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.localPanel.add((Component)this.pnlRemoteInterface, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.localPanel.add((Component)new JPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 1, GUIUtils.INSETS_BOTTOM, 0, 0));
        this.recalcWidthForComponent(this.pnlGeneralConfig.getComponentsForWidthCalculation(), this.pnlRemoteInterface.getComponentsForWidthCalculation());
        return this.localPanel;
    }

    private class LocalBehavior
    implements ActionListener {
        private LocalBehavior() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (e2.getSource().equals(CCConfigPanel.this.pnlGeneralConfig)) {
                String actionCommand = e2.getActionCommand();
                if (Boolean.parseBoolean(actionCommand)) {
                    CCConfigPanel.this.pnlRemoteInterface.setEnabled(true);
                } else {
                    CCConfigPanel.this.pnlRemoteInterface.setEnabled(false);
                }
            }
        }
    }
}

