/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.lib.util.PreferencesUtils;
import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.util.Hyperactive;
import com.inet.setup.panels.util.JHyperLink;
import com.inet.setup.panels.widget.ReadmeFactory;
import com.inet.setup.panels.widget.StartOption;
import com.inet.setup.panels.widget.StartOptionsListPanel;
import com.inet.textui.Group;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackHandler;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;

public class CCFinishPanel
extends AbstractPanel
implements ItemListener {
    static final String SERVER_STARTER;
    static final String DESIGNER_STARTER;
    private Runnable registerDesigner = new Runnable(){

        @Override
        public void run() {
            CCFinishPanel.this.setUpdateDesignerValue(true);
        }
    };
    private Runnable unregisterDesigner = new Runnable(){

        @Override
        public void run() {
            CCFinishPanel.this.setUpdateDesignerValue(false);
        }
    };
    private Runnable startServer = new Runnable(){

        @Override
        public void run() {
            try {
                URL url = new URL("HTTP", "localhost", Integer.parseInt(CCFinishPanel.this.idata.getVariable("SERVICE_INSTALL_PORT")), "");
                if (!CCFinishPanel.this.testURL(url)) {
                    CCFinishPanel.this.startListener();
                } else {
                    CCFinishPanel.this.emitNotification(null, ((CCFinishPanel)CCFinishPanel.this).parent.langpack.getString("FinishPanel.standaloneIsRunning.msg"));
                }
                int count = 0;
                boolean sucStart = true;
                while (!CCFinishPanel.this.testURL(url)) {
                    if (count > 20) {
                        sucStart = false;
                        break;
                    }
                    try {
                        Thread.sleep(500L);
                        ++count;
                    }
                    catch (InterruptedException ex2) {}
                }
                if (sucStart) {
                    CCFinishPanel.this.openDocument(url);
                }
            }
            catch (MalformedURLException ex3) {
                CCFinishPanel.this.emitError("ERROR", ex3.toString());
                Debug.error(ex3, this.getClass());
            }
            catch (IOException ex4) {
                CCFinishPanel.this.emitError("ERROR", ex4.toString());
                Debug.error(ex4, this.getClass());
            }
        }
    };
    private Runnable startCM = new Runnable(){

        @Override
        public void run() {
            try {
                CCFinishPanel.this.startConfigManager();
            }
            catch (IOException e1) {
                Debug.error(e1, this.getClass());
            }
        }
    };
    private Runnable startDesigner = new Runnable(){

        @Override
        public void run() {
            try {
                CCFinishPanel.this.startDesigner();
            }
            catch (IOException e1) {
                CCFinishPanel.this.emitError("ERROR", e1.toString());
                Debug.error(e1, this.getClass());
            }
        }
    };
    private File readmeFile = null;
    private Runnable openReadme = new Runnable(){

        @Override
        public void run() {
            if (CCFinishPanel.this.readmeFile != null && CCFinishPanel.this.readmeFile.exists()) {
                try {
                    CCFinishPanel.this.openDocument(CCFinishPanel.this.readmeFile.toURI().toURL());
                    Thread.sleep(500L);
                }
                catch (MalformedURLException ex2) {
                    CCFinishPanel.this.emitError("ERROR", ex2.toString());
                    Debug.error(ex2, this.getClass());
                }
                catch (InterruptedException ex3) {
                    CCFinishPanel.this.emitError("ERROR", ex3.toString());
                    Debug.error(ex3, this.getClass());
                }
            } else {
                Debug.log((Object)"readme file was not generated!", this.getClass());
            }
        }
    };
    private static final long serialVersionUID = 3891324564274584122L;
    private FilteredVariables filteredVariables;
    private StartOptionsListPanel pnlStartOptions;
    private Pack packByID;
    private Pack packByName;
    private JCheckBox startConfigManager;
    private JCheckBox startListener;

    public CCFinishPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("CCFinishPanel.heading"), null, null, "com/inet/setup/images/Success48.png");
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("INSTALL_PATH", null);
        requiredVariables.put("SERVICE_INSTALL_PORT", null);
        requiredVariables.put("SELECTED", null);
        requiredVariables.put("INSTALLDATE", null);
        requiredVariables.put("INSTALLPATH", null);
        requiredVariables.put("INSTALLVERSION", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
        if (this.idata.installSuccess) {
            this.setPanelIcon("com/inet/setup/images/Success48.png");
        } else {
            this.setPanelIcon("com/inet/setup/images/Abort48.png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void panelDeactivate() {
        try {
            this.createRegistryEntries();
        }
        catch (BackingStoreException e2) {
            Debug.error(e2);
        }
        try {
            this.createReadme();
            if (this.pnlStartOptions != null) {
                this.pnlStartOptions.runChosenOptions();
            }
            super.panelDeactivate();
        }
        finally {
            this.closeAndCopyLogFile(this.filteredVariables.getVariable("INSTALL_PATH"));
            this.deleteTmp(this.idata.getInstallPath() + File.separator + "setup_tmp/");
        }
    }

    private void createRegistryEntries() throws BackingStoreException {
        ArrayList<String> ignore = new ArrayList<String>();
        ignore.add("UNINSTALL_NAME".toLowerCase());
        ignore.add("modify.izpack.install".toLowerCase());
        ignore.add("ShowCreateDirectoryMessage".toLowerCase());
        ignore.add("DesktopShortcutCheckboxEnabled".toLowerCase());
        ignore.add("FILE_SEPARATOR".toLowerCase());
        ignore.add("APP_VER".toLowerCase());
        ignore.add("APP_URL".toLowerCase());
        ignore.add("APP_NAME".toLowerCase());
        ignore.add("CLASS_PATH".toLowerCase());
        Preferences pref = Preferences.userRoot();
        pref = pref.node("crinstallpreferences").node(this.filteredVariables.getVariable("INSTALLDATE"));
        pref.flush();
        pref.sync();
        pref.put("INSTALLDATE".toLowerCase(), this.filteredVariables.getVariable("INSTALLDATE"));
        pref.put("INSTALLPATH".toLowerCase(), this.filteredVariables.getVariable("INSTALLPATH"));
        pref.put("INSTALLVERSION".toLowerCase(), this.filteredVariables.getVariable("INSTALLVERSION"));
        Properties variables = this.idata.getVariables();
        Set<Object> keySet = variables.keySet();
        for (Object object : keySet) {
            String string = object.toString();
            if (ignore.contains(string.toLowerCase()) || string.toLowerCase().startsWith("system")) continue;
            String property = variables.getProperty(string);
            pref.put(string.toLowerCase(), property);
        }
        pref.flush();
        pref.sync();
    }

    private void createReadme() {
        try {
            ReadmeFactory remf = new ReadmeFactory(this.idata);
            this.readmeFile = remf.createResultingReadme();
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            Debug.log((Object)("exception while creating readme: " + t2.getMessage()), this.getClass());
        }
    }

    @Override
    public JPanel initPanelGUI() {
        JPanel localPanel = new JPanel();
        localPanel.setLayout(new GridBagLayout());
        if (this.idata.installSuccess) {
            this.idata.installSuccess = this.parent.getUnpacker().getResult();
        }
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.parent.langpack.getString("FinishPanel.done"));
        this.parent.setQuitButtonIcon("done");
        if (this.idata.installSuccess) {
            this.pnlStartOptions = new StartOptionsListPanel(this.parent.langpack, this.createOptions(this.parent.langpack, this.idata));
            localPanel.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.success"), this.parent.icons.getImageIcon("information"), 10), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 16, 2, GUIUtils.INSETS_TOP, 0, 0));
            localPanel.add((Component)this.pnlStartOptions, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
            Map<JCheckBox, StartOption> checkboxes = this.pnlStartOptions.getCheckboxes();
            Set<JCheckBox> keys = checkboxes.keySet();
            for (JCheckBox jCheckBox : keys) {
                if (checkboxes.get(jCheckBox).getText().equalsIgnoreCase(this.parent.langpack.getString("FinishPanel.startStandalone", new String[]{SERVER_STARTER}))) {
                    this.startListener = jCheckBox;
                    if (this.startListener != null) {
                        this.startListener.addItemListener(this);
                    }
                }
                if (!checkboxes.get(jCheckBox).getText().equalsIgnoreCase(this.parent.langpack.getString("FinishPanel.startConfig"))) continue;
                this.startConfigManager = jCheckBox;
                if (this.startConfigManager == null) continue;
                this.startConfigManager.addItemListener(this);
            }
            if (this.startConfigManager != null) {
                if (this.startListener != null && this.startListener.isVisible() && this.startConfigManager.isVisible()) {
                    this.startConfigManager.setEnabled(this.startListener.isSelected());
                } else {
                    this.startConfigManager.setEnabled(true);
                }
            }
        } else {
            localPanel.add((Component)this.createFailPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        }
        return localPanel;
    }

    private JPanel createFailPanel() {
        StringBuilder b2;
        Exception exception;
        JLabel lbl;
        JPanel p2;
        Debug.log("===============================================");
        Debug.log("==================SETUP ERROR==================");
        Debug.log("===============================================");
        JPanel pnlFail = new JPanel(new GridBagLayout());
        pnlFail.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel lblFailHeading = new JLabel(this.parent.langpack.getString("FinishPanel.fail"), 10);
        lblFailHeading.setFont(new Font(lblFailHeading.getFont().getName(), 1, lblFailHeading.getFont().getSize()));
        JLabel lblFailText = new JLabel(this.parent.langpack.getString("FinishPanel.componentlist"), 10);
        JHyperLink lblHyperlink = new JHyperLink(this.parent.langpack.getString("FinishPanel.s2"));
        lblHyperlink.addActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent e2) {
                URL url = null;
                try {
                    url = new URL("mailto:ClearReports@inetsoftware.de");
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                if (OsVersion.IS_WINDOWS) {
                    try {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler mailto:ClearReports@inetsoftware.de");
                        return;
                    }
                    catch (Exception exception) {}
                    return;
                }
                if (OsVersion.IS_LINUX) {
                    String[] browserprocesses = new String[]{"thunderbird " + url.toString(), "evolution " + url.toString(), "gnome-open " + url.toString(), "kfmclient exec " + url.toString(), "sensible-browser " + url.toString(), "x-www-browser " + url.toString(), "netscape -remote openURL(" + url.toString() + ")", "netscape " + url.toString(), "firefox " + url.toString(), "opera " + url.toString(), "konqueror " + url.toString(), "epiphany " + url.toString(), "mozilla " + url.toString()};
                    for (int p2 = 0; p2 < browserprocesses.length; ++p2) {
                        try {
                            Process process = Runtime.getRuntime().exec(browserprocesses[p2]);
                            int exitCode = process.waitFor();
                            if (exitCode != 0) continue;
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return;
                }
                if (!OsVersion.IS_MAC) return;
                try {
                    Process process = Runtime.getRuntime().exec("open " + url.toString());
                    int exitCode = process.waitFor();
                    if (exitCode == 0) return;
                    Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                    Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, url);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JPanel pnlPackList = new JPanel();
        pnlPackList.setLayout(new BoxLayout(pnlPackList, 1));
        Map<Object, Exception> notSuccessfullInstalledPacks = this.idata.getNotSuccessfullInstalledPacks();
        Set<Object> keySet = notSuccessfullInstalledPacks.keySet();
        int counter = 0;
        ArrayList<Pack> packError = new ArrayList<Pack>();
        ArrayList<Object> nonPackError = new ArrayList<Object>();
        for (Object object : keySet) {
            if (object instanceof Pack) {
                packError.add((Pack)object);
                continue;
            }
            if (object instanceof String) {
                String packID = (String)object;
                this.packByID = PackHandler.getPack(packID);
                if (this.packByID != null) {
                    packError.add(this.packByID);
                    continue;
                }
                this.packByName = PackHandler.getPackByName(packID);
                if (this.packByName != null) {
                    packError.add(this.packByName);
                    continue;
                }
                nonPackError.add(packID);
                continue;
            }
            nonPackError.add(object);
        }
        for (Pack currentPack : PackHandler.getSelectedPacks()) {
            p2 = new JPanel();
            p2.setLayout(new BoxLayout(p2, 0));
            p2.setOpaque(true);
            p2.setBackground(++counter % 2 == 0 ? GUIUtils.BRIGTHER : GUIUtils.DARKER);
            p2.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            lbl = LabelFactory.create(this.parent.langpack.getString(currentPack.id), 10);
            if (packError.contains(currentPack)) {
                lbl.setFont(new Font(lblFailHeading.getFont().getName(), 1, lblFailHeading.getFont().getSize()));
                lbl.setForeground(Color.RED);
                exception = notSuccessfullInstalledPacks.get(currentPack);
                Debug.log("ERROR IN: " + currentPack.id);
                if (exception == null && (exception = notSuccessfullInstalledPacks.get(currentPack.id)) == null) {
                    exception = notSuccessfullInstalledPacks.get(currentPack.name);
                }
                if (exception != null && exception.getMessage() != null && exception.getCause() != null) {
                    Debug.log(exception);
                    b2 = new StringBuilder();
                    b2.append("<html><p>");
                    b2.append(exception.getMessage() != null ? exception.getMessage() + "</p><p>" : "");
                    b2.append(exception.getCause() != null ? exception.getCause() : "").append("</p></html>");
                    ToolTipManager.sharedInstance().setInitialDelay(10);
                    ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
                    p2.setToolTipText(b2.toString());
                }
            }
            p2.add(lbl);
            p2.add(Box.createHorizontalGlue());
            pnlPackList.add(p2);
        }
        for (Object object : nonPackError) {
            p2 = new JPanel();
            p2.setLayout(new BoxLayout(p2, 0));
            p2.setOpaque(true);
            p2.setBackground(++counter % 2 == 0 ? GUIUtils.BRIGTHER : GUIUtils.DARKER);
            p2.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            lbl = LabelFactory.create(object.toString(), 10);
            lbl.setFont(new Font(lblFailHeading.getFont().getName(), 1, lblFailHeading.getFont().getSize()));
            lbl.setForeground(Color.RED);
            exception = notSuccessfullInstalledPacks.get(object);
            Debug.log("ERROR IN: " + object);
            if (exception != null) {
                Debug.log(exception);
                b2 = new StringBuilder();
                b2.append("<html><p>");
                b2.append(exception.getMessage() != null ? exception.getMessage() + "</p><p>" : "");
                b2.append(exception.getCause() != null ? exception.getCause() : "").append("</p></html>");
                ToolTipManager.sharedInstance().setInitialDelay(10);
                ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
                p2.setToolTipText(b2.toString());
            }
            p2.add(lbl);
            p2.add(Box.createHorizontalGlue());
            pnlPackList.add(p2);
        }
        JScrollPane scrollPackList = new JScrollPane(pnlPackList);
        scrollPackList.getVerticalScrollBar().setUnitIncrement(10);
        scrollPackList.getVerticalScrollBar().setUnitIncrement(10);
        JPanel pnlContactUs = new JPanel(new GridBagLayout());
        pnlContactUs.setBorder(new EmptyBorder(0, 0, 0, 0));
        pnlContactUs.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.s1") + " "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, GUIUtils.INSETS_NULL, 0, 0));
        pnlContactUs.add((Component)lblHyperlink, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, GUIUtils.INSETS_NULL, 0, 0));
        pnlContactUs.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 1, GUIUtils.INSETS_NULL, 0, 0));
        pnlContactUs.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.s3")), new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 0, GUIUtils.INSETS_NULL, 0, 0));
        pnlFail.add((Component)lblFailHeading, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_TOP_HALF, 0, 0));
        pnlFail.add((Component)lblFailText, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        pnlFail.add((Component)scrollPackList, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        pnlFail.add((Component)pnlContactUs, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_BOTTOM, 0, 0));
        return pnlFail;
    }

    protected Map<StartOption.OptionGroup, List<StartOption>> createOptions(final LocaleDatabase langpack, InstallData idataLocal) {
        final boolean condDesigner = idataLocal.getRules().isConditionTrue("izpack.selected.CCDesigner");
        final boolean condServer = idataLocal.getRules().isConditionTrue("izpack.selected.CCServer");
        final boolean condService = idataLocal.getRules().isConditionTrue("izpack.selected.CCService") || idataLocal.getRules().isConditionTrue("izpack.selected.CCDaemon");
        boolean initiallySelectDesignerAutoUpdate = true;
        try {
            String selectedConfigImport = this.filteredVariables.getVariable("SELECTED");
            if (selectedConfigImport == null || !selectedConfigImport.contains("CREATE")) {
                Preferences pref = PreferencesUtils.userRoot();
                String s2 = (pref = pref.node("com/inet/designer/prefs")).get("welcome_update", "true");
                if (s2 != null) {
                    initiallySelectDesignerAutoUpdate = Boolean.valueOf(s2);
                }
            }
        }
        catch (SecurityException e2) {
            // empty catch block
        }
        final boolean selectAutoUpdate = initiallySelectDesignerAutoUpdate;
        final ArrayList<StartOption> desOptions = new ArrayList<StartOption>(){
            {
                this.add(new StartOption(StartOption.OptionGroup.Designer, langpack.getString("FinishPanel.runNow", new String[]{DESIGNER_STARTER}), langpack.getString("FinishPanel.startDesigner.tip"), CCFinishPanel.this.startDesigner, null, false));
                this.add(new StartOption(StartOption.OptionGroup.Designer, langpack.getString("FinishPanel.autoupdateDesignerStartPage"), langpack.getString("FinishPanel.autoupdateDesignerStartPage.tip"), CCFinishPanel.this.registerDesigner, CCFinishPanel.this.unregisterDesigner, selectAutoUpdate));
            }
        };
        final ArrayList<StartOption> docOptions = new ArrayList<StartOption>(){
            {
                this.add(new StartOption(StartOption.OptionGroup.Documentation, langpack.getString("FinishPanel.openDoc"), langpack.getString("FinishPanel.openDoc.tip"), CCFinishPanel.this.openReadme, null, false));
            }
        };
        final ArrayList<StartOption> serOptions = new ArrayList<StartOption>(){
            {
                if (!condService) {
                    String port = CCFinishPanel.this.filteredVariables.getVariable("SERVICE_INSTALL_PORT");
                    this.add(new StartOption(StartOption.OptionGroup.Server, langpack.getString("FinishPanel.startStandalone", new String[]{SERVER_STARTER}), langpack.getString("FinishPanel.startStandalone.tip", new String[]{port}), CCFinishPanel.this.startServer, null, false));
                }
                this.add(new StartOption(StartOption.OptionGroup.Server, langpack.getString("FinishPanel.startConfig"), langpack.getString("FinishPanel.startConfig.tip"), CCFinishPanel.this.startCM, null, false));
            }
        };
        TreeMap<StartOption.OptionGroup, List<StartOption>> options = new TreeMap<StartOption.OptionGroup, List<StartOption>>(){
            {
                if (condDesigner) {
                    this.put(StartOption.OptionGroup.Designer, desOptions);
                }
                if (condServer) {
                    this.put(StartOption.OptionGroup.Server, serOptions);
                }
                this.put(StartOption.OptionGroup.Documentation, docOptions);
            }
        };
        return options;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i2 = 0; i2 < children.length; ++i2) {
                boolean success = CCFinishPanel.deleteDir(new File(dir, children[i2]));
                if (success) continue;
                return false;
            }
            dir.delete();
        } else {
            Debug.log(dir.getAbsolutePath());
            dir.delete();
        }
        return true;
    }

    private void deleteTmp(String delete_dir) {
        try {
            File dir = new File(delete_dir);
            if (dir.exists() && dir.canWrite()) {
                CCFinishPanel.deleteDir(dir);
            }
        }
        catch (Exception e2) {
            this.emitError(this.parent.langpack.getString("installer.error"), e2.getMessage());
            Debug.error(e2, this.getClass());
        }
    }

    @Override
    public Group getTextUiGroup() {
        this.createReadme();
        this.closeAndCopyLogFile(this.filteredVariables.getVariable("INSTALL_PATH"));
        String tmp = this.idata.getInstallPath() + File.separator + "setup_tmp";
        if (new File(tmp).exists()) {
            this.deleteTmp(tmp);
        }
        this.parent.writeUninstallData();
        Housekeeper.getInstance().shutDownWithoutExit();
        return null;
    }

    private void watchProcess(Process exec) throws IOException {
        int killCounter = 10;
        BufferedInputStream input = new BufferedInputStream(exec.getInputStream());
        while (killCounter > 0) {
            try {
                if (input.available() > 0) break;
                --killCounter;
                Thread.sleep(50L);
            }
            catch (InterruptedException e2) {
                this.emitError("ERROR", e2.toString());
            }
        }
        input.close();
    }

    protected void startDesigner() throws IOException {
        if (OsVersion.IS_WINDOWS) {
            String[] commands = new String[]{"cmd", "/c", "startDesigner.bat"};
            this.watchProcess(Runtime.getRuntime().exec(commands, null, new File(this.idata.getInstallPath())));
        } else if (OsVersion.IS_MAC) {
            String[] executeFile = new String[]{"open", "i-net Designer.app"};
            this.watchProcess(Runtime.getRuntime().exec(executeFile, null, new File(this.idata.getInstallPath())));
        } else if (OsVersion.IS_LINUX) {
            String executeFile = "/bin/sh startDesigner.sh";
            this.watchProcess(Runtime.getRuntime().exec(executeFile, null, new File(this.idata.getInstallPath())));
        } else {
            Debug.error(new IOException("not supported operation system"), this.getClass());
        }
    }

    protected void startListener() throws IOException {
        if (OsVersion.IS_WINDOWS) {
            String[] commands = new String[]{"cmd", "/c", "start", "startListener.bat"};
            this.watchProcess(Runtime.getRuntime().exec(commands, null, new File(this.idata.getInstallPath())));
        } else if (OsVersion.IS_MAC) {
            String[] executeFile = new String[]{"open", "Start i-net Clear Reports Server.app"};
            this.watchProcess(Runtime.getRuntime().exec(executeFile, null, new File(this.idata.getInstallPath())));
        } else if (OsVersion.IS_LINUX && !OsVersion.IS_MAC) {
            String executeFile = "/bin/sh startListener.sh";
            this.watchProcess(Runtime.getRuntime().exec(executeFile, null, new File(this.idata.getInstallPath())));
        } else {
            Debug.error(new IOException("not supported operation system"), this.getClass());
        }
    }

    protected void startConfigManager() throws IOException {
        String port = "9000";
        if (this.idata.getRules().isConditionTrue("CCApache") || this.idata.getRules().isConditionTrue("CCApacheLinux") || this.idata.getRules().isConditionTrue("CCApacheMac")) {
            port = this.idata.getVariable("APACHEPHP_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCGeneric")) {
            port = this.idata.getVariable("GENERIC_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCGlassfish")) {
            port = this.idata.getVariable("GLASSFISH_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCJBoss")) {
            port = this.idata.getVariable("JBOSS_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCJetty")) {
            port = this.idata.getVariable("JETTY_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCOracle")) {
            port = this.idata.getVariable("ORACLE_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCService") || this.idata.getRules().isConditionTrue("CCDaemon")) {
            port = this.idata.getVariable("SERVICE_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCTomcat")) {
            port = this.idata.getVariable("TOMCAT_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCWeblgic")) {
            port = this.idata.getVariable("WEBLOGIC_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCWebsphere")) {
            port = this.idata.getVariable("WEBSPHERE_INSTALL_PORT");
        }
        if (port == null) {
            port = "9000";
        }
        this.openDocument(new URL("http://localhost:" + port + "/remote/configmanager"));
    }

    protected void openDocument(URL url) {
        Hyperactive h2 = new Hyperactive();
        h2.showDocument(url);
    }

    protected boolean testURL(URL url) {
        try {
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(500);
            conn.connect();
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private void setUpdateDesignerValue(boolean value) {
        String valueToSet = String.valueOf(value);
        Preferences pref = PreferencesUtils.userRoot();
        if (pref.parent() != null) {
            pref = pref.parent();
        }
        try {
            pref.flush();
            pref.sync();
        }
        catch (BackingStoreException ex2) {
            // empty catch block
        }
        pref = pref.node("com/inet/designer/prefs");
        pref.put("welcome_update", valueToSet);
        try {
            pref.flush();
            pref.sync();
        }
        catch (BackingStoreException ex3) {
            Debug.error(ex3, this.getClass());
        }
    }

    private void closeAndCopyLogFile(String installPath) {
        PrintWriter logfile = Debug.getLogFile();
        if (logfile != null) {
            logfile.close();
        }
        String absolutePath = new File(installPath, Debug.getLogFilePosition().getName()).getAbsolutePath();
        Utils.copyfile(Debug.getLogFilePosition().getAbsolutePath(), absolutePath);
        UninstallData.getInstance().addFile(absolutePath, true);
    }

    @Override
    public void itemStateChanged(ItemEvent e2) {
        if (e2.getSource().equals(this.startListener) && e2.getStateChange() == 2) {
            if (this.startConfigManager != null) {
                this.startConfigManager.setSelected(false);
                this.startConfigManager.setEnabled(false);
            }
        } else if (e2.getSource().equals(this.startListener) && e2.getStateChange() == 1) {
            if (this.startConfigManager != null) {
                this.startConfigManager.setEnabled(true);
            }
        } else if (e2.getSource().equals(this.startConfigManager) && e2.getStateChange() == 1 && this.startListener != null) {
            this.startListener.setSelected(true);
        }
    }

    static {
        if (OsVersion.IS_WINDOWS) {
            DESIGNER_STARTER = "startDesigner.bat";
            SERVER_STARTER = "startListener.bat";
        } else if (OsVersion.IS_MAC && !OsVersion.IS_LINUX) {
            DESIGNER_STARTER = "\"i-net Designer.app\"";
            SERVER_STARTER = "\"Start i-net Clear Reports Server.app\"";
        } else {
            DESIGNER_STARTER = "startDesigner.sh";
            SERVER_STARTER = "startListener.sh";
        }
    }
}

