/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.textui.Group;
import com.inet.textui.ListGroup;
import com.izforge.izpack.installer.IUnpacker;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.UnpackerBase;
import com.izforge.izpack.panels.ProcessPanel;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class CCInstallPanel
extends AbstractPanel
implements AbstractUIProgressHandler {
    private static final long serialVersionUID = 1L;
    private JPanel localPanel;
    private JLabel lblProgressPack;
    private JLabel lblProgressAll;
    private JProgressBar barProgressPack;
    private JProgressBar barProgressAll;
    private int noOfPacks = 0;
    private boolean finished = false;
    private ProcessPanel processpanel;
    private boolean headless;

    public CCInstallPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("CCInstallPanel.heading"), null, null, "com/inet/setup/images/Install48.png");
    }

    @Override
    public void panelActivate() {
        this.headless = "true".equals(this.idata.getVariable("HEADLESS"));
        try {
            File[] oldLogFiles;
            File directory = new File(this.idata.getInstallPath());
            for (File logFile : oldLogFiles = directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String pathLower = pathname.getName().toLowerCase();
                    return pathLower.startsWith("Install_".toLowerCase()) && pathLower.endsWith(".log");
                }
            })) {
                logFile.delete();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.idata.getStatHandler().notifyPanelActivation(this);
        super.panelActivate();
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        try {
            this.processpanel = new ProcessPanel(this.parent, this.idata){

                @Override
                public void startProcess(String jobName) {
                    jobName = this.parent.langpack.getString(jobName);
                    CCInstallPanel.this.nextStep(jobName, CCInstallPanel.this.barProgressAll.getValue() + 2, 1);
                }

                @Override
                public void progress(final int substepNo, String message) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CCInstallPanel.this.barProgressPack.setValue(substepNo + 1);
                        }
                    });
                }

                @Override
                public void setMaxSteps(int max) {
                    CCInstallPanel.this.barProgressPack.setMaximum(max);
                }
            };
            this.processpanel.worker.readSpec();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        this.parent.install(this);
    }

    @Override
    public boolean isValidated() {
        return super.isValidated();
    }

    @Override
    public Group getTextUiGroup() {
        ListGroup g2 = new ListGroup(){

            @Override
            public String isValid() {
                while (!CCInstallPanel.this.finished) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return null;
            }
        };
        g2.addEntry(this.barProgressAll);
        return g2;
    }

    @Override
    public JPanel initPanelGUI() {
        this.localPanel = new JPanel(new GridBagLayout());
        this.lblProgressPack = new JLabel(this.parent.langpack.getString("InstallPanel.tip"), 0);
        this.barProgressPack = new JProgressBar();
        this.barProgressPack.setStringPainted(true);
        this.barProgressPack.setString(this.parent.langpack.getString("InstallPanel.begin"));
        this.barProgressPack.setValue(0);
        this.lblProgressAll = new JLabel(this.parent.langpack.getString("InstallPanel.progress"), 0);
        this.barProgressAll = new JProgressBar();
        this.barProgressAll.setStringPainted(true);
        if (this.noOfPacks == 1) {
            this.barProgressAll.setIndeterminate(true);
        }
        this.barProgressAll.setString("");
        this.barProgressAll.setValue(0);
        this.localPanel.add((Component)new JPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, GUIUtils.INSETS_NULL, 0, 0));
        this.localPanel.add((Component)this.lblProgressAll, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.INSETS_TOP, 0, 0));
        this.localPanel.add((Component)this.barProgressAll, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.INSETS_BOTTOM, 0, 0));
        this.localPanel.add((Component)this.lblProgressPack, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.INSETS_TOP, 0, 0));
        this.localPanel.add((Component)this.barProgressPack, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.INSETS_MIDDLE, 0, 0));
        this.localPanel.add((Component)new JPanel(), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 18, 1, GUIUtils.INSETS_NULL, 0, 0));
        return this.localPanel;
    }

    @Override
    public void nextStep(String packName, int stepNo, int max) {
        this.barProgressPack.setValue(0);
        this.barProgressPack.setMinimum(0);
        this.barProgressPack.setMaximum(max);
        this.barProgressPack.setString(packName);
        Debug.log((Object)("processing now (" + Integer.toString(stepNo) + " / " + Integer.toString(this.noOfPacks) + ") : " + packName), this.getClass());
        this.barProgressAll.setValue(stepNo - 1);
        if (this.headless) {
            this.barProgressAll.setString(this.parent.langpack.getString("InstallPanel.progress"));
        } else {
            this.barProgressAll.setString(Integer.toString(stepNo) + " / " + Integer.toString(this.noOfPacks));
        }
    }

    @Override
    public void progress(final int substepNo, String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CCInstallPanel.this.barProgressPack.setValue(substepNo + 1);
            }
        });
    }

    @Override
    public void setSubStepNo(final int noOfSubsteps) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CCInstallPanel.this.barProgressPack.setMaximum(noOfSubsteps);
            }
        });
    }

    @Override
    public void startAction(String name, int noOfJobs) {
        this.noOfPacks = noOfJobs;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!"true".equals(CCInstallPanel.this.idata.getVariable("HEADLESS"))) {
                    CCInstallPanel.this.parent.blockGUI();
                    CCInstallPanel.this.noOfPacks = CCInstallPanel.this.noOfPacks + ((CCInstallPanel)CCInstallPanel.this).processpanel.worker.getJobs().size();
                    CCInstallPanel.this.barProgressAll.setMinimum(0);
                    CCInstallPanel.this.barProgressAll.setMaximum(CCInstallPanel.this.noOfPacks);
                    if (CCInstallPanel.this.headless) {
                        CCInstallPanel.this.barProgressAll.setString(((CCInstallPanel)CCInstallPanel.this).parent.langpack.getString("InstallPanel.progress"));
                    } else {
                        CCInstallPanel.this.barProgressAll.setString("0 / " + Integer.toString(CCInstallPanel.this.noOfPacks));
                    }
                }
            }
        });
    }

    @Override
    public void stopAction() {
        this.processpanel.worker.run();
        IUnpacker unpacker = this.parent.getUnpacker();
        if (unpacker instanceof UnpackerBase) {
            ((UnpackerBase)unpacker).setResult(unpacker.getResult() && this.processpanel.worker.getResult());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CCInstallPanel.this.parent.releaseGUI();
                CCInstallPanel.this.parent.lockPrevButton();
                CCInstallPanel.this.finished = true;
                CCInstallPanel.this.barProgressAll.setValue(CCInstallPanel.this.barProgressAll.getMaximum());
                CCInstallPanel.this.processpanel.displayLoggedErrorsIfAny();
                int ppbMax = CCInstallPanel.this.barProgressPack.getMaximum();
                if (ppbMax < 1) {
                    ppbMax = 1;
                    CCInstallPanel.this.barProgressPack.setMaximum(ppbMax);
                }
                CCInstallPanel.this.barProgressPack.setValue(ppbMax);
                CCInstallPanel.this.barProgressPack.setString(((CCInstallPanel)CCInstallPanel.this).parent.langpack.getString("InstallPanel.finished"));
                CCInstallPanel.this.barProgressPack.setEnabled(false);
                String no_of_packs = Integer.toString(CCInstallPanel.this.noOfPacks);
                if (CCInstallPanel.this.noOfPacks == 1) {
                    CCInstallPanel.this.barProgressAll.setIndeterminate(false);
                }
                CCInstallPanel.this.barProgressAll.setString(no_of_packs + " / " + no_of_packs);
                CCInstallPanel.this.barProgressAll.setEnabled(false);
                ((CCInstallPanel)CCInstallPanel.this).idata.canClose = true;
                if (((CCInstallPanel)CCInstallPanel.this).idata.panels.indexOf(this) != ((CCInstallPanel)CCInstallPanel.this).idata.panels.size() - 1) {
                    CCInstallPanel.this.parent.unlockNextButton();
                    if (!CCInstallPanel.this.headless) {
                        CCInstallPanel.this.parent.navigateNext();
                    }
                }
            }
        });
    }
}

