/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.gui.widget.LicensePane;
import com.inet.setup.Constants;
import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.util.JsonCreator;
import com.inet.setup.panels.widget.IPAdressItem;
import com.inet.setup.panels.widget.IPAdresseInputPanel;
import com.inet.setup.panels.widget.IPAdresseSelection;
import com.inet.setup.panels.widget.IPAdresseSelectionPanel;
import com.inet.setup.panels.widget.IPCheckThread;
import com.inet.textui.Group;
import com.inet.textui.ListGroup;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class CCLicenseKeyPanel
extends AbstractPanel
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private LicensePane licensePane;
    private JPanel localPanel;
    private JPanel pnlLicenseSelection;
    private ButtonGroup groupLicense;
    private JRadioButton radioExistingLicense;
    private JRadioButton radioChoicePlusLicense;
    private JRadioButton radioChoiceDefaultLicense;
    private JLabel lblLicensePane;
    private JLabel lblChoiseDefaultLicenseText;
    private JLabel lblChoisePlusLicenseText;
    private JPanel pnlLicenseKeySelection;
    private JLabel lblKeyDescription;
    private IPAdresseSelection pnlIPSelection;
    private FilteredVariables filteredVariables;
    private String localHostIPAdresse;
    private String trialLicenseKey = "";
    private int currentLicenseCount = 0;
    private boolean hasKeyFromProperties = false;
    private boolean first = true;
    private final InstallerFrame parent;
    private String selected = "";
    private String selected_property = "";
    private MutableComboBoxModel cmbboxModel = new DefaultComboBoxModel();

    public CCLicenseKeyPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("CCLicenseKeyPanel.text"), null, null, "com/inet/setup/images/License48.png");
        this.parent = parent;
        this.cmbboxModel.addElement("");
        IPCheckThread threadIPChecker = new IPCheckThread(this.cmbboxModel);
        threadIPChecker.start();
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("SERVLET_REMOTE_INSTALL", null);
        requiredVariables.put("CONFIG_NAME", null);
        requiredVariables.put("SCOPE_NAME", null);
        requiredVariables.put("ADD_TO_CONFIG", null);
        requiredVariables.put("SELECTED", null);
        requiredVariables.put("SELECTED_PROPERTY", null);
        requiredVariables.put("LICENSETYPE", null);
        requiredVariables.put("IP_ADDRESS", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
        boolean isEnabled = ((JComponent)((Object)this.pnlIPSelection)).isEnabled();
        if (Boolean.toString(true).equalsIgnoreCase(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL")) || GraphicsEnvironment.isHeadless()) {
            if (this.pnlIPSelection instanceof IPAdresseSelectionPanel) {
                this.localPanel.remove((JComponent)((Object)this.pnlIPSelection));
                this.pnlIPSelection = new IPAdresseInputPanel(this.parent, this);
                ((IPAdresseInputPanel)this.pnlIPSelection).setEnabled(isEnabled);
                this.localPanel.add((Component)((IPAdresseInputPanel)this.pnlIPSelection), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
            }
        } else if (this.pnlIPSelection instanceof IPAdresseInputPanel) {
            this.localPanel.remove((JComponent)((Object)this.pnlIPSelection));
            this.pnlIPSelection = new IPAdresseSelectionPanel(this.parent, this);
            ((IPAdresseSelectionPanel)this.pnlIPSelection).setEnabled(isEnabled);
            this.localPanel.add((Component)((IPAdresseSelectionPanel)this.pnlIPSelection), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        }
        if (this.pnlIPSelection instanceof IPAdresseSelectionPanel) {
            ((IPAdresseSelectionPanel)this.pnlIPSelection).setIPData(this.cmbboxModel);
            String variable = this.filteredVariables.getVariable("IP_ADDRESS");
            if (variable != null && variable.trim().length() > 0) {
                for (int i2 = 0; i2 < this.cmbboxModel.getSize(); ++i2) {
                    IPAdressItem ipitem;
                    Object elementAt = this.cmbboxModel.getElementAt(i2);
                    if (!(elementAt instanceof IPAdressItem) || !(ipitem = (IPAdressItem)elementAt).getIPAdresse().toString().equalsIgnoreCase(variable)) continue;
                    this.cmbboxModel.setSelectedItem(elementAt);
                }
            }
        }
        this.localPanel.revalidate();
        this.localPanel.repaint();
        boolean checkConfig = this.checkConfig(this.filteredVariables.getVariable("SELECTED"), this.filteredVariables.getVariable("SELECTED_PROPERTY"));
        if (this.first || checkConfig) {
            this.clearLicensePane();
            this.licensePane.getLicenseTextField().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e2) {
                    if (CCLicenseKeyPanel.this.licensePane.getLicenseKeys().length() >= 30) {
                        CCLicenseKeyPanel.this.setKeyDescription("");
                    } else {
                        CCLicenseKeyPanel.this.setKeyDescription(((CCLicenseKeyPanel)CCLicenseKeyPanel.this).parent.langpack.getString("CCLicenseKeyPanel.NoKey"));
                    }
                    CCLicenseKeyPanel.this.setKeyDescriptionVisible(true);
                    CCLicenseKeyPanel.this.groupLicense.setSelected(CCLicenseKeyPanel.this.radioExistingLicense.getModel(), true);
                }
            });
            this.licensePane.getLicenseTextField().addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e2) {
                    if (CCLicenseKeyPanel.this.licensePane.getLicenseKeys().length() >= 30) {
                        CCLicenseKeyPanel.this.setKeyDescription("");
                    } else {
                        CCLicenseKeyPanel.this.setKeyDescription(((CCLicenseKeyPanel)CCLicenseKeyPanel.this).parent.langpack.getString("CCLicenseKeyPanel.NoKey"));
                    }
                }
            });
            Configuration config = this.loadConfiguration();
            if (config != null) {
                String licensekey = config.get("licensekey");
                this.validateLicenseKey(licensekey);
                this.groupLicense.setSelected(this.radioExistingLicense.getModel(), true);
            } else if (this.hasKeyFromProperties) {
                this.groupLicense.setSelected(this.radioExistingLicense.getModel(), true);
                this.hasKeyFromProperties = false;
            } else {
                this.groupLicense.setSelected(this.radioChoicePlusLicense.getModel(), true);
            }
            this.currentLicenseCount = this.licensePane.getLicenseKeyArray().length;
            this.setKeyDescription("");
            this.setEnabledStats(this.groupLicense.getSelection());
            this.first = false;
        }
    }

    private boolean checkConfig(String selected1, String selected_property1) {
        if (this.selected.equals(selected1) && this.selected_property.equals(selected_property1)) {
            return false;
        }
        this.selected = selected1;
        this.selected_property = selected_property1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration loadConfiguration() {
        Configuration config;
        block18: {
            config = null;
            try {
                ConfigurationManager configManager = ConfigurationManager.getInstance();
                String scopeName = this.filteredVariables.getVariable("SCOPE_NAME");
                int scope = Constants.getScopeValue(scopeName);
                String selectedConfigImport = this.filteredVariables.getVariable("SELECTED");
                if (selectedConfigImport.equalsIgnoreCase("CREATE_FROM_LOCAL")) {
                    String selectedProperty = this.filteredVariables.getVariable("SELECTED_PROPERTY");
                    String[] split = selectedProperty.split("::");
                    config = configManager.get(Constants.getScopeValue(split[0]), split[1]);
                    break block18;
                }
                if (selectedConfigImport.equalsIgnoreCase("CREATE_FROM_PROPS")) {
                    String selectedProperty = this.filteredVariables.getVariable("SELECTED_PROPERTY");
                    Properties properties = new Properties();
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(selectedProperty);
                        properties.load(fis);
                        if (!properties.isEmpty() && properties.getProperty("licensekey").length() > 0) {
                            this.clearLicensePane();
                            String licensekey = properties.getProperty("licensekey");
                            this.validateLicenseKey(licensekey);
                            this.hasKeyFromProperties = true;
                        }
                        break block18;
                    }
                    catch (Throwable e2) {
                        break block18;
                    }
                    finally {
                        try {
                            fis.close();
                        }
                        catch (IOException e3) {}
                    }
                }
                if (selectedConfigImport.equalsIgnoreCase("CREATE_NEW")) {
                    this.clearLicensePane();
                } else {
                    config = configManager.get(scope, this.filteredVariables.getVariable("CONFIG_NAME"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return config;
    }

    private void clearLicensePane() {
        String key = "";
        while (this.licensePane.getLicenseKeyArray().length > 0) {
            try {
                key = this.licensePane.removeLastLicense();
                if (key.trim().length() != 0) continue;
            }
            catch (Exception e2) {}
            break;
        }
    }

    private void setKeyDescription(String desc) {
        this.lblKeyDescription.setText(desc);
        this.lblKeyDescription.revalidate();
        this.lblKeyDescription.repaint();
    }

    private void setKeyDescriptionVisible(boolean b2) {
        this.lblKeyDescription.setVisible(b2);
    }

    private void validateLicenseKey(String licensekey) {
        if (licensekey != null && licensekey.length() > 0) {
            String[] licenseKeyArray = this.licensePane.getLicenseKeyArray();
            if (licenseKeyArray != null && licenseKeyArray.length > 0) {
                boolean containsKey = false;
                for (String key : licenseKeyArray) {
                    if (!key.equalsIgnoreCase(licensekey)) continue;
                    containsKey = true;
                    break;
                }
                if (!containsKey) {
                    this.licensePane.addNewLicense(licensekey, true);
                    this.setSelectedRadioButton(this.radioExistingLicense.getModel(), true);
                }
            } else {
                this.licensePane.addNewLicense(licensekey, true);
                this.setSelectedRadioButton(this.radioExistingLicense.getModel(), true);
            }
        }
    }

    private void setSelectedRadioButton(ButtonModel model, boolean b2) {
        this.groupLicense.setSelected(model, b2);
        if (b2) {
            this.setEnabledStats(model);
        }
    }

    public void panelFinish() {
        String licenseKeys = this.licensePane.getLicenseKeys();
        StringBuilder formatedLicenseKey = new StringBuilder();
        for (int i2 = 0; i2 < licenseKeys.length(); ++i2) {
            if ((i2 - 30) % 64 == 0 && i2 != 0) {
                formatedLicenseKey.append("\n");
            }
            formatedLicenseKey.append(licenseKeys.charAt(i2));
        }
        if (this.groupLicense.isSelected(this.radioChoiceDefaultLicense.getModel()) || this.groupLicense.isSelected(this.radioChoicePlusLicense.getModel())) {
            this.putToSummary(this.parent.langpack.getString("CCLicenseKeyPanel.licenseType"), this.groupLicense.isSelected(this.radioChoiceDefaultLicense.getModel()) ? this.parent.langpack.getString("CCLicenseKeyPanel.trialchooser.choice.default") : this.parent.langpack.getString("CCLicenseKeyPanel.trialchooser.choice.plus"), 0);
            this.putToSummary(this.parent.langpack.getString("CCLicenseKeyPanel.ipAdresse"), this.localHostIPAdresse, 1);
        } else {
            this.putToSummary(this.parent.langpack.getString("CCLicenseKeyPanel.licenseType"), this.parent.langpack.getString("CCLicenseKeyPanel.activate"), 0);
            this.putToSummary(this.parent.langpack.getString("CCLicenseKeyPanel.heading"), this.licensePane.getLicenseKeyArray().length > 0 ? formatedLicenseKey.toString() : this.parent.langpack.getString("CCLicenseKeyPanel.noKey.short"), 1);
        }
        String variable = this.filteredVariables.getVariable("ADD_TO_CONFIG");
        HashMap<Object, Object> map = null;
        if (variable != null && variable.trim().length() > 0) {
            try {
                map = JsonCreator.createMapFromJson(variable);
            }
            catch (IllegalArgumentException iae) {
                map = new HashMap();
            }
            catch (NullPointerException npe) {
                map = new HashMap();
            }
        } else {
            map = new HashMap();
        }
        if (this.groupLicense.isSelected(this.radioExistingLicense.getModel())) {
            map.remove("licensekey");
            map.put("licensekey", this.licensePane.getLicenseKeyArray().length > 0 ? licenseKeys : " ");
            this.filteredVariables.setVariable("LICENSETYPE", this.licensePane.getLicenseKeyArray().length > 0 ? "activate" : "none");
        } else {
            map.remove("licensekey");
            map.put("licensekey", this.trialLicenseKey);
            this.filteredVariables.setVariable("LICENSETYPE", this.groupLicense.isSelected(this.radioChoicePlusLicense.getModel()) ? "plus" : "default");
        }
        this.filteredVariables.setVariable("ADD_TO_CONFIG", JsonCreator.createJsonFromMap(map));
    }

    @Override
    public boolean isValidated() {
        JComponent comp = null;
        if (this.pnlIPSelection instanceof IPAdresseInputPanel) {
            comp = ((IPAdresseInputPanel)this.pnlIPSelection).isValidated();
            if (!this.groupLicense.isSelected(this.radioExistingLicense.getModel()) && comp != null) {
                comp.requestFocus();
                return false;
            }
        } else if (this.pnlIPSelection instanceof IPAdresseSelectionPanel) {
            comp = ((IPAdresseSelectionPanel)this.pnlIPSelection).isValidated();
            if (!this.groupLicense.isSelected(this.radioExistingLicense.getModel()) && comp != null) {
                comp.requestFocus();
                return false;
            }
        }
        if (!this.groupLicense.isSelected(this.radioExistingLicense.getModel()) && !this.requestLicenseKey(this.radioChoicePlusLicense.isSelected())) {
            this.emitWarning(null, this.parent.langpack.getString("CCLicenseKeyPanel.serverError"));
            return false;
        }
        this.panelFinish();
        return super.isValidated();
    }

    @Override
    public JPanel initPanelGUI() {
        Component[] components;
        this.localPanel = new JPanel();
        this.localPanel.setBorder(BorderFactory.createEmptyBorder());
        this.localPanel.setLayout(new GridBagLayout());
        this.licensePane = new LicensePane(false);
        this.licensePane.setName("licensePane");
        this.licensePane.addPropertyChangeListener("LicenseChanged", this);
        this.pnlLicenseSelection = new JPanel();
        this.pnlLicenseSelection.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString("CCLicenseKeyPanel.LicenseKey")));
        this.pnlLicenseSelection.setLayout(new GridBagLayout());
        this.pnlIPSelection = new IPAdresseSelectionPanel(this.parent, this);
        ((JComponent)((Object)this.pnlIPSelection)).setEnabled(false);
        this.groupLicense = new ButtonGroup();
        this.radioExistingLicense = new JRadioButton(this.parent.langpack.getString("CCLicenseKeyPanel.activate"));
        this.radioExistingLicense.setName("radioActivate");
        this.radioExistingLicense.addActionListener(this);
        this.radioChoiceDefaultLicense = new JRadioButton(this.parent.langpack.getString("CCLicenseKeyPanel.trialchooser.choice.default"));
        this.radioChoiceDefaultLicense.setName("radioTrial");
        this.radioChoiceDefaultLicense.addActionListener(this);
        this.radioChoicePlusLicense = new JRadioButton(this.parent.langpack.getString("CCLicenseKeyPanel.trialchooser.choice.plus"));
        this.radioChoicePlusLicense.setName("radioPlus");
        this.radioChoicePlusLicense.addActionListener(this);
        this.groupLicense.add(this.radioExistingLicense);
        this.groupLicense.add(this.radioChoiceDefaultLicense);
        this.groupLicense.add(this.radioChoicePlusLicense);
        this.radioExistingLicense.setSelected(true);
        this.lblLicensePane = new JLabel(this.parent.langpack.getString("CCLicenseKeyPanel.LicenseKey") + ":");
        JLabel lblImport = new JLabel("Import Licensefile");
        for (Component component : components = this.licensePane.getComponents()) {
            if (!"importButton".equalsIgnoreCase(component.getName())) continue;
            lblImport.setLabelFor(component);
            break;
        }
        this.lblKeyDescription = new JLabel();
        this.lblKeyDescription.setForeground(Color.RED);
        this.lblLicensePane.setLabelFor(this.licensePane);
        this.lblChoiseDefaultLicenseText = new JLabel(this.parent.langpack.getString("CCLicenseKeyPanel.trialchooser.information.default"));
        this.lblChoiseDefaultLicenseText.setLabelFor(this.radioChoiceDefaultLicense);
        this.lblChoisePlusLicenseText = new JLabel(this.parent.langpack.getString("CCLicenseKeyPanel.trialchooser.information.plus"));
        this.lblChoisePlusLicenseText.setLabelFor(this.radioChoicePlusLicense);
        this.pnlLicenseKeySelection = new JPanel();
        this.pnlLicenseKeySelection.setName("pnlLicenseKeySelection");
        this.pnlLicenseKeySelection.setLayout(new GridBagLayout());
        this.pnlLicenseKeySelection.add((Component)this.lblLicensePane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 10), 0, 0));
        this.pnlLicenseKeySelection.add((Component)this.licensePane, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.pnlLicenseSelection.add((Component)this.radioExistingLicense, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        this.pnlLicenseSelection.add((Component)this.pnlLicenseKeySelection, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.addGap(GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 1, 20), 0, 0));
        this.pnlLicenseSelection.add((Component)this.radioChoiceDefaultLicense, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        this.pnlLicenseSelection.add((Component)this.lblChoiseDefaultLicenseText, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.addGap(GUIUtils.COMPONENT_INSETS_MIDDLE, 1, 20), 0, 0));
        this.pnlLicenseSelection.add((Component)this.radioChoicePlusLicense, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        this.pnlLicenseSelection.add((Component)this.lblChoisePlusLicenseText, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.addGap(GUIUtils.COMPONENT_INSETS_BOTTOM, 1, 20), 0, 0));
        this.localPanel.add((Component)this.pnlLicenseSelection, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_TOP, 0, 0));
        this.localPanel.add((Component)((JComponent)((Object)this.pnlIPSelection)), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.localPanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, GUIUtils.INSETS_NULL, 0, 0));
        this.localPanel.add((Component)this.lblKeyDescription, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 16, 2, GUIUtils.INSETS_MIDDLE_HALF, 0, 0));
        return this.localPanel;
    }

    private boolean requestLicenseKey(boolean isPlus) {
        this.trialLicenseKey = "";
        StringBuffer licURL = new StringBuffer("http://www.inetsoftware.de/external-services/licensekeyremoterequest_trial.php?ip=");
        if (!"true".equalsIgnoreCase(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL")) && !GraphicsEnvironment.isHeadless()) {
            Frame frameForComponent = JOptionPane.getRootFrame();
            frameForComponent.setCursor(new Cursor(3));
        }
        try {
            InetAddress inetAdr = InetAddress.getLocalHost();
            this.localHostIPAdresse = this.pnlIPSelection.getIPAdresse();
            licURL.append(this.localHostIPAdresse);
            licURL.append("&version=13");
            licURL.append("&host=" + inetAdr.getHostName());
            if (isPlus) {
                licURL.append("&type=Plus");
            }
            URL url = new URL(licURL.toString());
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDoInput(true);
            urlConnection.connect();
            InputStream in = urlConnection.getInputStream();
            byte[] inp = new byte[512];
            int l2 = 0;
            int readbyte = -1;
            while ((readbyte = in.read()) != -1) {
                inp[l2] = (byte)readbyte;
                ++l2;
            }
            Debug.log((Object)("[LICINP] " + Arrays.toString(inp)), this.getClass());
            in.close();
            Debug.log((Object)("[LICURL] " + licURL), this.getClass());
            this.trialLicenseKey = new String(inp, 0, l2);
            Debug.log((Object)("[LICKEY] " + this.trialLicenseKey), this.getClass());
            return true;
        }
        catch (Throwable t2) {
            Debug.log((Object)licURL, this.getClass());
            return this.askQuestion(this.parent.langpack.getString("CCLicenseKeyPanel.license.generateFailed.title"), this.parent.langpack.getString("CCLicenseKeyPanel.license.generateFailed.msg"), 37) == 49;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Object source = e2.getSource();
        if (source instanceof JRadioButton) {
            JRadioButton radioSoure = (JRadioButton)source;
            this.licensePane.setEnabled(radioSoure == this.radioExistingLicense);
            this.setEnabledStats(radioSoure.getModel());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.currentLicenseCount > this.licensePane.getLicenseKeyArray().length) {
            if (this.groupLicense.isSelected(this.radioExistingLicense.getModel())) {
                this.setKeyDescription(this.parent.langpack.getString("CCLicenseKeyPanel.keyRemoved"));
            }
        } else {
            this.setKeyDescription("");
            this.setSelectedRadioButton(this.radioExistingLicense.getModel(), true);
        }
        this.currentLicenseCount = this.licensePane.getLicenseKeyArray().length;
    }

    private void setEnabledStats(ButtonModel radioSource) {
        if (radioSource.equals(this.radioExistingLicense.getModel())) {
            ((JComponent)((Object)this.pnlIPSelection)).setEnabled(false);
            this.setKeyDescriptionVisible(true);
        }
        if (radioSource.equals(this.radioChoiceDefaultLicense.getModel())) {
            ((JComponent)((Object)this.pnlIPSelection)).setEnabled(true);
            this.setKeyDescriptionVisible(false);
        }
        if (radioSource.equals(this.radioChoicePlusLicense.getModel())) {
            ((JComponent)((Object)this.pnlIPSelection)).setEnabled(true);
            this.setKeyDescriptionVisible(false);
        }
    }

    @Override
    public Group getTextUiGroup() {
        ListGroup textUiGroup = (ListGroup)super.getTextUiGroup();
        List<Component> components = textUiGroup.getComponents();
        for (Component component : components) {
            if (!"txtLicense".equalsIgnoreCase(component.getName())) continue;
            textUiGroup.removeComponentFromList(component);
        }
        textUiGroup.addEntry(this.licensePane);
        return textUiGroup;
    }
}

