/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.html.InetHtmlEditorKit;
import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class CCLicensePanel
extends AbstractPanel
implements ActionListener {
    private JEditorPane paneLicense;
    private JRadioButton btnAgreeYes;
    private JRadioButton btnAgreeNo;
    private JLabel lblReadCareful;
    private JScrollPane scrollLicense;
    private JPanel localPanel;

    public CCLicensePanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("CCLicensePanel.heading"), null, null, "com/inet/setup/images/Legal48.png");
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        super.panelActivate();
        if (!this.btnAgreeYes.isSelected()) {
            this.parent.lockNextButton();
        }
    }

    @Override
    public void panelDeactivate() {
        this.checkJavawPath();
        super.panelDeactivate();
    }

    @Override
    public boolean isValidated() {
        if (this.btnAgreeNo.isSelected() && "true".equalsIgnoreCase(this.idata.getVariable("HEADLESS"))) {
            this.parent.exit();
            return false;
        }
        if (this.btnAgreeYes.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
        return super.isValidated() == this.btnAgreeYes.isSelected();
    }

    @Override
    public JPanel initPanelGUI() {
        this.localPanel = new JPanel();
        this.localPanel.setBorder(BorderFactory.createEmptyBorder());
        this.localPanel.setLayout(new GridBagLayout());
        this.lblReadCareful = new JLabel(this.parent.langpack.getString("CCLicensePanel.info") + ":");
        this.localPanel.add((Component)this.lblReadCareful, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, GUIUtils.INSETS_TOP, 0, 0));
        URL url = this.getFileURL();
        this.paneLicense = new JEditorPane();
        this.paneLicense.setEditorKitForContentType("text/html", new InetHtmlEditorKit());
        this.paneLicense.setMargin(new Insets(2, 2, 2, 2));
        this.paneLicense.setEditable(false);
        this.paneLicense.setContentType("text/html");
        this.paneLicense.getKeymap().removeBindings();
        try {
            this.paneLicense.setPage(url);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.scrollLicense = new JScrollPane(this.paneLicense);
        this.scrollLicense.setAlignmentX(0.0f);
        this.localPanel.add((Component)this.scrollLicense, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, GUIUtils.INSETS_MIDDLE, 0, 0));
        this.btnAgreeYes = new JRadioButton(this.parent.langpack.getString("CCLicensePanel.agree"), false);
        this.btnAgreeNo = new JRadioButton(this.parent.langpack.getString("CCLicensePanel.notagree"), true);
        this.btnAgreeYes.addActionListener(this);
        this.btnAgreeNo.addActionListener(this);
        this.btnAgreeYes.setName("CCLicensePanel_btnAgreeYes");
        this.btnAgreeNo.setName("CCLicensePanel_btnAgreeNo");
        if (GraphicsEnvironment.isHeadless()) {
            this.btnAgreeNo.setSelected(false);
        }
        ButtonGroup grpAgree = new ButtonGroup();
        grpAgree.add(this.btnAgreeYes);
        grpAgree.add(this.btnAgreeNo);
        this.localPanel.add((Component)this.btnAgreeYes, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.INSETS_MIDDLE_ZERO, 0, 0));
        this.localPanel.add((Component)this.btnAgreeNo, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.INSETS_BOTTOM, 0, 0));
        return this.localPanel;
    }

    protected URL getFileURL() {
        URL url = null;
        try {
            url = ResourceManager.getInstance().getURL("eng.license.html");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.isValidated();
    }

    private void checkJavawPath() {
        String defaultJavawPath = "javaw.exe";
        defaultJavawPath = new File(System.getenv("windir") + File.separator + "SysWOW64").exists() ? System.getenv("windir") + File.separator + "SysWOW64" + File.separator + "javaw.exe" : System.getenv("windir") + File.separator + "System32" + File.separator + "javaw.exe";
        this.idata.setVariable("JAVAW_PATH", defaultJavawPath);
    }
}

