/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.setup.Constants;
import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.CheckBoxNode;
import com.inet.setup.panels.CheckBoxNodeRenderer;
import com.inet.setup.panels.CheckTreeController;
import com.inet.setup.panels.PacksTreeUI;
import com.inet.setup.panels.TreeState;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackHandler;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.Debugger;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;

public class CCPacksPanel
extends AbstractPanel {
    private static final int COLUM_WIDTH = 80;
    private static final long serialVersionUID = 5684716698930628262L;
    private JTextArea descriptionArea;
    private JTree treePacks;
    private JScrollPane tableScroller;
    private long bytes = 0L;
    private HashMap<String, Pack> idToPack;
    private HashMap<String, ArrayList<String>> treeData;
    private HashMap<Pack, Integer> packToRowNumber;
    private HashMap<String, CheckBoxNode> nameToCheckBoxNode = new HashMap();
    private CheckTreeController checkTreeController;
    private JPanel localPanel;
    private JLabel lblSpaceText;
    private JLabel lblSpaceValue;
    private DefaultTreeModel modelPacks;
    private TreeState ts = new TreeState();

    public CCPacksPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("CCPacksPanel.heading"), null, parent.langpack.getString("CCPacksPanel.summaryCaption"), "com/inet/setup/images/Components48.png");
    }

    @Override
    public void panelActivate() {
        String chosenComponent = this.idata.getVariable("COMPONENT_TO_INSTALL");
        if (chosenComponent.equalsIgnoreCase("Designer")) {
            this.parent.skipPanel();
        }
        this.createReverseDependencies();
        this.createReverseMapping();
        super.panelActivate();
        this.updatePacksTree();
        this.refreshFromPackStates();
        Object lastSelectedPathComponent = this.treePacks.getLastSelectedPathComponent();
        if (lastSelectedPathComponent == null) {
            this.treePacks.setSelectionRow(0);
        }
        if (this.ts != null && this.treePacks != null) {
            TreeState.setTreeState(this.treePacks, this.ts);
        }
        this.tableScroller.setViewportView(this.treePacks);
    }

    @Override
    public boolean panelValidated() {
        this.refreshPacksToInstall();
        return super.panelValidated();
    }

    @Override
    public void panelDeactivate() {
        if (this.treePacks != null && this.ts != null) {
            this.ts = TreeState.getTreeState(this.treePacks);
        }
        super.panelDeactivate();
    }

    protected void createNormalLayout() {
        this.localPanel.setBorder(BorderFactory.createEmptyBorder(20, 28, 10, 28));
        double[][] sizes = new double[][]{{-1.0}, {-1.0, 5.0, -2.0}};
        TableLayout layout = new TableLayout(sizes);
        this.localPanel.setLayout(layout);
        this.treePacks = this.createPacksTree(400);
        this.tableScroller = new JScrollPane(this.treePacks);
        this.tableScroller.setViewportView(this.treePacks);
        this.tableScroller.setAlignmentX(0.0f);
        this.tableScroller.getViewport().setBackground(Color.white);
        this.tableScroller.getVerticalScrollBar().setUnitIncrement(10);
        this.tableScroller.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2), this.tableScroller.getBorder()));
        this.localPanel.add((Component)this.tableScroller, "0,0");
        this.descriptionArea = this.createTextArea(this.parent.langpack.getString("PacksPanel.description"), null);
        this.descriptionArea.setMinimumSize(new Dimension(400, 80));
        this.localPanel.add((Component)this.descriptionArea, "0,2");
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public void showSpaceRequired() {
    }

    public JPanel createSpaceRequired() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        this.lblSpaceText = new JLabel();
        this.lblSpaceValue = new JLabel(Pack.toByteUnitsString(this.bytes));
        pnl.add((Component)this.lblSpaceText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        pnl.add((Component)this.lblSpaceValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        return pnl;
    }

    public Debugger getDebugger() {
        return null;
    }

    @Override
    public boolean isValidated() {
        this.refreshPacksToInstall();
        return super.isValidated();
    }

    private String getI18NPackName(Pack pack) {
        String packName = pack.name;
        String key = pack.id;
        if (pack.id != null && !"".equals(pack.id)) {
            packName = this.idata.langpack.getString(key);
        }
        if ("".equals(packName) || key == null || key.equals(packName)) {
            packName = pack.name;
        }
        return packName;
    }

    public String getI18NPackName(String packId) {
        Pack pack = this.idToPack.get(packId);
        if (pack == null) {
            return this.idata.langpack.getString(packId);
        }
        return this.getI18NPackName(pack);
    }

    protected JLabel createLabel(String msgId, String iconId) {
        JLabel label = LabelFactory.create(this.parent.langpack.getString(msgId), this.parent.icons.getImageIcon(iconId), 2);
        return label;
    }

    private void refreshPacksToInstall() {
        CheckBoxNode cbn = (CheckBoxNode)this.getTree().getModel().getRoot();
        Enumeration<TreeNode> e2 = cbn.depthFirstEnumeration();
        while (e2.hasMoreElements()) {
            CheckBoxNode c2 = (CheckBoxNode)e2.nextElement();
            Pack pack = c2.getPack();
            List<Pack> selectedPacks = PackHandler.getSelectedPacks();
            List<Pack> availablePacks = PackHandler.getAvailablePacks();
            if (c2.isSelected() || c2.isPartial()) {
                if (!availablePacks.contains(pack)) {
                    Debug.log((Object)("[MISSING PACKS, ADD]" + pack), this.getClass());
                }
                if (!selectedPacks.contains(pack)) {
                    PackHandler.setSelectedPack(pack);
                }
                Debug.log((Object)("[REFRESH PACKS, ADD]" + pack), this.getClass());
                continue;
            }
            if (!availablePacks.contains(pack)) {
                Debug.log((Object)("[MISSING PACKS, REM]" + pack), this.getClass());
            }
            if (selectedPacks.contains(pack) && !pack.isHidden()) {
                PackHandler.unsetSelectedPack(pack);
            }
            Debug.log((Object)("[REFRESH PACKS, REM]" + pack), this.getClass());
        }
    }

    protected JTextArea createTextArea(String msgId, JScrollPane scroller) {
        JTextArea area = new JTextArea(){

            @Override
            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                return new Dimension(preferredSize.width, Math.max(80, preferredSize.height));
            }
        };
        area.setName("areaDescription");
        area.setAlignmentX(0.0f);
        area.setCaretPosition(0);
        area.setEditable(false);
        area.setOpaque(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setBorder(BorderFactory.createTitledBorder(msgId));
        area.setFont(this.getControlTextFont());
        if (scroller != null) {
            scroller.setViewportView(area);
        }
        return area;
    }

    protected void updatePacksTree() {
        CheckBoxNode treeStructure = this.populateTreePacks(null);
        this.modelPacks = new DefaultTreeModel(treeStructure);
        DefaultTreeModel copy = this.pruneUneditables((CheckBoxNode)this.modelPacks.getRoot(), this.modelPacks);
        this.treePacks.setModel(copy);
        this.treePacks.treeDidChange();
    }

    protected JTree createPacksTree(int width) {
        this.checkTreeController = new CheckTreeController(this, this.parent, this.idata);
        CheckBoxNode treeStructure = this.populateTreePacks(null);
        this.modelPacks = new DefaultTreeModel(treeStructure);
        JTree tree = new JTree(this.modelPacks){

            @Override
            public void updateUI() {
                this.setUI(new PacksTreeUI(this));
            }

            @Override
            protected void paintComponent(Graphics g2) {
                int selRow;
                g2.setColor(Color.WHITE);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                int[] selRows = this.getSelectionRows();
                int n2 = selRow = selRows == null || selRows.length == 0 ? -1 : selRows[0];
                if (selRow != -1) {
                    Color c2 = UIManager.getColor("Tree.selectionBackground");
                    Rectangle r2 = this.getRowBounds(selRow);
                    g2.setColor(c2);
                    g2.fillRect(0, r2.y, this.getWidth(), r2.height);
                }
                this.setOpaque(false);
                super.paintComponent(g2);
                this.setOpaque(true);
                g2.setFont(new JLabel().getFont());
                g2.setColor(Color.BLACK);
                g2.drawString(((CCPacksPanel)CCPacksPanel.this).parent.langpack.getString("CCPacksPanel.pack.names"), 5, 15);
                String strPackSize = ((CCPacksPanel)CCPacksPanel.this).parent.langpack.getString("CCPacksPanel.pack.size");
                int swPackSize = g2.getFontMetrics().stringWidth(strPackSize);
                g2.drawString(strPackSize, this.getWidth() - 5 - 160 - 20 + (80 - swPackSize), 15);
                String strTotalSize = ((CCPacksPanel)CCPacksPanel.this).parent.langpack.getString("CCPacksPanel.totalpack.size");
                int swTotalSize = g2.getFontMetrics().stringWidth(strTotalSize);
                g2.drawString(strTotalSize, this.getWidth() - 5 - 80 + (80 - swTotalSize), 15);
                g2.setColor(Color.GRAY);
                g2.drawLine(0, 20, this.getWidth(), 20);
                for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                    Object obj = this.getPathForRow(i2).getLastPathComponent();
                    Rectangle b2 = this.getRowBounds(i2);
                    CheckBoxNode checkboxNode = (CheckBoxNode)obj;
                    if (checkboxNode.getLevel() <= 1 && checkboxNode.isSelected()) {
                        if (checkboxNode.isEnabled()) {
                            g2.setColor(Color.BLACK);
                        } else {
                            g2.setColor(Color.LIGHT_GRAY);
                        }
                        String totalSizeString = "";
                        long totalSize = checkboxNode.getTotalSize();
                        if (totalSize > 0L) {
                            totalSizeString = Pack.toMegaByteUnitsString(totalSize);
                            int swtotalSizeString = g2.getFontMetrics().stringWidth(totalSizeString);
                            g2.drawString(totalSizeString, this.getWidth() - 5 - 80 + (80 - swtotalSizeString), b2.y + b2.height - 6);
                        }
                    }
                    if (checkboxNode.isEnabled()) {
                        g2.setColor(Color.GRAY);
                    } else {
                        g2.setColor(Color.LIGHT_GRAY);
                    }
                    String packbytesString = "0.00 MB";
                    long packbytes = checkboxNode.getPack().nbytes;
                    if (packbytes > 0L) {
                        packbytesString = Pack.toMegaByteUnitsString(packbytes);
                    } else if (checkboxNode.getLevel() <= 1) {
                        packbytesString = "";
                    }
                    int swpackbytesString = g2.getFontMetrics().stringWidth(packbytesString);
                    g2.drawString(packbytesString, this.getWidth() - 5 - 160 - 20 + (80 - swpackbytesString), b2.y + b2.height - 6);
                }
            }
        };
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        tree.setSelectionModel(selectionModel);
        tree.setCellRenderer(new CheckBoxNodeRenderer(tree));
        tree.setLargeModel(true);
        tree.setEditable(false);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setBorder(BorderFactory.createEmptyBorder(25, 2, 0, 2));
        tree.setBackground(Color.white);
        tree.setToggleClickCount(0);
        tree.expandRow(0);
        tree.addMouseListener(this.checkTreeController);
        tree.addKeyListener(this.checkTreeController);
        tree.addTreeSelectionListener(this.checkTreeController);
        return tree;
    }

    private DefaultTreeModel pruneUneditables(CheckBoxNode rootNode, DefaultTreeModel model) {
        CheckBoxNode root = (CheckBoxNode)model.getRoot();
        DefaultTreeModel copy = new DefaultTreeModel(root);
        int count = rootNode.getChildCount();
        RulesEngine rules = this.parent.getRules();
        Properties variables = this.idata.getVariables();
        for (int i2 = count - 1; i2 >= 0; --i2) {
            CheckBoxNode child = (CheckBoxNode)rootNode.getChildAt(i2);
            this.pruneUneditables(child, model);
            Pack pack = child.getPack();
            boolean cantInstall = !rules.canInstallPack(pack.id, variables);
            boolean cantInstallOptional = !rules.canInstallPackOptional(pack.id, variables);
            boolean isHidden = pack.isHidden();
            if ((!cantInstall || !cantInstallOptional) && !isHidden) continue;
            copy.removeNodeFromParent(child);
        }
        return copy;
    }

    void refreshFromPackStates() {
        CheckBoxNode root = (CheckBoxNode)this.treePacks.getModel().getRoot();
        this.checkTreeController.initStates(root);
        this.checkTreeController.updateAllParents(root);
    }

    private void createTreeData() {
        this.treeData = new HashMap();
        this.idToPack = new HashMap();
        for (Pack pack : PackHandler.getAvailablePacks()) {
            this.idToPack.put(pack.id, pack);
            if (pack.parent == null) continue;
            ArrayList<String> kids = null;
            kids = this.treeData.containsKey(pack.parent) ? this.treeData.get(pack.parent) : new ArrayList<String>();
            kids.add(pack.id);
            this.treeData.put(pack.parent, kids);
        }
    }

    public void setDescription(String id) {
        Pack pack;
        if (this.descriptionArea != null && id != null && id.length() > 0 && (pack = this.idToPack.get(id)) != null) {
            String desc = "";
            String key = pack.id + ".description";
            if (pack.id != null && !"".equals(pack.id)) {
                desc = this.idata.langpack.getString(key);
            }
            if ("".equals(desc) || key.equals(desc)) {
                desc = pack.description;
            }
            String requires = this.getRequiresText(pack);
            String requiredBy = this.getRequiredByText(pack);
            if (requires != null) {
                desc = "(" + this.idata.langpack.getString("CCServerPacksPanel.requires") + ": " + requires + ")\n\n" + desc;
            }
            if (requiredBy != null) {
                desc = "(" + this.idata.langpack.getString("CCServerPacksPanel.requiredby") + ": " + requiredBy + ")\n\n" + desc;
            }
            if (desc == null || desc.length() == 0) {
                desc = " ";
            }
            this.descriptionArea.setText(desc);
        }
    }

    private String getRequiredByText(Pack pack) {
        StringBuilder sb = new StringBuilder();
        List<String> reverseDependencies = pack.getReverseDependencies();
        if (reverseDependencies != null) {
            for (String string : reverseDependencies) {
                Pack pack2 = PackHandler.getPackByName(string);
                if (pack2 == null) continue;
                sb.append(this.getI18NPackName(pack2)).append(", ");
            }
            if (sb.length() > 0) {
                String result = sb.toString();
                return result.substring(0, result.length() - 2);
            }
        }
        return null;
    }

    private String getRequiresText(Pack pack) {
        if (pack.getDependencies() != null) {
            StringBuilder sb = new StringBuilder();
            block0: for (String dependency : pack.getDependencies()) {
                for (Pack p2 : PackHandler.getAvailablePacks()) {
                    if (!p2.name.equals(dependency)) continue;
                    sb.append(this.getI18NPackName(p2)).append(", ");
                    continue block0;
                }
            }
            if (sb.length() > 0) {
                String result = sb.toString();
                return result.substring(0, result.length() - 2);
            }
        }
        return null;
    }

    CheckBoxNode getCheckBoxNodeByName(String name) {
        return this.nameToCheckBoxNode.get(name);
    }

    private CheckBoxNode populateTreePacks(String parentID) {
        if (parentID == null) {
            ArrayList<CheckBoxNode> rootNodes = new ArrayList<CheckBoxNode>();
            for (Pack pack : PackHandler.getAvailablePacks()) {
                if (pack.parent != null) continue;
                rootNodes.add(this.populateTreePacks(pack.id));
            }
            CheckBoxNode nv = new CheckBoxNode("Root", "Root", rootNodes.toArray(), true);
            return nv;
        }
        ArrayList<CheckBoxNode> links = new ArrayList<CheckBoxNode>();
        ArrayList<String> childsObject = this.treeData.get(parentID);
        Pack pack = this.idToPack.get(parentID);
        String translated = this.getI18NPackName(parentID);
        if (childsObject != null) {
            List childs = childsObject;
            for (Object child : childs) {
                String childID = (String)child;
                links.add(this.populateTreePacks(childID));
            }
            CheckBoxNode cbn = new CheckBoxNode(parentID, translated, links.toArray(), true);
            this.nameToCheckBoxNode.put(pack.name, cbn);
            cbn.setPack(pack);
            cbn.setTotalSize(pack.nbytes);
            return cbn;
        }
        CheckBoxNode cbn = new CheckBoxNode(parentID, translated, true);
        this.nameToCheckBoxNode.put(pack.name, cbn);
        cbn.setPack(pack);
        cbn.setTotalSize(pack.nbytes);
        return cbn;
    }

    @Override
    public JPanel initPanelGUI() {
        this.localPanel = new JPanel();
        try {
            this.packToRowNumber = new HashMap();
            List<Pack> availablePacks = PackHandler.getAvailablePacks();
            for (Pack pack : availablePacks) {
                this.packToRowNumber.put(pack, availablePacks.indexOf(pack));
            }
            this.createTreeData();
            this.createNormalLayout();
            this.refreshFromPackStates();
            CheckBoxNode root = (CheckBoxNode)this.treePacks.getModel().getRoot();
            this.checkTreeController.updateParents(root);
            CheckTreeController.initTotalSize(root, false);
            this.treePacks.revalidate();
            this.treePacks.repaint();
            this.tableScroller.setColumnHeaderView(null);
            this.tableScroller.setColumnHeader(null);
            this.bytes = 0L;
            for (Pack pack : PackHandler.getAvailablePacks()) {
                if (pack.isRequired()) {
                    this.bytes += pack.nbytes;
                    continue;
                }
                if (!PackHandler.getSelectedPacks().contains(pack)) continue;
                this.bytes += pack.nbytes;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return this.localPanel;
    }

    @Override
    public String getSummaryBody() {
        StringBuffer retval = new StringBuffer(256);
        boolean first = true;
        ArrayList<String> dependencies = new ArrayList<String>();
        for (Pack pack : PackHandler.getSelectedPacks()) {
            if (pack == null || pack.getDependencies() == null) continue;
            dependencies.addAll(pack.getDependencies());
        }
        HashSet s2 = new HashSet(dependencies);
        dependencies = new ArrayList(s2);
        block1: for (String packToShow : Constants.PACKAGES_TO_SHOW) {
            for (Pack pack : PackHandler.getSelectedPacks()) {
                if (!pack.id.equalsIgnoreCase(packToShow) || dependencies.contains(pack.name)) continue;
                if (!first) {
                    retval.append("<br>");
                }
                retval.append(this.getI18NPackName(pack));
                first = false;
                continue block1;
            }
        }
        return retval.toString();
    }

    public JTree getTree() {
        return this.treePacks;
    }
}

