/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.widget.DrivesRenderPanel;
import com.inet.setup.panels.widget.DrivesThread;
import com.inet.setup.panels.widget.SortedListModel;
import com.inet.textui.Group;
import com.inet.textui.ListGroup;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class CCPathPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private JPanel localPanel = new JPanel();
    private JPanel pnlPrevInstallation = new JPanel();
    private JPanel pnlPathSelection;
    private JPanel pnlAvailableDrives;
    private JPanel pnlSelection;
    private JButton btnSelection;
    private JTextField txtSelection;
    private JComboBox boxPrevInstallation = new JComboBox();
    private ButtonGroup groupSearchButtons = new ButtonGroup();
    private AbstractAction actionFileOpen;
    private FilteredVariables filteredVariables;
    private JList listDrives;
    private JTextField txtInstallationSize;
    private boolean isUpdate;
    private boolean mustExist;
    private boolean first;
    private String origInstallPath;
    private static String defaultInstallDir = null;
    private static File currentPath = null;
    private VersionInformation prevVersion;

    public CCPathPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("CCPathPanel.choosepath"), null, null, "com/inet/setup/images/Path48.png");
        this.actionFileOpen = new AbstractAction(this.parent.langpack.getString("CCPathPanel.search")){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    CCPathPanel.this.createFileChooser(new File(CCPathPanel.this.txtSelection.getText().trim()));
                }
                catch (Exception e1) {
                    DrivesRenderPanel panel = (DrivesRenderPanel)CCPathPanel.this.listDrives.getModel().getElementAt(CCPathPanel.this.listDrives.getSelectedIndex());
                    CCPathPanel.this.createFileChooser(panel.getCurrentDrive());
                }
            }
        };
        this.listDrives = new JList(new SortedListModel());
        this.isUpdate = false;
        this.mustExist = false;
        this.first = true;
        this.prevVersion = null;
        if (!GraphicsEnvironment.isHeadless()) {
            DrivesThread threadDriveReader = new DrivesThread(this.getFileRoots(), parent, this.listDrives);
            threadDriveReader.start();
        }
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("modify.izpack.install", null);
        requiredVariables.put("ShowCreateDirectoryMessage", null);
        requiredVariables.put("INSTALL_PATH", null);
        requiredVariables.put("IS_UPDATE", null);
        requiredVariables.put("REDIRECTURLDOC", null);
        requiredVariables.put("REDIRECTURLGS", null);
        requiredVariables.put("I18N_CONFIGMAN_INFO", null);
        requiredVariables.put("INSTALLDATE", null);
        requiredVariables.put("INSTALLPATH", null);
        requiredVariables.put("INSTALLVERSION", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
        if (!GraphicsEnvironment.isHeadless()) {
            Object elementAt;
            if (this.first && !OsVersion.IS_WINDOWS) {
                File installPath = new File(this.idata.getInstallPath());
                if ((installPath = installPath.getParentFile()) != null) {
                    DrivesRenderPanel element;
                    SortedListModel defaultListModel = (SortedListModel)this.listDrives.getModel();
                    if (!defaultListModel.contains(element = new DrivesRenderPanel(installPath, this.parent))) {
                        defaultListModel.add(element);
                    }
                    this.listDrives.setSelectedIndex(defaultListModel.getIndexOfElement(element));
                }
                if (this.listDrives.getSelectedIndex() == -1 && this.listDrives.getModel().getSize() > 0) {
                    this.listDrives.setSelectedIndex(0);
                }
                this.first = false;
            }
            if (this.listDrives.getSelectedIndex() == -1 && this.listDrives.getModel().getSize() > 0) {
                this.listDrives.setSelectedIndex(0);
            }
            if ((elementAt = ((SortedListModel)this.listDrives.getModel()).getElementAt(this.listDrives.getSelectedIndex())) != null) {
                currentPath = ((DrivesRenderPanel)elementAt).getCurrentDrive();
            }
            long installationBytes = 0L;
            for (Pack pack : this.idata.getSelectedPacks()) {
                installationBytes += pack.nbytes;
            }
            this.txtInstallationSize.setText(this.parent.langpack.getString("CCPathPanel.InstallSize") + ": " + Pack.toByteUnitsString(installationBytes));
        }
    }

    public void panelFinish() {
        String choosenPath = this.txtSelection.getText().trim();
        if (OsVersion.IS_LINUX || OsVersion.IS_MAC || OsVersion.IS_OSX || OsVersion.IS_UNIX) {
            choosenPath = choosenPath.replace("\\ ", " ");
        }
        this.idata.setInstallPath(choosenPath);
        this.filteredVariables.setVariable("INSTALL_PATH", choosenPath);
        this.filteredVariables.setVariable("INSTALLPATH", choosenPath);
        this.filteredVariables.setVariable("modify.izpack.install", "false");
        this.filteredVariables.setVariable("ShowCreateDirectoryMessage", "true");
        this.filteredVariables.setVariable("IS_UPDATE", Boolean.toString(this.isUpdate));
        this.filteredVariables.setVariable("REDIRECTURLDOC", "client/documentation/manual.html");
        this.filteredVariables.setVariable("REDIRECTURLGS", "client/documentation/gettingstarted.html");
        String string = this.parent.langpack.getString("config_select.subtitle");
        try {
            string = string.replaceAll("\\<.*?\\>", "");
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.filteredVariables.setVariable("I18N_CONFIGMAN_INFO", string);
        String tmp = choosenPath + File.separator + "setup_tmp" + File.separator;
        if (new File(tmp).exists()) {
            this.deleteTmp(tmp);
        }
        this.putToSummary(this.parent.langpack.getString("CCPathPanel.heading"), choosenPath, 0);
        if (this.prevVersion != null && this.prevVersion.hasSamePath(choosenPath)) {
            this.putPrevValuesToInstallation();
        }
    }

    @Override
    public JPanel initPanelGUI() {
        this.localPanel.setLayout(new GridBagLayout());
        if (!GraphicsEnvironment.isHeadless()) {
            this.pnlAvailableDrives = this.createDrivesPanel();
            String drivesPanelLabel = "CCPathPanel.drives";
            if (OsVersion.IS_LINUX) {
                drivesPanelLabel = "CCPathPanel.drives.linux";
            }
            this.pnlAvailableDrives.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString(drivesPanelLabel)));
            this.localPanel.add((Component)this.pnlAvailableDrives, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, GUIUtils.TITLED_INSETS_TOP, 0, 0));
        }
        Preferences prefs = Preferences.systemRoot();
        prefs = prefs.node("crinstallpreferences");
        this.pnlPrevInstallation = this.createPrevInstallationPanel();
        if (this.pnlPrevInstallation != null) {
            TitledBorder createTitledBorder = BorderFactory.createTitledBorder(this.parent.langpack.getString("CCPathPanel.prevselection"));
            Border createEmptyBorder = BorderFactory.createEmptyBorder(5, 10, 10, 10);
            this.pnlPrevInstallation.setBorder(BorderFactory.createCompoundBorder(createTitledBorder, createEmptyBorder));
            this.localPanel.add((Component)this.pnlPrevInstallation, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_BOTTOM, 0, 0));
        }
        this.pnlPathSelection = this.createSelectionPanel();
        this.pnlPathSelection.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString("CCPathPanel.pathselection")));
        this.localPanel.add((Component)this.pnlPathSelection, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_BOTTOM, 0, 0));
        return this.localPanel;
    }

    private void putPrevValuesToInstallation() {
        ArrayList<String> ignore = new ArrayList<String>();
        ignore.add("COMPONENT_TO_INSTALL".toLowerCase());
        ignore.add("INSTALLDATE".toLowerCase());
        ignore.add("INSTALLPATH".toLowerCase());
        ignore.add("INSTALLVERSION".toLowerCase());
        ignore.add("INSTALLVERSION".toLowerCase());
        Preferences prefs = this.prevVersion.getNode();
        try {
            String[] keys;
            for (String key : keys = prefs.keys()) {
                if (ignore.contains(key.toLowerCase())) continue;
                this.idata.setVariable(key.toUpperCase(), prefs.get(key, ""));
            }
        }
        catch (BackingStoreException e2) {
            Debug.error(e2);
        }
    }

    private ArrayList<VersionInformation> readPrefs(Preferences prefs) {
        ArrayList<VersionInformation> vrList = new ArrayList<VersionInformation>();
        try {
            String[] keys;
            for (String child : keys = prefs.childrenNames()) {
                Preferences node = prefs.node(child);
                String path = node.get("INSTALLPATH".toLowerCase(), "path");
                String version = node.get("INSTALLVERSION".toLowerCase(), "Version 0");
                String date = node.get("INSTALLDATE".toLowerCase(), "0");
                String component = node.get("COMPONENT_TO_INSTALL".toLowerCase(), "null");
                if (!(path.equalsIgnoreCase("path") && version.equalsIgnoreCase("Version 0") && date.equalsIgnoreCase("0") && "COMPONENT_TO_INSTALL".toLowerCase().equalsIgnoreCase("null"))) {
                    VersionInformation versionrenderer = new VersionInformation(version, path, date, node);
                    if (component.trim().length() > 0) {
                        versionrenderer.addComponentName(component.trim());
                    }
                    vrList.add(versionrenderer);
                    continue;
                }
                node.removeNode();
            }
        }
        catch (BackingStoreException e2) {
            Debug.error(e2);
        }
        return vrList;
    }

    private JPanel createPrevInstallationPanel() {
        JPanel pnlPrev = new JPanel();
        pnlPrev.setLayout(new BorderLayout());
        ArrayList<VersionInformation> vrList = new ArrayList<VersionInformation>();
        Preferences prefs = Preferences.systemRoot();
        prefs = prefs.node("crinstallpreferences");
        vrList.addAll(this.readPrefs(prefs));
        prefs = Preferences.userRoot();
        prefs = prefs.node("crinstallpreferences");
        vrList.addAll(this.readPrefs(prefs));
        ArrayList vrListCopy = new ArrayList();
        vrListCopy = new ArrayList(vrList);
        for (VersionInformation versionRenderer : vrList) {
            for (VersionInformation versionRenderer2 : vrList) {
                if (!versionRenderer.hasSamePath(versionRenderer2) || versionRenderer == versionRenderer2) continue;
                if (versionRenderer.isInstallationAfter(versionRenderer2)) {
                    vrListCopy.remove(versionRenderer2);
                    continue;
                }
                vrListCopy.remove(versionRenderer);
            }
            if (versionRenderer.path.exists()) continue;
            vrListCopy.remove(versionRenderer);
        }
        vrList = vrListCopy;
        if (vrList.size() == 0) {
            return null;
        }
        this.boxPrevInstallation = new JComboBox<Object>(vrList.toArray());
        this.boxPrevInstallation.insertItemAt(this.parent.langpack.getString("CCPathPanel.prevSelection"), 0);
        this.boxPrevInstallation.setSelectedIndex(0);
        this.boxPrevInstallation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Object selectedItem = CCPathPanel.this.boxPrevInstallation.getSelectedItem();
                if (selectedItem instanceof VersionInformation) {
                    VersionInformation r2 = (VersionInformation)selectedItem;
                    CCPathPanel.this.prevVersion = r2;
                    CCPathPanel.this.txtSelection.setText(r2.getPath().getAbsolutePath());
                    if (!((CCPathPanel)CCPathPanel.this).parent.langpack.getString("CCPathPanel.noPrevSelection").equalsIgnoreCase(CCPathPanel.this.boxPrevInstallation.getItemAt(0).toString())) {
                        CCPathPanel.this.boxPrevInstallation.removeItemAt(0);
                        CCPathPanel.this.boxPrevInstallation.insertItemAt(((CCPathPanel)CCPathPanel.this).parent.langpack.getString("CCPathPanel.noPrevSelection"), 0);
                    }
                }
            }
        });
        this.boxPrevInstallation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                int stateChange = e2.getStateChange();
                Object item = e2.getItem();
                if (stateChange == 1 && !(item instanceof VersionInformation)) {
                    CCPathPanel.this.prevVersion = null;
                }
            }
        });
        pnlPrev.add((Component)this.boxPrevInstallation, "Center");
        return pnlPrev;
    }

    private JPanel createSelectionPanel() {
        this.pnlSelection = new JPanel();
        this.pnlSelection.setLayout(new GridBagLayout());
        this.origInstallPath = this.filteredVariables.getVariable("INSTALL_PATH");
        this.txtSelection = new JTextField(this.origInstallPath);
        this.txtSelection.setName("CCPathPanel_txtSelection");
        this.btnSelection = new JButton(this.actionFileOpen);
        this.btnSelection.setName("btnSelection");
        this.groupSearchButtons.add(this.btnSelection);
        this.pnlSelection.add((Component)this.txtSelection, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        this.pnlSelection.add((Component)this.btnSelection, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        return this.pnlSelection;
    }

    private JPanel createDrivesPanel() {
        this.txtInstallationSize = new JTextField();
        this.txtInstallationSize.setMargin(new Insets(5, 10, 5, 10));
        this.txtInstallationSize.setHorizontalAlignment(11);
        this.txtInstallationSize.setEditable(false);
        this.txtInstallationSize.setFocusable(false);
        this.txtInstallationSize.setName("CCPathPanel_txtInstallationSize");
        this.txtInstallationSize.setBackground(new JTextField().getBackground());
        this.listDrives.setName("listDrives");
        this.listDrives.setSelectionMode(0);
        this.listDrives.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof DrivesRenderPanel) {
                    return (DrivesRenderPanel)value;
                }
                return this;
            }
        });
        this.listDrives.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() > 1) {
                    DrivesRenderPanel panel = (DrivesRenderPanel)CCPathPanel.this.listDrives.getModel().getElementAt(CCPathPanel.this.listDrives.getSelectedIndex());
                    CCPathPanel.this.createFileChooser(panel.getCurrentDrive());
                }
            }
        });
        this.listDrives.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                if (e2.getValueIsAdjusting()) {
                    CCPathPanel.this.updateSelection();
                }
            }
        });
        this.listDrives.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e2) {
                CCPathPanel.this.updateSelection();
            }

            @Override
            public void keyReleased(KeyEvent e2) {
                CCPathPanel.this.updateSelection();
            }

            @Override
            public void keyPressed(KeyEvent e2) {
                CCPathPanel.this.updateSelection();
            }
        });
        JScrollPane scrollDrivesList = new JScrollPane(this.listDrives, 20, 31){

            @Override
            public Dimension getMinimumSize() {
                Dimension minimumSize = super.getMinimumSize();
                minimumSize.height = Math.max(minimumSize.height, 150);
                return minimumSize;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                preferredSize.height = Math.max(preferredSize.height, 150);
                return preferredSize;
            }
        };
        scrollDrivesList.setBorder(new JTextField().getBorder());
        scrollDrivesList.getVerticalScrollBar().setUnitIncrement(10);
        JPanel pnlWrapper = new JPanel();
        pnlWrapper.setLayout(new GridBagLayout());
        pnlWrapper.add((Component)scrollDrivesList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        pnlWrapper.add((Component)this.txtInstallationSize, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 10, 10), 0, 0));
        return pnlWrapper;
    }

    private void updateSelection() {
        DrivesRenderPanel panel = (DrivesRenderPanel)this.listDrives.getModel().getElementAt(this.listDrives.getSelectedIndex());
        currentPath = this.switchRoot(this.txtSelection.getText().trim(), panel.getCurrentDrive(), currentPath);
    }

    private List<File> getFileRoots() {
        ArrayList<File> rootDrives = new ArrayList<File>();
        if (OsVersion.IS_WINDOWS) {
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            List<File> roots = Arrays.asList(File.listRoots());
            for (File file : roots) {
                if (fileSystemView.isFloppyDrive(file)) continue;
                rootDrives.add(file);
            }
            return rootDrives;
        }
        if (OsVersion.IS_LINUX && !OsVersion.IS_MAC) {
            String property = System.getProperty("user.home");
            String sep = String.valueOf(File.separatorChar);
            rootDrives.add(new File(sep));
            rootDrives.add(new File(sep + "opt" + sep));
            rootDrives.add(new File(sep + "usr" + sep + "share" + sep));
            rootDrives.add(new File(property + sep));
            rootDrives.add(new File(property + sep + "Desktop" + sep));
            return rootDrives;
        }
        if (OsVersion.IS_MAC) {
            String sep = String.valueOf(File.separatorChar);
            File f2 = new File(sep + "Volumes" + sep);
            File[] listFiles = f2.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            rootDrives.add(new File(sep + "Applications" + sep));
            for (File file : listFiles) {
                rootDrives.add(file);
            }
            return rootDrives;
        }
        return null;
    }

    @Override
    public boolean isValidated() {
        boolean modifyinstallation;
        String choosenPath = this.txtSelection.getText().trim();
        if (choosenPath != null && choosenPath.length() > 0) {
            choosenPath = new File(choosenPath).getAbsolutePath();
        }
        boolean ok = true;
        if (choosenPath.length() == 0) {
            if (this.isMustExist()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString("CCPathPanel.required"));
                if (GraphicsEnvironment.isHeadless()) {
                    this.txtSelection.setText(this.origInstallPath);
                }
                this.txtSelection.requestFocus();
                return false;
            }
            boolean bl2 = ok = this.askQuestion(this.parent.langpack.getString("installer.Message"), this.parent.langpack.getString("TargetPanel.emptyTargetMsg"), 37) == 47;
            if (ok) {
                choosenPath = this.filteredVariables.getVariable("INSTALL_PATH");
                this.txtSelection.setText(choosenPath);
            } else {
                this.txtSelection.requestFocus();
                return false;
            }
        }
        if (modifyinstallation = "true".equalsIgnoreCase(this.filteredVariables.getVariable("modify.izpack.install"))) {
            this.mustExist = true;
            File installationinformation = new File(this.txtSelection.getText().trim() + File.separator + ".installationinformation");
            if (!installationinformation.exists()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString("CCPathPanel.required.forModificationInstallation"));
                if (GraphicsEnvironment.isHeadless()) {
                    this.txtSelection.setText(this.origInstallPath);
                }
                this.txtSelection.requestFocus();
                return false;
            }
        }
        if (choosenPath.startsWith("~")) {
            String home = System.getProperty("user.home");
            choosenPath = home + choosenPath.substring(1);
        }
        File path = new File(choosenPath).getAbsoluteFile();
        choosenPath = path.toString();
        if (this.isMustExist()) {
            if (!path.exists()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString("CCPathPanel.required"));
                if (GraphicsEnvironment.isHeadless()) {
                    this.txtSelection.setText(this.origInstallPath);
                }
                this.txtSelection.requestFocus();
                return false;
            }
        } else {
            if (!this.isWriteable()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString("TargetPanel.notwritable"));
                if (GraphicsEnvironment.isHeadless()) {
                    this.txtSelection.setText(this.origInstallPath);
                }
                this.txtSelection.requestFocus();
                return false;
            }
            if (path.exists()) {
                int res = this.askQuestion(this.parent.langpack.getString("installer.Message"), this.parent.langpack.getString("TargetPanel.warnMsg"), 37, 47);
                boolean bl3 = ok = res == 47;
                if (!ok && GraphicsEnvironment.isHeadless()) {
                    this.txtSelection.setText(this.origInstallPath);
                }
                this.isUpdate = true;
            } else {
                this.isUpdate = false;
            }
        }
        if (!ok) {
            this.txtSelection.requestFocus();
            return false;
        }
        this.panelFinish();
        return super.isValidated();
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public void setMustExist(boolean b2) {
        this.mustExist = b2;
    }

    private void deleteTmp(String delete_dir) {
        try {
            Vector<String> dirs = new Vector<String>();
            File f2 = new File(delete_dir);
            if (!f2.exists()) {
                return;
            }
            File[] list = f2.listFiles();
            if (list == null) {
                return;
            }
            if (list.length == 0) {
                f2.delete();
            } else {
                for (int i2 = 0; i2 < list.length; ++i2) {
                    if (list[i2].isFile()) {
                        list[i2].delete();
                        continue;
                    }
                    dirs.addElement(list[i2].getAbsolutePath());
                }
                for (int j2 = 0; j2 < dirs.size(); ++j2) {
                    this.deleteTmp((String)dirs.elementAt(j2));
                    new File((String)dirs.elementAt(j2)).delete();
                }
                f2.delete();
            }
        }
        catch (Exception e2) {
            this.emitError(null, e2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteable() {
        File existParent = IoHelper.existingParent(new File(this.txtSelection.getText().trim()));
        if (existParent == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            File tmpFile = null;
            try {
                tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
            }
            catch (IOException e2) {
                Debug.log((Object)e2.toString(), this.getClass());
                boolean bl2 = false;
                return bl2;
            }
            finally {
                if (tmpFile != null) {
                    try {
                        tmpFile.delete();
                    }
                    catch (Exception e2) {
                        tmpFile.deleteOnExit();
                    }
                }
            }
            return true;
        }
        return existParent.canWrite();
    }

    public static String getDefaultInstallDir() {
        return defaultInstallDir;
    }

    public static void setDefaultInstallDir(String string) {
        defaultInstallDir = string;
    }

    @Override
    public Group getTextUiGroup() {
        ListGroup g2 = new ListGroup();
        g2.addEntry(this.parent.langpack.getString("CCPathPanel.pathselection"), this.txtSelection);
        return g2;
    }

    private void generatePath(File selectedFile) {
        String absolutePath = selectedFile.getAbsolutePath();
        this.txtSelection.setText(absolutePath);
    }

    private File switchRoot(String currentTextFieldContent, File destinationDriveFile, File sourceDriveFile) {
        if (destinationDriveFile == null || sourceDriveFile == null) {
            File file = new File(currentTextFieldContent);
            this.txtSelection.setText(file.getAbsolutePath());
            return file;
        }
        if (destinationDriveFile.equals(sourceDriveFile)) {
            return destinationDriveFile;
        }
        if (currentTextFieldContent.trim().length() == 0) {
            this.txtSelection.setText(destinationDriveFile.getAbsolutePath());
            return destinationDriveFile;
        }
        String sourceDrive = sourceDriveFile.getAbsolutePath();
        String destinationDrive = destinationDriveFile.getAbsolutePath();
        sourceDrive = sourceDrive.endsWith(File.separator) ? sourceDrive : sourceDrive + File.separator;
        destinationDrive = destinationDrive.endsWith(File.separator) ? destinationDrive : destinationDrive + File.separator;
        sourceDrive = sourceDrive.replace("\\", "\\\\");
        destinationDrive = destinationDrive.replace("\\", "\\\\");
        currentTextFieldContent = currentTextFieldContent.replaceFirst(sourceDrive, destinationDrive);
        this.txtSelection.setText(currentTextFieldContent);
        return destinationDriveFile;
    }

    private void createFileChooser(File preselection) throws HeadlessException {
        File selectedFile;
        String selectedFileName = null;
        while (!preselection.exists() && preselection.getParent() != null && preselection.getParent() != "") {
            String tmp = selectedFileName != null ? File.separator + selectedFileName : "";
            selectedFileName = preselection.getName() + tmp;
            preselection = new File(preselection.getParent());
        }
        JFileChooser fileDialog = new JFileChooser(preselection.getAbsolutePath());
        fileDialog.setLocale(Locale.getDefault());
        fileDialog.updateUI();
        FileChooserUI fileChooserUI = fileDialog.getUI();
        if (fileChooserUI instanceof BasicFileChooserUI) {
            BasicFileChooserUI basicFileChooserUI = (BasicFileChooserUI)fileChooserUI;
            if (selectedFileName != null) {
                basicFileChooserUI.setFileName(new File(selectedFileName).getAbsolutePath());
                basicFileChooserUI.setDirectoryName(new File(selectedFileName).getAbsolutePath());
            } else {
                basicFileChooserUI.setFileName(this.idata.getVariable("APP_NAME"));
                basicFileChooserUI.setDirectoryName(this.idata.getVariable("APP_NAME"));
            }
        } else if (selectedFileName != null) {
            fileDialog.setSelectedFile(new File(selectedFileName));
        } else {
            fileDialog.setSelectedFile(new File(preselection.getAbsolutePath() + this.idata.getVariable("APP_NAME")));
        }
        fileDialog.setMultiSelectionEnabled(false);
        fileDialog.setFileSelectionMode(1);
        fileDialog.setFileFilter(new javax.swing.filechooser.FileFilter(){

            @Override
            public String getDescription() {
                return ((CCPathPanel)CCPathPanel.this).parent.langpack.getString("ServletPanel.directorys_only");
            }

            @Override
            public boolean accept(File f2) {
                return f2.isDirectory();
            }
        });
        if (fileDialog.showOpenDialog(this.localPanel) == 0) {
            selectedFile = fileDialog.getSelectedFile();
            if (selectedFile.isFile()) {
                selectedFile = selectedFile.getParentFile();
            }
        } else {
            return;
        }
        this.generatePath(selectedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDefaultInstallDir(InstallerFrame parentFrame, InstallData idata) {
        if (CCPathPanel.getDefaultInstallDir() != null) {
            return;
        }
        BufferedReader br2 = null;
        try {
            InputStream in = null;
            if (OsVersion.IS_WINDOWS) {
                try {
                    in = parentFrame.getResource("TargetPanel.dir.windows");
                }
                catch (ResourceNotFoundException rnfe) {}
            } else if (OsVersion.IS_OSX) {
                try {
                    in = parentFrame.getResource("TargetPanel.dir.macosx");
                }
                catch (ResourceNotFoundException rnfe) {}
            } else {
                String os = System.getProperty("os.name");
                os = os.replace(' ', '_');
                os = os.toLowerCase();
                try {
                    in = parentFrame.getResource("TargetPanel.dir.".concat(os));
                }
                catch (ResourceNotFoundException rnfe) {
                    // empty catch block
                }
                if (in == null) {
                    try {
                        in = parentFrame.getResource("TargetPanel.dir.unix");
                    }
                    catch (ResourceNotFoundException eee) {
                        // empty catch block
                    }
                }
            }
            if (in == null) {
                try {
                    in = parentFrame.getResource("TargetPanel.dir");
                }
                catch (ResourceNotFoundException eee) {
                    // empty catch block
                }
            }
            if (in != null) {
                String line;
                InputStreamReader isr = new InputStreamReader(in);
                br2 = new BufferedReader(isr);
                while ((line = br2.readLine()) != null && "".equals(line = line.trim())) {
                }
                defaultInstallDir = line;
                VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
                defaultInstallDir = vs.substitute(defaultInstallDir, null);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            defaultInstallDir = null;
        }
        finally {
            try {
                if (br2 != null) {
                    br2.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private class VersionInformation {
        private final String version;
        private final File path;
        private final Date date;
        private final String timestamp;
        private String compName = "";
        private final Preferences node;

        public VersionInformation(String version, String path, String date, Preferences node) {
            this.version = version;
            this.node = node;
            this.path = new File(path);
            this.timestamp = date;
            this.date = new Date(Long.parseLong(date));
        }

        public void addComponentName(String compNameLocal) {
            this.compName = compNameLocal;
        }

        public boolean hasSamePath(String choosenPath) {
            try {
                File f2 = new File(choosenPath);
                return this.path.equals(f2);
            }
            catch (Exception e2) {
                return false;
            }
        }

        public String toString() {
            String dateString = "";
            try {
                DateFormat format = DateFormat.getDateInstance(3);
                dateString = " (" + format.format(this.getDate()) + ") ";
            }
            catch (Exception e2) {
                // empty catch block
            }
            String name = "";
            if (this.compName != null && !this.compName.isEmpty()) {
                if (this.compName.equalsIgnoreCase("designer")) {
                    name = "i-net Designer";
                } else if (this.compName.equalsIgnoreCase("server")) {
                    name = "i-net Clear Reports Server";
                } else if (this.compName.equalsIgnoreCase("custom")) {
                    name = "i-net Clear Reports Server/Designer";
                }
            }
            return name + " - Version " + this.getVersion() + dateString + this.getPath().getAbsolutePath();
        }

        public String getVersion() {
            return this.version;
        }

        public File getPath() {
            return this.path;
        }

        public Date getDate() {
            return this.date;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public boolean hasSamePath(VersionInformation vr) {
            return this.path.equals(vr.getPath());
        }

        public boolean isInstallationAfter(VersionInformation vr) {
            return this.date.after(vr.getDate());
        }

        public Preferences getNode() {
            return this.node;
        }
    }
}

