/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.setup.Constants;
import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.widget.ConfigurationInputPanel;
import com.inet.setup.panels.widget.ConfigurationSelectionPanel;
import com.inet.setup.panels.widget.PropertiesImportPanel;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class CCRemotePropertiesPanel
extends AbstractPanel
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private JRadioButton radioCreateNew;
    private JRadioButton radioUseOld;
    private ButtonGroup groupConfigSelection;
    private JPanel pnlSelectImportType;
    private JLabel lblSelectImportType;
    private JPanel localPanel;
    private JPanel pnlFiller;
    private String config_name = "";
    private String scope_name = "";
    private String property = "";
    private String new_default_name = "new";
    private String import_default_name = "crystalclear";
    private FilteredVariables filteredVariables;
    private JRadioButton radioUseLocalCopy;
    private JRadioButton radioUseImporedPropertie;
    private JRadioButton radioUseCurrentActive;
    private JRadioButton radioUseUserDefined;
    private JRadioButton radioUseDefault;
    private ButtonGroup groupCreateNew;
    private ButtonGroup groupUseOld;
    private ConfigurationInputPanel pnlCreateNew;
    private PropertiesImportPanel pnlUseImporedPropertie;
    private ConfigurationSelectionPanel pnlUseLocalCopy;
    private ConfigurationInputPanel pnlUseUserDefined;

    public CCRemotePropertiesPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("CCPropertiesPanel.heading"), null, null, "com/inet/setup/images/Database48.png");
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("SELECTED_PROPERTY", null);
        requiredVariables.put("CONFIG_NAME", null);
        requiredVariables.put("SCOPE_NAME", null);
        requiredVariables.put("SCOPE_INT", null);
        requiredVariables.put("SELECTED", null);
        requiredVariables.put("ALLOWED_SYSTEM_SCOPES", null);
        requiredVariables.put("CONFIG_NAME_XML", null);
        requiredVariables.put("USER_NAME", null);
        requiredVariables.put("hasConfigs", null);
        requiredVariables.put("SCOPE_CONFIG", null);
        requiredVariables.put("PRESELECTED_SCOPE", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
        int allowedScope = Integer.parseInt(this.filteredVariables.getVariable("ALLOWED_SYSTEM_SCOPES"));
        int preselectedScope = Integer.parseInt(this.filteredVariables.getVariable("PRESELECTED_SCOPE"));
        this.pnlCreateNew.updateBox(allowedScope, preselectedScope);
        this.pnlUseLocalCopy.updateBox(allowedScope, preselectedScope);
        this.pnlUseUserDefined.updateBox(allowedScope, preselectedScope);
        this.initComponentState();
    }

    private void initComponentState() {
        this.config_name = this.filteredVariables.getVariable("CONFIG_NAME");
        String selected = this.filteredVariables.getVariable("SELECTED");
        if (this.pnlUseLocalCopy.isForceDisabled()) {
            this.radioUseLocalCopy.setEnabled(false);
        } else {
            this.radioUseLocalCopy.setEnabled(true);
        }
        if (selected != null && !"".equalsIgnoreCase(selected)) {
            if (selected.equalsIgnoreCase("CREATE_NEW")) {
                this.groupConfigSelection.setSelected(this.radioCreateNew.getModel(), true);
                this.groupCreateNew.setSelected(this.radioUseDefault.getModel(), true);
                this.itemStateChanged(new ItemEvent(this.radioUseOld, 701, this.radioUseOld, 2));
                this.itemStateChanged(new ItemEvent(this.radioUseLocalCopy, 701, this.radioUseLocalCopy, 2));
                this.itemStateChanged(new ItemEvent(this.radioUseImporedPropertie, 701, this.radioUseImporedPropertie, 2));
                if (this.pnlCreateNew != null && this.config_name != null) {
                    this.pnlCreateNew.setConfigName(this.config_name);
                }
            } else if (selected.equalsIgnoreCase("CREATE_FROM_LOCAL")) {
                this.groupConfigSelection.setSelected(this.radioCreateNew.getModel(), true);
                this.groupCreateNew.setSelected(this.radioUseLocalCopy.getModel(), true);
                this.itemStateChanged(new ItemEvent(this.radioUseOld, 701, this.radioUseOld, 2));
                this.itemStateChanged(new ItemEvent(this.radioUseDefault, 701, this.radioUseDefault, 2));
                this.itemStateChanged(new ItemEvent(this.radioUseImporedPropertie, 701, this.radioUseImporedPropertie, 2));
                if (this.pnlCreateNew != null && this.config_name != null) {
                    this.pnlCreateNew.setConfigName(this.config_name);
                }
            } else if (selected.equalsIgnoreCase("CREATE_FROM_PROPS")) {
                this.groupConfigSelection.setSelected(this.radioCreateNew.getModel(), true);
                this.groupCreateNew.setSelected(this.radioUseImporedPropertie.getModel(), true);
                this.itemStateChanged(new ItemEvent(this.radioUseOld, 701, this.radioUseOld, 2));
                this.itemStateChanged(new ItemEvent(this.radioUseDefault, 701, this.radioUseDefault, 2));
                this.itemStateChanged(new ItemEvent(this.radioUseLocalCopy, 701, this.radioUseLocalCopy, 2));
                this.property = this.filteredVariables.getVariable("SELECTED_PROPERTY");
                if (this.property != null && !this.property.startsWith("setup_tmp")) {
                    this.pnlUseImporedPropertie.setPropertyName(this.property);
                }
                if (this.pnlCreateNew != null && this.config_name != null) {
                    this.pnlCreateNew.setConfigName(this.config_name);
                }
            } else if (selected.equalsIgnoreCase("USE_ACTIVE")) {
                this.groupConfigSelection.setSelected(this.radioUseOld.getModel(), true);
                this.groupUseOld.setSelected(this.radioUseCurrentActive.getModel(), true);
                this.itemStateChanged(new ItemEvent(this.radioCreateNew, 701, this.radioCreateNew, 2));
                this.itemStateChanged(new ItemEvent(this.radioUseUserDefined, 701, this.radioUseUserDefined, 2));
            } else if (selected.equalsIgnoreCase("USE_ENTERED")) {
                this.groupConfigSelection.setSelected(this.radioUseOld.getModel(), true);
                this.groupUseOld.setSelected(this.radioUseUserDefined.getModel(), true);
                this.itemStateChanged(new ItemEvent(this.radioCreateNew, 701, this.radioCreateNew, 2));
                this.itemStateChanged(new ItemEvent(this.radioUseCurrentActive, 701, this.radioUseCurrentActive, 2));
            } else {
                this.groupConfigSelection.setSelected(this.radioUseOld.getModel(), true);
                this.groupUseOld.setSelected(this.radioUseCurrentActive.getModel(), true);
                this.itemStateChanged(new ItemEvent(this.radioCreateNew, 701, this.radioCreateNew, 2));
                this.itemStateChanged(new ItemEvent(this.radioUseUserDefined, 701, this.radioUseUserDefined, 2));
            }
        } else {
            this.groupConfigSelection.setSelected(this.radioUseOld.getModel(), true);
            this.groupUseOld.setSelected(this.radioUseCurrentActive.getModel(), true);
            this.itemStateChanged(new ItemEvent(this.radioCreateNew, 701, this.radioCreateNew, 2));
            this.itemStateChanged(new ItemEvent(this.radioUseUserDefined, 701, this.radioUseUserDefined, 2));
        }
    }

    public void panelFinish() {
        if (this.groupConfigSelection.isSelected(this.radioCreateNew.getModel())) {
            this.config_name = this.pnlCreateNew.getConfigName();
            this.scope_name = this.pnlCreateNew.getConfigScope();
            if (this.groupCreateNew.isSelected(this.radioUseDefault.getModel())) {
                this.property = "setup_tmp" + File.separatorChar + "crystalclear.properties";
                this.filteredVariables.setVariable("SELECTED", "CREATE_NEW");
            } else if (this.groupCreateNew.isSelected(this.radioUseImporedPropertie.getModel())) {
                this.property = this.pnlUseImporedPropertie.getPropertyName();
                this.filteredVariables.setVariable("SELECTED", "CREATE_FROM_PROPS");
            } else {
                this.filteredVariables.setVariable("SELECTED", "CREATE_FROM_LOCAL");
                this.property = this.pnlUseLocalCopy.getConfig();
            }
        } else if (this.groupConfigSelection.isSelected(this.radioUseOld.getModel())) {
            if (this.groupUseOld.isSelected(this.radioUseCurrentActive.getModel())) {
                this.filteredVariables.setVariable("SELECTED", "USE_ACTIVE");
            } else {
                this.filteredVariables.setVariable("SELECTED", "USE_ENTERED");
                this.config_name = this.pnlUseUserDefined.getConfigName();
                this.scope_name = this.pnlUseUserDefined.getConfigScope();
            }
        }
        this.filteredVariables.setVariable("SELECTED_PROPERTY", this.property);
        this.filteredVariables.setVariable("CONFIG_NAME", this.config_name);
        String config_name_xml = CCRemotePropertiesPanel.encodeXML(this.config_name);
        this.filteredVariables.setVariable("CONFIG_NAME_XML", config_name_xml);
        this.filteredVariables.setVariable("SCOPE_NAME", this.scope_name);
        if (this.scope_name.length() == 0) {
            this.filteredVariables.setVariable("SCOPE_CONFIG", "");
            this.filteredVariables.setVariable("SCOPE_INT", "");
        } else {
            this.filteredVariables.setVariable("SCOPE_INT", String.valueOf(Constants.getScopeValue(this.scope_name)));
            this.filteredVariables.setVariable("SCOPE_CONFIG", this.scope_name + "/" + config_name_xml);
        }
        if (this.radioCreateNew.isSelected()) {
            this.putToSummary(this.parent.langpack.getString("CCPropertiesPanel.edit_name"), this.pnlCreateNew.getConfigForSummary(), 1);
            if (this.groupCreateNew.isSelected(this.radioUseImporedPropertie.getModel())) {
                this.putToSummary(this.parent.langpack.getString("CCPropertiesPanel.action"), this.radioUseImporedPropertie.getText(), 0);
                this.putToSummary("i-net Crystal-Clear properties", this.pnlUseImporedPropertie.getPropertyName(), 2);
            } else if (this.groupCreateNew.isSelected(this.radioUseLocalCopy.getModel())) {
                this.putToSummary(this.parent.langpack.getString("CCPropertiesPanel.action"), this.radioUseLocalCopy.getText(), 0);
                this.putToSummary("copy of configuration", this.pnlUseLocalCopy.getConfigForSummary(), 2);
            } else {
                this.putToSummary(this.parent.langpack.getString("CCPropertiesPanel.action"), this.radioUseDefault.getText(), 0);
            }
        } else if (this.groupUseOld.isSelected(this.radioUseCurrentActive.getModel())) {
            this.putToSummary(this.parent.langpack.getString("CCPropertiesPanel.action"), this.radioUseCurrentActive.getText(), 0);
        } else {
            this.putToSummary(this.parent.langpack.getString("CCPropertiesPanel.action"), this.radioUseUserDefined.getText(), 0);
            this.putToSummary(this.parent.langpack.getString("CCPropertiesPanel.edit_name"), this.pnlUseUserDefined.getConfigForSummary(), 1);
        }
        this.filteredVariables.setVariable("hasConfigs", Boolean.toString(this.pnlUseLocalCopy.hasConfigurations()));
    }

    @Override
    public boolean isValidated() {
        boolean isImport = this.groupCreateNew.isSelected(this.radioUseImporedPropertie.getModel());
        boolean isCreateNew = this.groupConfigSelection.isSelected(this.radioCreateNew.getModel());
        boolean useUserDefined = this.groupUseOld.isSelected(this.radioUseUserDefined.getModel());
        boolean useUserExisting = this.groupConfigSelection.isSelected(this.radioUseOld.getModel());
        JComponent comp = null;
        if (isCreateNew && (comp = this.pnlCreateNew.isValidated()) != null) {
            comp.requestFocus();
            return false;
        }
        if (isCreateNew && isImport && (comp = this.pnlUseImporedPropertie.isValidated()) != null) {
            comp.requestFocus();
            return false;
        }
        if (useUserExisting && useUserDefined && (comp = this.pnlUseUserDefined.isValidated()) != null) {
            comp.requestFocus();
            return false;
        }
        this.panelFinish();
        return super.isValidated();
    }

    @Override
    public JPanel initPanelGUI() {
        this.localPanel = new JPanel();
        this.localPanel.setBorder(BorderFactory.createEmptyBorder());
        this.localPanel.setLayout(new GridBagLayout());
        this.lblSelectImportType = new JLabel(this.parent.langpack.getString("CCPropertiesPanel.action_label"));
        this.lblSelectImportType.setName("lblSelectImportType");
        this.createImportTypePanel();
        this.localPanel.add((Component)this.lblSelectImportType, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.INSETS_TOP_HALF, 0, 0));
        this.localPanel.add((Component)this.pnlSelectImportType, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE_HALF, 0, 0));
        this.pnlFiller = new JPanel();
        this.localPanel.add((Component)this.pnlFiller, new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 18, 1, GUIUtils.INSETS_BOTTOM, 0, 0));
        return this.localPanel;
    }

    private void createImportTypePanel() {
        this.radioCreateNew = new JRadioButton(this.parent.langpack.getString("CCPropertiesPanel.create_new"));
        this.radioCreateNew.setFont(new Font(this.radioCreateNew.getFont().getFontName(), 1, this.radioCreateNew.getFont().getSize()));
        this.radioCreateNew.setName("radioCreateNew");
        this.pnlCreateNew = new ConfigurationInputPanel(this.parent, Integer.parseInt(this.filteredVariables.getVariable("ALLOWED_SYSTEM_SCOPES")), Integer.parseInt(this.filteredVariables.getVariable("PRESELECTED_SCOPE")), this.filteredVariables.getVariable("USER_NAME"), this, false);
        this.pnlCreateNew.setName("pnlCreateNew");
        this.radioUseOld = new JRadioButton(this.parent.langpack.getString("CCPropertiesPanel.use_old.remote"));
        this.radioUseOld.setFont(new Font(this.radioUseOld.getFont().getFontName(), 1, this.radioUseOld.getFont().getSize()));
        this.radioUseOld.setName("radioUseOld");
        this.groupConfigSelection = new ButtonGroup();
        this.groupConfigSelection.add(this.radioCreateNew);
        this.groupConfigSelection.add(this.radioUseOld);
        this.radioCreateNew.addItemListener(this);
        this.radioUseOld.addItemListener(this);
        this.radioUseDefault = new JRadioButton(this.parent.langpack.getString("CCRemotePropertiesPanel.createDefaultConfig"));
        this.radioUseDefault.setName("radioUseDefault");
        this.radioUseLocalCopy = new JRadioButton(this.parent.langpack.getString("CCRemotePropertiesPanel.createConfigFromLocalCopy"));
        this.radioUseLocalCopy.setName("radioUseLocalCopy");
        this.pnlUseLocalCopy = new ConfigurationSelectionPanel(this.parent, Integer.parseInt(this.filteredVariables.getVariable("PRESELECTED_SCOPE")), this.filteredVariables.getVariable("CONFIG_NAME"), Integer.parseInt(this.filteredVariables.getVariable("ALLOWED_SYSTEM_SCOPES")), this.filteredVariables.getVariable("USER_NAME"));
        this.pnlUseLocalCopy.setName("pnlUseLocalCopy");
        this.radioUseImporedPropertie = new JRadioButton(this.parent.langpack.getString("CCRemotePropertiesPanel.createConfigFromPropertie"));
        this.radioUseImporedPropertie.setName("radioUseImporedPropertie");
        this.pnlUseImporedPropertie = new PropertiesImportPanel(this.parent, false, this);
        this.pnlUseImporedPropertie.setName("pnlUseImporedPropertie");
        this.groupCreateNew = new ButtonGroup();
        this.groupCreateNew.add(this.radioUseDefault);
        this.groupCreateNew.add(this.radioUseLocalCopy);
        this.groupCreateNew.add(this.radioUseImporedPropertie);
        this.radioUseDefault.addItemListener(this);
        this.radioUseLocalCopy.addItemListener(this);
        this.radioUseImporedPropertie.addItemListener(this);
        this.radioUseCurrentActive = new JRadioButton(this.parent.langpack.getString("CCRemotePropertiesPanel.useActiveConfig"));
        this.radioUseCurrentActive.setName("radioUseCurrentActive");
        this.radioUseUserDefined = new JRadioButton(this.parent.langpack.getString("CCRemotePropertiesPanel.useUserDefinedConfig"));
        this.radioUseUserDefined.setName("radioUseUserDefined");
        this.pnlUseUserDefined = new ConfigurationInputPanel(this.parent, Integer.parseInt(this.filteredVariables.getVariable("ALLOWED_SYSTEM_SCOPES")), Integer.parseInt(this.filteredVariables.getVariable("PRESELECTED_SCOPE")), this.filteredVariables.getVariable("USER_NAME"), this, false);
        this.pnlUseUserDefined.setName("pnlUseUserDefined");
        this.groupUseOld = new ButtonGroup();
        this.groupUseOld.add(this.radioUseCurrentActive);
        this.groupUseOld.add(this.radioUseUserDefined);
        this.radioUseCurrentActive.addItemListener(this);
        this.radioUseUserDefined.addItemListener(this);
        this.pnlSelectImportType = new JPanel(new GridBagLayout());
        this.pnlSelectImportType.setBorder(new TitledBorder(this.parent.langpack.getString("CCPropertiesPanel.import_panel")));
        this.pnlSelectImportType.add((Component)this.radioCreateNew, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        this.pnlSelectImportType.add((Component)this.pnlCreateNew, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        this.pnlSelectImportType.add((Component)this.radioUseDefault, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, GUIUtils.addGap(GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 1, 10), 0, 0));
        this.pnlSelectImportType.add((Component)this.radioUseLocalCopy, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, GUIUtils.addGap(GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 1, 10), 0, 0));
        this.pnlSelectImportType.add((Component)this.pnlUseLocalCopy, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        this.pnlSelectImportType.add((Component)this.radioUseImporedPropertie, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, GUIUtils.addGap(GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 1, 10), 0, 0));
        this.pnlSelectImportType.add((Component)this.pnlUseImporedPropertie, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        this.pnlSelectImportType.add((Component)this.radioUseOld, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 18, 2, GUIUtils.COMPONENT_INSETS_TOP, 0, 0));
        this.pnlSelectImportType.add((Component)this.radioUseCurrentActive, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 2, GUIUtils.addGap(GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 1, 10), 0, 0));
        this.pnlSelectImportType.add((Component)this.radioUseUserDefined, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, GUIUtils.addGap(GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 1, 10), 0, 0));
        this.pnlSelectImportType.add((Component)this.pnlUseUserDefined, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof Configuration) {
            Configuration c1 = (Configuration)o1;
            Configuration c2 = (Configuration)o2;
            String name1 = c1.getScope() + c1.getName();
            String name2 = c2.getScope() + c2.getName();
            return name1.compareToIgnoreCase(name2);
        }
        return ((String)o1).compareToIgnoreCase((String)o2);
    }

    private void checkAndSetNames() {
        int scope;
        ConfigurationManager configManager = ConfigurationManager.getInstance();
        if (configManager.get(scope = this.pnlCreateNew.getSelectedConfigurationValue(), "Default") == null) {
            this.new_default_name = "Default";
            this.import_default_name = "Default";
        } else {
            String tmp_name = this.new_default_name;
            int counter = 0;
            while (configManager.get(scope, tmp_name) != null) {
                tmp_name = this.new_default_name + String.valueOf(++counter);
            }
            if (counter > 0) {
                this.new_default_name = this.new_default_name + String.valueOf(counter);
            }
            tmp_name = this.import_default_name;
            counter = 0;
            while (configManager.get(scope, tmp_name) != null) {
                tmp_name = this.import_default_name + String.valueOf(++counter);
            }
            if (counter > 0) {
                this.import_default_name = this.import_default_name + String.valueOf(counter);
            }
        }
        if (this.groupConfigSelection.isSelected(this.radioCreateNew.getModel()) && this.groupCreateNew.isSelected(this.radioUseImporedPropertie.getModel())) {
            this.pnlCreateNew.setConfigName(this.import_default_name);
            this.import_default_name = "crystalclear";
        }
        if (this.groupConfigSelection.isSelected(this.radioCreateNew.getModel()) && !this.groupCreateNew.isSelected(this.radioUseImporedPropertie.getModel())) {
            this.pnlCreateNew.setConfigName(this.new_default_name);
            this.new_default_name = "new";
        }
    }

    public void setEnabledNew(boolean enabled) {
        this.radioUseDefault.setEnabled(enabled);
        this.radioUseLocalCopy.setEnabled(enabled && !this.pnlUseLocalCopy.isForceDisabled());
        this.radioUseImporedPropertie.setEnabled(enabled);
        if (!enabled) {
            this.pnlUseLocalCopy.setEnabled(enabled);
            this.pnlUseImporedPropertie.setEnabled(enabled);
        }
        if (this.radioUseLocalCopy.isEnabled() && this.radioUseLocalCopy.isSelected()) {
            this.pnlUseLocalCopy.setEnabled(enabled);
        }
        if (this.radioUseImporedPropertie.isEnabled() && this.radioUseImporedPropertie.isSelected()) {
            this.pnlUseImporedPropertie.setEnabled(enabled);
        }
        if (this.groupCreateNew.getSelection() == null) {
            this.groupCreateNew.setSelected(this.radioUseDefault.getModel(), true);
        }
    }

    public void setEnabledOld(boolean enabled) {
        this.radioUseCurrentActive.setEnabled(enabled);
        this.radioUseUserDefined.setEnabled(enabled);
        if (!enabled) {
            this.pnlUseUserDefined.setEnabled(enabled);
        }
        if (this.radioUseUserDefined.isEnabled() && this.radioUseUserDefined.isSelected()) {
            this.pnlUseUserDefined.setEnabled(enabled);
        }
        if (this.groupUseOld.getSelection() == null) {
            this.groupUseOld.setSelected(this.radioUseCurrentActive.getModel(), true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e2) {
        AbstractButton abstractButton;
        Enumeration<AbstractButton> elements;
        this.checkAndSetNames();
        if (e2.getSource() == this.radioCreateNew) {
            if (e2.getStateChange() == 1) {
                this.setEnabledNew(true);
                this.pnlCreateNew.setEnabled(true);
            } else {
                this.setEnabledNew(false);
                this.pnlCreateNew.setEnabled(false);
                elements = this.groupCreateNew.getElements();
                while (elements.hasMoreElements()) {
                    abstractButton = elements.nextElement();
                    abstractButton.setSelected(false);
                }
            }
        }
        if (e2.getSource() == this.radioUseOld) {
            if (e2.getStateChange() == 1) {
                this.setEnabledOld(true);
            } else {
                this.setEnabledOld(false);
                elements = this.groupUseOld.getElements();
                while (elements.hasMoreElements()) {
                    abstractButton = elements.nextElement();
                    abstractButton.setSelected(false);
                }
            }
        }
        if (e2.getSource() != this.radioUseDefault || e2.getStateChange() == 1) {
            // empty if block
        }
        if (e2.getSource() == this.radioUseLocalCopy) {
            if (e2.getStateChange() == 1) {
                this.pnlUseLocalCopy.setEnabled(true);
            } else {
                this.pnlUseLocalCopy.setEnabled(false);
            }
        }
        if (e2.getSource() == this.radioUseImporedPropertie) {
            if (e2.getStateChange() == 1) {
                this.pnlUseImporedPropertie.setEnabled(true);
            } else {
                this.pnlUseImporedPropertie.setEnabled(false);
            }
        }
        if (e2.getSource() != this.radioUseCurrentActive || e2.getStateChange() == 1) {
            // empty if block
        }
        if (e2.getSource() == this.radioUseUserDefined) {
            if (e2.getStateChange() == 1) {
                this.pnlUseUserDefined.setEnabled(true);
            } else {
                this.pnlUseUserDefined.setEnabled(false);
            }
        }
    }
}

