/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.setup.Constants;
import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.textui.Group;
import com.inet.textui.PanelGroup;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackHandler;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class CCServerPacksPanel
extends AbstractPanel
implements ActionListener,
MouseListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static final String FORCE_SELECTED_SCOPE = "forceSelected";
    private static final String ALLOWED_SCOPE = "allowedScope";
    private static final String PRESELECTED_SCOPE = "preselectedScope";
    private static final String ENABLE_PACKAGE_INSTALLATION = "disablePackageInstallation";
    private static final String RULES_TO_CHECK = "RULES_TO_CHECK";
    private JPanel pnlButtonArea;
    private JPanel pnlDescriptionArea;
    private ButtonGroup groupServerSelection = null;
    private JTextArea txtArea;
    private JPanel pnlArea;
    private FilteredVariables filteredVariables;
    private JScrollPane scrollTextArea;
    private int defaultAllowedScope = -1;
    private int currentSelecetedScope = 8;
    private JRadioButton currentSelecetedRadio = null;

    public CCServerPacksPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("CCServerPacksPanel.heading"), null, null, "com/inet/setup/images/Components48.png");
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("ALLOWED_SYSTEM_SCOPES", null);
        requiredVariables.put("ALLOWED_REMOTE_INSTALL", null);
        requiredVariables.put("PRESELECTED_SCOPE", null);
        requiredVariables.put("SCOPE_NAME", null);
        requiredVariables.put("TOMCAT_INSTALL_PATH", null);
        requiredVariables.put("APACHEPHP_INSTALL_PATH", null);
        requiredVariables.put("GENERIC_INSTALL_PATH", null);
        requiredVariables.put("GLASSFISH_INSTALL_PATH", null);
        requiredVariables.put("JBOSS_INSTALL_PATH", null);
        requiredVariables.put("JETTY_INSTALL_PATH", null);
        requiredVariables.put("WEBLOGIC_INSTALL_PATH", null);
        requiredVariables.put("WEBSPHERE_INSTALL_PATH", null);
        requiredVariables.put("SERVICE_INSTALL_PATH", null);
        requiredVariables.put("TOMCAT_INSTALL_PORT", null);
        requiredVariables.put("APACHEPHP_INSTALL_PORT", null);
        requiredVariables.put("GENERIC_INSTALL_PORT", null);
        requiredVariables.put("GLASSFISH_INSTALL_PORT", null);
        requiredVariables.put("JBOSS_INSTALL_PORT", null);
        requiredVariables.put("JETTY_INSTALL_PORT", null);
        requiredVariables.put("WEBLOGIC_INSTALL_PORT", null);
        requiredVariables.put("WEBSPHERE_INSTALL_PORT", null);
        requiredVariables.put("SERVICE_INSTALL_PORT", null);
        requiredVariables.put("SERVLET_REMOTE_INSTALL", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        this.createReverseDependencies();
        this.createReverseMapping();
        super.panelActivate();
        if (System.getProperty("remove_documentation", Boolean.TRUE.toString()) == Boolean.TRUE.toString()) {
            this.removePacksReverse(Constants.PACKAGES_TO_UNSELECT, PackHandler.getSelectedPacks());
        }
        if (this.groupServerSelection.getSelection() == null) {
            this.parent.lockNextButton();
        }
        if (this.defaultAllowedScope < 0) {
            this.defaultAllowedScope = Integer.parseInt(this.filteredVariables.getVariable("ALLOWED_SYSTEM_SCOPES"));
        }
        boolean fail = false;
        AbstractButton abstactButtonFromSelectedButton = this.getAbstactButtonFromSelectedButton();
        if (abstactButtonFromSelectedButton == null) {
            Debug.log((Object)"selected pack: null; select first button", this.getClass());
            Enumeration<AbstractButton> elements = this.groupServerSelection.getElements();
            if (elements.hasMoreElements()) {
                abstactButtonFromSelectedButton = elements.nextElement();
            } else {
                fail = true;
            }
        }
        if (!fail) {
            Debug.log((Object)("selected pack: " + abstactButtonFromSelectedButton.getName()), this.getClass());
            this.changeSelectedPacks(abstactButtonFromSelectedButton, 1);
            Debug.log((Object)("description: " + this.getPackIdFromSelectedButton()), this.getClass());
            this.changeDescription(this.getPackIdFromSelectedButton());
        }
    }

    public void panelFinish() {
        Enumeration<AbstractButton> elements = this.groupServerSelection.getElements();
        while (elements.hasMoreElements()) {
            JRadioButton abstractButton = (JRadioButton)elements.nextElement();
            if (!abstractButton.isSelected()) continue;
            try {
                String[] rulesName = (String[])abstractButton.getClientProperty(RULES_TO_CHECK);
                if (rulesName.length > 0) {
                    for (String rule : rulesName) {
                        if (this.idata.getRules().isConditionTrue(rule)) continue;
                        this.emitNotification(this.parent.langpack.getString("CheckRules"), this.parent.langpack.getString("CheckRules." + rule));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.filteredVariables.setVariable("ALLOWED_SYSTEM_SCOPES", abstractButton.getClientProperty(ALLOWED_SCOPE).toString());
            this.filteredVariables.setVariable("ALLOWED_REMOTE_INSTALL", abstractButton.getClientProperty(ENABLE_PACKAGE_INSTALLATION).toString());
            this.filteredVariables.setVariable("PRESELECTED_SCOPE", abstractButton.getClientProperty(PRESELECTED_SCOPE).toString());
            return;
        }
    }

    private void removePacksReverse(String[] list, List<Pack> packsList) {
        for (String idToRemove : list) {
            Pack packToRemove = PackHandler.getPack(idToRemove);
            this.removePacksCascadingReverse(packsList, packToRemove);
        }
    }

    private void removePacksCascadingReverse(List<Pack> toRemoveList, Pack packToRemove) {
        if (packToRemove == null) {
            return;
        }
        List<String> childList = packToRemove.getRevMapping();
        if (childList != null) {
            for (String childID : childList) {
                Pack childToRemove = PackHandler.getPack(childID);
                this.removePacksCascadingReverse(toRemoveList, childToRemove);
            }
        }
        if (toRemoveList.contains(packToRemove)) {
            PackHandler.unsetSelectedPack(packToRemove);
        }
    }

    @Override
    public boolean isValidated() {
        this.valueChanged();
        if (this.groupServerSelection.getSelection() == null) {
            this.parent.lockNextButton();
            return false;
        }
        this.parent.unlockNextButton();
        this.panelFinish();
        return super.isValidated();
    }

    @Override
    public JPanel initPanelGUI() {
        JPanel localPanel = new JPanel();
        localPanel.setLayout(new GridBagLayout());
        this.pnlButtonArea = new JPanel();
        this.pnlButtonArea.setLayout(new GridLayout(6, 2, 0, 0));
        this.groupServerSelection = new ButtonGroup();
        int defaultScopeServlets = 0;
        defaultScopeServlets = OsVersion.IS_WINDOWS ? 1 : (OsVersion.IS_LINUX ? ((Integer.parseInt(this.filteredVariables.getVariable("ALLOWED_SYSTEM_SCOPES")) & 1) > 0 ? 1 : 2) : 2);
        if (OsVersion.IS_MAC) {
            this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.runtime"), "CCRunTime", 7, 2, false, 7, new String[0]));
        } else {
            this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.runtime"), "CCRunTime", 7, 2, false, 6, new String[0]));
        }
        if (!GraphicsEnvironment.isHeadless()) {
            this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.websphere"), "CCWebsphere", 7, defaultScopeServlets, true, new String[0]));
        }
        if (OsVersion.IS_WINDOWS) {
            this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.service"), "CCService", 1, 1, false, 1, new String[0]));
        } else if (OsVersion.IS_LINUX && !OsVersion.IS_MAC) {
            this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.daemon"), "CCDaemon", 1, 1, false, 1, new String[0]));
        }
        if (GraphicsEnvironment.isHeadless()) {
            this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.websphere"), "CCWebsphere", 7, defaultScopeServlets, true, new String[0]));
        }
        this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.weblogic"), "CCWeblogic", 7, defaultScopeServlets, true, new String[0]));
        if (OsVersion.IS_WINDOWS) {
            this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.miis"), "CCIIS", 1, 1, false, "hasIIS", "hasDOTNET"));
        }
        this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.tomcat"), "CCTomcat", 7, defaultScopeServlets, true, new String[0]));
        if (OsVersion.IS_WINDOWS) {
            this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.apache"), "CCApache", 1, 1, false, new String[0]));
        } else if (OsVersion.IS_LINUX || !OsVersion.IS_MAC) {
            this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.apache"), "CCApacheLinux", 1, 1, false, new String[0]));
        } else if (OsVersion.IS_MAC) {
            this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.apache"), "CCApacheMac", 7, defaultScopeServlets, false, new String[0]));
        }
        this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.jetty"), "CCJetty", 7, defaultScopeServlets, true, new String[0]));
        this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.jboss"), "CCJBoss", 7, defaultScopeServlets, true, new String[0]));
        this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.glassfish"), "CCGlassFish", 7, defaultScopeServlets, true, new String[0]));
        this.pnlButtonArea.add(this.createRadioButton(this.parent.langpack.getString("CCServerPacksPanel.generic"), "CCGeneric", 7, defaultScopeServlets, true, new String[0]));
        this.pnlDescriptionArea = this.createTextArea("PacksPanel.description");
        this.pnlDescriptionArea.setName("pnlDescriptionArea");
        localPanel.add((Component)this.pnlButtonArea, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_TOP, 0, 0));
        localPanel.add((Component)this.pnlDescriptionArea, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        if (this.currentSelecetedRadio != null) {
            this.currentSelecetedRadio.setSelected(true);
        }
        return localPanel;
    }

    private JRadioButton createRadioButton(String label, String id, int allowedScope, int preselectedScope, boolean enablePackageInstallation, int forceSelectedScope, String ... rulesToCheck) {
        JRadioButton jrbButton = new JRadioButton(label);
        jrbButton.putClientProperty(ALLOWED_SCOPE, String.valueOf(allowedScope));
        jrbButton.putClientProperty(PRESELECTED_SCOPE, String.valueOf(preselectedScope));
        jrbButton.putClientProperty(FORCE_SELECTED_SCOPE, String.valueOf(forceSelectedScope));
        jrbButton.putClientProperty(ENABLE_PACKAGE_INSTALLATION, Boolean.toString(enablePackageInstallation));
        jrbButton.putClientProperty(RULES_TO_CHECK, rulesToCheck);
        int allowedSystemScope = Integer.parseInt(this.filteredVariables.getVariable("ALLOWED_SYSTEM_SCOPES"));
        if ((allowedScope & allowedSystemScope) > 0) {
            jrbButton.setEnabled(true);
        } else {
            jrbButton.setEnabled(false);
        }
        if ((forceSelectedScope & allowedSystemScope) > 0 && forceSelectedScope < this.currentSelecetedScope) {
            this.currentSelecetedRadio = jrbButton;
            this.currentSelecetedScope = forceSelectedScope;
        }
        jrbButton.addActionListener(this);
        jrbButton.addMouseListener(this);
        jrbButton.addItemListener(this);
        jrbButton.setName(id);
        jrbButton.setBorder(new EmptyBorder(new Insets(1, 10, 10, 10)));
        this.groupServerSelection.add(jrbButton);
        return jrbButton;
    }

    private JRadioButton createRadioButton(String label, String id, int allowedScope, int preselectedScope, boolean enablePackageInstallation, String ... rulesToCheck) {
        return this.createRadioButton(label, id, allowedScope, preselectedScope, enablePackageInstallation, 8, rulesToCheck);
    }

    protected JPanel createTextArea(String msgId) {
        this.pnlArea = new JPanel();
        this.pnlArea.setLayout(new GridBagLayout());
        this.pnlArea.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString(msgId)));
        this.txtArea = new JTextArea();
        this.txtArea.setName("txtArea");
        this.txtArea.setAlignmentX(0.0f);
        this.txtArea.setCaretPosition(0);
        this.txtArea.setEditable(false);
        this.txtArea.setOpaque(false);
        this.txtArea.setLineWrap(true);
        this.txtArea.setWrapStyleWord(true);
        this.txtArea.setFont(this.getControlTextFont());
        this.scrollTextArea = new JScrollPane(this.txtArea);
        this.scrollTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.scrollTextArea.getHorizontalScrollBar().setValue(this.scrollTextArea.getHorizontalScrollBar().getMinimum());
        this.pnlArea.add((Component)this.scrollTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, GUIUtils.COMPONENT_INSETS_MIDDLE_HALF, 0, 0));
        return this.pnlArea;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.valueChanged();
    }

    private void valueChanged() {
        Pack selectedPack = PackHandler.getPack(this.getPackIdFromSelectedButton());
        if (selectedPack == null) {
            return;
        }
        this.changeDescription(selectedPack.id);
        if (this.groupServerSelection.getSelection() == null) {
            this.parent.lockNextButton();
        } else {
            this.parent.unlockNextButton();
        }
    }

    private void changeDescription(String packId) {
        if (this.pnlDescriptionArea != null && packId != null && packId.length() > 0) {
            String key = packId + ".description";
            String description = this.idata.langpack.getString(key);
            if ("".equals(description) || key.equals(description)) {
                Pack packByID = PackHandler.getPack(packId);
                description = packByID != null ? packByID.description : key;
            }
            this.txtArea.setText(description);
            this.scrollTextArea.getHorizontalScrollBar().setValue(this.scrollTextArea.getHorizontalScrollBar().getMinimum());
        }
    }

    private void removeCascading(Pack pack) {
        List<String> dependentPackNames;
        if (pack == null) {
            return;
        }
        if (PackHandler.getSelectedPacks().contains(pack) && !pack.preselected) {
            PackHandler.unsetSelectedPack(pack);
            Debug.log((Object)("[REMOVES PACK] " + pack), this.getClass());
        }
        if ((dependentPackNames = pack.getDependencies()) != null && dependentPackNames.size() > 0) {
            for (String depPack : dependentPackNames) {
                Pack dependentPack = PackHandler.getPackByName(depPack);
                this.removeCascading(dependentPack);
                Debug.log((Object)("[REMOVES PACK DEPEND] " + dependentPack), this.getClass());
            }
        }
        if (pack.parent != null) {
            this.removeCascading(PackHandler.getPack(pack.parent));
        }
    }

    private void addCascading(Pack pack) {
        List<String> dependentPackNames;
        if (pack == null) {
            return;
        }
        if (!PackHandler.getSelectedPacks().contains(pack)) {
            PackHandler.setSelectedPack(pack);
            Debug.log((Object)("[ADD PACK] " + pack), this.getClass());
        }
        if ((dependentPackNames = pack.getDependencies()) != null && dependentPackNames.size() > 0) {
            for (String depPack : dependentPackNames) {
                Pack dependentPack = PackHandler.getPackByName(depPack);
                this.addCascading(dependentPack);
                Debug.log((Object)("[ADD PACK DEPEND] " + dependentPack), this.getClass());
            }
        }
        if (pack.parent != null) {
            this.addCascading(PackHandler.getPack(pack.parent));
        }
    }

    private String getPackIdFromSelectedButton() {
        String name;
        AbstractButton abstactButtonFromSelectedButton = this.getAbstactButtonFromSelectedButton();
        if (abstactButtonFromSelectedButton != null && (name = abstactButtonFromSelectedButton.getName()) != null) {
            return name;
        }
        return "";
    }

    private AbstractButton getAbstactButtonFromSelectedButton() {
        ButtonModel selectedButton = this.groupServerSelection.getSelection();
        Enumeration<AbstractButton> allButtons = this.groupServerSelection.getElements();
        if (selectedButton != null && allButtons != null) {
            while (allButtons.hasMoreElements()) {
                AbstractButton abstractButton = allButtons.nextElement();
                if (abstractButton == null || abstractButton.getModel() == null || !abstractButton.getModel().equals(selectedButton)) continue;
                return abstractButton;
            }
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        Object source = e2.getSource();
        if (source instanceof JRadioButton) {
            JRadioButton btn = (JRadioButton)source;
            this.changeDescription(btn.getName());
        }
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.changeDescription(this.getPackIdFromSelectedButton());
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public Group getTextUiGroup() {
        JPanel textPanel = new JPanel();
        textPanel.add(this.pnlButtonArea);
        return new PanelGroup(textPanel);
    }

    @Override
    public void itemStateChanged(ItemEvent e2) {
        JRadioButton item = (JRadioButton)e2.getSource();
        int stateChange = e2.getStateChange();
        this.changeSelectedPacks(item, stateChange);
    }

    private void changeSelectedPacks(AbstractButton item, int stateChange) {
        if (stateChange == 2) {
            this.removeCascading(PackHandler.getPack(item.getName()));
        } else if (stateChange == 1) {
            this.addCascading(PackHandler.getPack(item.getName()));
        }
    }
}

