/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.coi.tools.os.win.NativeLibException;
import com.inet.lib.swing.InetTitledBorder;
import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.ShortcutSpec;
import com.inet.setup.panels.ShortcutSpecFactory;
import com.inet.textui.Group;
import com.inet.textui.ListGroup;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import com.izforge.izpack.util.os.unix.UnixHelper;
import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class CCShortcutPanel2
extends AbstractPanel
implements TableLayoutConstants {
    private static final long serialVersionUID = 3164747879556941908L;
    private JPanel localPanel = new JPanel();
    private LocaleDatabase msg;
    private ShortcutSpec shortcutSpec;
    private LocalBehavior localBehavior = new LocalBehavior(this);
    private JCheckBox chkCreateStartMenu;
    private JPanel pnlProgramGroup;
    private JLabel lblExplain1;
    private JLabel lblExplain2;
    private JTextField txtProgramGroup;
    private JButton btnBrowse;
    private JPanel pnlAssociation;
    private JPanel pnlUsers;
    private JCheckBox chkRegisterJRA = new JCheckBox();
    private JCheckBox chkRegisterRPT = new JCheckBox();
    private JRadioButton radioCurrentUser;
    private JRadioButton radioAllUsers;
    private FilteredVariables filteredVariables;
    private final String key = "value";

    public CCShortcutPanel2(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("CCShortcutPanel.heading"), null, null, "com/inet/setup/images/Shortcut48.png");
        this.msg = parent.langpack;
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("CREATE_SHORTCUTS", null);
        requiredVariables.put("VISIBLE_SHORTCUTS", null);
        requiredVariables.put("REGISTER_JRA", null);
        requiredVariables.put("REGISTER_RPT", null);
        requiredVariables.put("IS_UPDATE", null);
        requiredVariables.put("SYSTEM_SCOPE", null);
        requiredVariables.put("PROGRAM_GROUP", null);
        requiredVariables.put("USER_TYPE", null);
        requiredVariables.put("PORT", null);
        requiredVariables.put("APACHEPHP_INSTALL_PATH", null);
        requiredVariables.put("GENERIC_INSTALL_PORT", null);
        requiredVariables.put("GLASSFISH_INSTALL_PORT", null);
        requiredVariables.put("JBOSS_INSTALL_PORT", null);
        requiredVariables.put("JETTY_INSTALL_PORT", null);
        requiredVariables.put("ORACLE_INSTALL_PORT", null);
        requiredVariables.put("SERVICE_INSTALL_PORT", null);
        requiredVariables.put("TOMCAT_INSTALL_PORT", null);
        requiredVariables.put("WEBLOGIC_INSTALL_PORT", null);
        requiredVariables.put("WEBSPHERE_INSTALL_PORT", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        if (this.shortcutSpec == null) {
            try {
                IXMLElement xmlSpec = this.readXMLSpec();
                this.shortcutSpec = ShortcutSpecFactory.getInstance().createShortcutSpec(this.idata, this.parent.getRules(), xmlSpec);
            }
            catch (ResourceNotFoundException e2) {
                Debug.log((Object)"could not read shortcut spec!", this.getClass());
                e2.printStackTrace();
            }
            catch (IOException e3) {
                Debug.log((Object)"could not read shortcut spec!", this.getClass());
                e3.printStackTrace();
            }
        }
        super.panelActivate();
        this.refreshEnabledStates();
    }

    private IXMLElement readXMLSpec() throws ResourceNotFoundException, IOException {
        InputStream input = null;
        try {
            input = ResourceManager.getInstance().getInputStream("shared/" + TargetFactory.getCurrentOSPrefix() + "ShortcutSpec.xml");
        }
        catch (ResourceNotFoundException rnfE) {
            input = ResourceManager.getInstance().getInputStream("shared/ShortcutSpec.xml");
        }
        if (input == null) {
            return null;
        }
        VariableSubstitutor substitutor = new VariableSubstitutor(this.idata.getVariables());
        String substitutedSpec = substitutor.substitute(input, "xml");
        XMLParser parser = new XMLParser();
        IXMLElement spec = parser.parse(substitutedSpec);
        input.close();
        return spec;
    }

    public void panelFinish() {
        this.idata.setAttribute("ShortcutSpec", this.shortcutSpec);
        this.filteredVariables.setVariable("PROGRAM_GROUP", this.txtProgramGroup.getText());
        if (this.radioCurrentUser.isSelected()) {
            this.filteredVariables.setVariable("USER_TYPE", String.valueOf(1));
        } else {
            this.filteredVariables.setVariable("USER_TYPE", String.valueOf(2));
        }
        if (this.chkCreateStartMenu.isSelected()) {
            this.filteredVariables.setVariable("CREATE_SHORTCUTS", "true");
            this.filteredVariables.setVariable("VISIBLE_SHORTCUTS", "yes");
        } else {
            this.filteredVariables.setVariable("CREATE_SHORTCUTS", "false");
            this.filteredVariables.setVariable("VISIBLE_SHORTCUTS", "no");
        }
        if (this.chkCreateStartMenu.isSelected() && OsVersion.IS_UNIX || !OsVersion.IS_UNIX) {
            if (!this.chkRegisterJRA.isSelected()) {
                this.filteredVariables.setVariable("REGISTER_JRA", "0");
            } else {
                this.filteredVariables.setVariable("REGISTER_JRA", (String)this.chkRegisterJRA.getClientProperty("value"));
            }
            if (!this.chkRegisterRPT.isSelected()) {
                this.filteredVariables.setVariable("REGISTER_RPT", "0");
            } else {
                this.filteredVariables.setVariable("REGISTER_RPT", (String)this.chkRegisterRPT.getClientProperty("value"));
            }
        } else {
            this.filteredVariables.setVariable("REGISTER_JRA", "0");
            this.filteredVariables.setVariable("REGISTER_RPT", "0");
        }
        String port = "9000";
        if (this.idata.getRules().isConditionTrue("CCApache")) {
            port = this.filteredVariables.getVariable("APACHEPHP_INSTALL_PATH");
        } else if (this.idata.getRules().isConditionTrue("CCGeneric")) {
            port = this.filteredVariables.getVariable("GENERIC_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCGlassfish")) {
            port = this.filteredVariables.getVariable("GLASSFISH_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCJBoss")) {
            port = this.filteredVariables.getVariable("JBOSS_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCJetty")) {
            port = this.filteredVariables.getVariable("JETTY_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCOracle")) {
            port = this.filteredVariables.getVariable("ORACLE_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCService")) {
            port = this.filteredVariables.getVariable("SERVICE_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCTomcat")) {
            port = this.filteredVariables.getVariable("TOMCAT_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCWeblgic")) {
            port = this.filteredVariables.getVariable("WEBLOGIC_INSTALL_PORT");
        } else if (this.idata.getRules().isConditionTrue("CCWebsphere")) {
            port = this.filteredVariables.getVariable("WEBSPHERE_INSTALL_PORT");
        }
        if (port == null) {
            port = "9000";
        }
        this.filteredVariables.setVariable("PORT", port);
    }

    @Override
    public boolean isValidated() {
        this.panelFinish();
        return super.isValidated();
    }

    @Override
    public JPanel initPanelGUI() {
        double[][] size = new double[][]{{28.0, -1.0, 20.0, -2.0, 28.0}, {20.0, -2.0, 10.0, -2.0, 10.0, -2.0, 10.0, -2.0, -1.0, 10.0}};
        TableLayout layout = new TableLayout(size);
        this.localPanel.setLayout(layout);
        this.chkCreateStartMenu = new JCheckBox(this.msg.getString("ShortcutPanel.regular.create", new String[]{this.getStartMenuString()}));
        this.chkCreateStartMenu.setName("chkCreateStartMenu");
        this.chkCreateStartMenu.setSelected(Boolean.parseBoolean(this.filteredVariables.getVariable("CREATE_SHORTCUTS")));
        this.chkCreateStartMenu.addActionListener(this.localBehavior);
        this.localPanel.add((Component)this.chkCreateStartMenu, "1,1,3,1");
        this.pnlProgramGroup = this.createProgramGroupPanel();
        this.localPanel.add((Component)this.pnlProgramGroup, "1,3,3,3");
        this.pnlUsers = this.createUsersPanel();
        this.localPanel.add((Component)this.pnlUsers, "1,5,3,5");
        this.pnlAssociation = this.createAssociationPanel();
        if (this.pnlAssociation != null) {
            this.localPanel.add((Component)this.pnlAssociation, "1,7,3,7");
        }
        return this.localPanel;
    }

    private JPanel createUsersPanel() {
        double[][] sizes = new double[][]{{10.0, -1.0}, {0.0, -2.0, 5.0, -2.0, 10.0}};
        JPanel pnlResult = new JPanel(new TableLayout(sizes));
        boolean forAllUsers = this.shortcutSpec.isCurrentUser() ? false : this.isRootUser();
        this.radioCurrentUser = new JRadioButton(this.msg.getString("ShortcutPanel.regular.currentUser"), !forAllUsers);
        this.radioAllUsers = new JRadioButton(this.msg.getString("ShortcutPanel.regular.allUsers"), forAllUsers);
        ButtonGroup usersGroup = new ButtonGroup();
        usersGroup.add(this.radioCurrentUser);
        usersGroup.add(this.radioAllUsers);
        pnlResult.add((Component)this.radioCurrentUser, "1,1");
        pnlResult.add((Component)this.radioAllUsers, "1,3");
        pnlResult.setBorder(new InetTitledBorder(this.parent.langpack.getString("ShortcutPanel.regular.userIntro")));
        return pnlResult;
    }

    private JPanel createAssociationPanel() {
        boolean des = this.installingDesigner();
        boolean viewer = this.installingViewer();
        JPanel pnlResult = new JPanel(new GridBagLayout());
        pnlResult.setBorder(new InetTitledBorder(this.msg.getString("ShortcutPanel.regular.register")));
        this.chkRegisterRPT.setName("chkRegisterRPT");
        pnlResult.add((Component)this.chkRegisterRPT, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        this.chkRegisterJRA.setName("chkRegisterJRA");
        pnlResult.add((Component)this.chkRegisterJRA, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, GUIUtils.COMPONENT_INSETS_MIDDLE, 0, 0));
        if (!Boolean.parseBoolean(this.filteredVariables.getVariable("IS_UPDATE"))) {
            if (des) {
                this.chkRegisterRPT.setSelected(true);
                this.chkRegisterRPT.setVisible(true);
            } else {
                this.chkRegisterRPT.setVisible(false);
            }
            if (viewer) {
                this.chkRegisterJRA.setSelected(true);
                this.chkRegisterJRA.setVisible(true);
            } else {
                this.chkRegisterJRA.setVisible(false);
            }
            pnlResult.setVisible(des || viewer);
            this.initAssociationCheckboxesValuesrpt();
            this.initAssociationCheckboxesValuesjra();
            this.initAssociationCheckboxesText();
        } else {
            String vrpt = this.filteredVariables.getVariable("REGISTER_RPT");
            int irpt = Integer.parseInt(vrpt);
            this.chkRegisterRPT.setSelected(irpt > 0);
            this.chkRegisterRPT.setVisible(des);
            this.chkRegisterRPT.putClientProperty("value", vrpt);
            String vjra = this.filteredVariables.getVariable("REGISTER_JRA");
            int ijra = Integer.parseInt(vjra);
            this.chkRegisterJRA.setSelected(ijra > 0);
            this.chkRegisterJRA.setVisible(viewer);
            this.chkRegisterJRA.putClientProperty("value", vjra);
            this.initAssociationCheckboxesText();
        }
        return pnlResult;
    }

    private JPanel createProgramGroupPanel() {
        double[][] sizes = new double[][]{{10.0, -1.0, 5.0, -2.0, 10.0}, {0.0, -2.0, 5.0, -2.0, 10.0, -2.0, 10.0}};
        TableLayout layout = new TableLayout(sizes);
        JPanel pnlResult = new JPanel(layout);
        pnlResult.setBorder(new InetTitledBorder(this.getStartMenuString()));
        this.lblExplain1 = new JLabel(this.msg.getString("ShortcutPanel.regular.create_explain", new String[]{this.getStartMenuString()}));
        this.lblExplain2 = new JLabel(this.msg.getString("ShortcutPanel.regular.create_explain2"));
        this.txtProgramGroup = new JTextField();
        this.txtProgramGroup.setName("txtProgramGroup");
        this.txtProgramGroup.setText(this.getSuggestedProgramGroup());
        this.btnBrowse = new JButton(this.msg.getString("ShortcutPanel.regular.browse"));
        this.btnBrowse.addActionListener(this.localBehavior);
        this.btnBrowse.setName("btnBrowse");
        pnlResult.add((Component)this.lblExplain1, "1,1,3,1");
        pnlResult.add((Component)this.lblExplain2, "1,3,3,3");
        if (OsVersion.IS_WINDOWS) {
            pnlResult.add((Component)this.txtProgramGroup, "1,5");
            pnlResult.add((Component)this.btnBrowse, "3,5");
        } else {
            pnlResult.add((Component)this.txtProgramGroup, "1,5,3,5");
        }
        return pnlResult;
    }

    private void initAssociationCheckboxesValuesrpt() {
        if (this.installingDesigner() && this.extensionExists(".rpt")) {
            if (this.extensionForCCExists(".rpt", "i-net Clear Reports Template")) {
                this.chkRegisterRPT.putClientProperty("value", "3");
            } else {
                this.chkRegisterRPT.putClientProperty("value", "2");
            }
        } else {
            this.chkRegisterRPT.putClientProperty("value", "1");
        }
    }

    private void initAssociationCheckboxesValuesjra() {
        if (this.installingViewer() && this.extensionExists(".jra")) {
            if (this.extensionForCCExists(".jra", "i-net Clear Reports Archive")) {
                this.chkRegisterJRA.putClientProperty("value", "3");
            } else {
                this.chkRegisterJRA.putClientProperty("value", "2");
            }
        } else {
            this.chkRegisterJRA.putClientProperty("value", "1");
        }
    }

    private void initAssociationCheckboxesText() {
        int irpt = 0;
        try {
            irpt = Integer.parseInt(this.chkRegisterRPT.getClientProperty("value").toString());
        }
        catch (Exception e2) {
            // empty catch block
        }
        switch (irpt) {
            case 1: {
                this.chkRegisterRPT.setText(this.msg.getString("ShortcutPanel.regular.registerNewRPT"));
                break;
            }
            case 2: {
                this.chkRegisterRPT.setText(this.msg.getString("ShortcutPanel.regular.addNewRPT"));
                break;
            }
            case 3: {
                this.chkRegisterRPT.setText(this.msg.getString("ShortcutPanel.regular.replaceNewRPT"));
                break;
            }
            default: {
                this.initAssociationCheckboxesValuesrpt();
                this.initAssociationCheckboxesText();
            }
        }
        int ijra = 0;
        try {
            ijra = Integer.parseInt(this.chkRegisterJRA.getClientProperty("value").toString());
        }
        catch (Exception e3) {
            // empty catch block
        }
        switch (ijra) {
            case 1: {
                this.chkRegisterJRA.setText(this.parent.langpack.getString("ShortcutPanel.regular.registerNewJRA"));
                break;
            }
            case 2: {
                this.chkRegisterJRA.setText(this.parent.langpack.getString("ShortcutPanel.regular.addNewJRA"));
                break;
            }
            case 3: {
                this.chkRegisterJRA.setText(this.parent.langpack.getString("ShortcutPanel.regular.replaceNewJRA"));
                break;
            }
            default: {
                this.initAssociationCheckboxesValuesjra();
                this.initAssociationCheckboxesText();
            }
        }
        if (OsVersion.IS_LINUX) {
            boolean selected = this.chkCreateStartMenu.isSelected();
            this.radioCurrentUser.setEnabled(selected);
            this.radioAllUsers.setEnabled(selected);
        }
    }

    private boolean extensionExists(String extension) {
        RegistryHandler reg = RegistryDefaultHandler.getInstance();
        if (reg == null) {
            return false;
        }
        try {
            reg.setRoot(Integer.MIN_VALUE);
            return reg.keyExist(extension);
        }
        catch (NativeLibException e2) {
            return false;
        }
    }

    private boolean extensionForCCExists(String extension, String fullName) {
        RegistryHandler reg = RegistryDefaultHandler.getInstance();
        if (reg == null) {
            return false;
        }
        try {
            reg.setRoot(Integer.MIN_VALUE);
            if (!reg.keyExist(extension)) {
                return false;
            }
            String[] listKeys = reg.getSubkeys(extension);
            if (listKeys != null) {
                for (String key1 : listKeys) {
                    String[] listValueNames;
                    if (key1 == null || !key1.equals("OpenWithProgIDs") || (listValueNames = reg.getValueNames(extension + "\\" + key1)) == null) continue;
                    for (String value : listValueNames) {
                        if (value == null || !value.equals(fullName)) continue;
                        return true;
                    }
                }
            }
            return reg.keyExist(extension);
        }
        catch (NativeLibException e2) {
            return false;
        }
    }

    private boolean installingViewer() {
        return this.installingDesigner() || this.idata.getRules().isConditionTrue("izpack.selected.CC");
    }

    private boolean installingDesigner() {
        return this.idata.getRules().isConditionTrue("izpack.selected.CCDesigner");
    }

    private boolean isRootUser() {
        int allowedScopes = Integer.parseInt(this.filteredVariables.getVariable("SYSTEM_SCOPE"));
        return (allowedScopes & 1) > 0;
    }

    private String getSuggestedProgramGroup() {
        return "i-net Clear Reports";
    }

    private String getStartMenuString() {
        String menuKind = this.msg.getString("ShortcutPanel.regular.StartMenu_Start-Menu");
        if (OsVersion.IS_UNIX && UnixHelper.kdeIsInstalled()) {
            menuKind = this.msg.getString("ShortcutPanel.regular.StartMenu_K-Menu");
        }
        return menuKind;
    }

    protected boolean isUnixSystem() {
        return OsVersion.IS_UNIX && UnixHelper.kdeIsInstalled();
    }

    @Override
    public Group getTextUiGroup() {
        return new ListGroup();
    }

    void setShortcutSpec(ShortcutSpec spec) {
        this.shortcutSpec = spec;
    }

    private void refreshEnabledStates() {
        boolean createShortcuts = this.chkCreateStartMenu.isSelected();
        this.lblExplain1.setEnabled(createShortcuts);
        this.lblExplain2.setEnabled(createShortcuts);
        this.txtProgramGroup.setEnabled(createShortcuts);
        this.btnBrowse.setEnabled(createShortcuts);
        this.radioCurrentUser.setEnabled(createShortcuts);
        this.radioAllUsers.setEnabled(createShortcuts && this.isRootUser());
        boolean des = this.installingDesigner();
        boolean viewer = this.installingViewer();
        if (!Boolean.parseBoolean(this.filteredVariables.getVariable("IS_UPDATE"))) {
            if (OsVersion.IS_UNIX) {
                this.chkRegisterRPT.setEnabled(des && createShortcuts);
                this.chkRegisterJRA.setEnabled(viewer && createShortcuts);
            } else {
                this.chkRegisterRPT.setEnabled(des);
                this.chkRegisterJRA.setEnabled(viewer);
            }
            ((TitledBorder)this.pnlProgramGroup.getBorder()).setTitleColor(createShortcuts ? GUIUtils.ENABLED_COLOR : GUIUtils.DISABLED_COLOR);
            ((TitledBorder)this.pnlUsers.getBorder()).setTitleColor(createShortcuts ? GUIUtils.ENABLED_COLOR : GUIUtils.DISABLED_COLOR);
            SwingUtilities.updateComponentTreeUI(this);
            if (des) {
                if (!this.chkRegisterRPT.isVisible()) {
                    this.chkRegisterRPT.setSelected(true);
                }
                this.chkRegisterRPT.setVisible(true);
            } else {
                this.chkRegisterRPT.setVisible(false);
            }
            if (viewer) {
                if (!this.chkRegisterJRA.isVisible()) {
                    this.chkRegisterJRA.setSelected(true);
                }
                this.chkRegisterJRA.setVisible(true);
            } else {
                this.chkRegisterJRA.setVisible(false);
            }
            if (this.pnlAssociation != null) {
                this.pnlAssociation.setVisible(des || viewer);
                if (OsVersion.IS_UNIX) {
                    ((TitledBorder)this.pnlAssociation.getBorder()).setTitleColor(createShortcuts ? GUIUtils.ENABLED_COLOR : GUIUtils.DISABLED_COLOR);
                }
            }
            this.initAssociationCheckboxesText();
        } else {
            this.chkRegisterRPT.setVisible(des);
            this.chkRegisterJRA.setVisible(viewer);
            this.initAssociationCheckboxesText();
        }
    }

    private String[] getListOfStartmenuFolders() {
        List<String> programGroups = this.shortcutSpec.getProgramGroups(this.getChosenUserType());
        try {
            programGroups.remove(this.getSuggestedProgramGroup());
        }
        catch (Exception exception) {
            // empty catch block
        }
        programGroups.add(0, this.getSuggestedProgramGroup());
        return programGroups.toArray(new String[0]);
    }

    private int getChosenUserType() {
        return this.radioCurrentUser.isSelected() ? 1 : 2;
    }

    private static class LocalBehavior
    implements ActionListener {
        private final CCShortcutPanel2 panel;

        private LocalBehavior(CCShortcutPanel2 panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            this.panel.refreshEnabledStates();
            if (e2.getSource() == this.panel.btnBrowse) {
                Object[] folders = this.panel.getListOfStartmenuFolders();
                Object choice = JOptionPane.showInputDialog(this.panel, this.panel.msg.getString("ShortcutPanel.regular.browseFolder"), this.panel.msg.getString("ShortcutPanel.regular.browseFolder"), 2, null, folders, this.panel.getSuggestedProgramGroup());
                if (choice != null) {
                    this.panel.txtProgramGroup.setText((String)choice);
                }
            }
            if (e2.getSource() == this.panel.chkCreateStartMenu && OsVersion.IS_LINUX) {
                boolean selected = this.panel.chkCreateStartMenu.isSelected();
                this.panel.radioCurrentUser.setEnabled(selected);
                this.panel.radioAllUsers.setEnabled(selected);
                this.panel.chkRegisterJRA.setEnabled(selected);
                this.panel.chkRegisterRPT.setEnabled(selected);
            }
        }
    }
}

