/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.html.InetHtmlEditorKit;
import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.textui.Group;
import com.inet.textui.PanelGroup;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.SummaryProcessor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CCSummaryPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1485228792747443743L;
    private JPanel localPanel;
    private JLabel lblPanelInfo;
    private JEditorPane paneSummary;
    private JScrollPane scrollSummary;
    private String summary;
    private FilteredVariables filteredVariables;

    public CCSummaryPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("CCSummaryPanel.heading"), null, null, "com/inet/setup/images/Summary48.png");
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("INSTALL_PATH", null);
        requiredVariables.put("TOMCAT_INSTALL_PATH", null);
        requiredVariables.put("APACHEPHP_INSTALL_PATH", null);
        requiredVariables.put("GENERIC_INSTALL_PATH", null);
        requiredVariables.put("GLASSFISH_INSTALL_PATH", null);
        requiredVariables.put("JBOSS_INSTALL_PATH", null);
        requiredVariables.put("JETTY_INSTALL_PATH", null);
        requiredVariables.put("WEBLOGIC_INSTALL_PATH", null);
        requiredVariables.put("WEBSPHERE_INSTALL_PATH", null);
        requiredVariables.put("SERVICE_INSTALL_PATH", null);
        requiredVariables.put("SERVLET_REMOTE_INSTALL", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.summary = SummaryProcessor.getInstance().getSummary(this.idata, this.parent);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
        this.updateSummary(this.summary);
        this.parent.setNextButtonText(this.parent.langpack.getString("InstallPanel.install"));
    }

    private void updateSummary(String s2) {
        this.paneSummary.setText(s2);
    }

    @Override
    public void panelDeactivate() {
        if (Boolean.toString(true).equalsIgnoreCase(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"))) {
            this.fillServletRemotePath("INSTALL_PATH", "TOMCAT_INSTALL_PATH");
            this.fillServletRemotePath("INSTALL_PATH", "APACHEPHP_INSTALL_PATH");
            this.fillServletRemotePath("INSTALL_PATH", "GENERIC_INSTALL_PATH");
            this.fillServletRemotePath("INSTALL_PATH", "GLASSFISH_INSTALL_PATH");
            this.fillServletRemotePath("INSTALL_PATH", "JBOSS_INSTALL_PATH");
            this.fillServletRemotePath("INSTALL_PATH", "JETTY_INSTALL_PATH");
            this.fillServletRemotePath("INSTALL_PATH", "WEBLOGIC_INSTALL_PATH");
            this.fillServletRemotePath("INSTALL_PATH", "WEBSPHERE_INSTALL_PATH");
            this.fillServletRemotePath("INSTALL_PATH", "SERVICE_INSTALL_PATH");
        }
        this.parent.setNextButtonText(this.parent.langpack.getString("installer.next"));
        super.panelDeactivate();
    }

    private void fillServletRemotePath(String installpath, String servletpath) {
        String variable = this.filteredVariables.getVariable(servletpath);
        String path = this.filteredVariables.getVariable(installpath);
        this.filteredVariables.setVariable(servletpath, path + File.separator + variable);
    }

    @Override
    public boolean isValidated() {
        return super.isValidated();
    }

    @Override
    public JPanel initPanelGUI() {
        this.localPanel = new JPanel();
        this.localPanel.setLayout(new GridBagLayout());
        this.lblPanelInfo = new JLabel(this.parent.langpack.getString("CCSummaryPanel.info"));
        this.localPanel.add((Component)this.lblPanelInfo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.INSETS_TOP_HALF, 0, 0));
        this.paneSummary = new JEditorPane();
        this.paneSummary.setEditorKitForContentType("text/html", new InetHtmlEditorKit());
        this.paneSummary.setMargin(new Insets(2, 2, 2, 2));
        this.paneSummary.setEditable(false);
        this.paneSummary.setContentType("text/html");
        this.paneSummary.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        this.paneSummary.setText(this.summary);
        this.paneSummary.getKeymap().removeBindings();
        this.scrollSummary = new JScrollPane(this.paneSummary);
        this.localPanel.add((Component)this.scrollSummary, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, GUIUtils.INSETS_BOTTOM, 0, 0));
        return this.localPanel;
    }

    @Override
    public Group getTextUiGroup() {
        return new PanelGroup(new JPanel());
    }
}

