/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.lib.util.PreferencesUtils;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.setup.Constants;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.textui.Group;
import com.inet.textui.ListGroup;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackHandler;
import com.izforge.izpack.installer.HelpButton;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsVersion;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class CCTypeSelectionPanel
extends AbstractPanel {
    private static final long serialVersionUID = -7711730400958263768L;
    private JPanel localPanel;
    private HelpButton hbDesigner = null;
    private HelpButton hbServer = null;
    private HelpButton hbCustom = null;
    private JCheckBox chkboxSendData;
    private FilteredVariables filteredVariables;
    private static String IMG_SETUP = "com/inet/setup/images/installer.image.setup.jpg";
    private static String IMG_DESIGNER = "com/inet/setup/images/installer.image.designer.png";
    private static String IMG_SERVER = "com/inet/setup/images/installer.image.server.png";
    private static String IMG_CUSTOM = "com/inet/setup/images/installer.image.custom.png";
    private static String IMG_HELP = "com/inet/setup/images/installer.image.help.png";
    private static String IMG_HELPDISABLED = "com/inet/setup/images/installer.image.help_dis.png";
    private boolean firstTime = true;
    private boolean activateFirst = false;
    private String lastComponentToInstall;
    private String currentComponentToInstall;
    private TreeMap<String, PackHandler.StateHolder> allStates = null;

    public CCTypeSelectionPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, null, null, null, null);
        super.setShowTitleBar(false);
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("COMPONENT_TO_INSTALL", null);
        requiredVariables.put("ALLOWED_SYSTEM_SCOPES", null);
        requiredVariables.put("PRESELECTED_SCOPE", null);
        requiredVariables.put("CONFIG_NAME", null);
        requiredVariables.put("SCOPE_NAME", null);
        requiredVariables.put("SCOPE_INT", null);
        requiredVariables.put("SYSTEM_SCOPE", null);
        requiredVariables.put("INSTALLDATE", null);
        requiredVariables.put("INSTALLVERSION", null);
        requiredVariables.put("DESIGNER_MEMORY", null);
        return requiredVariables;
    }

    @Override
    public JPanel initPanelGUI() {
        this.localPanel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = -8637048868762161288L;

            @Override
            public void paint(Graphics g2) {
                Image image = CCTypeSelectionPanel.this.getImage(IMG_SETUP).getImage();
                int height2 = image.getHeight(null);
                int width2 = image.getWidth(null);
                int heightOffset = (this.getHeight() - height2) / 2;
                int widthOffset = (this.getWidth() - width2) / 2;
                g2.setColor(UIManager.getColor("Panel.background"));
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.drawImage(image, widthOffset, heightOffset, width2, height2, null);
                super.paint(g2);
            }
        };
        this.localPanel.setOpaque(false);
        JPanel pnlButtonBar = this.createButtonBar();
        this.localPanel.add((Component)pnlButtonBar, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(150, 20, 20, 20), 0, 0));
        ToolTipManager.sharedInstance().setInitialDelay(10);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        UIManager.put("ToolTip.border", BorderFactory.createCompoundBorder(UIManager.getBorder("ToolTip.border"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        return this.localPanel;
    }

    private JPanel createButtonBar() {
        ImageIcon imgDesigner = this.getImage(IMG_DESIGNER);
        ImageIcon imgServer = this.getImage(IMG_SERVER);
        ImageIcon imgCustom = this.getImage(IMG_CUSTOM);
        ImageIcon imgHelp = this.getImage(IMG_HELP);
        ImageIcon imgHelpDisabled = this.getImage(IMG_HELPDISABLED);
        JPanel pnlCenterCenter = new JPanel();
        pnlCenterCenter.setLayout(new GridBagLayout());
        this.hbDesigner = new HelpButton(this.idata.langpack.getString("installer.language.designer"), imgDesigner, imgHelp, imgHelpDisabled, imgHelp);
        this.hbDesigner.setVisible(true);
        this.hbDesigner.setOpaque(false);
        this.hbDesigner.getInnerButton().addActionListener(new LocalBehavior());
        this.hbDesigner.getInnerButton().setSelected(false);
        this.hbDesigner.getInnerButton().setName("Designer");
        this.hbDesigner.getJlIcon().setName("DesignerHelp");
        this.hbDesigner.getJlIcon().setToolTipText(this.idata.langpack.getString("installer.language.designer_help"));
        pnlCenterCenter.add((Component)this.hbDesigner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 30, 10, 10), 0, 0));
        this.hbServer = new HelpButton(this.idata.langpack.getString("installer.language.server"), imgServer, imgHelp, imgHelpDisabled, imgHelp);
        this.hbServer.setVisible(true);
        this.hbServer.setOpaque(false);
        this.hbServer.getInnerButton().addActionListener(new LocalBehavior());
        this.hbServer.getInnerButton().setSelected(false);
        this.hbServer.getInnerButton().setName("Server");
        this.hbServer.getJlIcon().setName("ServerHelp");
        this.hbServer.getJlIcon().setToolTipText(this.idata.langpack.getString("installer.language.server_help"));
        pnlCenterCenter.add((Component)this.hbServer, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 30, 10, 10), 0, 0));
        this.hbCustom = new HelpButton(this.idata.langpack.getString("installer.language.custom"), imgCustom, imgHelp, imgHelpDisabled, imgHelp);
        this.hbCustom.setVisible(true);
        this.hbCustom.setOpaque(false);
        this.hbCustom.getInnerButton().addActionListener(new LocalBehavior());
        this.hbCustom.getInnerButton().setSelected(false);
        this.hbCustom.getInnerButton().setName("Custom");
        this.hbCustom.getJlIcon().setName("CustomHelp");
        this.hbCustom.getJlIcon().setToolTipText(this.idata.langpack.getString("installer.language.custom_help"));
        pnlCenterCenter.add((Component)this.hbCustom, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 30, 10, 10), 0, 0));
        this.chkboxSendData = new JCheckBox(this.idata.langpack.getString("installer.senddata"));
        this.chkboxSendData.setToolTipText(this.idata.langpack.getString("installer.senddata.tooltip"));
        this.chkboxSendData.setSelected(true);
        this.chkboxSendData.setVisible(true);
        this.chkboxSendData.setOpaque(false);
        pnlCenterCenter.add((Component)this.chkboxSendData, new GridBagConstraints(0, 1, 3, 3, 0.0, 0.0, 10, 1, new Insets(10, 30, 30, 10), 50, 0));
        pnlCenterCenter.setOpaque(false);
        return pnlCenterCenter;
    }

    @Override
    public void panelActivate() {
        this.parent.hideNextButton();
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
        if (this.allStates == null) {
            this.allStates = this.deepCopy(PackHandler.getAllStates());
        }
        this.lastComponentToInstall = this.filteredVariables.getVariable("COMPONENT_TO_INSTALL");
        this.filteredVariables.setVariable("INSTALLDATE", new Long(System.currentTimeMillis()).toString());
        this.filteredVariables.setVariable("INSTALLVERSION", this.idata.getVariable("APP_VER"));
        this.activateFirst = true;
    }

    @Override
    public void panelDeactivate() {
        super.panelDeactivate();
        this.createReverseDependencies();
        this.createReverseMapping();
        if (this.activateFirst && this.firstTime) {
            this.firstTime = false;
        }
    }

    @Override
    public boolean panelValidated() {
        boolean silent = false;
        if (!GraphicsEnvironment.isHeadless()) {
            silent = this.currentComponentToInstall.equalsIgnoreCase("designer");
        }
        this.checkAdminMode(silent);
        this.setDesignerMemory();
        return super.panelValidated();
    }

    private void setDesignerMemory() {
        this.filteredVariables.setVariable("DESIGNER_MEMORY", "-Xmx512m");
        try {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            for (Method method : operatingSystemMXBean.getClass().getMethods()) {
                method.setAccessible(true);
                String methodName = method.getName();
                if (!methodName.startsWith("get") || !Modifier.isPublic(method.getModifiers()) || !OperatingSystemMXBean.class.isAssignableFrom(method.getDeclaringClass())) continue;
                try {
                    Object invoke;
                    if (!methodName.equals("getTotalPhysicalMemorySize") || !((invoke = method.invoke((Object)operatingSystemMXBean, new Object[0])) instanceof Long)) continue;
                    long mem = (Long)invoke;
                    long sizeMB = mem / 0x100000L;
                    this.filteredVariables.setVariable("DESIGNER_MEMORY", "-Xmx256m");
                    if (sizeMB >= 2000L) {
                        this.filteredVariables.setVariable("DESIGNER_MEMORY", "-Xmx512m");
                    }
                    if (sizeMB < 4000L) continue;
                    this.filteredVariables.setVariable("DESIGNER_MEMORY", "-Xmx1024m");
                }
                catch (Throwable ex2) {
                    // empty catch block
                }
            }
        }
        catch (Exception e2) {
            Debug.error(e2);
        }
    }

    private ImageIcon getImage(String res) {
        ImageIcon imageIconResource = null;
        try {
            imageIconResource = ResourceManager.getInstance().getImageIconResource(res);
        }
        catch (ResourceNotFoundException e2) {
            Debug.error(e2, this.getClass());
        }
        catch (IOException e3) {
            Debug.error(e3, this.getClass());
        }
        return imageIconResource;
    }

    private void checkAdminMode(boolean silent) {
        boolean isSystemWriteable = PreferencesUtils.isSystemWriteable(PreferencesUtils.systemRoot().absolutePath());
        boolean isUserWriteable = PreferencesUtils.isUserWriteable(PreferencesUtils.userRoot().absolutePath());
        Debug.trace("[isSystemWriteable] " + isSystemWriteable, this.getClass());
        Debug.trace("[isUserWriteable] " + isUserWriteable, this.getClass());
        boolean isRootName = true;
        if (OsVersion.IS_UNIX) {
            isRootName = "root".equalsIgnoreCase(System.getProperty("user.name"));
        }
        if (isSystemWriteable && isRootName) {
            this.filteredVariables.setVariable("ALLOWED_SYSTEM_SCOPES", String.valueOf(7));
            this.filteredVariables.setVariable("SYSTEM_SCOPE", String.valueOf(7));
        } else {
            if (!silent) {
                if (GraphicsEnvironment.isHeadless()) {
                    this.emitWarning(this.idata.langpack.getString("installer.warning"), this.idata.langpack.getString("GUIInstaller.no_administrator0"));
                } else {
                    this.emitWarning(this.idata.langpack.getString("installer.warning"), this.idata.langpack.getString("GUIInstaller.no_administrator0") + this.idata.langpack.getString("GUIInstaller.no_administrator1"));
                }
            }
            if (isUserWriteable) {
                this.filteredVariables.setVariable("ALLOWED_SYSTEM_SCOPES", String.valueOf(2));
                this.filteredVariables.setVariable("SYSTEM_SCOPE", String.valueOf(2));
            } else if (!silent) {
                this.emitWarning(this.idata.langpack.getString("installer.warning"), this.idata.langpack.getString("GUIInstaller.no_user"));
            }
        }
    }

    private void hidePacksReverse(String[] list) {
        for (String idToHide : list) {
            Pack packToHide = PackHandler.getPack(idToHide);
            this.hidePacksCascadingReverse(packToHide, true);
        }
    }

    private void unhidePacksReverse(String[] list) {
        for (String idToHide : list) {
            Pack packToHide = PackHandler.getPack(idToHide);
            this.hidePacksCascadingReverse(packToHide, false);
        }
    }

    private void hidePacksCascadingReverse(Pack packToHide, boolean ishidden) {
        if (packToHide == null) {
            return;
        }
        List<String> childList = packToHide.getRevMapping();
        if (childList != null) {
            for (String childID : childList) {
                Pack childToHide = PackHandler.getPack(childID);
                this.hidePacksCascadingReverse(childToHide, ishidden);
            }
        }
        packToHide.setHidden(ishidden);
    }

    private TreeMap<String, PackHandler.StateHolder> deepCopy(TreeMap<String, PackHandler.StateHolder> original) {
        TreeMap<String, PackHandler.StateHolder> copy = new TreeMap<String, PackHandler.StateHolder>();
        for (String key : original.keySet()) {
            PackHandler.StateHolder stateHolder = original.get(key);
            copy.put(key, new PackHandler.StateHolder(stateHolder.isAvailable(), stateHolder.isSelected()));
        }
        return copy;
    }

    @Override
    public Group getTextUiGroup() {
        return new ListGroup();
    }

    public void readingDesignerConfig() {
        ConfigurationManager cm2 = ConfigurationManager.getInstance();
        Preferences pref = PreferencesUtils.userRoot();
        pref = pref.node("com/inet/designer/crystalclear");
        String configName = pref.get("defaultConfigName", null);
        String scopeName = pref.get("defaultConfigScope", null);
        if (configName != null && scopeName != null) {
            int scopeInt = Integer.parseInt(scopeName);
            Configuration defaultConfig = null;
            try {
                defaultConfig = cm2.get(scopeInt, configName);
            }
            catch (Exception e2) {
                Debug.error(e2, this.getClass());
            }
            if (defaultConfig != null) {
                this.filteredVariables.setVariable("SCOPE_NAME", Constants.getScopeName(scopeInt));
                this.filteredVariables.setVariable("SCOPE_INT", scopeName);
                this.filteredVariables.setVariable("CONFIG_NAME", configName);
                return;
            }
        }
        Configuration userDefault = null;
        try {
            userDefault = cm2.get(2, "Default");
        }
        catch (Exception e3) {
            Debug.error(e3, this.getClass());
        }
        if (userDefault != null) {
            this.filteredVariables.setVariable("SCOPE_NAME", "user");
            this.filteredVariables.setVariable("SCOPE_INT", String.valueOf(2));
            this.filteredVariables.setVariable("CONFIG_NAME", "Default");
            return;
        }
        Configuration systemDefault = null;
        try {
            systemDefault = cm2.get(1, "Default");
        }
        catch (Exception e4) {
            Debug.error(e4, this.getClass());
        }
        if (systemDefault != null) {
            this.filteredVariables.setVariable("SCOPE_NAME", "system");
            this.filteredVariables.setVariable("SCOPE_INT", String.valueOf(1));
            this.filteredVariables.setVariable("CONFIG_NAME", "Default");
            return;
        }
        this.filteredVariables.setVariable("SCOPE_NAME", "user");
        this.filteredVariables.setVariable("SCOPE_INT", String.valueOf(2));
        this.filteredVariables.setVariable("CONFIG_NAME", "Default");
    }

    private class LocalBehavior
    implements ActionListener {
        private LocalBehavior() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            CCTypeSelectionPanel.this.filteredVariables.setVariable("PRESELECTED_SCOPE", "2");
            if (CCTypeSelectionPanel.this.chkboxSendData.isSelected() && CCTypeSelectionPanel.this.firstTime) {
                Housekeeper.getInstance().registerForCleanup(CCTypeSelectionPanel.this.idata.getStatHandler());
            }
            CCTypeSelectionPanel.this.currentComponentToInstall = ((Component)e2.getSource()).getName();
            CCTypeSelectionPanel.this.filteredVariables.setVariable("COMPONENT_TO_INSTALL", CCTypeSelectionPanel.this.currentComponentToInstall);
            if (!CCTypeSelectionPanel.this.currentComponentToInstall.equalsIgnoreCase(CCTypeSelectionPanel.this.lastComponentToInstall)) {
                PackHandler.setAllStates(CCTypeSelectionPanel.this.deepCopy(CCTypeSelectionPanel.this.allStates));
            }
            for (Pack p2 : CCTypeSelectionPanel.this.idata.getAllPacks()) {
                if (p2.id.equalsIgnoreCase("CCDesigner") && !((Component)e2.getSource()).getName().equalsIgnoreCase("server")) {
                    p2.preselected = true;
                    CCTypeSelectionPanel.this.idata.addSelectedPack(p2);
                }
                if (p2.id.equalsIgnoreCase("CCRunTime") && ((Component)e2.getSource()).getName().equalsIgnoreCase("custom")) {
                    p2.preselected = true;
                    CCTypeSelectionPanel.this.idata.addSelectedPack(p2);
                }
                if (p2.id.equalsIgnoreCase("CCServer") && ((Component)e2.getSource()).getName().equalsIgnoreCase("custom")) {
                    p2.preselected = true;
                    CCTypeSelectionPanel.this.idata.addSelectedPack(p2);
                }
                if (!p2.id.equalsIgnoreCase("CCRepository") || !((Component)e2.getSource()).getName().equalsIgnoreCase("designer")) continue;
                p2.preselected = false;
                if (!CCTypeSelectionPanel.this.idata.getSelectedPacks().contains(p2)) continue;
                CCTypeSelectionPanel.this.idata.removeSelectedPack(p2);
            }
            if ("server".equalsIgnoreCase(((Component)e2.getSource()).getName())) {
                CCTypeSelectionPanel.this.hidePacksReverse(Constants.PACKAGES_TO_HIDE);
            } else {
                CCTypeSelectionPanel.this.unhidePacksReverse(Constants.PACKAGES_TO_HIDE);
                CCTypeSelectionPanel.this.readingDesignerConfig();
            }
            CCTypeSelectionPanel.this.parent.showNextButton();
            CCTypeSelectionPanel.this.parent.navigateNext();
        }
    }
}

