/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.lib.swing.widgets.TristateCheckBox;
import com.inet.setup.panels.CheckBoxNode;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

class CheckBoxNodeRenderer
implements TreeCellRenderer {
    private static final JPanel RENDERER_PANEL = new JPanel();
    private static final TristateCheckBox CHECKBOX = TristateCheckBox.create("");
    private static final Color TREE_SELECTION_FOREGROUND = UIManager.getColor("Tree.selectionForeground");
    private static final Color TREE_SELECTION_BACKGROUND = UIManager.getColor("Tree.selectionBackground");
    private static final Color TREE_TEXT_FOREGROUND = UIManager.getColor("Tree.textForeground");
    private static final Color TREE_TEXT_BACKGROUNG = UIManager.getColor("Tree.textBackground");

    public CheckBoxNodeRenderer(JTree t2) {
        CHECKBOX.setTristateSelectionAllowed(true);
        int treeWidth = t2.getMaximumSize().width;
        int height = CheckBoxNodeRenderer.CHECKBOX.getPreferredSize().height;
        int cellWidth = treeWidth;
        double[][] sizes = new double[][]{{-2.0}, {-2.0}};
        RENDERER_PANEL.setLayout(new TableLayout(sizes));
        RENDERER_PANEL.setBackground(TREE_TEXT_BACKGROUNG);
        RENDERER_PANEL.add((Component)CHECKBOX, "0,0,r,t");
        RENDERER_PANEL.setMinimumSize(new Dimension(cellWidth, height));
        RENDERER_PANEL.setPreferredSize(new Dimension(cellWidth, height));
        RENDERER_PANEL.setBorder(BorderFactory.createEmptyBorder(-2, 0, 2, 0));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            CHECKBOX.setForeground(TREE_SELECTION_FOREGROUND);
            CHECKBOX.setBackground(TREE_SELECTION_BACKGROUND);
            RENDERER_PANEL.setForeground(TREE_SELECTION_FOREGROUND);
            RENDERER_PANEL.setBackground(TREE_SELECTION_BACKGROUND);
        } else {
            CHECKBOX.setForeground(TREE_TEXT_FOREGROUND);
            CHECKBOX.setBackground(TREE_TEXT_BACKGROUNG);
            RENDERER_PANEL.setForeground(TREE_TEXT_FOREGROUND);
            RENDERER_PANEL.setBackground(TREE_TEXT_BACKGROUNG);
        }
        if (value != null && value instanceof CheckBoxNode) {
            CheckBoxNode node = (CheckBoxNode)value;
            if (node.isPartial()) {
                CHECKBOX.setSelected(false);
            } else {
                CHECKBOX.setSelected(node.isSelected());
            }
            CHECKBOX.setText(node.getTranslatedText());
            CHECKBOX.setEnabled(node.isEnabled());
            if (node.isPartial()) {
                CHECKBOX.setState(2);
            } else if (node.isSelected()) {
                CHECKBOX.setState(0);
            } else {
                CHECKBOX.setState(1);
            }
        }
        return RENDERER_PANEL;
    }

    public Component getCheckRenderer() {
        return RENDERER_PANEL;
    }
}

