/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.looks.plastic.PlasticTreeUI;
import com.inet.setup.panels.CCPacksPanel;
import com.inet.setup.panels.CheckBoxNode;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackHandler;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class CheckTreeController
extends MouseAdapter
implements KeyListener,
TreeSelectionListener {
    private CCPacksPanel treePacksPanel;
    private int checkWidth;
    private final InstallData data;
    private final InstallerFrame parent;
    private CheckBoxNode parent2;

    public CheckTreeController(CCPacksPanel panel, InstallerFrame parent, InstallData data) {
        this.checkWidth = new JCheckBox().getPreferredSize().width;
        this.parent = parent;
        this.data = data;
        this.treePacksPanel = panel;
    }

    private void nodeSelectionChanged(CheckBoxNode current) {
        current.setPartial(false);
        Enumeration<TreeNode> e2 = current.depthFirstEnumeration();
        while (e2.hasMoreElements()) {
            CheckBoxNode child = (CheckBoxNode)e2.nextElement();
            if (child == current || !child.isEnabled()) continue;
            boolean newValue = current.isSelected() || child.getPack().isRequired();
            child.setSelected(newValue);
            if (!child.isSelected()) {
                child.setPartial(false);
            }
            this.updateAllDependencies(child, child.isSelected());
        }
    }

    private boolean hasExcludes(CheckBoxNode node) {
        Enumeration<TreeNode> e2 = node.depthFirstEnumeration();
        while (e2.hasMoreElements()) {
            CheckBoxNode cbn = (CheckBoxNode)e2.nextElement();
            if (cbn.getPack().excludeGroup == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        int x2 = me.getX();
        JTree tree = this.treePacksPanel.getTree();
        TreePath path = tree.getPathForLocation(x2, me.getY());
        if (path == null) {
            return;
        }
        CheckBoxNode current = (CheckBoxNode)path.getLastPathComponent();
        Pack pack = current.getPack();
        this.treePacksPanel.setDescription(current.getId());
        int offsetForPlasticUI = 0;
        if (tree.getUI() instanceof PlasticTreeUI) {
            offsetForPlasticUI += path.getPathCount() * 20 - 20;
        }
        int i2 = tree.getPathBounds((TreePath)path).x + this.checkWidth + offsetForPlasticUI;
        int j2 = tree.getPathBounds((TreePath)path).x + offsetForPlasticUI;
        if (x2 > i2 || x2 < j2) {
            return;
        }
        if (pack.isRequired() || !current.isEnabled()) {
            return;
        }
        boolean currWasSelected = current.isSelected() & !current.isPartial();
        boolean currIsPartial = current.isPartial();
        boolean currHasExcludes = this.hasExcludes(current);
        CheckBoxNode root = (CheckBoxNode)current.getRoot();
        if (currIsPartial && currHasExcludes) {
            current.setSelected(false);
            this.nodeSelectionChanged(current);
            this.updateAllParents(root);
        } else {
            current.setSelected(!currWasSelected);
            this.nodeSelectionChanged(current);
            this.updateAllDependencies(current, !currWasSelected);
            if (currWasSelected) {
                this.setSelectAllEnabledChildNodes(current, !currWasSelected);
            }
            this.updateAllParents(root);
        }
        CheckTreeController.initTotalSize(root, true);
        this.treePacksPanel.setBytes((int)root.getTotalSize());
        this.treePacksPanel.showSpaceRequired();
        tree.treeDidChange();
        if ("Custom".equalsIgnoreCase(this.data.getVariable("COMPONENT_TO_INSTALL"))) {
            this.updateNextButtonState(root);
        }
    }

    private void updateNextButtonState(CheckBoxNode root) {
        boolean hasAtLeastOneSelectedNode = false;
        if (root != null && root.getChildCount() > 0) {
            block0: for (int i2 = 0; !hasAtLeastOneSelectedNode && i2 < root.getChildCount(); ++i2) {
                TreeNode childAt = root.getChildAt(i2);
                if (childAt == null) continue;
                CheckBoxNode checkBoxNode = (CheckBoxNode)childAt;
                Enumeration<TreeNode> rootEnum = checkBoxNode.depthFirstEnumeration();
                while (rootEnum.hasMoreElements()) {
                    CheckBoxNode child = (CheckBoxNode)rootEnum.nextElement();
                    if (!child.isSelected() || child.getId().equalsIgnoreCase("Uninstaller")) continue;
                    hasAtLeastOneSelectedNode = true;
                    continue block0;
                }
            }
        }
        if (hasAtLeastOneSelectedNode) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    private void setSelectAllEnabledChildNodes(CheckBoxNode cbn, boolean select) {
        Enumeration<TreeNode> e2 = cbn.children();
        while (e2.hasMoreElements()) {
            CheckBoxNode subCbn = (CheckBoxNode)e2.nextElement();
            this.updateAllDependencies(subCbn, select);
            if (subCbn.getChildCount() > 0) {
                this.setSelectAllEnabledChildNodes(subCbn, select);
            }
            if (subCbn.isEnabled()) {
                subCbn.setSelected(select);
            }
            if (subCbn.isEnabled()) continue;
            subCbn.setSelected(true);
        }
    }

    private void updateAllDependencies(CheckBoxNode cbn, boolean parentIsSelected) {
        Pack pack = cbn.getPack();
        List<String> deps = pack.getDependencies();
        if (deps == null) {
            return;
        }
        for (String depId : deps) {
            CheckBoxNode depCbn = this.treePacksPanel.getCheckBoxNodeByName(depId);
            if (depCbn == null) continue;
            this.updateAllDependencies(depCbn, parentIsSelected);
            if (parentIsSelected && depCbn.getChildCount() > 0 && (!depCbn.isSelected() || depCbn.isPartial())) {
                this.setSelectAllEnabledChildNodes(depCbn, true);
            }
            if (parentIsSelected) {
                depCbn.setSelected(true);
            }
            boolean notOtherDependencies = true;
            List<String> listReverseDependencies = depCbn.getPack().getReverseDependencies();
            if (listReverseDependencies != null) {
                for (String reverseDependentPackName : listReverseDependencies) {
                    Pack childPack;
                    CheckBoxNode reverseDependentNode;
                    if (reverseDependentPackName == null || reverseDependentPackName.trim().length() <= 0 || (reverseDependentNode = this.treePacksPanel.getCheckBoxNodeByName(reverseDependentPackName)) == null || !reverseDependentNode.isSelected() || !notOtherDependencies || (childPack = reverseDependentNode.getPack()) == null || childPack.isHidden()) continue;
                    notOtherDependencies = false;
                }
            }
            boolean notRequired = !depCbn.getPack().isRequired();
            boolean notSelected = !parentIsSelected;
            boolean enabled = notRequired && notSelected && notOtherDependencies;
            depCbn.setEnabled(enabled);
            this.updateParents(depCbn);
        }
    }

    void updateAllParents(CheckBoxNode root) {
        Enumeration<TreeNode> rootEnum = root.depthFirstEnumeration();
        while (rootEnum.hasMoreElements()) {
            CheckBoxNode child = (CheckBoxNode)rootEnum.nextElement();
            if (child.getParent() == null || child.getParent().equals(root)) continue;
            this.updateParents(child);
        }
    }

    void updateParents(CheckBoxNode node) {
        this.parent2 = (CheckBoxNode)node.getParent();
        if (this.parent2 != null && !this.parent2.equals(this.parent2.getRoot())) {
            Enumeration<TreeNode> ne = this.parent2.children();
            boolean allSelected = true;
            boolean allDeselected = true;
            boolean allDisabled = true;
            while (ne.hasMoreElements()) {
                CheckBoxNode child = (CheckBoxNode)ne.nextElement();
                if (child.isSelected()) {
                    allDeselected = false;
                } else {
                    allSelected = false;
                }
                if (child.isPartial()) {
                    allDeselected = false;
                    allSelected = false;
                }
                if (child.isEnabled()) {
                    allDisabled = false;
                }
                if (allSelected || allDeselected) continue;
                break;
            }
            if (this.parent2.getChildCount() > 0) {
                if (!allSelected && !allDeselected) {
                    CheckTreeController.setPartialParent(this.parent2);
                } else if (!this.parent2.getPack().isRequired()) {
                    this.parent2.setPartial(false);
                }
                if (allSelected) {
                    this.parent2.setSelected(true);
                }
                if (allDeselected && !this.parent2.getPack().isRequired()) {
                    this.parent2.setSelected(false);
                }
                this.parent2.setEnabled(!allDisabled && !this.parent2.getPack().isRequired());
                if (allSelected || allDeselected) {
                    this.updateParents(this.parent2);
                }
            }
        }
    }

    private static void setPartialParent(CheckBoxNode node) {
        node.setPartial(true);
        CheckBoxNode parent = (CheckBoxNode)node.getParent();
        if (parent != null && !parent.equals(parent.getRoot())) {
            CheckTreeController.setPartialParent(parent);
        }
    }

    static long initTotalSize(CheckBoxNode node, boolean markChanged) {
        if (node.isLeaf()) {
            return node.getPack().nbytes;
        }
        Enumeration<TreeNode> e2 = node.children();
        Pack nodePack = node.getPack();
        long bytes = 0L;
        if (nodePack != null) {
            bytes = nodePack.nbytes;
        }
        while (e2.hasMoreElements()) {
            CheckBoxNode c2 = (CheckBoxNode)e2.nextElement();
            long size = CheckTreeController.initTotalSize(c2, markChanged);
            if (!c2.isSelected() && !c2.isPartial()) continue;
            bytes += size;
        }
        if (markChanged) {
            long old = node.getTotalSize();
            if (old != bytes) {
                node.setTotalSizeChanged(true);
            } else {
                node.setTotalSizeChanged(false);
            }
        }
        node.setTotalSize(bytes);
        return bytes;
    }

    @Override
    public void keyPressed(KeyEvent e2) {
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        TreePath path;
        if (e2.getKeyChar() == ' ') {
            Rectangle pathBounds = this.treePacksPanel.getTree().getPathBounds(this.treePacksPanel.getTree().getSelectionPath());
            this.mouseReleased(new MouseEvent(this.treePacksPanel.getTree(), 123, System.currentTimeMillis(), 0, pathBounds.x, pathBounds.y, 1, false));
        }
        if ((path = this.treePacksPanel.getTree().getSelectionPath()) == null) {
            return;
        }
        CheckBoxNode current = (CheckBoxNode)path.getLastPathComponent();
        this.treePacksPanel.setDescription(current.getId());
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }

    void initStates(CheckBoxNode rnode) {
        Enumeration<TreeNode> e2 = rnode.children();
        while (e2.hasMoreElements()) {
            TreeNode next = e2.nextElement();
            CheckBoxNode cbnode = (CheckBoxNode)next;
            Pack nodePack = cbnode.getPack();
            if (!cbnode.isPartial() && nodePack != null) {
                boolean select;
                boolean isHidden = nodePack.isHidden();
                cbnode.setEnabled(!nodePack.isRequired());
                boolean bl2 = select = !isHidden && PackHandler.getAvailablePacks().contains(nodePack) && (nodePack.isRequired() || PackHandler.getSelectedPacks().contains(nodePack));
                if (!isHidden) {
                    cbnode.setSelected(select);
                }
                if (!cbnode.isEnabled()) {
                    cbnode.setSelected(true);
                }
                this.updateAllDependencies(cbnode, select);
            }
            this.initStates(cbnode);
        }
        CheckTreeController.initTotalSize(rnode, true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e2) {
        if (this.treePacksPanel.getTree() == null) {
            return;
        }
        TreePath path = this.treePacksPanel.getTree().getSelectionPath();
        if (path == null) {
            return;
        }
        CheckBoxNode current = (CheckBoxNode)path.getLastPathComponent();
        this.treePacksPanel.setDescription(current.getId());
    }
}

