/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FilteredVariables {
    private final Map<String, String> filter;
    private final Properties properties;

    FilteredVariables(Properties properties, Map<String, String> filter) {
        this.filter = filter;
        this.properties = properties;
        Set<String> keySet = this.filter.keySet();
        for (String key : keySet) {
            String value = this.filter.get(key);
            if (value == null) continue;
            this.properties.put(key, value);
        }
    }

    public String getVariable(String key) {
        if (this.filter.containsKey(key)) {
            return this.filter(this.properties.getProperty(key), this.filter.get(key));
        }
        throw new IllegalStateException("The key \"" + key + "\" is not allowed!");
    }

    private String filter(String normalResult, String filterResult) {
        if (filterResult != null && filterResult.length() > 0) {
            return filterResult;
        }
        if (normalResult != null && normalResult.length() > 0) {
            return normalResult;
        }
        return "";
    }

    public void setVariable(String key, String value) {
        if (!this.filter.containsKey(key)) {
            throw new IllegalStateException("The key \"" + key + "\" is not allowed!");
        }
        this.properties.put(key, value);
        this.filter.put(key, value);
    }

    public Set<String> keySet() {
        return this.filter.keySet();
    }
}

