/*
 * Decompiled with CFR 0.152.
 */
package com.inet.setup.panels;

import com.inet.setup.GUIUtils;
import com.inet.setup.panels.AbstractPanel;
import com.inet.setup.panels.FilteredVariables;
import com.inet.setup.panels.widget.ContextPanel;
import com.inet.setup.panels.widget.GlassFishServerPanel;
import com.inet.setup.panels.widget.PathPanel;
import com.inet.setup.panels.widget.PortPanel;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class GlassFishPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private ContextPanel pnlContext;
    private PathPanel pnlPath;
    private GlassFishServerPanel pnlServer;
    private File checkPath;
    private FilteredVariables filteredVariables;
    private PortPanel pnlPort;

    public GlassFishPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, parent.langpack.getString("GlassFishPanel.heading"), null, null, "com/inet/setup/images/Components48.png");
    }

    @Override
    public Map<String, String> getRequiredVariables() {
        Map<String, String> requiredVariables = super.getRequiredVariables();
        requiredVariables.put("GLASSFISH_CONTEXT_NAME", null);
        requiredVariables.put("GLASSFISH_INSTALL_PATH", "true".equalsIgnoreCase(this.idata.getVariable("SERVLET_REMOTE_INSTALL")) ? this.idata.getInstallPath() + File.separatorChar + "glassfish" : "");
        requiredVariables.put("GLASSFISH_DOMAIN_NAME", "domain1");
        requiredVariables.put("SERVLET_REMOTE_INSTALL", null);
        requiredVariables.put("GLASSFISH_INSTALL_PORT", null);
        return requiredVariables;
    }

    @Override
    public void panelActivate() {
        this.idata.getStatHandler().notifyPanelActivation(this);
        this.filteredVariables = this.readFilteredVariables(this.getRequiredVariables());
        super.panelActivate();
        this.checkPath = new File(this.filteredVariables.getVariable("GLASSFISH_INSTALL_PATH"));
        this.pnlPath.isRemoteInstallation(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"));
    }

    public void panelFinish() {
        this.filteredVariables.setVariable("GLASSFISH_CONTEXT_NAME", this.pnlContext.getContext());
        this.filteredVariables.setVariable("GLASSFISH_DOMAIN_NAME", this.pnlServer.getServerName());
        this.filteredVariables.setVariable("GLASSFISH_INSTALL_PORT", this.pnlPort.getPort());
        if (this.pnlPath.getPath() != null && !"true".equalsIgnoreCase(this.filteredVariables.getVariable("SERVLET_REMOTE_INSTALL"))) {
            this.filteredVariables.setVariable("GLASSFISH_INSTALL_PATH", this.pnlPath.getPath());
        } else {
            this.filteredVariables.setVariable("GLASSFISH_INSTALL_PATH", "glassfish");
        }
        this.putToSummary(this.parent.langpack.getString("GlassFishPanel.installPath"), this.filteredVariables.getVariable("GLASSFISH_INSTALL_PATH"), 4);
        this.putToSummary(this.parent.langpack.getString("ServletPanel.servletContext"), this.filteredVariables.getVariable("GLASSFISH_CONTEXT_NAME"), 0);
    }

    @Override
    public boolean isValidated() {
        JComponent reselecet = null;
        reselecet = this.pnlContext.isValidated();
        if (this.pnlContext != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        reselecet = this.pnlPort.isValidated();
        if (this.pnlPort != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        if (this.pnlPath != null && !this.pnlPath.isVisible()) {
            this.pnlPath.setPath(this.idata.getInstallPath() + File.separatorChar + "glassfish");
            this.panelFinish();
            return true;
        }
        reselecet = this.pnlPath.isValidated();
        if (this.pnlPath != null && reselecet != null) {
            reselecet.requestFocus();
            return false;
        }
        String installPath = this.pnlPath.getPath();
        boolean ok = true;
        File rootPath = new File(installPath).getAbsoluteFile();
        if ((installPath = rootPath.toString()).endsWith(File.separator)) {
            installPath = installPath.substring(0, installPath.length() - 1);
        }
        this.pnlPath.setPath(installPath);
        this.checkPath = new File(installPath + File.separatorChar + "glassfish" + File.separatorChar + "domains" + File.separatorChar + this.pnlServer.getServerName() + File.separatorChar + "autodeploy");
        if (rootPath.exists() && !rootPath.isDirectory()) {
            this.emitError(null, this.parent.langpack.getString("TargetPanel.nodir"));
            ok = false;
        } else if (!rootPath.exists() || !this.checkPath.exists()) {
            ok = this.askQuestion(this.parent.langpack.getString("installer.Message"), this.parent.langpack.getString("GlassFishPanel.noGlassFishPath"), 0) == 47;
        } else if (new File(this.checkPath.getAbsolutePath() + File.separatorChar + this.pnlContext.getContext()).exists()) {
            boolean bl2 = ok = this.askQuestion(this.parent.langpack.getString("installer.Message"), this.parent.langpack.getString("GlassFishPanel.contextExists"), 0) == 47;
        }
        if (ok) {
            try {
                if (this.checkPath.exists()) {
                    File tempFile = File.createTempFile("ccsetup", null, this.checkPath);
                    tempFile.deleteOnExit();
                } else {
                    File tempFile = File.createTempFile("ccsetup", null, rootPath);
                    tempFile.deleteOnExit();
                }
            }
            catch (Exception e2) {
                String errorMsg = this.parent.langpack.getString("installer.no_write_permissions1");
                errorMsg = errorMsg.replace("{0}", this.checkPath.exists() ? this.checkPath.getAbsolutePath() : rootPath.getAbsolutePath());
                this.emitError(null, errorMsg);
                ok = false;
            }
        }
        if (!ok) {
            return false;
        }
        this.panelFinish();
        return super.isValidated();
    }

    @Override
    public JPanel initPanelGUI() {
        JPanel localPanel = new JPanel();
        localPanel.setLayout(new GridBagLayout());
        this.pnlContext = new ContextPanel(this.parent, this.filteredVariables.getVariable("GLASSFISH_CONTEXT_NAME"), this);
        this.pnlContext.setName("pnlContext");
        localPanel.add((Component)this.pnlContext, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_TOP, 0, 0));
        this.pnlServer = new GlassFishServerPanel(this.parent, this.filteredVariables.getVariable("GLASSFISH_DOMAIN_NAME"));
        this.pnlServer.setName("pnlServer");
        localPanel.add((Component)this.pnlServer, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.pnlPort = new PortPanel(this.parent, this.filteredVariables.getVariable("GLASSFISH_INSTALL_PORT"), this);
        this.pnlPort.setName("pnlPort");
        localPanel.add((Component)this.pnlPort, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        this.pnlPath = new PathPanel(this.parent, this.filteredVariables.getVariable("GLASSFISH_INSTALL_PATH"), this);
        this.pnlPath.setName("pnlPath");
        localPanel.add((Component)this.pnlPath, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, GUIUtils.TITLED_INSETS_MIDDLE, 0, 0));
        localPanel.add((Component)new JPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, GUIUtils.INSETS_NULL, 0, 0));
        this.recalcWidthForComponent(this.pnlContext.getComponentsForWidthCalculation(), this.pnlPath.getComponentsForWidthCalculation(), this.pnlServer.getComponentsForWidthCalculation(), this.pnlPort.getComponentsForWidthCalculation());
        return localPanel;
    }
}

